//====================================================================
//                
// Copyright (C) 2006,  Goedson Teixeira Paixao
//                
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
//                
// Filename:      TextFormatter.cc
// Author:        Goedson Teixeira Paixao <goedson@debian.org>
// Description:   
//                
// Created at:    Sat May  6 15:55:24 2006
// Modified at:   Thu May 11 17:52:04 2006
// Modified by:   Goedson Teixeira Paixao <goedson@debian.org>
//====================================================================

#include "TextFormatter.hh"
#include "ResourceManager.hh"
#include "GabberUtility.hh"
#include "IconTheme.hh"

Gabber::TextFormatter::TextFormatter(Glib::RefPtr<Gtk::TextBuffer> buffer): _buffer(buffer)
{
    _uritag = _buffer->create_tag("uri");
    _uritag->property_foreground().set_value("blue");
    _uritag->property_underline().set_value(Pango::UNDERLINE_SINGLE);
    _uritag->signal_event().connect(sigc::mem_fun(*this, &TextFormatter::on_tag_uri_event));
    _clickedtag = _buffer->create_tag("uri-clicked");
    _clickedtag->property_foreground().set_value("purple");
}

Gabber::TextFormatter::~TextFormatter() 
{
}

void Gabber::TextFormatter::format_text(const Glib::ustring& body, bool seen)
{

    Glib::ustring::size_type startchar = 0, endchar = 0, currentchar = 0;
    Glib::ustring current_text;

    while (currentchar < body.size()) {
        startchar = currentchar;
        while (currentchar < body.size() && Glib::Unicode::isspace(body[currentchar]))
            currentchar++;
        endchar = currentchar;
        if (seen)
            _buffer->insert_with_tag(_buffer->end(), body.substr(startchar, endchar - startchar), "seen");
        else
            _buffer->insert(_buffer->end(), body.substr(startchar, endchar - startchar));
        
        if (currentchar == body.size())
            break;
        
        startchar = currentchar;
        while (currentchar < body.size() && !Glib::Unicode::isspace(body[currentchar]))
            currentchar++;
        endchar = currentchar;
        
        current_text = body.substr(startchar, endchar - startchar);
        if (is_uri(current_text)) {
            _buffer->insert_with_tag(_buffer->end(), current_text, "uri");
        } else {
            if (ResourceManager::getSingleton().getEmoticonTheme()->get_icon_path(current_text) != "") {
                Glib::RefPtr<Gdk::Pixbuf> face = ResourceManager::getSingleton().getEmoticonPixbuf(current_text);
                _buffer->insert_pixbuf(_buffer->end(), face);
            } else {
                if (seen)
                    _buffer->insert_with_tag(_buffer->end(), current_text, "seen");
                else
                    _buffer->insert(_buffer->end(), current_text);
            }
        }
    }
    
}

bool Gabber::TextFormatter::is_uri(const Glib::ustring& text) {
    Glib::ustring::size_type i = 0;
    Glib::ustring::size_type text_size = text.size();
    
    if (!Glib::Unicode::isalpha(text[i]))
        return false;
    
    i++;
    
    do {
        if (i == text_size)
            return false;
        
        if (text[i] != ':')
            i++;
    } while (Glib::Unicode::isalpha(text[i]) || Glib::Unicode::isdigit(text[i]) || text[i] == '+' || text[i] == '.');
    
    if (i == text_size || text[i] !=':')
        return false;
    
    i++;
    
    if (i == text_size)
        return false;
    
    return true;
    
}

bool Gabber::TextFormatter::on_tag_uri_event(const Glib::RefPtr<Glib::Object>& o, GdkEvent* e, const Gtk::TextIter& i)
{
    if (e->type == GDK_BUTTON_PRESS && e->button.button == 1)
    {
        Gtk::TextIter startchar = i;
        Gtk::TextIter endchar = i;
        
        while(!startchar.begins_tag(_uritag))
            --startchar;
        
        while(!endchar.ends_tag(_uritag))
            ++endchar;
        
            Glib::ustring theuri = _buffer->get_text(startchar, endchar);
            
            Util::openuri(theuri);
            
            _buffer->apply_tag(_clickedtag, startchar, endchar);
    }
    return false;
}
