//====================================================================
//                
// Copyright (C) 2006,  Goedson Teixeira Paixao
//                
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
// 02111-1307, USA.
//                
// Filename:      IconTheme.hh
// Author:        Goedson Teixeira Paixao <goedson@debian.org>
// Description:   Icon theme support
//                
// Created at:    Wed May 10 17:10:29 2006
// Modified at:   Thu May 11 17:58:01 2006
// Modified by:   Goedson Teixeira Paixao <goedson@debian.org>
//====================================================================

#ifndef __GABBER_INCL_ICONTHEME_HH__
#define __GABBER_INCL_ICONTHEME_HH__

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif


#include <string>
#include <map>

namespace Gabber {

    class IconTheme {
    public:
        IconTheme(std::string theme_name, std::string base_dir);
        ~IconTheme();
        std::string get_icon_path(std::string icon);
    private:
        std::map<std::string, std::string> _icons;
        std::map<std::string, std::string> _properties;
        std::string _theme_path;
        std::string build_icon_path(std::string icon);

    };
    
    class EmoticonTheme: public IconTheme {
    public:
        EmoticonTheme(std::string theme);
    };


    class UserInterfaceTheme: public IconTheme {
    public:
        UserInterfaceTheme(std::string theme);
    };


}


#endif // __GABBER_INCL_ICONTHEME_HH__
