/* 

                          Firewall Builder

                 Copyright (C) 2003 NetCitadel, LLC

  Author:  Illiya Yalovoy <yalovoy@gmail.com>

  $Id: ObjectListViewItem.h,v 1.1 2005/09/07 16:40:50 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/



#ifndef  OBJECTLISTVIEWITEM_H
#define  OBJECTLISTVIEWITEM_H

#include <qlistview.h>

#include <string>
#include <map>

namespace libfwbuilder {
    class FWObject;
}

class ObjectTreeView;

class ObjectListViewItem : public QListViewItem {

    libfwbuilder::FWObject *objptr;
    QMap<QString, QString>  props;
    QString                 lib;
    std::string             ID;  
    
 public:

    ObjectListViewItem(QListView *parent) : QListViewItem(parent) {
        objptr=NULL;
        ID="";
    }

    ObjectListViewItem(QListViewItem *parent) : QListViewItem(parent){
        objptr=NULL;
        ID="";
    }

    libfwbuilder::FWObject *getFWObject() {return mw->db()->getById(ID,true); }
    std::string getFWObjectID() {return ID; }
    void setFWObject(libfwbuilder::FWObject *obj) { ID=obj->getId(); }

    ObjectTreeView* getTree();

    QString getLib() { return lib; }
    void        setLib(const QString &l) { lib=l; }

    QString getProperty(const QString &name) { return props[name]; }
    void        setProperty(const QString &name,const QString &val) {
        props[name]=val;
    }
};

#endif
