#!/bin/sh
#
# Copyright (C) 2014 Thomas Goirand <zigo@debian.org>
#
# Runs pgsql server, then use that to run tests.
#

set -e
set -x

BINDIR=`pg_config --bindir`
PG_MYTMPDIR=`mktemp -d`
chown postgres:postgres ${PG_MYTMPDIR} || true
./debian/start_pg.sh ${PG_MYTMPDIR}

#####################  
### RUN THE TESTS ###
#####################
# Set defaults to use the socket file
sed -i "s#host: \".*\"#host: \"${PG_MYTMPDIR}\"#" nailgun/nailgun/settings.yaml
sed -i "s#passwd: \".*\"#passwd: \"\"#" nailgun/nailgun/settings.yaml
sed -i "s#port: \".*\"#port: \"\"#" nailgun/nailgun/settings.yaml

export TEST_NAILGUN_DB=nailgun
cd nailgun
#nosetests -v --with-timer --timer-ok=5 --timer-verbose --exclude=nailgun/test/integration --exclude=nailgun/test/performance --exclude=nailgun/extensions
python -m pytest -vv --cleandb nailgun/test/unit
ecode=$?
cd ..

# Get back to the configuration before running the tests (so we can build twice)
sed -i "s#host: \".*\"#host: \"localhost\"#" nailgun/nailgun/settings.yaml
sed -i "s#passwd: \".*\"#passwd: \"nailgun\"#" nailgun/nailgun/settings.yaml
sed -i "s#port: \".*\"#port: \"5432\"#" nailgun/nailgun/settings.yaml

###############################################
### SHUTDOWN PGSQL AND CLEAN ITS TMP FOLDER ###
###############################################
$BINDIR/pg_ctl stop -D ${PG_MYTMPDIR}
wait
killall postgres
rm -rf ${PG_MYTMPDIR}

exit ${ecode}

