# This file is part of the Frescobaldi project, http://www.frescobaldi.org/
#
# Copyright (c) 2008 - 2014 by Wilbert Berendsen
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
# See http://www.gnu.org/licenses/ for more information.

"""
Dummy file containing messages that are part of some Python modules or Qt and used in our application.
"""

from __future__ import unicode_literals

# Python, optparse:
_("Usage")
_("Usage: %s\n")
_("show this help message and exit")
_("show program's version number and exit")
# L10N: Command line options
_("Options")

# Python, argparse:
_("usage: ")
_("positional arguments")
_("optional arguments")
_("show this help message and exit")
_("show program's version number and exit")

# Qt
_("CloseButton", "Close Tab")

_("QDialogButtonBox", "Apply")
_("QDialogButtonBox", "&Cancel")
_("QDialogButtonBox", "Cancel")
_("QDialogButtonBox", "Close")
_("QDialogButtonBox", "Close without Saving")
_("QDialogButtonBox", "Discard")
_("QDialogButtonBox", "Help")
_("QDialogButtonBox", "&OK")
_("QDialogButtonBox", "OK")
_("QDialogButtonBox", "Open")
_("QDialogButtonBox", "Reset")
_("QDialogButtonBox", "&Save")
_("QDialogButtonBox", "Save")

_("QDialog", "What's This?")

_("QFileDialog", "All Files (*)")
_("QFileDialog", "Back")
_("QFileDialog", "Change to detail view mode")
_("QFileDialog", "Change to list view mode")
_("QFileDialog", "Create a New Folder")
_("QFileDialog", "Create New Folder")
_("QFileDialog", "&Delete")
_("QFileDialog", "Detail View")
_("QFileDialog", "Drive")
_("QFileDialog", "File")
_("QFileDialog", "File &name:")
_("QFileDialog", "Files of type:")
_("QFileDialog", "Find Directory")
_("QFileDialog", "Folder")
_("QFileDialog", "Forward")
_("QFileDialog", "Go back")
_("QFileDialog", "Go forward")
_("QFileDialog", "Go to the parent directory")
_("QFileDialog", "List View")
_("QFileDialog", "Look in:")
_("QFileDialog", "&New Folder")
_("QFileDialog", "&Open")
_("QFileDialog", "Parent Directory")
_("QFileDialog", "Remove")
_("QFileDialog", "&Rename")
_("QFileDialog", "Show ")
_("QFileDialog", "Show &hidden files")

_("QFileSystemModel", "%1 bytes")
_("QFileSystemModel", "%1 KB")
_("QFileSystemModel", "Computer")
_("QFileSystemModel", "Date Modified")
_("QFileSystemModel", "Name")
_("QFileSystemModel", "Size")
_("QFileSystemModel", "Type")

_("QFontDatabase", "Black")
_("QFontDatabase", "Bold")
_("QFontDatabase", "Demi Bold")
_("QFontDatabase", "Light")
_("QFontDatabase", "Oblique")

_("QInputContext", "XIM")

_("QLocalSocket", "%1: Invalid name")

_("QMultiInputContext", "Select IM")

_("QScrollBar", "Bottom")
_("QScrollBar", "Left edge")
_("QScrollBar", "Page down")
_("QScrollBar", "Page left")
_("QScrollBar", "Page right")
_("QScrollBar", "Page up")
_("QScrollBar", "Right edge")
_("QScrollBar", "Scroll down")
_("QScrollBar", "Scroll here")
_("QScrollBar", "Scroll left")
_("QScrollBar", "Scroll right")
_("QScrollBar", "Scroll up")
_("QScrollBar", "Top")

_("QShortcut", "+")
_("QShortcut", "Add Favorite")
_("QShortcut", "Adjust Brightness")
_("QShortcut", "Alt")
_("QShortcut", "Application Left")
_("QShortcut", "Application Right")
_("QShortcut", "Audio Cycle Track")
_("QShortcut", "Audio Forward")
_("QShortcut", "Audio Random Play")
_("QShortcut", "Audio Repeat")
_("QShortcut", "Audio Rewind")
_("QShortcut", "Away")
_("QShortcut", "Back")
_("QShortcut", "Back Forward")
_("QShortcut", "Backspace")
_("QShortcut", "Backtab")
_("QShortcut", "Bass Boost")
_("QShortcut", "Bass Down")
_("QShortcut", "Bass Up")
_("QShortcut", "Battery")
_("QShortcut", "Browser")
_("QShortcut", "Caps Lock")
_("QShortcut", "CapsLock")
_("QShortcut", "Clear")
_("QShortcut", "Clear Grab")
_("QShortcut", "Close")
_("QShortcut", "Copy")
_("QShortcut", "Ctrl")
_("QShortcut", "Cut")
_("QShortcut", "Del")
_("QShortcut", "Delete")
_("QShortcut", "Display")
_("QShortcut", "Documents")
_("QShortcut", "Down")
_("QShortcut", "Eject")
_("QShortcut", "End")
_("QShortcut", "Enter")
_("QShortcut", "Esc")
_("QShortcut", "F%1")
_("QShortcut", "Forward")
_("QShortcut", "Go")
_("QShortcut", "Help")
_("QShortcut", "History")
_("QShortcut", "Home Page")
_("QShortcut", "Ins")
_("QShortcut", "Insert")
_("QShortcut", "Left")
_("QShortcut", "Media Next")
_("QShortcut", "Media Pause")
_("QShortcut", "Media Play")
_("QShortcut", "Media Previous")
_("QShortcut", "Media Record")
_("QShortcut", "Media Stop")
_("QShortcut", "Menu")
_("QShortcut", "Meta")
_("QShortcut", "Music")
_("QShortcut", "News")
_("QShortcut", "Number Lock")
_("QShortcut", "Num Lock")
_("QShortcut", "NumLock")
_("QShortcut", "Open URL")
_("QShortcut", "Option")
_("QShortcut", "Page Down")
_("QShortcut", "Page Up")
_("QShortcut", "Paste")
_("QShortcut", "Pause")
_("QShortcut", "PgDown")
_("QShortcut", "PgUp")
_("QShortcut", "Refresh")
_("QShortcut", "Reload")
_("QShortcut", "Return")
_("QShortcut", "Right")
_("QShortcut", "Save")
_("QShortcut", "Scroll Lock")
_("QShortcut", "ScrollLock")
_("QShortcut", "Search")
_("QShortcut", "Select")
_("QShortcut", "Send")
_("QShortcut", "Shift")
_("QShortcut", "Space")
_("QShortcut", "Spellchecker")
_("QShortcut", "Split Screen")
_("QShortcut", "Spreadsheet")
_("QShortcut", "Standby")
_("QShortcut", "Stop")
_("QShortcut", "Subtitle")
_("QShortcut", "Support")
_("QShortcut", "Suspend")
_("QShortcut", "SysReq")
_("QShortcut", "Tab")
_("QShortcut", "Task Panel")
_("QShortcut", "Terminal")
_("QShortcut", "Time")
_("QShortcut", "Toggle Media Play/Pause")
_("QShortcut", "Tools")
_("QShortcut", "Top Menu")
_("QShortcut", "Treble Down")
_("QShortcut", "Treble Up")
_("QShortcut", "Up")
_("QShortcut", "Video")
_("QShortcut", "View")
_("QShortcut", "Volume Down")
_("QShortcut", "Volume Mute")
_("QShortcut", "Volume Up")
_("QShortcut", "Zoom In")
_("QShortcut", "Zoom Out")

_('QTextControl', '&Undo')
_('QTextControl', '&Redo')
_('QTextControl', 'Cu&t')
_('QTextControl', '&Copy')
_('QTextControl', '&Paste')
_('QTextControl', 'Delete')
_('QTextControl', 'Select All')

_("QWhatsThisAction", "What's This?")
