# - Try to find CFITSIO
# Once done this will define
#  CFITSIO_FOUND - System has TIS
#  CFITSIO_INCLUDE_DIRS - The TIS include directories
#  CFITSIO_LIBRARIES - The libraries needed to use TIS

find_path(	CFITSIO_INCLUDE_DIR fitsio.h
			PATH_SUFFIXES cfitsio
			PATHS
			$ENV{CFITSIO_INCLUDEDIR})

find_library(	CFITSIO_LIBRARY NAMES cfitsio
				PATHS
				$ENV{CFITSIO_LIBRARYDIR})			
		
IF(CFITSIO_INCLUDE_DIR AND CFITSIO_LIBRARY)
	set(CFITSIO_FOUND TRUE)
	set(CFITSIO_LIBRARIES  ${CFITSIO_LIBRARY})
ELSE(CFITSIO_INCLUDE_DIR AND CFITSIO_LIBRARY)
	set(CFITSIO_FOUND FALSE)
ENDIF(CFITSIO_INCLUDE_DIR AND CFITSIO_LIBRARY)

INCLUDE(FindPackageHandleStandardArgs)

FIND_PACKAGE_HANDLE_STANDARD_ARGS(CFITSIO DEFAULT_MSG
  CFITSIO_INCLUDE_DIR
  CFITSIO_LIBRARY)

mark_as_advanced(CFITSIO_INCLUDE_DIR CFITSIO_LIBRARIES)





