/*
   yahoo_wrapper.c: higher level wrapper to libyahoo functions


   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

/* READ ME FIRST:
   All the process_*  and handle_yahoo_message functions should use
   PRINTF_MESSAGE only to print any message to screen. This will
   ensure proper insertion of message into readline buffer.
*/


#include <assert.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/stat.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <guile/gh.h>
#include <readline/readline.h>

#include <glib.h>
#include <libyahoo2/yahoo2.h>
#include <libyahoo2/yahoo2_callbacks.h>

#include "freehoo.h"
#include "interpreter.h"
#include "yahoo-wrapper.h"
#include "messenger.h"
#include "fh-utils.h"
#include "extension.h"
#include <config.h>


GHashTable *fh_buddy_list = NULL;
static char current_target_buddy[USERNAME_LENGTH];
yahoo_idlabel yahoo_status_codes[] = 
  {
    {YAHOO_STATUS_AVAILABLE, "Available"},
    {YAHOO_STATUS_BRB, "Be Right Back"},
    {YAHOO_STATUS_BUSY, "Busy"},
    {YAHOO_STATUS_NOTATHOME, "Not Home"},
    {YAHOO_STATUS_NOTATDESK, "Not at Desk"},
    {YAHOO_STATUS_NOTINOFFICE, "Not in Office"},
    {YAHOO_STATUS_ONPHONE, "On Phone"},
    {YAHOO_STATUS_ONVACATION, "On Vacation"},
    {YAHOO_STATUS_OUTTOLUNCH, "Out to Lunch"},
    {YAHOO_STATUS_STEPPEDOUT, "Stepped Out"},
    {YAHOO_STATUS_INVISIBLE, "Invisible"},
    {YAHOO_STATUS_IDLE, "Idle"},
    {YAHOO_STATUS_OFFLINE, "Offline"},
    {YAHOO_STATUS_CUSTOM, "[Custom]"},
    //    {YAHOO_STATUS_TYPING, "Typing"},
    {YAHOO_STATUS_UNKNOWN, "Unknown"}
  };


void 
set_current_target_buddy (char *current_target_buddy_value)
{
  if (current_target_buddy_value)
    strcpy (current_target_buddy, current_target_buddy_value);
  else
    current_target_buddy[0] = 0;
}

char *
get_current_target_buddy (void)
{
  return current_target_buddy;
}

void 
send_message (char *to, char *message)
{
  /* hook evaluation */
  set_current_target_buddy (to);	// AUTO-INSERT-MODE
  
  set_hook_return (0);
  scm_run_hook (get_message_send_hook (),
		gh_list (gh_str02scm (to),
			 gh_str02scm (message),
			 SCM_UNDEFINED));
  
  if (get_hook_return () == 1)
    return;
  
  yahoo_send_im ((get_fh_session ())->session_id, NULL, to, message, 0);
}

/* this function is primarily for scm-procedure. using this function
for other purposes is not justified 
*/
void 
send_message_no_hook (char *to, char *message)
{
  
  // dont set current_target_buddy from inside this call. otherwise
  // it will confuse "session (AUTU-INSERT-MODE). 
  // set_current_target_buddy (to); // AUTO-INSERT-MODE
  
  yahoo_send_im ((get_fh_session ())->session_id, NULL, to, message, 0);
}


void 
fh_key_destroy (gpointer key)
{
  return;
}

void 
fh_value_destroy (gpointer data)
{
  return;
}

void
build_fh_buddy_table (const void *data)
{
  struct yahoo_buddy *buddy = (struct yahoo_buddy *) data;
  struct fh_buddy *hoob = NULL;
  
  hoob = (fh_buddy *) malloc (sizeof (fh_buddy));
  hoob->group = strdup (buddy->group);
  hoob->id = strdup (buddy->id);
  hoob->real_name = (buddy->real_name) ? strdup (buddy->real_name) : NULL;
  hoob->status = YAHOO_STATUS_OFFLINE;
  hoob->status_msg = NULL;
  
  g_hash_table_insert (fh_buddy_list, hoob->id, hoob);
}

void 
build_fh_buddy_list ()
{
  YList *buds;
  fh_buddy_list = g_hash_table_new (g_str_hash, g_str_equal);
  buds = (get_fh_session ())->buddy_list;
  for(; buds; buds = buds->next) 
    build_fh_buddy_table (buds->data);
}

void
show_buddy (gpointer data)
{
  static char *current_group = NULL;
  struct yahoo_buddy *buddy = (struct yahoo_buddy *) data;
  fh_buddy *hoob = NULL;
  
  if (!current_group || strcmp (current_group, buddy->group))
    {
      current_group = buddy->group;
      printf ("[%s]\n", current_group);
    }
  
  hoob = g_hash_table_lookup (fh_buddy_list, buddy->id);
  if (!hoob)
    {
      /* Sometimes libyahoo2 buddy_list and fh_buddy_list doesn't
	 synchronize in realtime. */
      // printf ("Error: No %s found in fh_buddy_list\n", buddy->id);
      return;
    }
  
  if (get_who_state () &&
      hoob->status != YAHOO_STATUS_AVAILABLE &&
      hoob->status == YAHOO_STATUS_OFFLINE)
    {
      return;
    }

  printf (" %c %s",
	  ((hoob->status == YAHOO_STATUS_AVAILABLE) ? '*' : ' '),
	  hoob->id);
  
  if (hoob->status == YAHOO_STATUS_CUSTOM)
    {
      printf (" (%s)", hoob->status_msg);
    }
  else
    {
      if (hoob->status != YAHOO_STATUS_OFFLINE &&
	  hoob->status != YAHOO_STATUS_AVAILABLE)
	{
	  printf (" (%s)", yahoo_status_code (hoob->status));
	}
    }
  printf ("\n");
}

void
show_ignore (gpointer data)
{
  struct yahoo_buddy *buddy = (struct yahoo_buddy *) data;
  printf ("%s\n", buddy->id);
}

void 
display_buddy_list ()
{
  YList *buds = (get_fh_session ())->buddy_list;
  for(; buds; buds = buds->next) 
    show_buddy (buds->data);
}

void 
display_ignore_list ()
{
  YList *igns = (get_fh_session ())->ignore_list;
  for(; igns; igns = igns->next) 
    show_ignore (igns->data);
}

GHashTable *
get_fh_buddy_list ()
{
  return fh_buddy_list;
}

char * 
yahoo_status_code (int s)
{
  int i;
  for (i = 0; yahoo_status_codes[i].id != -1; i++)
    {
      if (yahoo_status_codes[i].id == s)
	return yahoo_status_codes[i].label;
    }
  
  return yahoo_status_codes[i].label;
}

char * __y_str_to_utf8(const char *in)
{
	unsigned int n, i = 0;
	char *result = NULL;

	if(in == NULL || *in == '\0')
		return "";
	
	result = g_new(char, strlen(in) * 2 + 1);

	/* convert a string to UTF-8 Format */
	for (n = 0; n < strlen(in); n++) {
		unsigned char c = (unsigned char)in[n];

		if (c < 128) {
			result[i++] = (char) c;
		} else {
			result[i++] = (char) ((c >> 6) | 192);
			result[i++] = (char) ((c & 63) | 128);
		}
	}
	result[i] = '\0';
	return result;
}

char * __y_utf8_to_str(const char *in)
{
	int i = 0;
	unsigned int n;
	char *result = NULL;

	if(in == NULL || *in == '\0')
		return "";
	
	result = g_new(char, strlen(in) + 1);

	/* convert a string from UTF-8 Format */
	for (n = 0; n < strlen(in); n++) {
		unsigned char c = in[n];

		if (c < 128) {
			result[i++] = (char) c;
		} else {
			result[i++] = (c << 6) | (in[++n] & 63);
		}
	}
	result[i] = '\0';
	return result;
}

