/* 
   freehoo.h: header file for freehoo(main file)
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

#ifndef _FREEHOO_H
#define _FREEHOO_H


#define USERNAME_LENGTH 32
#define PASSWORD_LENGTH 32

#define FH_BUG_REPORT_EMAIL         "gnubot@yahoo.com"
#define FH_BUG_REPORT_ID            "gnubot"
#define FH_ROBOT                    "gnubot"
#define FH_ROBOT_GROUP              "GNU"

#define FH_PROMPT_STRING            "HOO!> "
#define FH_CONFIG_DIRECTORY         "." PACKAGE
#define FH_CONFIG_DIRECTORY_MODE    S_IRWXU
#define FH_CONFIG_FILE              FH_CONFIG_DIRECTORY "/" PACKAGE ".scm"
#define FH_CONFIG_FILE_MODE         S_IRWXU
#define FH_DEFAULT_CONFIG_DIRECTORY PATH_CFG "/" PACKAGE
#define FH_DEFAULT_CONFIG_FILE      FH_DEFAULT_CONFIG_DIRECTORY "/" PACKAGE
#define FH_DOWNLOADS_DIRECTORY      "downloads"
#define FH_DOWNLOADS_URL_FILE       "downloads.url"
#define FH_DEFAULT_GROUP            "Friends"
#define FH_DEFAULT_STATUS           YAHOO_STATUS_AVAILABLE

#define FH_GLOBAL_EXTENSIONS_DIRECTORY DATADIR "/" PACKAGE "/extensions"
#define FH_LOCAL_EXTENSIONS_DIRECTORY  FH_CONFIG_DIRECTORY "/extensions"
#define FH_INIT_FILE                   "init.scm"
#define FH_GLOBAL_INIT_FILE            FH_GLOBAL_EXTENSIONS_DIRECTORY "/" FH_INIT_FILE

#define UTC_TIME_STR_SIZE              30
#define UTC_TIME_STR_FORMAT            "%a %b %d %X UTC %G"

#define FH_DEFAULT_CONFIG_CONTENTS     \
";;; FreeHoo loads the startup options from `~/.freehoo/freehoo.scm'.\n\
;;; Right from custom settings like username, password ... to complete\n\
;;; Scheme programming can be done in this file.\n\
;;; All entries in this `freehoo.scm' file are optional.  How ever\n\
;;; there is no limit in customizing or extending FreeHoo through Guile\n\
;;; interface. Please refer info pages with command \n\
;;; `info freehoo Customization freehoo.scm'\n"

char *get_default_login_id (void);
void set_default_login_id (char *default_login_id_value);
char *get_default_password (void);
void set_default_password (char *default_password_value);
char *get_default_prompt (void);
void set_default_prompt (char *prompt_default_value);
int get_setup_mode (void);
void set_setup_mode (int setup_mode_value);

#endif
