;;; proud-of-freehoo.scm: i am proud of freehoo. are you ?
;;; author: M.P.Anand Babu <ab@gnu.org.in>

;;; This program is free software; you can redistribute it and/or
;;; modify it under the terms of the GNU General Public License as
;;; published by the Free Software Foundation; either version 2, or (at
;;; your option) any later version.
;;; 
;;; This program is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;; General Public License for more details.
;;; 
;;; You should have received a copy of the GNU General Public License
;;; along with this program; if not, write to the Free Software
;;; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA

;;; example:
;;; i know you are proud of using freehoo. so let this file be
;;; automatically loaded thru init.scm
;;; to check if the other buddy is using freehoo, try this command
;;; ~qp~!> ?eval (freehoo? 'buddy-name)
;;;
;;; proud-of-freehoo.scm depends on color.scm
 
(ignore-message! "^.messenger")

(define (proud-of-freehoo from msg)
  "tell ur buddy that you are proud of using freehoo"
  (and (string=? "?messenger" msg)
       (fh-send-message-no-hook from "?messenger->freehoo")
       (begin (fh-display (string-append "Told ["
			       from
			       "] that I'm proud of using Freehoo")))
       (fh-hook-return)))

(define (freehoo? buddy)
  "does this buddy use freehoo"
  (fh-send-message-no-hook buddy "?messenger"))
  
(define (proud-of-fh-handler from msg)
  "handle the freehoo? reply"
  (if (string=? "?messenger-"
		      (car (string-separate msg #\>)))
      ;; ?messenger->MESSENGER-NAME reply message
      (if (string=? "?messenger->freehoo" msg)
	  (begin
	    (fh-display 
	     (string-append "Yes [" from "] is using ["
			    (cadr (string-separate msg #\>))
			    "]"))
	    (fh-hook-return))
	  (begin
	    (fh-display
	     (string-append "No, but [" from "] is using ["
			    (cadr (string-separate msg #\>))
			    "]"))
	     (fh-hook-return)))))


(add-hook! fh-message-receive-hook proud-of-freehoo)
(add-hook! fh-message-receive-hook proud-of-fh-handler)

(fh-register-command! '("?freehoo" "?freehoo BUDDY\n\t- check whether a BUDDY is using freehoo"))
(define (?freehoo args)
  "dynamic command interface to proud-of-freehoo extension"
  (set! args (list->strlist args))
  (if (= (length args) 1)
      (freehoo? (car args))
      (begin
	(display "proud-of-freehoo.scm: wrong number of arguments to ?freehoo\n"))))
