//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: StaticCenter.cpp,v 1.6 2005/09/25 14:02:40 delpinux Exp $

#include <StaticCenter.hpp>
#include <iostream>

#include <StreamCenter.hpp>
#include <ReferenceCounting.hpp>

#include <Q1HexahedronFiniteElement.hpp>
#include <Q2HexahedronFiniteElement.hpp>
#include <P1TetrahedronFiniteElement.hpp>
#include <P2TetrahedronFiniteElement.hpp>

#include <Q1Quadrangle3DFiniteElement.hpp>
#include <Q2Quadrangle3DFiniteElement.hpp>
#include <P1Triangle3DFiniteElement.hpp>
#include <P2Triangle3DFiniteElement.hpp>

#include <QuadratureFormula.hpp>
#include <RunningOptions.hpp>

bool StaticCenter::__instanciated(false);

StaticCenter::StaticCenter()
{
  if (__instanciated==true) {
    std::cerr << "Cannot use more than one StaticCenter\n";
    std::exit(1);
  }

  /// utils
  StreamCenter::create();
  ReferenceCountingCenter::create();
  RunningOptions::create();

  /// Quadrature formulae
  QuadratureFormulaQ1Hexahedron::create();
  QuadratureFormulaP1Tetrahedron::create();
  QuadratureFormulaQ2Hexahedron::create();
  QuadratureFormulaP2Tetrahedron::create();

  QuadratureFormulaP1Triangle3D::create();
  QuadratureFormulaQ1Quadrangle3D::create();
  QuadratureFormulaP2Triangle3D::create();
  QuadratureFormulaQ2Quadrangle3D::create();

  /// Finite elements
  Q1HexahedronFiniteElement::create();
  Q2HexahedronFiniteElement::create();
  P1TetrahedronFiniteElement::create();
  P2TetrahedronFiniteElement::create();

  Q1Quadrangle3DFiniteElement::create();
  Q2Quadrangle3DFiniteElement::create();
  P1Triangle3DFiniteElement::create();
  P2Triangle3DFiniteElement::create();
}

StaticCenter::~StaticCenter()
{
  /// Finite elements
  Q1HexahedronFiniteElement::destroy();
  Q2HexahedronFiniteElement::destroy();
  P1TetrahedronFiniteElement::destroy();
  P2TetrahedronFiniteElement::destroy();

  Q1Quadrangle3DFiniteElement::destroy();
  Q2Quadrangle3DFiniteElement::destroy();
  P1Triangle3DFiniteElement::destroy();
  P2Triangle3DFiniteElement::destroy();

  /// Quadrature formulae
  QuadratureFormulaP1Tetrahedron::destroy();
  QuadratureFormulaP2Tetrahedron::destroy();
  QuadratureFormulaQ1Hexahedron::destroy();
  QuadratureFormulaQ2Hexahedron::destroy();

  QuadratureFormulaP1Triangle3D::destroy();
  QuadratureFormulaP2Triangle3D::destroy();
  QuadratureFormulaQ1Quadrangle3D::destroy();
  QuadratureFormulaQ2Quadrangle3D::destroy();

  /// utils
  RunningOptions::destroy();
  ReferenceCountingCenter::destroy();
  StreamCenter::destroy();
}
