//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: PDECondition.hpp,v 1.1.1.1 2003/02/17 16:32:51 delpinux Exp $

#ifndef PDECONDITION_H
#define PDECONDITION_H

#include <string>

#include <StreamCenter.hpp>
/*!
  \class PDECondition

  Defines the boundary condition type.

  \author Stphane Del Pino
*/

class PDECondition
{
public:
  //! allowed types.
  enum Type {
    dirichlet,
    neumann,
    fourrier
  };

private:
  //! The type.
  const PDECondition::Type __type;

  //! The number of the associated unknown.
  const size_t __unknownNumber;
  
  //! type name.
  virtual const std::string typeName() const = 0;
public:

  const size_t unknownNumber() const
  {
    return __unknownNumber;
  }
  

  //! read only access to the type.
  const PDECondition::Type& type() const
  {
    return __type;
  }

  //! Constructs the condition for a given type.
  PDECondition(const PDECondition::Type& cType,
	       const size_t unknownNumber)
    : __type(cType),
      __unknownNumber(unknownNumber)
  {
    ;
  }

  //! Copy constructor.
  PDECondition(const PDECondition& C)
    : __type(C.__type),
      __unknownNumber(C.__unknownNumber)
  {
    ;
  }

  //! writes the condition.
  friend std::ostream& operator << (std::ostream& os,
				    const PDECondition& BC)
  {
    os << BC.typeName();
    return os;
  }

  //! destructor.
  virtual ~PDECondition()
  {
    ;
  }

};

#endif // PDECONDITION_H

