//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: FEMFunctionBuilder.hpp,v 1.2 2005/10/29 14:42:00 delpinux Exp $

#include <ReferenceCounting.hpp>
#include <Mesh.hpp>
#include <FEMFunction.hpp>

#ifndef FEM_FUNCTION_BUILDER_HPP
#define FEM_FUNCTION_BUILDER_HPP

class FEMFunctionBuilder
{
private:
  template <typename MeshType>
  ReferenceCounting<FEMFunctionBase>
  __build(const DiscretizationType& d,
	  const MeshType& mesh) const;

public:
  ReferenceCounting<FEMFunctionBase>
  build(const DiscretizationType& d, const Mesh& mesh) const;

  ReferenceCounting<FEMFunctionBase>
  build(const DiscretizationType& d,
	const Mesh& mesh,
	const UserFunction& u) const;

  ReferenceCounting<FEMFunctionBase>
  build(const DiscretizationType& d,
	const Mesh& mesh,
	const Vector<real_t>& values) const;

  FEMFunctionBuilder()
  {
    ;
  }

  ~FEMFunctionBuilder()
  {
    ;
  }
};

#endif // FEM_FUNCTION_BUILDER_HPP
