//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: Sphere.cpp,v 1.1.1.1 2003/02/17 16:32:50 delpinux Exp $


// This class provides a toolkit to manipulate Spheres. It inherits
// from the Shape class.

#include <Sphere.hpp>

#include <cmath>
#include <fstream>

//! copies a the Sphere \a S.
const Sphere&  Sphere::operator = (const Sphere& S)
{
  __center  = S.__center;
  __radius  = S.__radius;
  __radius2 = S.__radius2;
  __trans   = S.__trans;
  return *this;
}

//! Default constructor.
Sphere::Sphere()
  : Shape(sphere)
{
  ;
}

/*!
  Builds a Sphere centered on \a c of radius \a r.
*/
Sphere::Sphere(const Vertex& c, const real_t& r)
  : Shape(sphere),
    __center(c),
    __radius(r),
    __radius2(r*r)
{
  ;
}

//! Copy constructor.
Sphere::Sphere(const Sphere& S)
  : Shape(S),
    __center (S.__center),
    __radius (S.__radius),
    __radius2(S.__radius2)
{
  ;
}

//! Prints the Sphere informations using the stream \a s.
std::ostream& Sphere::put(std::ostream& s) const {
  s << "sphere {\n" << __center
    << ", " << __radius << '\n';
  for (size_t i=0; i<nbTransform(); i++)
    s << (*__trans[i]).povWrite() << '\n';
  s << "}\n";
  return s;
}

