//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: ConnectivityBuilder.cpp,v 1.6 2005/01/31 20:41:02 delpinux Exp $

#include <ConnectivityBuilder.hpp>
#include <Connectivity.hpp>
#include <Structured3DMesh.hpp>
#include <MeshOfTetrahedra.hpp>
#include <MeshOfHexahedra.hpp>

template <>
void ConnectivityBuilder<MeshOfHexahedra>::__setFaces()
{
  __face[0][0] = 4;
  __face[0][1] = 7;
  __face[0][2] = 3;
  __face[0][3] = 0;

  __face[1][0] = 1;
  __face[1][1] = 2;
  __face[1][2] = 6;
  __face[1][3] = 5;

  __face[2][0] = 4;
  __face[2][1] = 5;
  __face[2][2] = 1;
  __face[2][3] = 0;

  __face[3][0] = 3;
  __face[3][1] = 2;
  __face[3][2] = 6;
  __face[3][3] = 7;

  __face[4][0] = 0;
  __face[4][1] = 1;
  __face[4][2] = 2;
  __face[4][3] = 3;

  __face[5][0] = 7;
  __face[5][1] = 6;
  __face[5][2] = 5;
  __face[5][3] = 4;
}

template <>
void ConnectivityBuilder<MeshOfHexahedra>::__setEdges()
{
  __edge[ 0][0] = 0;
  __edge[ 0][1] = 1;

  __edge[ 1][0] = 2;
  __edge[ 1][1] = 3;

  __edge[ 2][0] = 6;
  __edge[ 2][1] = 7;

  __edge[ 3][0] = 4;
  __edge[ 3][1] = 5;

  __edge[ 4][0] = 0;
  __edge[ 4][1] = 3;

  __edge[ 5][0] = 1;
  __edge[ 5][1] = 2;

  __edge[ 6][0] = 5;
  __edge[ 6][1] = 6;

  __edge[ 7][0] = 4;
  __edge[ 7][1] = 7;

  __edge[ 8][0] = 0;
  __edge[ 8][1] = 4;

  __edge[ 9][0] = 1;
  __edge[ 9][1] = 5;

  __edge[10][0] = 2;
  __edge[10][1] = 6;

  __edge[11][0] = 3;
  __edge[11][1] = 7;
}

template <>
void ConnectivityBuilder<Structured3DMesh>::__setFaces()
{
  __face[0][0] = 4;
  __face[0][1] = 7;
  __face[0][2] = 3;
  __face[0][3] = 0;

  __face[1][0] = 1;
  __face[1][1] = 2;
  __face[1][2] = 6;
  __face[1][3] = 5;

  __face[2][0] = 4;
  __face[2][1] = 5;
  __face[2][2] = 1;
  __face[2][3] = 0;

  __face[3][0] = 3;
  __face[3][1] = 2;
  __face[3][2] = 6;
  __face[3][3] = 7;

  __face[4][0] = 0;
  __face[4][1] = 1;
  __face[4][2] = 2;
  __face[4][3] = 3;

  __face[5][0] = 7;
  __face[5][1] = 6;
  __face[5][2] = 5;
  __face[5][3] = 4;
}

template <>
void ConnectivityBuilder<Structured3DMesh>::__setEdges()
{
  __edge[ 0][0] = 0;
  __edge[ 0][1] = 1;

  __edge[ 1][0] = 2;
  __edge[ 1][1] = 3;

  __edge[ 2][0] = 6;
  __edge[ 2][1] = 7;

  __edge[ 3][0] = 4;
  __edge[ 3][1] = 5;

  __edge[ 4][0] = 0;
  __edge[ 4][1] = 3;

  __edge[ 5][0] = 1;
  __edge[ 5][1] = 2;

  __edge[ 6][0] = 5;
  __edge[ 6][1] = 6;

  __edge[ 7][0] = 4;
  __edge[ 7][1] = 7;

  __edge[ 8][0] = 0;
  __edge[ 8][1] = 4;

  __edge[ 9][0] = 1;
  __edge[ 9][1] = 5;

  __edge[10][0] = 2;
  __edge[10][1] = 6;

  __edge[11][0] = 3;
  __edge[11][1] = 7;
}

template <>
void ConnectivityBuilder<MeshOfTetrahedra>::__setFaces()
{
  __face[0][0] = 1;
  __face[0][1] = 2;
  __face[0][2] = 3;

  __face[1][0] = 3;
  __face[1][1] = 2;
  __face[1][2] = 0;

  __face[2][0] = 0;
  __face[2][1] = 1;
  __face[2][2] = 3;

  __face[3][0] = 2;
  __face[3][1] = 1;
  __face[3][2] = 0;
}

template <>
void ConnectivityBuilder<MeshOfTetrahedra>::__setEdges()
{
  __edge[0][0] = 0;
  __edge[0][1] = 1;

  __edge[1][0] = 0;
  __edge[1][1] = 2;

  __edge[2][0] = 0;
  __edge[2][1] = 3;

  __edge[3][0] = 1;
  __edge[3][1] = 2;

  __edge[4][0] = 3;
  __edge[4][1] = 1;

  __edge[5][0] = 2;
  __edge[5][1] = 3;
}

template <>
void ConnectivityBuilder<SurfaceMeshOfTriangles>::__setFaces()
{
  __face[0][0] = 1;
  __face[0][1] = 2;

  __face[1][0] = 2;
  __face[1][1] = 0;

  __face[2][0] = 0;
  __face[2][1] = 1;
}

template <>
void ConnectivityBuilder<SurfaceMeshOfTriangles>::__setEdges()
{
  __edge[0][0] = 0;
  __edge[1][0] = 1;
  __edge[2][0] = 2;
 }
