AC_DEFUN([AC_CHECK_VTK],
[
  REQUIRED_VTK_MAJOR=4
  REQUIRED_VTK_MINOR=2

  REQUIRED_VTK=`echo "$REQUIRED_VTK_MAJOR.$REQUIRED_VTK_MINOR"`

  AC_MSG_CHECKING([for VTK library (>= $REQUIRED_VTK)])

  vtkinclude=""
dnl look for vtk in standard pathes
  for i in /usr/include /usr/local/include
  do
    if test -e "$i/vtk/vtkConfigure.h"
    then
      VTK_VERSION=`grep VTK_VERSION $i/vtk/vtkConfigure.h`
      VTK_VERSION=`expr "$VTK_VERSION" : '.*"\(.*\)"' '|' "$VTK_VERSION"`
      vtkinclude=$i/vtk

      VTK_MAJOR=`expr "$VTK_VERSION" : '\(.*\)\..*\..*' '|' "$VTK_VERSION"`
      VTK_MINOR=`expr "$VTK_VERSION" : '.*\.\(.*\)\..*' '|' "$VTK_VERSION"`
      if test $VTK_MAJOR -lt $REQUIRED_VTK_MAJOR
      then
        FOUND_VTK=false
      else
        if test $VTK_MINOR -lt $REQUIRED_VTK_MINOR
        then
          FOUND_VTK=false
        else 
          FOUND_VTK=true
        fi
      fi
    fi
  done

  if test x$FOUND_VTK != xtrue
  then
     AC_MSG_RESULT(no)
  else
     AC_MSG_RESULT(yes)
     VTK_CXXFLAGS="-I$vtkinclude"
     VTK_LDADD="-lvtkRendering -lvtkGraphics -lvtkImaging -lvtkCommon"
  fi
  AC_SUBST(VTK_CXXFLAGS)
  AC_SUBST(VTK_LDADD)
])
