//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: TestFunctionExpression.hpp,v 1.3 2004/12/31 14:00:47 delpinux Exp $

#ifndef TEST_FUNCTION_EXPRESSION_HPP
#define TEST_FUNCTION_EXPRESSION_HPP

#include <Expression.hpp>
#include <Variable.hpp>

#include <Stringify.hpp>
#include <ErrorHandler.hpp>

#include<list>

class TestFunctionExpressionList
  : public Expression
{
private:
  typedef std::list<ReferenceCounting<TestFunctionVariable> > ListType;
  ListType __list;

  std::ostream& put(std::ostream& os) const
  {
    os << "tests Functions: ";
    for(ListType::const_iterator i = __list.begin();
	i != __list.end(); ++i) {
      os << (*(*i)).name() << ' ';
    }
    return os;
  }

public:
  /** 
   * Returns the number of test functions
   * 
   * 
   * @return size
   */
  const size_t size() const
  {
    return __list.size();
  }

  inline const size_t
  number(ReferenceCounting<TestFunctionVariable> f) const
  {
    size_t n = 0;
    for(ListType::const_iterator i = __list.begin(); i != __list.end(); ++i) {
      if ((*i) == f) {
	return n;
      }
      ++n;
    }

    const std::string errorMsg
      = stringify((*f).name())+" is not a variable of the test function list";

    throw ErrorHandler(__FILE__,__LINE__,
		       errorMsg,
		       ErrorHandler::normal);

    return 0;
  }


  void add(ReferenceCounting<TestFunctionVariable> t)
  {
    __list.push_back(t);
  }

  void execute()
  {
    ;
  }

  void subscribe();

  void unSubscribe();

  TestFunctionExpressionList()
    : Expression(Expression::testFunctionList)
  {
    ;
  }

  ~TestFunctionExpressionList()
  {
    ;
  }
};

#endif // TEST_FUNCTION_EXPRESSION_HPP

