package net.sf.freecol.common;

/**
 * Provides pseudo-random numbers like {@link java.util.Random}.
 * <p>
 * FreeCol code should not use the built-in random number classes directly, as
 * that makes it difficult to reproduce bugs. If all the random numbers for a
 * game are generated by the server it is possible to control the sequence by
 * starting with the same seed. It can still be difficult if multiple clients
 * request numbers in parallel, but at least it is a starting point.
 * <p>
 * With a given starting seed {@link java.util.Random} will return the same
 * sequence every time. Implementations of this interface should provide the
 * same guarantee.
 * <p>
 * NOTE! The client-side implementation is not required to return the same
 * sequence of numbers if a number is lost due to network failures. There
 * is an existing method in the server class that keeps track of old values
 * in order to return the same value multiple times, but that is overkill
 * here. If that guarantee is needed (in order to prevent cheating or
 * something) use the existing method.
 */
public interface PseudoRandom {
    static final String COPYRIGHT = "Copyright (C) 2003-2005 The FreeCol Team";
    static final String LICENSE = "http://www.gnu.org/licenses/gpl.html";
    static final String REVISION = "$Revision: 2319 $";

    /**
     * Get the next pseudo-random integer in a given range.
     * 
     * @param n The upper bound (exclusive).
     * @return random number between 0 (inclusive) and n (exclusive).
     */
    int nextInt(int n);
}
