# 1 "TCA_Automaton.c"
# 1 "<interne>"
# 1 "<ligne de commande>"
# 1 "TCA_Automaton.c"
/********************************************************************
* MACHINE TERMINALE TCA_Automaton
********************************************************************
* Descriptif : 
*  TCA_Automaton is a terminal machine and is in charge of managing the states
*  depending on the input events generated by TCR_FileReader or TCW_FileWriter.
*  and also emitting the events based on the state transition.
*
*********************************************************************/
/********************************************************************
*CONTEXTE
*********************************************************************/

# 1 "TCA_Automaton.i" 1
/********************************************************************
* MACHINE TERMINALE TCA_Automaton
********************************************************************
* Mnemonique : 
*  TCA
*
* Definition : 
*  TCA_Automaton is a terminal machine and is in charge of managing the states
*  depending on the input events generated by TCR_FileReader or TCW_FileWriter.
*  and also emitting the events based on the state transition.
*
* Particularites : 
*              AUCUNE
*********************************************************************/
# 1 "/projets/u3cat/ETUDES/ASF/DLAC_V1_3/DLAC/src/frama-c/inc/STANDARD_C.h" 1




/********************************************************************
* MACHINE TERMINALE STANDARD_C
********************************************************************
* Mnemonique : 
*  UST
*
* Definition : 
*    STANDARD_C abstract machine is makes to replace services of standard
*  C library, to allow 
*   to perform all covering tests on embedded code
*   It also define:
*   - all basic types used by subsets of CMS-ACD function
*   - PORTABLES services, independant on the storing mode of bytes in memory,
*  
*   performed by the CPU
*   - a CRC computation service, used by several subsets
*   - a formatting service, allowing to switch from a LittelEndian or BigEndian
*  
*   platform (PACK) to AFDX (BigEndian) world,
*   - a unformattind service, allowing to switch from AFDS world (BigEndian)
*  to
*   LittelEndian or BigEndian platform (UNPACK).
* 
*  A data coded on serveral bytes respecting the Big-Edian convention means
*  that
*  le most significant byte of the data is located  at the lowest adress.
*  A data coded on serveral bytes respecting the Little-Edian convention
*  means 
*  that le less significant byte of the data is located  at the lowest adress.
* 
*  For example, 32 bytes data which value is 0xDEADBEEF will be represented
*  in 
*  memory as follow:
*      Big-endian memory                Little-endian memory
*     storing convention                 storing convention
*      Address   Value                    Address   Value
*      -------   -----                    -------   -----
*      @Base     DE                       @Base       EF
*      @Base+1   AD                       @Base+1     BE
*      @Base+2   BE                       @Base+2     AD
*      @Base+3   EF                       @Base+3     DE
* 
*  Of course the principle is the same for a data coded on 16 binary digits
*  (2 bytes),
*  or 64 binary digits (8 bytes).
*  Remark: The order of binary digit of each byte remains unchanged.
* 
*  For CMS-ACD needs, only services PACK/UNPACK for 16,  32 et 64 binary
*  digits data are
*  implemented.
*
* Particularites : 
*              AUCUNE
*********************************************************************/

/********************************************************************
*TYPES, RESSOURCES, CONSTANTES EXPORTES
*********************************************************************/

typedef enum {FALSE=0, TRUE=1} BOOLEAN;

typedef char CHAR;

typedef unsigned char BYTE;

typedef BYTE * TP_BYTE;

typedef TP_BYTE const TP_BYTE_CST;

typedef char* STRING;

typedef STRING const STRING_CST;

typedef float FLOAT32;

typedef FLOAT32 * TP_FLOAT32;

typedef double FLOAT64;

typedef FLOAT64 * TP_FLOAT64;

typedef signed char INT8;

typedef INT8 * TP_INT8;

typedef signed short INT16;

typedef INT16 * TP_INT16;

typedef signed int INT32;

typedef INT32 * TP_INT32;

typedef unsigned char UINT8;

typedef unsigned char * TP_UINT8;

typedef unsigned short int UINT16;

typedef UINT16 * TP_UINT16;

typedef unsigned int UINT32;

typedef UINT32 * TP_UINT32;

typedef void VOID;

typedef void * TP_VOID;

typedef void * const TP_VOID_CST;

typedef unsigned short WORD16;

typedef WORD16 * TP_WORD16;

typedef unsigned int WORD32;

typedef WORD32 * TP_WORD32;

typedef unsigned long long WORD64;

typedef WORD64 * TP_WORD64;

typedef unsigned long long INT64;

typedef char ** STRING_ARRAY;
# 164 "/projets/u3cat/ETUDES/ASF/DLAC_V1_3/DLAC/src/frama-c/inc/STANDARD_C.h"
/********************************************************************
*SERVICES EXPORTES
*********************************************************************/



/********************************************************************
* SERVICE  UST_Me_PackBigEndian16
********************************************************************
*
* Fonction : 
*   Function : 
*    This macro convert a data of any type coded on 16 binary digits (Value16digits)
*     into a table of 2 bytes (ValBigEndian), coded on BigEndian convention.
*    This macro is independant of the platform architecture (on LittleEndian
*   or BigEndian 
*    convention) and must be used when ever the user shall export a data coded
*   on 16 binary
*    digits, directlly or indirectly.
*    
*    Input parameters :
*       - Value16digits : variable to be converted (its type doesn't matter,
*   its shall 
*    be coded 16 binary digits)
*    
*    Output parameters :
*       - ValBigEndian : table of 2 bytes, allocated by the user, containing
*   the variable 
*    after conversion.
*  
*********************************************************************/



/********************************************************************
* SERVICE  UST_Me_PackBigEndian32
********************************************************************
*
* Fonction : 
*   Function : 
*    This macro convert a data of any type of 32 binary digits (Value32digits)
*    in a table of 4 bytes (ValBigEndian) on BigEndian convention
*    This macro is not dependant on platform architecture (LittleEndian or
*   BigEndian convention),
*    and must be used when ever the user shall export a data of 32 binary
*   digits, 
*    directly or indirectly.
*    
*    Input parameters:
*       - Value32digits : variable to be convert (the type of the variable
*   doesn't matter, the variable 
*    just needs to be coded on 32 binary digits)
*    
*    Ouput parameters:
*       - ValBigEndian : table of 4 bytes, allocated by the user, containing
*   
*     the variable after conversion.
*  
*********************************************************************/



/********************************************************************
* SERVICE  UST_Me_PackBigEndian64
********************************************************************
*
* Fonction : 
*   Function : 
*    This macro convert a data of any type coded on 64 binary digits (Value64digits)
*     into a table of 8 bytes (ValBigEndian) on BigEndian convention.
*    This macro is not dependent on the platform architecture (on LittleEndian
*   or BigEndian convention) and must be used 
*    when ever the user shall export a data on 64 binary digits, directly
*   ou indirectly.
*    
*    Input parameters :
*       - Value64digits : variable to be converted (its type doesn't matter,
*   it just 
*     need to be coded on 64 binary digits)
*    
*    Ouput parameters :
*       - ValBigEndian : table of 8 octets, allocated by the user, containing
*     the variable after conversion.
*  
*********************************************************************/



/********************************************************************
* SERVICE  UST_Me_UnpackBigEndian16
********************************************************************
*
* Fonction : 
*   Function : 
*    This macro converts a table of 2 bytes (ValBigEndian) on BigEndian 
*    convention into a data of any type on 16 binary digits
*     (Value16digits).
*    This macro does not depend on the platform architecture 
*     (on LittleEndian or BigEndian convention)and must be used when ever
*     the user shall interpret a data coded on 16 bits
*    
*    Input parameters :
*       - ValBigEndian : table of 2 bytes, containing the value to convert.
*    
*    Ouput parameters :
*       - Value16digits : converted result (whatever the type is)
*  
*********************************************************************/



/********************************************************************
* SERVICE  UST_Me_UnpackBigEndian32
********************************************************************
*
* Fonction : 
*   Function : 
*    This macro converts a table of 4 bytes (ValBigEndian) on BigEndian 
*    convention into a data of any type on 32 binary digits
*     (Value32digits).
*    This macro does not depend on the platform architecture 
*     (on LittleEndian or BigEndian convention)and must be used when ever
*     the user shall interpret a data coded on 32 bits
*    
*    Input parameters :
*       - ValBigEndian : table of 4 bytes, containing the value to convert.
*    
*    Ouput parameters :
*       - Value32digits : converted result (whatever the type is)
*  
*********************************************************************/



/********************************************************************
* SERVICE  UST_Me_UnpackBigEndian64
********************************************************************
*
* Fonction : 
*   Function : 
*    This macro converts a table of 8 bytes (ValBigEndian) on BigEndian 
*    convention into a data of any type on 64 binary digits
*     (Value64digits).
*    This macro does not depend on the platform architecture 
*     (on LittleEndian or BigEndian convention)and must be used when ever
*     the user shall interpret a data coded on 64 bits
*    
*    Input parameters :
*       - ValBigEndian : table of 8 bytes, containing the value to convert.
*    
*    Ouput parameters :
*       - Value64digits : converted result (whatever the type is)
*  
*********************************************************************/



/********************************************************************
* SERVICE  UST_Se_MemCmp
********************************************************************
*
* Fonction : 
*   Function : 
*    This service compares byte by byte, 2 blocks of NbByt bytes stored
*     respectively in addresses BlocMem1 and BlocMem2. The contain of each
*   byte
*     is interpreted as a natural integer belonging to the range 0..255.
*    
*    Input parameters :
*       - BlocMem1 : memory address of one of blocks to be compared 
*     ;
*       - BlocMem2 : memory address of the other block ;
*       - NbByt    : number of bytes on wich the comparaison shall be done.
*    
*    Ouput parameters :
*    
*    Returned value :
*       The function returns a signed integer which report the comparaison
*   result:
*        0 if block1 = block2 or if NbByt is null ;
*       >0 si block1 > block2 ;
*       <0 si block1 < block2.
*  
*********************************************************************/
extern INT32 UST_Se_MemCmp
      (const void * const /* in */ string1,
      const void * const /* in */ string2,
      const INT32 /* in */ size);


/********************************************************************
* SERVICE  UST_Se_MemCpy
********************************************************************
*
* Fonction : 
*   Function : 
*    This service copies to memory address BlocMem1 (destination) a block
*   of NbByt
*    consecutive bytes stored at memory address BlocMem2 (source).
*    If NbByt is null, BlocMem1 remains unchanged.
*    
*    Input parameters :
*       - dest : address of memory block to be crushed;
*       - src : address of memory block to be copied ;
*       - size   : number of bytes to be copied.
*    
*    Ouput parameters :
*  
*********************************************************************/
//extern void UST_Se_MemCpy
//      (VOID * const 	/* out */	dest, 
//      const void * const 	/* in */	src, 
//      const INT32 	/* in */	size);



/********************************************************************
* SERVICE  UST_Se_MemMove
********************************************************************
*
* Fonction : 
*   Function : 
*    This function copies NbOctets bytes of the area ZoneMem2 (source) in
*   area ZoneMem1
*     (destination) while managing any possible overlap between the two memory
*   areas.
*    If NbBytes is nul, ZoneMem1 remains unchanged.
*    
*    Input parameters :
*       - ZoneMem1 : address of the memory area which will be crushed ;
*       - ZoneMem2 : address of the memory area which will be copied  ;
*       - NbBytes : number of bytes to be copied.
*    
*    Ouput parameters :
*  
*********************************************************************/
//extern void UST_Se_MemMove
//      (VOID * const 	/* out */	dest, 
//      const void * const 	/* in */	src, 
//      const INT32 	/* in */	size);



/********************************************************************
* SERVICE  UST_Se_MemSet
********************************************************************
*
* Fonction : 
*   Function : 
*    This service initialises a memory block of NbByt consecutive bytes located
*   
*    a the address BlocMem with the value ValByt.
*    If NbByt is null, BlocMem remains uninitialised.
*    
*    Input parameters :
*       - BlocMem : address of the memory area to be initialised ;
*       - ValByt  : value to initialise all bytes of the memory area with;
*       - NbByt   : number of bytes to be initialised.
*    
*    Ouput parameters :
*  
*********************************************************************/
//extern void UST_Se_MemSet
//      (VOID * const 	/* out */	s, 
//      const INT32 	/* in */	c, 
//      const INT32 	/* in */	size);



/********************************************************************
* SERVICE  UST_Se_StrCat
********************************************************************
*
* Fonction : 
*   Function : 
*    This service concatenates a copy of string String2 (source)
*    with string String1 (destination), in the order "String1String2",
*    and add the character "enf of string" at the end of the result .
*    The first character of String2 crushs the character end of string String1.
*    The result of the concatenation is stored in String1.
*    
*    Input parameters :
*       - String1 : address of the destination string ;
*       - String2 : address of the source string.
*    
*    Ouput parameters :
*    
*    Returned code :
*  
*********************************************************************/
extern void UST_Se_StrCat
      (CHAR * const /* out */ dest,
      const char * const /* in */ src);


/********************************************************************
* SERVICE  UST_Se_StrCmp
********************************************************************
*
* Fonction : 
*   Function : 
*    This service compares character by character the strings String1
*    and String2 by comparing their ASCII value.
*    
*    The comparison stops if the character "end of string" is found in one
*   of 
*    the two strings.
*    
*    Input parameters :
*       - String1 : address of one strings to be compared ;
*       - String2 : address of the other string.
*    
*    Ouput parameters :
*    
*    Returned value :
*     The function returns a signed integer which reports the result of the
*   
*     comparison :
*        0 if String1 = String2
*       >0 if String1 > String2
*       <0 if String1 < String2.
*  
*********************************************************************/
extern INT32 UST_Se_StrCmp
      (const char * const /* in */ string1,
      const char * const /* in */ string2);


/********************************************************************
* SERVICE  UST_Se_StrCpy
********************************************************************
*
* Fonction : 
*   Function : 
*    This service copies the string String2 (source) int the string String1
*   (destination), until and including the characer "end of string". 
*   The copy stops as soon as the character "end of string" of String2(source)
*   
*   is encountered.
*    The result od the copy is strored in String1.
*    
*    Input parameters :
*       - String1 : address of the string to be crushed ;
*       - String2 : address of the string to be copied.
*    
*    Ouput parameters :
*    
*    Returned code :
*  
*********************************************************************/

extern void UST_Se_BisStrCpy
      (CHAR * const /* out */ dest,
      const char * const /* in */ src);


/********************************************************************
* SERVICE  UST_Se_StrLen
********************************************************************
*
* Fonction : 
*   Function : 
*    This service returns the number of characters hold in the string "String",
*    excluding the character "end of string".
*    
*    Input parameters :
*       - String : address of the string, which the size is to be measured.
*    
*    Ouput parameters :
*    
*    Returned value :
*       - the length of the string, expressed in number of bytes.
*  
*********************************************************************/
extern INT32 UST_Se_StrLen
      (const char * const /* in */ string);


/********************************************************************
* SERVICE  UST_Se_StrnCat
********************************************************************
*
* Fonction : 
*   Function : 
*    This service concatenates at most the NbChar firsts characters of String2
*   (source)
*    after the string String1 (destination) and add the character "end of
*   string" at the
*    end of the result .
*    The first character of String2 crushes the character "enf of string"
*   of String1.
*    The result of the concatenation is stored in String1.
*    If NbChar is null, String remains unchanged.
*    
*    Input parameters :
*       - String1 : address of the destination string ;
*       - String2 : address of the source string ;
*       - NbChar  : number of characters of String2 to be concatenate after
*   String1.
*    
*    Ouput parameters :
*    
*    Returned code :
*  
*********************************************************************/
extern void UST_Se_StrnCat
      (CHAR * const /* out */ dest,
      const char * const /* in */ src,
      const INT32 /* in */ size);


/********************************************************************
* SERVICE  UST_Se_StrnCmp
********************************************************************
*
* Fonction : 
*   Function : 
*    This service compares character by character at most the NbChar first
*     characters of strings String1 and String2 by comparing their ASCII value.
*    The comparison stops if the character "end of string" is encountered
*   
*    in one of the two strings.
*    If NbChar is null, the service returns 0.
*    
*    Input parameters :
*       - String1 : address of one the two strings to be compared ;
*       - String2 : address of the other string ;
*       - NbChar   : number of characters on which the comparison must be
*   done.
*    
*    Ouput parameters :
*    
*    Returned value :
*       The function returns a signed integer which reports the result of
*   the comparison :
*        0 if String1 = String2 or if NbByt is null ;
*       >0 if String1 > String2 ;
*       <0 if String1 < String2.
*  
*********************************************************************/
extern INT32 UST_Se_StrnCmp
      (const char * const /* in */ string1,
      const char * const /* in */ string2,
      const INT32 /* in */ size);


/********************************************************************
* SERVICE  UST_Se_StrnCpy
********************************************************************
*
* Fonction : 
*   Function : 
*    This service copies exactly the NbChar first characters of String2
*     (source) in String1 (destination), truncking String2 (source) or adding
*   to
*     String1 (destination) the character '\0' if necessary.
*    If the number of characters to be copied (NbChar) is bigger than the
*   number of
*     characters of String2 (source), String1 (destination) is completed with
*     le character '\0' until NbChar.
*    If the number of characters to be copied (NbChar) is lower than the number
*   of
*     characters of String2 (source) AND bigger than the number of characters
*   de
*     String1 (destination), the character '\0' is inserted at end of copy.
*    If those two conditions are not fulfilled, the character '\0' is not
*     inserted at end of the copy.
*    
*    The result of the copy is stored in String1.
*    If NbChar is null, String1 ramains unchanged.
*    
*    Input parameters :
*       - String1 : address of the string to be crushed ;
*       - String2 : address of the string to be copied  ;
*       - NbChar  : number  of characters to be copied.
*    
*    Ouput parameters :
*    
*    Returned code :
*  
*********************************************************************/
extern void UST_Se_StrnCpy
      (CHAR * const /* out */ dest,
      const char * const /* in */ src,
      const INT32 /* in */ size);



/********************************************************************
* SERVICE  UST_Me_Assert
********************************************************************
*
* Fonction : 
*  assertion Macro
*  
*********************************************************************/
# 16 "TCA_Automaton.i" 2
# 1 "TCA_Automaton.h" 1




/********************************************************************
* MACHINE TERMINALE TCA_Automaton
********************************************************************
* Mnemonique : 
*  TCA
*
* Definition : 
*  TCA_Automaton is a terminal machine and is in charge of managing the states
*  depending on the input events generated by TCR_FileReader or TCW_FileWriter.
*  and also emitting the events based on the state transition.
*
* Particularites : 
*              AUCUNE
*********************************************************************/

/********************************************************************
*TYPES, RESSOURCES, CONSTANTES EXPORTES
*********************************************************************/

typedef enum {
TCA_E_INIT=0,
TCA_E_TX_WAIT,
TCA_E_RX_WAIT,
TCA_E_TX_DATA,
TCA_E_RX_DATA
}TCA_Te_States;
/*
typedef enum{
TCA_E_RD_BLK_KO,
TCA_E_WR_BLK_KO,
TCA_E_RD_BLK_OK,
TCA_E_WR_BLK_OK,
TCA_E_RD_FILE_REQ,
TCA_E_WR_FILE_REQ,
TCA_E_DATA,
TCA_E_TIMER_EXP,
TCA_E_OACK,
TCA_E_ACK,
TCA_E_BLK_SIZE_KO,
TCA_E_MAX_RETRY_REACHED,
TCA_E_DONE,
TCA_E_ERROR
}TCA_Te_Events;

typedef enum{
TCA_E_SEND_ERROR,
TCA_E_WR_BLK,
TCA_E_CLOSE_CONN,
TCA_E_START_TIMER,
TCA_E_RD_BLK,
TCA_E_SEND_WRQ,
TCA_E_SEND_RRQ,
TCA_E_SEND_ACK,
TCA_E_SEND_DATA,
TCA_E_RESEND
}TCA_Te_Emissions;

typedef WORD32 TCA_Td_AutomatonInputs;

typedef WORD32 TCA_Td_AutomatonOutputs;

typedef struct{
TCA_Td_AutomatonInputs InputEvents;
TCA_Td_AutomatonOutputs OutputEvents;
TCA_Te_States CurrentState;
}TCA_Ts_Automaton;
*/
/********************************************************************
*SERVICES EXPORTES
*********************************************************************/



/********************************************************************
* SERVICE  TCA_Se_Init
********************************************************************
*
* Fonction : 
*  TCA_Se_Init Initializes the Client Automaton default state to INIT
*  - Initialize the default maximum retry number
*  
*  In Parameters
*  none
*  
*  Out Parameters
*  Automaton: Automaton state information.
*  
*********************************************************************/
extern void TCA_Se_Init();
      //(TCA_Ts_Automaton * const 	/* out */	Automaton);


/********************************************************************
* SERVICE  TCA_Se_Reset
********************************************************************
*
* Fonction : 
*  TCA_Se_Reset re-initialize the state to default, and turns off all the
*   in and out events.
*  
*  Out Parameters
*  Automaton: Automaton state information.
*  
*********************************************************************/
extern void TCA_Se_Reset();
      //(TCA_Ts_Automaton * const 	/* out */	Automaton);


/********************************************************************
* SERVICE  TCA_Se_Automate
********************************************************************
*
* Fonction : 
*  TCA_Se_Automate evaluates the input events and change the state if necessary
*   to next state
*  and emits the out events.
*  
*  Out Parameters
*  Automaton: Automaton state information.
*  
*********************************************************************/
extern void TCA_Se_Automate();
      //(TCA_Ts_Automaton * const 	/* in out */	Automaton);


/********************************************************************
* SERVICE  TCA_Se_SetEvent
********************************************************************
*
* Fonction : 
*  TCA_Se_SetEvent asserts the given event.
*  
*  In Parameters
*  Event input event raised.
*  
*  Out Parameters
*  Automaton: Automaton state information.
*  
*********************************************************************/

//extern void TCA_Se_SetEvent
      //(const TCA_Te_Events 	/* in */	Event, 
      //TCA_Ts_Automaton * const 	/* out */	Automaton);


/********************************************************************
* SERVICE  TCA_Se_IsEventSet
********************************************************************
*
* Fonction : 
*  TCA_Se_IsEvebtSet returns TRUE if the corresponding event is asserted,
*   else FALSE.
*  
*  In Parameters
*  Event: output event raised by automaton.
*  
*  Out Parameters
*  Automaton: Automaton state information.
*  
*  Return Code
*  returns TRUE if the corresponding event is asserted, else FALSE(BOOLEAN).
*  
*********************************************************************/
//extern BOOLEAN TCA_Se_IsEventSet
      //(const TCA_Te_Emissions 	/* in */	Event, 
      //const TCA_Ts_Automaton 	/* in */	Automaton);
# 17 "TCA_Automaton.i" 2
# 15 "TCA_Automaton.c" 2

/********************************************************************
*RESSOURCES et CONSTANTES EXPORTEES
*********************************************************************/



// Input ports
int TCA_E_RD_BLK_KO=0;
int TCA_E_WR_BLK_KO=0;
int TCA_E_RD_BLK_OK=0;
int TCA_E_WR_BLK_OK=0;
int TCA_E_RD_FILE_REQ=0;
int TCA_E_WR_FILE_REQ=0;
int TCA_E_DATA=0;
int TCA_E_TIMER_EXP=0;
int TCA_E_OACK=0;
int TCA_E_ACK=0;
int TCA_E_BLK_SIZE_KO=0;
int TCA_E_MAX_RETRY_REACHED=0;
int TCA_E_DONE=0;
int TCA_E_ERROR=0;

// Output ports
int TCA_E_SEND_ERROR=0;
int TCA_E_WR_BLK=0;
int TCA_E_CLOSE_CONN=0;
int TCA_E_START_TIMER=0;
int TCA_E_RD_BLK=0;
int TCA_E_SEND_WRQ=0;
int TCA_E_SEND_RRQ=0;
int TCA_E_SEND_ACK=0;
int TCA_E_SEND_DATA=0;
int TCA_E_RESEND=0;

TCA_Te_States CurrentState;

/********************************************************************
*TYPES, DONNEES, CONSTANTES INTERNES
*********************************************************************/



/********************************************************************
*TYPES, DONNEES, CONSTANTES MANUELLES
*********************************************************************/



/********************************************************************
*SERVICES INTERNES
*********************************************************************/
/********************************************************************
* SERVICE  TCA_Si_SetOutputEvent
********************************************************************
*
* Fonction : 
*  TCA_Si_SetOutputEvent asserts output event. 
*  
*********************************************************************/
//void TCA_Si_SetOutputEvent
//(const TCA_Te_Emissions 	/* in */	Event,TCA_Ts_Automaton* Automaton);


/********************************************************************
* SERVICE  TCA_Si_ClearOutputEvents
********************************************************************
*
* Fonction : 
*  TCA_Si_ClearOutputEvents Clears all output events aserted. 
*  
*********************************************************************/
void TCA_Si_ClearOutputEvents();//TCA_Ts_Automaton* /*out*/Automaton);


/********************************************************************
* SERVICE  TCA_Si_IsInputEventSet
********************************************************************
*
* Fonction : 
*  TCA_Si_IsInputEventSet Returns TRUE if the given input event is 
*asserted, else returns FALSE. 
*  
*********************************************************************/
/* */
//BOOLEAN TCA_Si_IsInputEventSet(const TCA_Te_Events 	/* in */	Event,
//                               TCA_Ts_Automaton* /*out*/Automaton);

/********************************************************************
* SERVICE  TCA_Si_ClearInputEvents
********************************************************************
*
* Fonction : 
*  TCA_Si_ClearInputEvents Clears all the input events
*  
*********************************************************************/
void TCA_Si_ClearInputEvents();//TCA_Ts_Automaton * /*out*/Automaton);

/********************************************************************
*CORPS DES SERVICES EXPORTES
*********************************************************************/

/*$*/
/*$********************************************************************/
/*$ SERVICE  TCA_Se_Init*/
/*$********************************************************************/
/* Description
*TCA_Se_Init Initializes the Client Automaton default state to INIT
*  - Initialize the default maximum retry number
*  
*  In Parameters
*  none
*  
*  Out Parameters
*  Automaton: Automaton state information.
*  
* Flots de controle et de donnees
*[initializes the automaton state and events to default values]
*  
* Contraintes : 
*********************************************************************/
void TCA_Se_Init()
//(TCA_Ts_Automaton * const 	/* out */	Automaton)
{
    /*initialize the automaton to default values*/
    CurrentState = TCA_E_INIT;

    /*clear input events*/
    //Automaton->InputEvents = 0x0;
    /*clear output events*/
    //Automaton->OutputEvents = 0x0;

    TCA_Si_ClearInputEvents();
    TCA_Si_ClearOutputEvents();

}
/*$*/
/*$********************************************************************/
/*$ SERVICE  TCA_Se_Reset*/
/*$********************************************************************/
/* Description
*TCA_Se_Reset re-initialize the state to default, and turns off all the
*   in and out events.
*  
*  Out Parameters
*  Automaton: Automaton state information.
*  
* Flots de controle et de donnees
*[clears all the input events and output events, reset state to INIT]
*  
* Contraintes : 
*********************************************************************/
void TCA_Se_Reset()
//(TCA_Ts_Automaton * const 	/* out */	Automaton)
{
    /*initialize the automaton to default values*/
    //CurrentState = TCA_E_INIT;
    /*clear input events*/
    //Automaton->InputEvents = 0x0;
    /*clear output events*/
    //Automaton->OutputEvents = 0x0;

    /*initialize the automaton to default values*/
    CurrentState = TCA_E_INIT;
    TCA_Si_ClearInputEvents();
    TCA_Si_ClearOutputEvents();
}
/*$*/
/*$********************************************************************/
/*$ SERVICE  TCA_Se_Automate*/
/*$********************************************************************/
/* Description
*TCA_Se_Automate evaluates the input events and change the state if necessary
*   to next state
*  and emits the out events.
*  
*  Out Parameters
*  Automaton: Automaton state information.
*  
* Flots de controle et de donnees
*[automates the input events depending on the current state of the automaton]
*  
* Contraintes : 
*********************************************************************/
/*@
@  requires TCA_E_RD_FILE_REQ==0 || TCA_E_RD_FILE_REQ==1;
@  requires TCA_E_WR_FILE_REQ==0 || TCA_E_WR_FILE_REQ==1;
@  requires TCA_E_DATA==0 || TCA_E_DATA==1;
@  requires TCA_E_ACK==0 || TCA_E_ACK==1;
@  requires TCA_E_TIMER_EXP==0 || TCA_E_TIMER_EXP==1;
@  requires TCA_E_WR_BLK_OK==0 || TCA_E_WR_BLK_OK==1;
@  requires TCA_E_RD_BLK_OK==0 || TCA_E_RD_BLK_OK==1;
@  requires TCA_E_RD_BLK_KO==0 || TCA_E_RD_BLK_KO==1;
@  requires TCA_E_WR_BLK_KO==0 || TCA_E_WR_BLK_KO==1;
@  requires TCA_E_BLK_SIZE_KO==0 || TCA_E_BLK_SIZE_KO==1;
@  requires TCA_E_MAX_RETRY_REACHED==0 || TCA_E_MAX_RETRY_REACHED==1;
@  requires TCA_E_DONE==0 || TCA_E_DONE==1;
@  requires TCA_E_OACK==0 || TCA_E_OACK==1;
@  requires TCA_E_ERROR==0 || TCA_E_ERROR==1;
@  requires TCA_E_SEND_RRQ==0 || TCA_E_SEND_RRQ==1;
@  requires TCA_E_SEND_WRQ==0 || TCA_E_SEND_WRQ==1;
@  requires TCA_E_START_TIMER==0 || TCA_E_START_TIMER==1;
@  requires TCA_E_SEND_DATA==0 || TCA_E_SEND_DATA==1;
@  requires TCA_E_CLOSE_CONN==0 || TCA_E_CLOSE_CONN==1;
@  requires TCA_E_RD_BLK==0 || TCA_E_RD_BLK==1;
@  requires TCA_E_WR_BLK==0 || TCA_E_WR_BLK==1;
@  requires TCA_E_RESEND==0 || TCA_E_RESEND==1;
@  requires TCA_E_SEND_ERROR==0 || TCA_E_SEND_ERROR==1;
@  requires TCA_E_SEND_ACK==0 || TCA_E_SEND_ACK==1;
@  behavior state_RX_WAIT:
@ 	assumes CurrentState==TCA_E_RX_WAIT;
@ 	ensures from_RX_WAIT_to_INIT2_1 : (\old(TCA_E_BLK_SIZE_KO)) && !(\old(TCA_E_OACK) && ! (\old(TCA_E_BLK_SIZE_KO))) ==> CurrentState==TCA_E_INIT;
@*/
void TCA_Se_Automate()
//(TCA_Ts_Automaton * const 	/* in out */	Automaton)
{
    /*temparry flag to store the event status*/
    BOOLEAN TempFlag=FALSE;

    /* Clear output events.*/
    TCA_Si_ClearOutputEvents();//Automaton);

    /*automate the emission and chagne of state depending on the current state
    * and input event.*/
    switch(CurrentState)
    {



    case TCA_E_RX_WAIT:
        /*If the block size negotiation failed*/
        if(TCA_E_BLK_SIZE_KO == TRUE)
        {
            /* send error, close connection and change state to init*/
            TCA_E_SEND_ERROR = TRUE;

            /*raise close connectin event*/
            TCA_E_CLOSE_CONN = TRUE;

            /* change state to TCA_E_INIT*/
            CurrentState = TCA_E_INIT;
        }
        /*when OACK event is raised*/
        if(TCA_E_OACK == TRUE)
        {
            /*if block size is ok*/
            if(!(TCA_E_BLK_SIZE_KO == TRUE))
            {
                /* raise send ACK and start timer event */
                TCA_E_SEND_ACK = TRUE;

                /*raise TCA_E_START_TIMER event*/
                TCA_E_START_TIMER = TRUE;
            }

        }
        /* when DATA event is raised*/
        else if(TCA_E_DATA == TRUE)
        {

            /*if not final ack*/
            if(!(TCA_E_DONE == TRUE))
            {
                /*raise write block event and change state to RX_DATA*/
                TCA_E_WR_BLK = TRUE;
                CurrentState = TCA_E_RX_DATA;
            }
        }
        /* when timer exp event is raised */
        else if(TCA_E_TIMER_EXP == TRUE)
        {
            /*store TCA_E_MAX_RETRY_REACHED status in to TempFlag*/
            TempFlag =
                (TCA_E_MAX_RETRY_REACHED == TRUE);
            /*if neither maximum retry reached nor transfer is completed*/
            if(! (TempFlag==TRUE
                || (TCA_E_DONE == TRUE)))
            {
                /* raise resend event*/
                TCA_E_RESEND = TRUE;
            }
        }
        /* wehen timer expire event is raised and */
        else if(TCA_E_TIMER_EXP == TRUE)
        {
            TempFlag =
                (TCA_E_MAX_RETRY_REACHED == TRUE);
            /*if either maximum retry reached or transfer is completed*/
            if(TempFlag==TRUE
                || (TCA_E_DONE == TRUE))
            {
                /*raise close connection and change state to INIT*/
                TCA_E_CLOSE_CONN = TRUE;

                /* change state to TCA_E_INIT*/
                CurrentState = TCA_E_INIT;
            }

        }
        else
        {
            /*Invalid input event.*/
        }

        break;

    default:
        break;
    }

    /*clear all the input events as ther processing is comleted*/
    TCA_Si_ClearInputEvents();//Automaton);
}
/*$*/
/*$********************************************************************/
/*$ SERVICE  TCA_Se_SetEvent*/
/*$********************************************************************/
/* Description
*TCA_Se_SetEvent asserts the given event.
*  
*  In Parameters
*  Event input event raised.
*  
*  Out Parameters
*  Automaton: Automaton state information.
*  
* Flots de controle et de donnees
*[set the corresponding event to TRUE, to say it is raised]
*  
* Contraintes : 
*********************************************************************/
//void TCA_Se_SetEvent
//(const TCA_Te_Events 	/* in */	Event, 
// TCA_Ts_Automaton * const 	/* out */	Automaton)
//{
//    /* Set Event raised indication in Automaton->InputEvents */
//    Automaton->InputEvents = (TCA_Td_AutomatonInputs)
//        ((1<<(WORD32)Event)|Automaton->InputEvents);
//    
//}
/*$*/
/*$********************************************************************/
/*$ SERVICE  TCA_Se_IsEventSet*/
/*$********************************************************************/
/* Description
*TCA_Se_IsEvebtSet returns TRUE if the corresponding event is asserted,
*   else FALSE.
*  
*  In Parameters
*  Event: output event raised by automaton.
*  
*  Out Parameters
*  Automaton: Automaton state information.
*  
*  Return Code
*  returns TRUE if the corresponding event is asserted, else FALSE.
*  
* Flots de controle et de donnees
*[returns TRUE if the requested event is raised]
*  
* Contraintes : 
*********************************************************************/
//BOOLEAN TCA_Se_IsEventSet
//(const TCA_Te_Emissions 	/* in */	Event, 
// const TCA_Ts_Automaton 	/* in */	Automaton)
//{
//    /*TRUE if the corresponding event is asserted, else FALSE*/
//    return (BOOLEAN)((0x0001) & (Automaton.OutputEvents>>(INT32)Event));
//}

/*$*/
/********************************************************************
*CORPS DES SERVICES INTERNES
*********************************************************************/
/*$*/
/*$********************************************************************/
/*$ SERVICE  TCA_Si_SetOutputEvent*/
/*$********************************************************************/
/* Description
*TCA_Si_SetOutputEvent asserts the given event in to output event list.
*  
*  In Parameters
*  Event output event raised.
*  
* Flots de controle et de donnees
*  AUCUN
* Contraintes : 
*********************************************************************/
//void TCA_Si_SetOutputEvent
//(const TCA_Te_Emissions 	/* in */Event,TCA_Ts_Automaton* /*out*/ Automaton)
//{
//    
//    /* Set Event raised indication in Automaton->InputEvents */
//    Automaton->OutputEvents = (TCA_Td_AutomatonOutputs)
//        ((1<<(WORD32)Event)|Automaton->OutputEvents);
//    
//}

/*$*/
/*$********************************************************************/
/*$ SERVICE  TCA_Si_ClearOutputEvents*/
/*$********************************************************************/
/* Description
*TCA_Si_ClearOutputEvents clears output events list.
*  
* Flots de controle et de donnees
*  AUCUN
* Contraintes : 
*********************************************************************/
/*@ ensures (TCA_E_SEND_ERROR==0);
  @ ensures (TCA_E_WR_BLK==0);
  @ ensures (TCA_E_CLOSE_CONN==0);
  @ ensures (TCA_E_START_TIMER==0);
  @ ensures (TCA_E_RD_BLK==0);
  @ ensures (TCA_E_SEND_WRQ==0);
  @ ensures (TCA_E_SEND_RRQ==0);
  @ ensures (TCA_E_SEND_ACK==0);
  @ ensures (TCA_E_SEND_DATA==0);
  @ ensures (TCA_E_RESEND==0);
  @*/
void TCA_Si_ClearOutputEvents()
//(TCA_Ts_Automaton* /*out*/Automaton)
{

    /* Cleare output events list */
    //Automaton->OutputEvents = 0;

  TCA_E_SEND_ERROR=0;
  TCA_E_WR_BLK=0;
  TCA_E_CLOSE_CONN=0;
  TCA_E_START_TIMER=0;
  TCA_E_RD_BLK=0;
  TCA_E_SEND_WRQ=0;
  TCA_E_SEND_RRQ=0;
  TCA_E_SEND_ACK=0;
  TCA_E_SEND_DATA=0;
  TCA_E_RESEND=0;
}

/*$*/
/*$********************************************************************/
/*$ SERVICE  TCA_Si_SetOutputEvent*/
/*$********************************************************************/
/* Description
*TCA_Se_IsEvebtSet returns TRUE if the corresponding event is asserted,
*   else FALSE.
*  
*  In Parameters
*  Event: input event.
*  
*  Retur Code
*  returns TRUE if the corresponding event is asserted, else FALSE
*  
* Flots de controle et de donnees
*  AUCUN
* Contraintes : 
*********************************************************************/
//BOOLEAN TCA_Si_IsInputEventSet
//(const TCA_Te_Events 	/* in */	Event,TCA_Ts_Automaton*/*out*/ Automaton)
//{
//    /*TRUE if the corresponding event is asserted, else FALSE*/
//    return ((BOOLEAN)((0x0001) & (Automaton->InputEvents>>(INT32)Event)));
//    
//}


/*$*/
/*$********************************************************************/
/*$ SERVICE  TCA_Si_ClearInputEvents*/
/*$********************************************************************/
/* Description
*TCA_Si_ClearInputEvents clears input events list.
*  
* Flots de controle et de donnees
*  AUCUN
* Contraintes : 
*********************************************************************/
/*@
  @ ensures (TCA_E_RD_BLK_KO == 0);
  @ ensures (TCA_E_WR_BLK_KO == 0);
  @ ensures (TCA_E_RD_BLK_OK == 0);
  @ ensures (TCA_E_WR_BLK_OK == 0);
  @ ensures (TCA_E_RD_FILE_REQ == 0);
  @ ensures (TCA_E_WR_FILE_REQ == 0);
  @ ensures (TCA_E_DATA == 0);
  @ ensures (TCA_E_TIMER_EXP == 0);
  @ ensures (TCA_E_OACK == 0);
  @ ensures (TCA_E_ACK == 0);
  @ ensures (TCA_E_BLK_SIZE_KO == 0);
  @ ensures (TCA_E_MAX_RETRY_REACHED == 0);
  @ ensures (TCA_E_DONE == 0);
  @ ensures (TCA_E_ERROR == 0);
  @*/
void TCA_Si_ClearInputEvents()//TCA_Ts_Automaton*/*out*/ Automaton)
{

    /* Cleare output events list */
    //Automaton->InputEvents = 0;

  TCA_E_RD_BLK_KO=0;
  TCA_E_WR_BLK_KO=0;
  TCA_E_RD_BLK_OK=0;
  TCA_E_WR_BLK_OK=0;
  TCA_E_RD_FILE_REQ=0;
  TCA_E_WR_FILE_REQ=0;
  TCA_E_DATA=0;
  TCA_E_TIMER_EXP=0;
  TCA_E_OACK=0;
  TCA_E_ACK=0;
  TCA_E_BLK_SIZE_KO=0;
  TCA_E_MAX_RETRY_REACHED=0;
  TCA_E_DONE=0;
  TCA_E_ERROR=0;
}
