/*
 * Copyright (C) 1999-2014  Andrej N. Gritsenko <andrej@rep.kiev.ua>
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * This file is part of FoxEye's source: common includes and definitions.
 */

/* strict POSIX.2 */
/* #define _POSIX2_SOURCE 1 */
#define _POSIX_C_SOURCE 200112L
#define _XOPEN_SOURCE 700
#undef _GNU_SOURCE

#ifdef __sun
# pragma error_messages (off, E_ARG_INCOMPATIBLE_WITH_ARG_L)
#endif

#ifdef HAVE_CONFIG_H
# include "../config.h"
#endif

#ifdef HAVE_STDINT_H
# include <stdint.h>
#endif

/* this is need for recursive thread under Linux */
#define __USE_UNIX98 1

#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdarg.h>
#include <pthread.h>

#ifdef HAVE_THREAD_H
# include <thread.h>
#endif

#ifdef _POSIX_SOURCE
# include <time.h>
#endif

#if defined STDC_HEADERS || defined _LIBC
# include <stdlib.h>
#else
# ifdef HAVE_MALLOC_H
#  include <malloc.h>
# else
void free ();
# endif
#endif

#if defined HAVE_STRING_H || defined _LIBC
# include <string.h>
#else
# ifndef memcpy
#  define memcpy(Dst, Src, Num) bcopy (Src, Dst, Num)
# endif
#endif

#if defined HAVE_STRINGS_H
# include <strings.h>
#endif

#if defined HAVE_UNISTD_H || defined _LIBC
# include <unistd.h>
#endif

#if TIME_WITH_SYS_TIME
# include <sys/time.h>
# include <time.h>
#else
# if HAVE_SYS_TIME_H
#  include <sys/time.h>
# else
#  include <time.h>
# endif
#endif

#if HAVE_SYS_WAIT_H
# include <sys/wait.h>
#endif

#ifndef WEXITSTATUS
# define WEXITSTATUS(stat_val) ((unsigned)(stat_val) >> 8)
#endif
#ifndef WIFEXITED
# define WIFEXITED(stat_val) (((stat_val) & 255) == 0)
#endif

#ifdef HAVE_LIMITS_H
# include <limits.h>
#endif

#if !defined(_POSIX_PATH_MAX) && defined(HAVE_POSIX1_LIM_H)
# include <posix1_lim.h>
#endif

#ifndef _POSIX_PATH_MAX
# define _POSIX_PATH_MAX 255
#endif

/* Don't include sys/param.h if it already has been.  */
#if defined HAVE_SYS_PARAM_H && !defined PATH_MAX && !defined MAXPATHLEN
# include <sys/param.h>
#endif

#ifdef HAVE_WCTYPE_H
# include <wctype.h>
#endif

#if !defined PATH_MAX && defined MAXPATHLEN
# define PATH_MAX MAXPATHLEN
#endif

#ifndef PATH_MAX
# define PATH_MAX _POSIX_PATH_MAX
#endif

/* set maximal filename length */
#ifdef HAVE_LONG_FILE_NAMES
# define FILENAME_LENGTH 255
#else
# define FILENAME_LENGTH 14
#endif

/* nifty trick I stole from ELM 2.5alpha. */
#ifdef DISPATCHER_C
# define WHERE 
# define INITVAL(x) = x
#else
# define WHERE extern
# define INITVAL(x) 
#endif

/* If we're not using GNU C, elide __attribute__ */
#ifndef __GNUC__
# define __attribute__(x) 
#endif

#define TRUE 1
#define FALSE 0

#define HUGE_STRING	5120
#define LONG_STRING	1024
#define STRING		256
#define SHORT_STRING	128

#ifdef ENABLE_NLS
# include <libintl.h>
# define _(a) (gettext (a))
# ifdef gettext_noop
#  define N_(a) gettext_noop (a)
# else
#  define N_(a) (a)
# endif
#else
# define _(a) (a)
# define N_(a) a
#endif

/*
 * IRC restrictions. Can be changed but not advisable to.
 */

#define LNAMELEN	32	/* Lname max width */
#define NAMEMAX		63	/* single name max width, must be >= LNAMELEN */
#define PASSWDMAX	NAMEMAX	/* still reserved 3 bytes for connchain flags */
#define IFNAMEMAX	2*NAMEMAX+1 /* interface name length */
#define IDENTLEN	10	/* user login name max width */
#define HOSTLEN		63	/* by RFC1123 */
#define HOSTMASKLEN	NAMEMAX+IDENTLEN+HOSTLEN+2 /* n!i@h or :p@h/n%f */
#define RESTRICTEDCHARS	" ,\007\r\n" /* cannot be in names */
#define MESSAGEMAX	1024	/* including '\0' at end */
#define FORMATMAX	120	/* max lenght of format string */

/* common Tcl/internal function prototypes */
typedef int (*Function)();

/* interface flags */
typedef enum
{
  I_INIT	= (1<<0),	/* the config maker */		/* 0x000001 */
  I_MODULE	= (1<<1),	/* module at all */
  I_FILE	= (1<<2),	/* userfile, channelfile, etc. */
//  I_BOT		= (1<<3),	/* linked bot */
  I_LISTEN	= (1<<4),	/* listening port */		/* 0x000010 */
  I_DIRECT	= (1<<5),	/* user or bot interface (telnet or DCC) */
  I_CLIENT	= (1<<6),	/* any link's client: user, channel, etc. */
  I_SERVICE	= (1<<7),	/* linked bot, server, network or service */
  I_CONSOLE	= (1<<8),	/* console if not detached */	/* 0x000100 */
  I_CONNECT	= (1<<9),	/* any IP connection */
  I_SCRIPT	= (1<<10),	/* interface to script interpreter */
  I_SHEDULE	= (1<<11),	/* sheduler request */
  I_TEMP	= (1<<12),	/* temporary interface */	/* 0x001000 */
  I_LOG		= (1<<13),	/* logfile or chat console log */
  I_DCCALIAS	= (1<<14),	/* DCC chat alias for requests (botnet chat) */
  I_QUERY	= (1<<15),	/* private query */
  I_PENDING	= (1<<16),	/* tmp, unset after request */	/* 0x010000 */
  I_FINWAIT	= (1<<17),	/* from thread for dispatcher: terminate me */
  I_LOCKED	= (1<<18),	/* this interface temporary unavailable */
  I_AUTHPASS	= (1<<19),	/* client is authenticated */
  I_DIED	= (1<<20)	/* this interface now died */	/* 0x100000 */
} iftype_t;

/* logging/request flags */
typedef enum
{
	/* message types */
  F_T_MESSAGE	= 0,		/* default message type          --- types ---*/
  F_T_NOTICE,
  F_T_CTCP,
  F_T_CTCR,
  F_T_ACTION,
	/* message flags */
  F_PUBLIC	= (1<<4),	/* p   public msg/notice/ctcp    --- dests ---*/
  F_PRIV	= (1<<5),	/* m   msg/notice/ctcp from/to bot */
  F_BOTNET	= (1<<6),	/* n   botnet messages */
  F_USERS	= (1<<7),	/* u   user changes information  --- logs ----*/
  F_CMDS	= (1<<8),	/* c   any user command */
  F_CONN	= (1<<9),	/* b   clients connections/shares */
  F_SERV	= (1<<10),	/* s   server-related information */
  F_ERROR	= (1<<11),	/* e   correctable internal errors */
  F_WARN	= (1<<12),	/* o   different state notices/warnings */
  F_DEBUG	= (1<<13),	/* d   debug info - test purposes only */
  F_BOOT	= (1<<14),	/* i   boot time messages */
  F_JOIN	= (1<<15),	/* j   group join/part/nickch    --- public --*/
  F_MODES	= (1<<16),	/* k   mode/topic change/kick/ban */
  F_WALL	= (1<<17),	/* w   wallops/server message */
  F_QUICK	= (1<<18),	/*     high priority of request	 --- flags ---*/
  F_AHEAD	= (1<<19),	/*     priority: insert before last */
  F_REPORT	= (1<<20),	/*     this is a report */
  F_MINE	= (1<<21),	/*     this send by me not for me */
  F_SHARE	= (1<<22),	/*     message to shared bot */
  F_SHAREINFO	= (1<<23),	/*     the same but info/greeting */
  F_ASK		= (1<<24),	/*     required answer to that message */
  F_SIGNAL	= (1<<25),	/*     generate signal instead of request */
  F_END		= (1<<26),	/*     client going to down */
  F_ECHO	= (1<<27),	/*     session only: echo on     --- session -*/
  F_COLOR	= (1<<28),	/*     session only: enable color */
  F_COLORCONV	= (1<<29)	/*     session only: convert color to ansi/mono */
} flag_t;

#define FLAG_T		"pmnucbseodijkw"

#define F_MIN		F_PUBLIC
#define F_T_MASK	(F_MIN-1)

#define F_ASK_BOOL	0	/* message types for F_ASK */
#define F_ASK_NUMBER	1
#define F_ASK_STRING	2

#define F_PREFIXED (F_USERS | F_CMDS | F_CONN | F_SERV | F_ERROR | F_WARN | \
		    F_JOIN | F_MODES) /* those must be prefixed in some cases */

/*
 * Note: All fields here are read only until you are sure it is only for you...
 * Note2: request, returned by IFRequest() have not to set only ->from in it
 */
typedef struct req_t
{
  struct _if_t *from;		/* what interface is from */
  iftype_t mask_if;		/* type interface request is to */
  flag_t flag;			/* subflag for requested iface */
  unsigned char to[IFNAMEMAX+1]; /* mask for request filtering */
  char string[MESSAGEMAX];	/* text of request or signal */
} REQUEST;

typedef enum
{
  S_REPORT = 1,			/* generate report to loggers */
  S_FLUSH,			/* flush the interface */
  S_TIMEOUT,			/* for flood and idle detect purposes */
  S_LOCAL,			/* local purposes */
  S_REG,			/* re-register all variables */
  S_STOP,			/* pause job on interface */
  S_CONTINUE,			/* continue stopped job */
  S_SHUTDOWN,			/* flush and terminate interface (quick) */
  S_TERMINATE			/* terminate interface and release resources */
} __attribute__ ((packed)) ifsig_t;

/* return values for _if_t::IFRequest */
#define REQ_OK		0
#define REQ_RELAYED	1
#define REQ_REJECTED	-1

typedef struct _if_t INTERFACE;
typedef iftype_t (*SigFunction)(INTERFACE *,ifsig_t);

struct _if_t
{
	/* these can be safe readed when IFSignal or IFRequest started */
	/* members ift, prev, data are writable that time, rest are read only */
  unsigned char *name;		/* registered name of that type interface */
  SigFunction IFSignal;		/* entry for signals */
  int (*IFRequest) (INTERFACE *, REQUEST *); /* entry for requests */
  INTERFACE *prev;		/* for nested interface - pointer to upper */
  void *data;			/* extra data - free by Delete_Iface() */
#ifdef HAVE_ICONV
  struct conversion_t *conv;	/* charset conversions descriptor */
#endif
  iftype_t ift;			/* flagged type of interface */
  int qsize;			/* queue FIFO size */
};

typedef enum
{
  /* common access levels */
  U_DENY	= (1<<0),	/* k   user has no service access */
  U_ACCESS	= (1<<1),	/* a   user has service access */
  U_INVITE	= (1<<2),	/* e   user is welcomed to come */
  U_FRIEND	= (1<<3),	/* f   user is friend **/
  U_VOICE	= (1<<4),	/* v   user can ask me to voice him **/
  U_HALFOP	= (1<<5),	/* h   user is halfop **/
  U_OP		= (1<<6),	/* o   user is service operator */
  U_MASTER	= (1<<7),	/* m   user has full bot/channel access **/
  U_SPEAK	= (1<<8),	/* s   user can tell me to say anything */
  U_OWNER	= (1<<9),	/* n   user is the bot/channel owner **/
  U_AUTO	= (1<<10),	/* *   auto grant service access */
  U_NOAUTH	= (1<<11),	/* i   may be trusted without authentication */
  /* channel specific levels */
  U_DEOP	= (1<<12),	/* d   user must be de-opped **/
  U_QUIET	= (1<<13),	/* q   never let him get a voice **/
  /* additional flags */
  U_FLA		= (1<<14),	/* A   user defined flag */
  U_FLB		= (1<<15),	/* B   */
  U_FLC		= (1<<16),	/* C   */
  U_FLD		= (1<<17),	/* D   */
  U_FLE		= (1<<18),	/* E   */
  U_FLF		= (1<<19),	/* F   */
  U_FLG		= (1<<20),	/* G   */
  U_FLH		= (1<<21),	/* H   */
  /* record attributes */
  U_UNSHARED	= (1<<22),	/* u   private, not shared with sharebots */
  U_SECRET	= (1<<23),	/* x   ignored by "autolog" module */
  U_IGNORED	= (1<<24),	/* I   user's messages are ignored */
  U_NEGATE	= (1<<25),	/*     (pseudo-user) inverse matching */
  U_ALIAS	= (1<<26),	/*     (pseudo-user) alias */
  U_SPECIAL	= (1<<27),	/*     (pseudo-user) network/service/channel */
  U_ANY		= (1<<28)	/*     set 1 for any regular user */
} userflag;

#define USERFLAG "kaefvhomsn*idqABCDEFGHuxI"

#define U_GLOBALS (U_DENY | U_INVITE | U_FRIEND | U_VOICE | U_MASTER | \
		   U_OWNER | U_NOAUTH | U_QUIET | U_IGNORED | U_SPECIAL | U_ANY)

#define U_AND	U_ALIAS	/* channel flag, for Add_Binding() only, means match */
			/*'global AND channel' instead of default OR behavior */
#define U_EQUAL	U_ALIAS	/* channel flag, for Check_Bintable() only, means */
			/*all flags and mask are matched when they are equal */

#define U_NONE  (~(U_NEGATE | U_ALIAS))	/* for Add_Binding() */
#define U_ALL	(~U_NEGATE)		/* global for Check_Bindtable() */
#define U_ANYCH	(~(U_NEGATE | U_EQUAL))	/* channel for Check_Bindtable() */

#define U_IMMUTABLE (U_NEGATE | U_ALIAS | U_SPECIAL | U_ANY) /* cannot be changed */

/* return values for Inspect_Client() */
typedef enum
{
  /* 4 bits preserved for network-specific modes: online/away/etc. */
  A_OFFLINE	= 0,
  /* user specific modes */
  A_MASKED	= (1<<4),	/* host masking is on */
  A_INVISIBLE	= (1<<5),	/* invisible or local */
  A_REGISTERED	= (1<<6),	/* identified */
  A_ME		= (1<<7),	/* it's me */
  /* "user-in-public" modes */
  A_ADMIN	= (1<<8),	/* creator / admin (UltimateIRCd) */
  A_OP		= (1<<9),	/* operator */
  A_HALFOP	= (1<<10),	/* half-op / local operator */
  A_VOICE	= (1<<11),	/* voiced */
  A_DENIED	= (1<<12),	/* banned without exempt */
  A_INVITED	= (1<<13),	/* in invitation list */
  A_EXEMPT	= (1<<14),	/* exception from ban list */
  /* channel modes */
  A_RESTRICTED	= (1<<16),	/* restricted */
  A_INVITEONLY	= (1<<17),	/* invite only */
  A_MODERATED	= (1<<18),	/* moderated */
  A_ANONYMOUS	= (1<<19),	/* anonymous */
  A_QUIET	= (1<<20),	/* quiet */
  A_NOOUTSIDE	= (1<<21),	/* no outside messages */
  A_PRIVATE	= (1<<22),	/* private */
  A_SECRET	= (1<<23),	/* secret */
  A_REOP	= (1<<24),	/* server reop */
  A_TOPICLOCK	= (1<<25),	/* only ops may change topic */
  A_NOCOLOR	= (1<<26),	/* no color messages */
  A_ASCIINICK	= (1<<27)	/* us-ascii nicks only */
} modeflag;

#define A_MODEMASK	(A_MASKED-1)

struct binding_t
{
  const char *key;		/* is matched to... */
  const char *name;		/* keyword for using by external script */
/*  unsigned int internal : 1;	       if internal binding, name == NULL */
  Function func;		/* called subprogram */
  struct binding_t *next;	/* next (not for B_UNIQ) binding */
  struct binding_t *prev;	/* previous (for B_U* types) binding */
  userflag gl_uf;		/* need global userflag for user */
  userflag ch_uf;		/* need channel userflag for user */
  int hits;			/* how many times binding was found */
};

typedef enum
{
  B_UNDEF = 0,
  B_KEYWORD,			/* for keyword */
  B_MASK,			/* for wildcards matching */
  B_MATCHCASE,			/* case-sensitive wildcards matching */
  B_UNIQ,			/* unique binding for keyword */
  B_UCOMPL,			/* unique binding for keyword with completion */
  B_UNIQMASK			/* unique binding with wildcards */
} bttype_t;

#include "protos.h"

/* conversion.c defines */
#define CHARSET_8BIT	"koi8-u" /* must be valid!!! */

/* wtmp.c defines */
#define WTMPS_MAX	12	/* maximum value of $wtmps, an year by default */
#define WTMP_GONE_EXT	"gone"	/* file extention where we keep gone events */

/* socket.c defines */

typedef short idx_t;
#define	SOCKETMAX	1024	/* max number of opened inet sockets */
#define STRICT_BACKRESOLV 1	/* define to ignore host IP=>host=>IP != IP */

/* main.c defines */
#define	CONSOLE_LOGLEV (F_PRIV | F_CMDS | F_CONN | F_USERS | F_BOOT | F_WARN | \
			F_ERROR | F_DEBUG | F_COLOR | F_COLORCONV)

/* sheduler.c defines */
#define	MAXDRIFT	3	/* max time shift to don't run "time-shift" */

/* module "irc-channel" defines */

#define	CHANNAMELEN	50		/* from RFC2811 */
#define	CTCPCMDMAX	128		/* max length of CTCP IRC command */

/* module "irc" defines */

#define	NICKLEN		32	/* see RFC2812, valid values 9...32 */
#define	REALNAMELEN	50
#define	IRCMSGLEN	512	/* see RFC, MESSAGEMAX should be above it! */

#define	CHANNFIRSTCHAR	"&#+!"	/* channel name first char */

/* IRC networks parameters */

#define IRCPAR_FIELD		"net-parms"

#define	IRCPAR_NICKLEN		"NICKLEN"	/* num, default=9 */
#define	IRCPAR_TOPICLEN		"TOPICLEN"	/* num, default=80 */
#define	IRCPAR_MAXBANS		"MAXBANS"	/* num, default=30 */
#define	IRCPAR_CHANNELS		"MAXCHANNELS"	/* num, default=10 */
#define	IRCPAR_MODES		"MODES"		/* num, default=3 */
#define	IRCPAR_TARGETS		"MAXTARGETS"	/* num, default=4 */
#define	IRCPAR_PREFIX		"PREFIX"	/* string, default=@+ */
#define	IRCPAR_CHANMODES	"CHANMODES"	/* string, default= */
#define	IRCPAR_CASEMAPPING	"CASEMAPPING"	/* string, default= */
#define	IRCPAR_UMODES		"UMODES"	/* string, from version */

/* module "ircd" defines */

#define A_SERVER	A_ME	/* no other usage on it */
#define A_SERVICE	A_ADMIN	/* for umode only */

#define IRCDLMAX	32	/* maximum of ircd listeners */
#define IRCD_DEFAULT_SENDQ 2000	/* default if client is out of any class */
#define AWAYLEN		120	/* away message max width */
#define SERVEROPTIONLEN	132	/* see RFC2813 for PASS command */
#define SERVERNAMELEN	63	/* see RFC2812 */
#define TOPICLEN	120	/* channel topic max width */
#define KEYLEN		23	/* channel key max width */
#define MAXMODES	3	/* max changes per MODE command */
#define MAXCHANNELS	20	/* max channels user can join */
#define MAXMATCHES	500	/* max number of replies on LIST or NAMES */
#define MAXTARGETS	4	/* max num. of targets for PRIVMSG or NOTICE */
#define MAXWHOIS	3	/* max targets to show on WHOIS */
#define MOTDMAXSIZE	5000	/* size of motd file we think it's not trash */

#undef USE_SERVICES		/* define it if you want to use local services */

  /* send SQUIT to youngest link on duplicate SERVER rather than to announcer */
#define IRCD_SQUIT_YOUNGEST 1
#define IRCD_P_FLAG		/* should require 'P' flag from links if def. */
#undef IRCD_STATM_EMPTYTOO	/* define to show commands never used (stat m) */
#define IRCD_TRACE_USERS 1	/* define if want opers see all users in TRACE */
  /* define to grant access to topic outside of channel which have neither mode
     +n nor +t. note: topic is still partially accessible with LIST command */
#define IRCD_PUBLIC_TOPIC 1
#undef IDLE_FROM_MSG		/* define if only PRIVMSG can reset idle time */
#define DEFAULT_INVISIBLE	/* define to set user mode +i on registration */
#undef WALLOP_ONLY_OPERS	/* define if only OPERs can get WALLOP messages */
#undef NO_SPARE_INVITES		/* define to disallow set +I for -i channels */
#define IRCD_STRICT_MODECMD 1	/* define to disable use such as 'MODE #a n' */
#undef IRCD_IGNORE_MKEY_ARG	/* define to not compare arg of -k with key */

  /* define to enable using these commands below by operators */
#define IRCD_ENABLE_KILL 1
#define IRCD_ENABLE_REHASH 1
#define IRCD_ENABLE_RESTART 1
#define IRCD_ENABLE_DIE 1
#undef IRCD_ENABLE_SUMMON
#undef IRCD_ENABLE_USERS

#define IRCD_MULTICONNECT 1	/* define to 1 to enable cyclic network scheme */

  /* next constant is used for bitmap to cache IDs in cyclic network scheme
     duplicated messages detection; it should be enough to take ids on lag,
     i.e. <lag time> * <max tagged messages of single server per second>;
     if it's too big then it will be waste of memory and if it's too little
     then some messages may be lost due to lag difference between servers */
#define IRCD_ID_HISTORY 8192	/* id bitmap size, must be power of 2 */

  /* Settings below are Network-Wide, never change them on single server,
     as well as CHARSET_8BIT, NICKLEN, and CHANNAMELEN! */
#define CHIDLEN		5	/* id len on ! channels */
#define CHASETIMELIMIT	90	/* "nick delay" for RFC2813 servers */
#define REOP_DELAY	5400	/* opless timelimit for +r channels */

#define IRCD_USES_ICONV 1	/* define to 1 if you want unicode IRCd */
#define IRCD_STRICT_NAMES 1	/* define to 1 to strict names to CHARSET_8BIT */
#define IRCD_NEEDS_TRANSLIT 1	/* more strict check on iconv compatibility */
#define CHARSET_UNICODE "utf-8"

/* module "ziplink" defines */

#define ZIPBUFSIZE			16384
#define ZIPLINK_COMPRESSION_LEVEL	5

#define BINDING_TYPE_dcc(func) static\
  int func(struct peer_t *, char *)
#define BINDING_TYPE_ss_(func) static\
  int func(struct peer_t *, INTERFACE *, char *)
#define BINDING_TYPE_chat(func) static\
  void func(struct peer_t *, char *)
#define BINDING_TYPE_chat_act(func) static\
  void func(struct peer_t *, char *)
#define BINDING_TYPE_in_filter(func) static\
  void func(struct peer_t *, char *, size_t )
#define BINDING_TYPE_out_filter(func) static\
  void func(struct peer_t *, char *, size_t )
#define BINDING_TYPE_chat_on(func) static\
  void func(struct peer_t *)
#define BINDING_TYPE_chat_off(func) static\
  void func(struct peer_t *)
#define BINDING_TYPE_chat_join(func) static\
  void func(INTERFACE *, int , const char *)
#define BINDING_TYPE_chat_part(func) static\
  void func(INTERFACE *, int )
#define BINDING_TYPE_passwd(func) static\
  void func(const char *, char **)
#define BINDING_TYPE_new_lname(func) static\
  void func(char *, char *)
#define BINDING_TYPE_load(func) static\
  void func(char *, char *)
#define BINDING_TYPE_unload(func) static\
  void func(char *)
#define BINDING_TYPE_login(func) static\
  void func(char *, char *, char *, struct peer_t *,\
		  char [SHORT_STRING], char **)
#define BINDING_TYPE_connect(func) static\
  int func(const char *, char *)
#define BINDING_TYPE_register(func) static\
  int func(const char *, void *, size_t )
#define BINDING_TYPE_unregister(func) static\
  int func(const char *)
#define BINDING_TYPE_function(func) static\
  int func(const char *, int (* ) (const char *))
#define BINDING_TYPE_unfunction(func) static\
  int func(const char *)
#define BINDING_TYPE_script(func) static\
  int func(char *)
#define BINDING_TYPE_ison(func) static\
  int func(const char *, const char *, const char *,\
	   const char **)
#define BINDING_TYPE_inspect_client(func) static\
  modeflag func(const char *, const char *,\
		      const char *, const char **,\
		      const char **, time_t *, short *)
#define BINDING_TYPE_time_shift(func) static\
  void func(int )
#define BINDING_TYPE_connchain_grow(func) static\
  int func(struct peer_t *, ssize_t (**)(struct connchain_i **, idx_t,\
			    char *, size_t, struct connchain_buffer **),\
	   ssize_t (**)(struct connchain_i **, idx_t, const char *,\
			    size_t *, struct connchain_buffer **),\
	   struct connchain_buffer **)
#define BINDING_TYPE_got_listener(func) static\
  int func(struct sockaddr *, int )
#define BINDING_TYPE_irc_join(func) static\
  void func(unsigned char *, const char *,\
		  INTERFACE *)
#define BINDING_TYPE_irc_part(func) static\
  void func(unsigned char *, const char *,\
		  INTERFACE *, char *)
#define BINDING_TYPE_irc_kick(func) static\
  void func(unsigned char *, const char *, INTERFACE *,\
		  unsigned char *, char *)
#define BINDING_TYPE_irc_topic(func) static\
  void func(unsigned char *, const char *,\
		  INTERFACE *, char *)
#define BINDING_TYPE_irc_modechg(func) static\
  void func(unsigned char *, const char *,\
		  INTERFACE *, char *)
#define BINDING_TYPE_irc_netjoin(func) static\
  void func(unsigned char *, const char *,\
		  INTERFACE *)
#define BINDING_TYPE_keychange(func) static\
  void func(char *, unsigned char *, const char *,\
		  userflag , char *)
#define BINDING_TYPE_ctcp_dcc(func) static\
  int func(INTERFACE *, unsigned char *, char *, char *)
#define BINDING_TYPE_dcc_got(func) static\
  void func(unsigned char *, char *)
#define BINDING_TYPE_dcc_sent(func) static\
  void func(unsigned char *, char *)
#define BINDING_TYPE_irc_raw(func) static\
  int func(INTERFACE *, char *, char *,\
	   unsigned char *, int , char **,\
	   size_t (*) (char *, const char *, size_t))
#define BINDING_TYPE_irc_connected(func) static\
  void func(INTERFACE *, char *, char *,\
		  size_t (*) (char *, const char *, size_t))
#define BINDING_TYPE_irc_disconnected(func) static\
  void func(INTERFACE *, char *, char *,\
		  size_t (*) (char *, const char *, size_t))
#define BINDING_TYPE_irc_pub_msg_mask(func) static\
  void func(INTERFACE *, unsigned char *, char *,\
		  char *, char *, char *)
#define BINDING_TYPE_irc_pub_notice_mask(func) static\
  void func(INTERFACE *, unsigned char *, char *,\
		  char *, char *, char *)
#define BINDING_TYPE_irc_pub_msg_cmd(func) static\
  int func(INTERFACE *, unsigned char *, char *,\
	   char *, char *, char *)
#define BINDING_TYPE_irc_pub_notice_cmd(func) static\
  int func(INTERFACE *, unsigned char *, char *,\
	   char *, char *, char *)
#define BINDING_TYPE_irc_pub_msg_ctcp(func) static\
  int func(INTERFACE *, unsigned char *, char *,\
	   char *, char *, char *)
#define BINDING_TYPE_irc_pub_notice_ctcp(func) static\
  int func(INTERFACE *, unsigned char *, char *,\
	   char *, char *, char *)
#define BINDING_TYPE_irc_priv_msg_mask(func) static\
  void func(INTERFACE *, unsigned char *, char *,\
		  char *, char *)
#define BINDING_TYPE_irc_priv_notice_mask(func) static\
  void func(INTERFACE *, unsigned char *, char *,\
		  char *, char *)
#define BINDING_TYPE_irc_priv_msg_cmd(func) static\
  int func(INTERFACE *, unsigned char *, char *,\
	   char *, char *)
#define BINDING_TYPE_irc_priv_notice_cmd(func) static\
  int func(INTERFACE *, unsigned char *, char *,\
	   char *, char *)
#define BINDING_TYPE_irc_priv_msg_ctcp(func) static\
  int func(INTERFACE *, unsigned char *, char *,\
	   char *, char *)
#define BINDING_TYPE_irc_priv_notice_ctcp(func) static\
  int func(INTERFACE *, unsigned char *, char *,\
	   char *, char *)
#define BINDING_TYPE_irc_flood(func) static\
  int func(unsigned char *, char *, char *, char *)
#define BINDING_TYPE_irc_nickchg(func) static\
  void func(INTERFACE *, char *, unsigned char *,\
		  char *, char *, char *)
#define BINDING_TYPE_irc_signoff(func) static\
  void func(INTERFACE *, char *, unsigned char *,\
		  char *, char *)
#define BINDING_TYPE_irc_netsplit(func) static\
  void func(INTERFACE *, char *, unsigned char *,\
		  char *, char *)
#define BINDING_TYPE_irc_quit(func) static\
  int func(INTERFACE *, char *, size_t )
#define BINDING_TYPE_ircd_auth(func) static\
  int func(struct peer_t *, char *, char *, const char **)
#define BINDING_TYPE_ircd_register_cmd(func) static\
  int func(INTERFACE *, struct peer_t *, int , const char **)
#define BINDING_TYPE_ircd_client_cmd(func) static\
  int func(INTERFACE *, struct peer_t *, char *, char *,\
	   char *, int , const char **)
#define BINDING_TYPE_ircd_server_cmd(func) static\
  int func(INTERFACE *, struct peer_t *, unsigned short ,\
	   const char *, const char *, char *, int ,\
	   const char **)
#define BINDING_TYPE_ircd_local_client(func) static\
  void func (INTERFACE *, struct peer_t *)
#define BINDING_TYPE_ircd_client(func) static\
  void func (INTERFACE *, const char *, const char *,\
		   const char *, const char *, const char *,\
		   const char *, const char *, modeflag ,\
		   unsigned int )
#define BINDING_TYPE_ircd_do_numeric(func) static\
  int func (INTERFACE *, int , const char *, modeflag ,\
	    char *)
#define BINDING_TYPE_ircd_channel(func) static\
  modeflag func(INTERFACE *, modeflag , modeflag ,\
		      int , const char *, NODE *,\
		      const char **)
#define BINDING_TYPE_ircd_check_message(func) static\
  int func(modeflag , modeflag , char *)
#define BINDING_TYPE_ircd_check_modechange(func) static\
  int func(modeflag , modeflag , int , modeflag ,\
	   char *)
#define BINDING_TYPE_ircd_modechange(func) static\
  modeflag func(INTERFACE *, const char *, modeflag ,\
		      const char *, modeflag , int ,\
		      char ,\
		      int (**)(INTERFACE *, const char *,\
				 const char *, int ,\
				 const char **))
#define BINDING_TYPE_ircd_umodechange(func) static\
  modeflag func(INTERFACE *, const char *, modeflag ,\
		      int )
#define BINDING_TYPE_ircd_whochar(func) static\
  char func(char )
#define BINDING_TYPE_ircd_client_filter(func) static\
  int func(INTERFACE *, struct peer_t *, modeflag , int ,\
	   const char **)
#define BINDING_TYPE_ircd_stats_reply(func) static\
  void func(INTERFACE *, const char *, modeflag )
#define BINDING_TYPE_ircd_collision(func) static\
  char *func(char *, size_t , int )
#define BINDING_TYPE_ircd_set_message_targets(func) static\
  int func (INTERFACE *srv, const char *sender, const char *target,\
	    int (*next)(INTERFACE *srv, const char *mask,\
			const char **lcname, modeflag *mf, int **mark,\
			void **iter))
#define BINDING_TYPE_ircd_check_send(func) static\
  int func(INTERFACE *srv, struct peer_t *tgt, modeflag tum, char *msg,\
	   size_t ms)
