/*
 *										
 *		File		: poplib.c					
 *										
 *		Title		: Flink email monitoring applet for GNOME 2	
 *										
 *		Description	: Connects to port 110 (POP) and uses STAT 	
 *				  	  to check for new mail.			
 *										
 *		Author		: Marcus Leyman (6 May 2001)			
 *				      Andrae Muys <andrae@humbug.org.au>	
 *										
 *		License		: GPL						
 *										
 *		Date		: 26th May 1999					
 *										
 */

#include <sys/socket.h>
#include <sys/types.h>
#include <string.h>
#include <unistd.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <stdlib.h>

#include "main.h"
#include "poplib.h"

/********************************************************
 * Function:	flink_pop_get_mail			*
 *							*
 * Description:	connects and checks for mail in pop	*
 *							*
 * Arguments:	gpointer data, Account to check		*
 *							*
 * Returns:	gpointer to int of message count	*
 ********************************************************/
gint
flink_pop_get_mail	(gpointer data)
{
  GConfClient   *client;
  Account	*acc = (Account *) data;
  gboolean	success;
  gint 		total;
  gint		sd;
  gint		msgs = 0;
  gint          old_msgs = 0;

  client = gconf_client_get_default();

  sd = flink_pop_connect(acc->hostname, acc->port);

  if (sd < 0 ) {
    msgs = -1;
  } else { 
    if (flink_pop_login(sd, acc->username, acc->password)) {
      msgs = flink_pop_stat(sd);
    } else {
      msgs = -2;
    }
  }    
 
  return msgs;
}

/********************************************************
 * Function:	flink_pop_connect			*
 *							*
 * Description:	connects to pop server			*
 *							*
 * Arguments:	gchar *host, hostname of server		*
 *		gint port, port to connect to		*
 *							*
 * Returns:	filehandle if positive, error if neg.	*
 ********************************************************/
gint
flink_pop_connect	(char *host, 
			gint port)
{
  struct          sockaddr_in     server;
  struct          hostent         *hent;
  gchar           response[513];
  gint            len;
  gint            sd;

  if (!host)
    return -1;
        
  hent = gethostbyname (host);
	                        
  if (!hent) {
    return -1;
  }
  memset (&server, 0, sizeof(server));
  server.sin_family = AF_INET;
  memcpy (&(server.sin_addr.s_addr), hent->h_addr,
	  sizeof(server.sin_addr.s_addr));

  server.sin_port = htons (port);	
	
  sd = socket (PF_INET, SOCK_STREAM, 0);
	
  if (sd < 0) {
    return -1;
  }
	
  if (connect (sd,(struct sockaddr *) &server, sizeof(server)) < 0) {
    close (sd);
    return -1;
  }

  len = read (sd, response, 512);
  response[len] = '\0';
		
  if (strncmp (response, "+OK", 3)) {
    close (sd);
    return -1;
  } 
  return sd;
}

/********************************************************
 * Function:	flink_pop_login				*
 *							*
 * Description:	Logs in to popserver			*
 *							*
 * Arguments:	gint sd, filehandle			*
 *		gchar *user, username			*
 *		gchar *pass, password			*
 *							*
 * Returns:	TRUE if successfull, FALSE else		*
 ********************************************************/
gboolean
flink_pop_login	(gint sd, 
		gchar *user, 
		gchar *pass)
{
  static gchar cmdline[128];
  static gchar response[513];
  static gint len;

  if (!user || !pass) {
    close(sd);
    return FALSE;
  }

  g_snprintf(cmdline, 128, "USER %s\r\n", user);
	
  write (sd, cmdline, strlen(cmdline));
	
  len = read (sd, response, 512);
  response[len] = '\0';

  if (strncmp (response, "+OK", 3)) {
    close(sd);		
    return FALSE;
  } 


  g_snprintf(cmdline, 128, "PASS %s\r\n", pass);

  write (sd, cmdline, strlen(cmdline));
  len = read (sd, response, 512);
  response[len] = '\0';
	
  if (strncmp (response, "+OK", 3)) {
    close(sd);
    return FALSE;
  } 
  g_free(user);
  g_free(pass);
	
  return TRUE;
}

/********************************************************
 * Function:	flink_pop_stat				*
 *							*
 * Description:	Checks popserver for unread mail	*
 *							*
 * Arguments:	gint sd, filehandle			*
 *							*
 * Returns:	if positive number of mail, else error	*
 ********************************************************/
gint
flink_pop_stat	(gint sd)
{
  gchar response[513];
  gint len;
  gint msgs;
  long bytes;

  write (sd, "STAT\r\n", strlen("STAT\r\n"));
  len = read (sd, response, 512);
  response[len] = '\0';

  if (strncmp (response, "+OK", 3)) {
    write (sd, "QUIT\r\n", strlen ("QUIT\r\n"));		
    close(sd);
    return -1;
  } else {
    sscanf (&response[3], "%d %ld", &msgs, &bytes);
  }
	
  write (sd, "QUIT\r\n", strlen ("QUIT\r\n"));		
  close(sd);
	
  return msgs;
}
