/*
 *										
 *		File		: mboxlib.c					
 *										
 *		Title		: Flink email monitoring applet for GNOME 2
 *										
 *		Description	: Routines for checking local mbox		
 *										
 *		Authors		: Marcus Leyman, 2002 <marcus@leyman.nu>	
 *										
 *		License		: GPL						
 *										
 *		Date		: 27 May 2002					
 *										
 */

#include <sys/stat.h>
#include <string.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>

#include "main.h"
#include "mboxlib.h"

/********************************************************
 * Function:	flink_mbox_get_mail			*
 *							*
 * Description:	checks absolute path for new mail	*
 *							*
 * Arguments:	gpointer data, Account struct		*
 *							*
 * Returns:	gpointer, int of new mail		*
 ********************************************************/
gint
flink_mbox_get_mail	(gpointer data)
{
  Account         *acc            = (Account *) data;
  GConfClient     *client;
  FILE            *file;
  struct          stat            s;
  static          gint            header = 0;
  gchar           line[256];
  gint            headerflag;
  gint            msgs            = 0;
  gint            old_msgs        = 0;
  gchar*          path            = acc->path;
	
	
  client = gconf_client_get_default();
	
  if (stat(path, &s) != 0)
    {
      msgs = -3;
    } else {

      if ((file = fopen (path, "r")) == NULL) 
	{
	  msgs = -4;
	} else {
	  while (fgets (line, 255, file)) 
	    {
			
	      if ((gchar *) strstr (line, "From ") == line) 
		{
		  headerflag = 0;		
		}
	      if (((gchar *) strstr(line, "\n") == line) && (headerflag == 0)) 
		{
		  headerflag = 1;
		  header++;
		}
	    }
	  msgs = header;
	  header = 0;

	  if (fclose (file) != 0) 
	    {
	      msgs = -5;
	    }
	}
    }	
  /*
  old_msgs = gconf_client_get_int(client, g_strdup_printf("/apps/flink/accounts/%d_newmail", acc->id), NULL);
        
  gconf_client_set_int(client, g_strdup_printf("/apps/flink/accounts/%d_newmail", acc->id), msgs, NULL);
        
  if(old_msgs < msgs)
    flink_bell();
  */
  return msgs;
}
