<?
include_once("functions.php");
include_once("shared.php");


echo "<h2>Aggiornamento degli utenti</h2>";
//creo la cartella che conterr gli utenti
if (!is_dir("misc/users/")){
	if (is_writable("misc/")){
		if (mkdir("misc/users/",0777)){
			echo "Ho creato la cartella <b>misc/users</b><br /><br />";
		}
		else {
			echo "<b>Attenzione: </b> non sono riuscito a creare la cartella misc/users/<br />Interrompo l'upgrade";
			die();
		}
	}
	else {
		echo "<b>Attenzione: </b>la cartella misc/ non  scrivibile. Controllare i permessi<br />Interrompo l'upgrade";
		die();
	}
}
else echo "la cartella misc/users esiste gi, procedo oltre.<br /><br />";



$users=array();
$users = list_old_users();

$n=0;

for ($n;$n<count($users);$n++){
	$user="";
	$user = $users[$n];
	$data = load_old_user_profile($user,"home");
	
// 	print_r($data);
	if (!file_exists("misc/users/$user.php")){
		save_user_profile($user,$data);
// 		echo "$user<br />";
		$newdata = load_new_user_profile($user);
		
		if ($data['password']==$data['password'])
			echo "ho aggiornato: <b>$user</b><br />";
		else echo "<b><i>problemi nell'aggiornamento di: $user</i></b><br />";
	}
	else echo "<i>Il profilo di $user era gi aggiornato</i><br />";
	
}

echo "<br /><b>Upgrade completato.</b> Rimuovere il file upgrade.php<br />Dopo aver verificato il buon funzionamento di Flatnuke e degli utenti potete eliminare la cartella <b>forum/users/</b> e i file contenuti.";







/**
 * Carica il vecchio profilo
 * 
 */
function load_old_user_profile($user){
	$user = getparam($user,PAR_NULL, SAN_FLAT);
	$addr = getparam("REMOTE_ADDR",PAR_SERVER,SAN_FLAT);
	$myforum = getparam("myforum",PAR_COOKIE,SAN_FLAT);

	if (!is_alphanumeric($user)){
		return NULL;
	}

	$userdata = "";
	$userprofile = array();
	if (file_exists("forum/users/$user.php")){
		$userdata = file("forum/users/$user.php");
		//la password
		if (is_alphanumeric(eregi_replace("^#","",$userdata[1]))){
			$userprofile['password'] = trim(eregi_replace("^#","",eregi_replace("\n$","",strip_tags($userdata[1]))));
		}
		else {
			fnlog("load_user_profile", "$addr||$myforum||md5 password not valid! (user: $user)");
		}
		//il nome
		$userprofile['name'] = trim(eregi_replace("^#","",eregi_replace("\n$","",strip_tags($userdata[2]))));
		//la mail
		$userprofile['mail'] = trim(eregi_replace("^#","",eregi_replace("\n$","",strip_tags($userdata[3]))));
		//home page
		$userprofile['homepage'] = trim(eregi_replace("^#","",eregi_replace("\n$","",strip_tags($userdata[4]))));
		if(trim($userprofile['homepage']=="http://")) {
			$userprofile['homepage'] = "";
		}
		//lavoro
		$userprofile['work'] = trim(eregi_replace("^#","",eregi_replace("\n$","",strip_tags($userdata[5]))));
		//provenienza
		$userprofile['from'] = trim(eregi_replace("^#","",eregi_replace("\n$","",strip_tags($userdata[6]))));
		//avatar
		$userprofile['avatar'] = trim(eregi_replace("^#","",eregi_replace("\n$","",strip_tags(trim($userdata[7])))));
		
		//deve essere un'immagine
		if (!eregi("jpg$|jpeg$|png$|gif$",get_file_extension($userprofile['avatar'])))
			$userprofile['avatar'] = "";
		//non si possono passare parametri nell'url
		if (eregi("\?",$userprofile['avatar']))
			$userprofile['avatar'] = "";
		//se non  un avatar remoto si controlla che il file esista
 		if (!eregi("^http://",$userprofile['avatar'])){
 			if (!file_exists("forum/".$userprofile['avatar']))
 				$userprofile['avatar'] = "images/blank.png";
 		}
		//firma
		$userprofile['sign'] = trim(stripslashes(eregi_replace("^#","",eregi_replace("\n$","",strip_tags($userdata[8],"<br>,<br/>,<br />")))));
		//livello
		$check_level = "";
		$check_level = trim(eregi_replace("^#","",strip_tags($userdata[9])));
		if (ctype_digit($check_level) and ($check_level>=0) and ($check_level<=10)){
			$userprofile['level'] = trim(eregi_replace("^#","",$userdata[9]));
		}
		else $userprofile['level'] = "-1";
	}
	else return NULL;
	return $userprofile;
}



/**
 * Salva il profilo in formato xml
 */
function save_new_user_profile($user, $data_array){
	$user = getparam($user,PAR_NULL, SAN_FLAT);

	//per salvare il log
	$addr=getparam("REMOTE_ADDR",PAR_SERVER,SAN_FLAT);
	$myforum=getparam("myforum",PAR_COOKIE,SAN_FLAT);
	
	if (!is_alphanumeric($user)){
		fnlog("save_user_profile", "$addr||$myforum||username not valid!");
		die("username is not valid!");
	}
	
	if (!is_array($data_array)){
		fnlog("save_user_profile", "$addr||$myforum||the second argument must be an array!");
		die("the second argoment of the function save_user_profile is not valid!");
	}
	
	//controllo tutti i parametri
	$clean_data = array();
	
	//password
	if (isset($data_array['password'])){
		if (ctype_alnum(trim($data_array['password']))){
			$clean_data['password'] = trim($data_array['password']);
		}
		else {
			fnlog("save_user_profile", "$addr||$myforum||the password isn't valid!");
			die("the password passed to the function save_user_profile is not valid! ($user)");
		}
	}
	else {
		fnlog("save_user_profile", "$addr||$myforum||the password isn't set!");
		die("the password passed to the function save_user_profile is not set! ($user)");
	}
	
	//nome
	if (isset($data_array['name'])){
		$clean_data['name'] = strip_tags(fnsanitize($data_array['name']));
	}
	else $clean_data['name'] = "";
	
	//mail
	if (isset($data_array['mail'])){
		$clean_data['mail'] = strip_tags(fnsanitize($data_array['mail']));
	}
	else $clean_data['name'] = "";
	
	//homepage
	if (isset($data_array['homepage'])){
		$clean_data['homepage'] = strip_tags(fnsanitize($data_array['homepage']));
	}
	else $clean_data['homepage'] = "";
		
	//work
	if (isset($data_array['work'])){
		$clean_data['work'] = strip_tags(fnsanitize($data_array['work']));
	}
	else $clean_data['work'] = "";	
	
	//from
	if (isset($data_array['from'])){
		$clean_data['from'] = strip_tags(fnsanitize($data_array['from']));
	}
	else $clean_data['from'] = "";
		
	//avatar
	//QUALI ALTRI CONTROLLI IMPLEMENTARE???
	if (isset($data_array['avatar'])){
		if (eregi("jpg$|jpeg$|png$|gif$",get_file_extension($data_array['avatar']))){
			$clean_data['avatar'] = strip_tags(fnsanitize($data_array['avatar']));
		}
		else $clean_data['avatar'] = "";
	}
	else $clean_data['avatar'] = "";
	
	
	//sign
	if (isset($data_array['sign'])){
		include_once("include/php_filters/kses.php");
		$sign_allowed = array('a' => array ('href' => array ()), 'br' => array(),
		'b'=>array(),'i'=>array(),'u' => array());
		$clean_data['sign'] = kses(stripslashes($data_array['sign']),$sign_allowed);
	}
	else $clean_data['sign'] = "";
	
	
	//level
	if (isset($data_array['level'])){
		if (ctype_digit($data_array['level']) and ($data_array['level']>=0) and ($data_array['level']<=10)){
			$clean_data['level'] = strip_tags(fnsanitize($data_array['level']));
		}
		else $clean_data['level'] = "0";
	}
	else $clean_data['level'] = "0";
	
	
	//ora scrivo tutto
	$xmlstring = "<fn:userprofile>
	<fn:password>".$clean_data['password']."</fn:password>
	<fn:name>".$clean_data['name']."</fn:name>
	<fn:mail>".$clean_data['mail']."</fn:mail>
	<fn:homepage>".$clean_data['homepage']."</fn:homepage>
	<fn:work>".$clean_data['work']."</fn:work>
	<fn:from>".$clean_data['from']."</fn:from>
	<fn:avatar>".$clean_data['avatar']."</fn:avatar>
	<fn:sign>".$clean_data['sign']."</fn:sign>
	<fn:level>".$clean_data['level']."</fn:level>
</fn:userprofile>";

	if (eregi("\<\?",$xmlstring) or eregi("\?\>",$xmlstring)){
		fnlog("save_user_profile", "$addr||$myforum||the xml profile cannot contains php tags!");
		die("data passed to the function save_user_profile contains php tags!");
	}
	
	$userfile = fopen("misc/users/$user.php","w");
	if (fwrite($userfile,"<?exit(1);?>\n<?xml version='1.0'?>\n$xmlstring")){
		fnlog("save_user_profile", "$addr||$myforum||saved profile of the user $user");
	}
	fclose($userfile);
	
}

/**
 * carica il profilo dell'utente specificato
 * @param string $user il nome dell'utente di cui caricare il profilo
 * @return un array con i dati dell'utente
 * @since 2.5.8
 * @author Aldo Boccacci
 */
function load_new_user_profile($user){
	$user = getparam($user,PAR_NULL, SAN_FLAT);	
	//per salvare il log
	$addr=getparam("REMOTE_ADDR",PAR_SERVER,SAN_FLAT);
	$myforum=getparam("myforum",PAR_COOKIE,SAN_FLAT);
	
	if (!is_alphanumeric($user)){
		fnlog("load_user_profile", "$addr||$myforum||username not valid!");
		die("username is not valid!");
	}
	
	$xmltring = "";
	$userprofile = array();
	if (file_exists("misc/users/$user.php")){
		$xmltring = get_file("misc/users/$user.php");
		
		//la password
		if (ctype_alnum(trim(get_xml_element("fn:password",$xmltring)))){
			$userprofile['password'] = trim(get_xml_element("fn:password",$xmltring));
		}
		else {
			fnlog("load_user_profile", "$addr||$myforum||md5 password not valid!");
			die("md5 password is not valid!");
		}
		
		//il nome
		$userprofile['name'] = strip_tags(get_xml_element("fn:name",$xmltring));
		
		//la mail
		$userprofile['mail'] = strip_tags(get_xml_element("fn:mail",$xmltring));
		
		//home page
		$userprofile['homepage'] = strip_tags(get_xml_element("fn:homepage",$xmltring));
		
		//lavoro
		$userprofile['work'] = strip_tags(get_xml_element("fn:work",$xmltring));
		
		//provenienza
		$userprofile['from'] = strip_tags(get_xml_element("fn:from",$xmltring));

		//avatar
		$userprofile['avatar'] = strip_tags(get_xml_element("fn:avatar",$xmltring));
		
		//firma
		include_once("include/php_filters/kses.php");
		$sign_allowed = array('a' => array ('href' => array ()), 'br' => array(),
		'b'=>array(),'i'=>array(),'u' => array());
		$userprofile['sign'] = kses(stripslashes(get_xml_element("fn:sign",$xmltring)),$sign_allowed);
		//strip_tags(get_xml_element("fn:sign",$xmltring));

		//livello
		$check_level = "";
		$check_level = trim(get_xml_element("fn:level",$xmltring));
		if (ctype_digit($check_level) and ($check_level>=0) and ($check_level<=10)){
			$userprofile['level'] = strip_tags(get_xml_element("fn:level",$xmltring));
		}
		else $userprofile['level'] = "-1";
	
	}
	else return NULL;
	
	return $userprofile;
}


function list_old_users(){

	$files = array();
	$users= array();
	$files = glob("forum/users/*.php");
		for ($count=0;$count<count($files);$count++){
		$username = "";
		$username = eregi_replace("\.php$","",basename($files[$count]));
		if (!is_alphanumeric($username)) {
			echo "Il profilo <b>$username</b> non verr aggiornato perch contiene caratteri non validi: nel nome puoi usare solo a-z, A-Z, 0-9<br />";
			continue;
		}
		$users[] = $username;
	}
	return $users;

}
?>