<?

/************************************************************************/
/* FlatNuke - Flat Text Based Content Management System                 */
/* ============================================                         */
/*                                                                      */
/* Copyright (c) 2003-2004 by Simone Vellei                             */
/* http://flatnuke.sourceforge.net                                      */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/


if (eregi("section.php",$_SERVER['PHP_SELF'])) {
	Header("Location: ../../index.php");
	die();
}

global $sitename, $guestnews;

// security convertions
$mod    = getparam("mod",    PAR_GET,  SAN_FLAT);
$action = getparam("action", PAR_POST, SAN_FLAT);
$req    = getparam("REQUEST_URI", PAR_SERVER, SAN_FLAT);

// intercept eventual guestnews parameter, and prevent to change default value
if(stristr($req,"guestnews=") OR isset($_GET['guestnews']) OR isset($_POST['guestnews'])) {
	$guestnews = 0;
}

switch($action) {
	case "signews":
		global $guestnews;
		$addr    = getparam("REMOTE_ADDR", PAR_SERVER, SAN_FLAT);
		$title   = getparam("title",       PAR_POST, SAN_FLAT);
		$icon    = getparam("icon",        PAR_POST, SAN_HTML);
		$head    = getparam("head",        PAR_POST, SAN_HTML);
		$body    = getparam("body",        PAR_POST, SAN_HTML);
		$mionome = getparam("mionome",     PAR_POST, SAN_HTML);
		$myname  = stripslashes(htmlspecialchars($mionome));
		// news by guests must be allowed, and user must correspond to the one who fill down the forms
		if($guestnews==0 AND get_username()!=$myname) {
			echo _DEVIREG." <b>".$sitename."</b> "._DEVIREG3;
			return;
		}
		// sanitize text
		$mytitle = stripslashes(htmlspecialchars($title));
		$myicon  = stripslashes(htmlspecialchars($icon));
		$myhead  = tag2html($head, "home");
		$mybody  = tag2html($body, "home");
		// build news
		$myhead  = "<b>$myname</b> "._HASCRITTO.":<br /><br />$myhead";
		$string  = "<?xml version='1.0'?>\n";
		$string .= "<!DOCTYPE fn:news SYSTEM \"http://flatnuke.sourceforge.net/dtd/news.dtd\">\n";
		$string .= "<fn:news xmlns:fn=\"http://flatnuke.sourceforge.net/news\">\n";
		$string .= "\t<fn:title>$mytitle</fn:title>\n";
		$string .= "\t<fn:avatar>$myicon</fn:avatar>\n";
		$string .= "\t<fn:reads>0</fn:reads>\n";
		$string .= "\t<fn:header>$myhead</fn:header>\n";
		$string .= "\t<fn:body>$mybody</fn:body>\n";
		$string .= "</fn:news>";
		// write news
		fnwrite("misc/news_".time().".xml", $string, "w", array("nonull"));
		fnlog("News", $addr."||".get_username()."||New news proposed.");
		?><script language="javascript">alert("<? echo _ALERTSIG ?>");window.location='index.php';</script><?
	break;
	default:
		if(is_admin() OR is_user() OR ($guestnews==1)){
			// get the name of submitter
			if(get_username()=="") {
				$comfrom = _SCON;
			} else {
				$comfrom = get_username();
			}
			// print html forms
			?><form action="index.php?mod=<?=$mod?>" method="post" name="insnews">
			<input type="hidden" name="action" value="signews" />
			<b><?= _TITNOTIZIA ?></b><br />
			<input type="text" id="news_title" name="title" style="width: 100%" /><br /><br />
			<b><?= _ARGOMENTO ?></b><br />
			<img name="avatar" src="images/nonews.png" border="0" alt="Argomento" />
			<br />
			<select name="icon" onchange="document.insnews.avatar.src='images/news/'+this.options[this.selectedIndex].value"><?
			$modlist = array();
			$handle = opendir('images/news');
			while ($file = readdir($handle)) {
				if (!( $file=="." or $file==".." ) and (!ereg("^\.",$file)and ($file!="CVS")) ) {
					array_push($modlist, $file);
				}
			}
			closedir($handle);
			if(count($modlist)>0)
				sort($modlist);
			for ($i=0; $i < count($modlist); $i++) {
				echo "<option value=\"$modlist[$i]\">".	str_replace("_"," ", ereg_replace("\..*","",$modlist[$i]))."</option>\n";
			}
			echo "</select><br /><br />";
			// bbcodes panel news HEADER
			bbcodes_panel("head", "home", "formatting"); echo "<br />";
			bbcodes_panel("head", "home", "emoticons"); echo "<br />";
			bbcodes_panel("head", "home", "images"); echo "<br />";
			echo "<b>"._INTMESSAGGIO."</b><br />";
			echo "<textarea id=\"news_head\" cols=\"50\" rows=\"20\" name=\"head\" style=\"width: 100%\"></textarea><br /><br />";
			// bbcodes panel news BODY
			bbcodes_panel("body", "home", "formatting"); echo "<br />";
			bbcodes_panel("body", "home", "emoticons"); echo "<br />";
			bbcodes_panel("body", "home", "images"); echo "<br />";
			echo "<b>"._CORPOMESSAGGIO."</b><br />";
			echo "<textarea id=\"news_body\"  cols=\"50\" rows=\"20\" name=\"body\"  style=\"width: 100%\"></textarea><br /><br />";
			echo "<input type=\"hidden\" name=\"mionome\" value=\"".$comfrom."\" /><br /><br />";
			// confirm button
			echo "<input type=\"submit\" value=\""._INSNOTIZIA."\" /> ";
			// preview system
			echo "<input type=\"button\" value=\""._ANTEPRIMA."\" onclick='prevshow();' />";
			echo "</form>";
			?><script language="javascript">
				getElement("news_title").onkeyup     = news_preview;
				getElement("news_title").onmousemove = news_preview;
				getElement("news_head").onkeyup      = news_preview;
				getElement("news_head").onmousemove  = news_preview;
				getElement("news_body").onkeyup      = news_preview;
				getElement("news_body").onmousemove  = news_preview;
				news_preview();
			</script>
			<div id="fnpreview" name="fnpreview" style="overflow: auto;top: 15px; left: 15px;max-height: 90%; display: block; visibility: hidden; background-color: #F0F0F0; border: 2px solid; padding: 5px; border-top-color: #ffffff; border-left-color: #ffffff; border-bottom-color: #666666; border-right-color: #666666; width: 600px;"></div><?
		} else {
			echo _DEVIREG." <b>".$sitename."</b> "._DEVIREG3;
		}
	break;
}

?>
