<?php

/*
 * Print forms to manage Flatnuke general configuration
 *
 * @author Marco Segato <segatom@users.sourceforge.net>
 * @version 20071014
 */
function fncc_generalconf() {
	// security conversions
	$mod = getparam("mod", PAR_GET, SAN_FLAT);
	// check file existance
	$file = "config.php";
	if(file_exists($file)) {
		echo "<form action=\"index.php?mod=$mod\" method=\"post\">";
		// scan configuration file to find all settings
		$settings  = array();
		$conf_file = file($file);
		for($i=0;$i<count($conf_file);$i++) {
			if(eregi("^\\\$.",$conf_file[$i]))	{			// take only rows starting with '$'
				$line_tmp = explode(";", $conf_file[$i]);	// purge strings from eventual comments on the right
				if(eregi(" = ",$line_tmp[0])) $sep = " = ";
					else $sep = "=";
				$line = explode($sep, $line_tmp[0]);			// split variable from its value
				// build array with settings [variable name, value]
				$settings[str_replace("$","",$line[0])] = htmlentities(trim($line[1],"\" "));
			}
		}	//print_r($settings);	//-> TEST
		// scan for installed themes (do not list hidden ones)
		$themes_array = array();
		$theme_num    = 0;
		foreach (glob(get_fn_dir("themes")."/*") as $theme_one){
			if(is_dir($theme_one) AND $theme_one!="CVS" AND $theme_one!="." AND $theme_one!=".." AND !stristr($theme_one,"none_")) {
				$themes_array[$theme_num] = $theme_one;
				$theme_num++;
			}
		}
		if($theme_num>0) {
			sort($themes_array);
		}	//print_r($themes_array);	//-> TEST
		// scan for installed languages
		$languages_array = array();
		$language_num    = 0;
		foreach (glob("languages/*.php") as $language_one){
			if(is_file($language_one) AND $language_one!="CVS" AND $language_one!="." AND $language_one!="..") {
				$languages_array[$language_num] = $language_one;
				$language_num++;
			}
		}
		if($language_num>0) {
			sort($languages_array);
		}	//print_r($languages_array);	//-> TEST
		?>
		<div style="margin-bottom:1em;">
			<label for="sitename"><?=_FNCC_CONFSITENAME?></label><br />
			<input type="text" name="sitename" id="sitename" style="width:100%;" maxlength="100" value="<?=$settings['sitename']?>" />
		</div>
		<div style="margin-bottom:1em;">
			<label for="sitedescription"><?=_FNCC_CONFSITEDESCRIPTION?></label><br />
			<input type="text" name="sitedescription" id="sitedescription" style="width:100%;" maxlength="500" value="<?=$settings['sitedescription']?>" />
		</div>
		<div style="margin-bottom:1em;">
			<label for="keywords"><?=_FNCC_CONFKEYWORDS?></label><br />
			<input type="text" name="keywords" id="keywords" style="width:100%;" maxlength="1500" value="<?=$settings['keywords']?>" />
		</div>
		<div style="margin-bottom:1em;">
			<div style="float:left;width:100%">
			<label for="theme"><?=_FNCC_CONFTHEME?></label>
			<ul><?
			// print the list of selectable themes
			foreach ($themes_array as $mytheme) {
				echo "<li style=\"margin:5px;float:left;display:block;\">\n";
				$mytheme = eregi_replace("^".get_fn_dir("themes")."/","",$mytheme);
				$screenshot = (file_exists(get_fn_dir("themes")."/$mytheme/screenshot.png")) ? (get_fn_dir("themes")."/$mytheme/screenshot.png") : (get_fn_dir("sections")."/$mod/none_images/no_preview.png");
				echo "<img src=\"$screenshot\" style='border:1px solid #000;max-width:130px;max-height:98px;' alt=\"$mytheme\" />\n";
				$checked = ($settings['theme'] == $mytheme) ? ("checked='checked'") : ("");
				echo "<br /><input type='radio' $checked name='theme' id='theme' value=\"$mytheme\" /> $mytheme</li>\n";
			}
			?></ul>
			</div>
		</div>
		<div style="margin-bottom:1em;">
			<label for="newspp"><?=_FNCC_CONFNEWSPP?></label><br />
			<input type="text" name="newspp" id="newspp" style="width:100%;" maxlength="3" value="<?=$settings['newspp']?>" />
		</div>
		<div style="margin-bottom:1em;">
			<label for="admin"><?=_FNCC_CONFADMIN?></label><br />
			<input type="text" name="admin" id="admin" style="width:100%;" maxlength="100" value="<?=$settings['admin']?>" />
		</div>
		<div style="margin-bottom:1em;">
			<label for="admin_mail"><?=_FNCC_CONFADMINMAIL?></label><br />
			<input type="text" name="admin_mail" id="admin_mail" style="width:100%;" maxlength="100" value="<?=$settings['admin_mail']?>" />
		</div>
		<div style="margin-bottom:1em;">
			<label for="lang"><?=_FNCC_CONFLANG?></label><br /><?
			// print the list of available languages
			foreach ($languages_array as $mylanguage) {
				$mylanguage = eregi_replace("^languages/","",$mylanguage);
				$mylanguage = str_replace(".php","",$mylanguage);
				$checked = ($settings['lang'] == $mylanguage) ? ("checked='checked'") : ("");
				echo "<input type='radio' $checked name='lang' id='lang' value='$mylanguage' /><img src='images/languages/$mylanguage.png' alt='$mylanguage' title='$mylanguage' />&nbsp;&nbsp;";
			}
		?></div>
		<div style="margin-bottom:1em;">
			<label for="reguser"><?=_FNCC_CONFREGUSER?></label><br /><?
			$reguser_sel0 = "";
			$reguser_sel1 = "";
			$reguser_sel2 = "";
			switch($settings['reguser']) {
				case 0: $reguser_sel0 = "checked='checked'"; break;
				case 1: $reguser_sel1 = "checked='checked'"; break;
				case 2: $reguser_sel2 = "checked='checked'"; break;
			}
			?><input type="radio" name="reguser" id="reguser" value="0" <?=$reguser_sel0?> /><?=_FNCC_NO?>
			<input type="radio" name="reguser" id="reguser" value="1" <?=$reguser_sel1?> /><?=_FNCC_YES?>
			<input type="radio" name="reguser" id="reguser" value="2" <?=$reguser_sel2?> /><?=_FEMAIL?>
		</div>
		<div style="margin-bottom:1em;">
			<label for="guestnews"><?=_FNCC_CONFGUESTNEWS?></label><br /><?
			$guestnews_sel0 = "";
			$guestnews_sel1 = "";
			switch($settings['guestnews']) {
				case 0: $guestnews_sel0 = "checked='checked'"; break;
				case 1: $guestnews_sel1 = "checked='checked'"; break;
			}
			?><input type="radio" name="guestnews" id="guestnews" value="0" <?=$guestnews_sel0?> /><?=_FNCC_NO?>
			<input type="radio" name="guestnews" id="guestnews" value="1" <?=$guestnews_sel1?> /><?=_FNCC_YES?>
		</div>
		<div style="margin-bottom:1em;">
			<label for="guestcomment"><?=_FNCC_CONFGUESTCOMMENT?></label><br /><?
			$guestcomment_sel0 = "";
			$guestcomment_sel1 = "";
			switch($settings['guestcomment']) {
				case 0: $guestcomment_sel0 = "checked='checked'"; break;
				case 1: $guestcomment_sel1 = "checked='checked'"; break;
			}
			?><input type="radio" name="guestcomment" id="guestcomment" value="0" <?=$guestcomment_sel0?> /><?=_FNCC_NO?>
			<input type="radio" name="guestcomment" id="guestcomment" value="1" <?=$guestcomment_sel1?> /><?=_FNCC_YES?>
		</div>
		<div style="margin-bottom:1em;">
			<label for="remember_login"><?=_FNCC_CONFREMEMBERLOGIN?></label><br /><?
			$remember_login_sel0 = "";
			$remember_login_sel1 = "";
			switch($settings['remember_login']) {
				case 0: $remember_login_sel0 = "checked='checked'"; break;
				case 1: $remember_login_sel1 = "checked='checked'"; break;
			}
			?><input type="radio" name="remember_login" id="remember_login" value="0" <?=$remember_login_sel0?> /><?=_FNCC_NO?>
			<input type="radio" name="remember_login" id="remember_login" value="1" <?=$remember_login_sel1?> /><?=_FNCC_YES?>
		</div>
		<div style="margin-bottom:1em;">
			<label for="fuso_orario"><?=_FUSO?> (1h 30m = 1,5):</label><br />
			<input type="text" name="fuso_orario" id="fuso_orario" style="width:100%;" maxlength="4" value="<?=$settings['fuso_orario']?>" />
		</div>
		<div style="margin-bottom:1em;">
			<label for="maintenance"><?=_FNCC_CONFMAINTENANCE?></label><br /><?
			$maintenance_sel0 = "";
			$maintenance_sel1 = "";
			switch($settings['maintenance']) {
				case 0: $maintenance_sel0 = "checked='checked'"; break;
				case 1: $maintenance_sel1 = "checked='checked'"; break;
			}
			?><input type="radio" name="maintenance" id="maintenance" value="0" <?=$maintenance_sel0?> /><?=_FNCC_NO?>
			<input type="radio" name="maintenance" id="maintenance" value="1" <?=$maintenance_sel1?> /><?=_FNCC_YES?>
		</div>
		<div style="margin-bottom:1em;">
			<label for="home_section"><?=_FNCC_CONFHOMESECTION?></label><br />
			<input type="text" name="home_section" id="home_section" style="width:100%;" maxlength="100" value="<?=$settings['home_section']?>" />
		</div>
		<div style="margin-bottom:1em;">
			<label for="topicperpage"><?=_FNCC_CONFTOPICPERPAGE?></label><br />
			<input type="text" name="topicperpage" id="topicperpage" style="width:100%;" maxlength="3" value="<?=$settings['topicperpage']?>" />
		</div>
		<div style="margin-bottom:1em;">
			<label for="postperpage"><?=_FNCC_CONFPOSTPERPAGE?></label><br />
			<input type="text" name="postperpage" id="postperpage" style="width:100%;" maxlength="3" value="<?=$settings['postperpage']?>" />
		</div>
		<div style="margin-bottom:1em;">
			<label for="memberperpage"><?=_FNCC_CONFMEMBERPERPAGE?></label><br />
			<input type="text" name="memberperpage" id="memberperpage" style="width:100%;" maxlength="3" value="<?=$settings['memberperpage']?>" />
		</div>
		<div style="margin-bottom:1em;">
			<label for="moderators"><?=_FNCC_CONFFORUMMODERATORS?></label><br />
			<input type="text" name="forum_moderators" id="forum_moderators" style="width:100%;" maxlength="500" value="<?=$settings['forum_moderators']?>" />
		</div>
		<input type="hidden" name="conf_mod" value="modgeneralconf" />
		<input type="hidden" name="conf_file" value="<?=$file?>" />
		<?
		// check writing permissions
		if(is_writeable($file))	{
			?><div align="center" style="font-weight:bold;">
				<?=_FNCC_WARNINGDOC?><br /><br /><input type="submit" value="<?=_MODIFICA?>" />
			</div><?
		} else {
			?><div align="center" style="font-weight:bold;font-color:red;">
				<?=_FNCC_WARNINGRIGHTS?>
			</div><? 
		}
		?></form><?
	} else echo "<div align='center' style='font-weight:bold;font-color:red;'>"._FNCC_WARNINGNOFILE."</div>";
}

/*
 * Read configuration files and print them ready to be managed
 *
 * @author Marco Segato <segatom@users.sourceforge.net>
 * @version 20070717
 *
 * @param	string	$file	File name to modify
 */
function fncc_editconffile($file) {
	// security conversions
	$mod  = getparam("mod", PAR_GET,  SAN_FLAT);
	$file = getparam($file, PAR_NULL, SAN_FLAT);
	// check file existance
	if(file_exists($file)) {
		echo "<form action=\"index.php?mod=$mod\" method=\"post\">";
		echo "<textarea rows='20' style='width:100%;' name='conf_body'>";
		echo htmlspecialchars(file_get_contents($file));
		echo "</textarea>";
		?><br /><br />
		<input type="hidden" name="conf_mod" value="modbodyfile" />
		<input type="hidden" name="conf_file" value="<?=$file?>" />
		<?
		// check writing permissions
		if(is_writeable($file))	{
			?><div align="center" style="font-weight:bold;">
				<?=_FNCC_WARNINGDOC?><br /><br /><input type="submit" value="<?=_MODIFICA?>" />
			</div><?
		} else { 
			?><div align="center" style="font-weight:bold;font-color:red;">
				<?=_FNCC_WARNINGRIGHTS?>
			</div><? 
		}
		?></form><?
	} else echo "<div align='center' style'font-weight:bold;font-color:red;'>"._FNCC_WARNINGNOFILE."</div>";
}

/*
 * Manage news of the site (write & edit)
 *
 * @author Marco Segato <segatom@users.sourceforge.net>
 * @version 20070717
 */
function fncc_managenews() {
	// security checks
	$mod  = getparam("mod",  PAR_GET, SAN_FLAT);
	$news = getparam("news", PAR_GET, SAN_FLAT);
	$rewrite     = "false";
	$edit_header = "";
	$edit_body   = "";
	$edit_cat    = "";
	global $sitename;
	// edit an old news
	if(isset($news) AND file_exists(get_fn_dir("news")."/$news.xml")) {
		$rewrite = $news;
		$fd = stripslashes(get_file(get_fn_dir("news")."/$news.xml"));
		$reftitle    = get_xml_element("fn:title", $fd);
		$edit_header = get_xml_element("fn:header",$fd);
		$edit_body   = get_xml_element("fn:body",  $fd);
		$edit_cat    = get_xml_element("fn:avatar",$fd);
	} else {
		// report a news with Flatnuke-Fast-News
		$refbody  = getparam("refbody",  PAR_GET, SAN_FLAT);
		$refurl   = getparam("refurl",   PAR_GET, SAN_FLAT);
		$reftitle = getparam("reftitle", PAR_GET, SAN_FLAT);
	}
	// options' list: write a new news, or edit an old one
	?><select style="max-width:100%" onchange="javascript:completeAHAH.ahah('<?=get_fn_dir("sections")?>/<?=$mod?>/section.php?mod=<?=$mod?>&amp;op=fnccnews&amp;news='+this.options[this.selectedIndex].value,'fn_adminpanel','0','get');"><?
		echo "\n<option value=\"\">---  "._ADDNEWS."  ---</option>\n";	// new news
		$news_array = array();
		$news_dir = opendir(get_fn_dir("news"));
		while($news_file=readdir($news_dir)) {
			if(!( $news_file=="." OR $news_file==".." ) AND (!ereg("^\.",$news_file) AND ($news_file!="CVS"))) {
				array_push($news_array, str_replace(".xml","",$news_file));
			}
		}
		closedir($news_dir);
		if(count($news_array)>0)
			rsort($news_array);
		for($i=0;$i<count($news_array);$i++) {	// old news
			$old_news = stripslashes(get_file(get_fn_dir("news")."/$news_array[$i].xml"));
			$old_news_tit = get_xml_element("fn:title",$old_news);
			echo "<option value=\"$news_array[$i]\"";
			if($news_array[$i]==$news) echo "selected=\"selected\"";
			echo ">$old_news_tit ("._POSTATO.date(" d/m/Y, H:i", $news_array[$i]).")</option>\n";
		}
	?></select><br /><br /><?
	// print html form to write the news
	echo "<form action=\"index.php?mod=$mod\" method=\"post\">";
	?><b><?= _TITNOTIZIA ?></b><br />
	<input type="text" id="news_title" name="title" style="width:100%" value="<?= $reftitle ?>" /><br /><br />
	<b><?= _ARGOMENTO ?></b><br />
	<? $print_cat = ($edit_cat=="") ? ("images/nonews.png") : ("images/news/$edit_cat"); ?>
	<img id="avatar" name="avatar" src="<?=$print_cat?>" border="0" alt="Topic" /><br />
	<select style="max-width:100%" name="icon" onchange="document.avatar.src='images/news/'+this.options[this.selectedIndex].value"><?
		// list topic arguments
		echo "\n<option value=\"../nonews.png\"> --- </option>\n";
		$icon_array = array();
		$icon_dir = opendir('images/news');
		while($icon_file=readdir($icon_dir)) {
			if(!( $icon_file=="." OR $icon_file==".." ) AND (!ereg("^\.",$icon_file) AND ($icon_file!="CVS")) ) {
				array_push($icon_array, $icon_file);
			}
		}
		closedir($icon_dir);
		if(count($icon_array)>0)
			sort($icon_array);
		for ($i=0;$i<count($icon_array);$i++) {
			echo "<option value=\"$icon_array[$i]\"";
			if($edit_cat == $icon_array[$i]) echo " selected=\"selected\"";
			echo ">".str_replace("_"," ", ereg_replace("\..*","",$icon_array[$i]))."</option>\n";
		}
	echo "</select><br /><br />";
	// bbcodes panel news HEADER
	bbcodes_panel("head", "home", "formatting"); echo "<br />";
	bbcodes_panel("head", "home", "emoticons"); echo "<br />";
	bbcodes_panel("head", "home", "images"); echo "<br />";
	echo "<b>"._INTMESSAGGIO."</b><br />";
	echo "<textarea id='news_head' rows='20' style='width:100%;' name='head'>";
	if(isset($refbody) AND $refbody != "") {
		echo "$refbody\n\nLink: <a href=\"$refurl\">$refurl</a>";	// Flatnuke-Fast-News link 
	} else echo "$edit_header";	// edit old news
	echo "</textarea>\n<br /><br />";
	// bbcodes panel news BODY
	bbcodes_panel("body", "home", "formatting"); echo "<br />";
	bbcodes_panel("body", "home", "emoticons"); echo "<br />";
	bbcodes_panel("body", "home", "images"); echo "<br />";
	echo "<b>"._CORPOMESSAGGIO."</b><br />";
	echo "<textarea id='news_body' rows='20' style='width:100%;' name='body'>$edit_body</textarea><br /><br />";
	// submit buttons
	?><input type="hidden" name="conf_mod" value="savenews" />
	<input type="hidden" name="rewrite" value="<?=$rewrite?>" />
	<input type="submit" value="<?=_INSNOTIZIA?>" />
	<input type="button" value="<?=_ANTEPRIMA?>" onclick='ShowHideDiv("fnpreview");' /><?
	if($rewrite!="false") {
		$delurl = get_fn_dir("sections")."/$mod/section.php?mod=$mod&amp;get_act=deletenews&amp;delnews=".get_fn_dir("news")."/$news.xml";
		echo "&nbsp;<input type=\"button\" value=\""._ELIMINA."\" onclick=\"javascript:completeAHAH.ahah('$delurl','fn_adminpanel','0','get');\" />";
	}
	?></form>
	<script language="javascript">
		getElement("news_title").onkeyup     = news_preview;
		getElement("news_title").onmousemove = news_preview;
		getElement("news_head").onkeyup      = news_preview;
		getElement("news_head").onmousemove  = news_preview;
		getElement("news_body").onkeyup      = news_preview;
		getElement("news_body").onmousemove  = news_preview;
		news_preview();
	</script>
	<br /><div id="fnpreview" name="fnpreview" style="overflow:auto;max-height:300px;visibility:visible;background-color:#F0F0F0;border:2px solid;padding:5px;border-top-color:#ffffff;border-left-color:#ffffff;border-bottom-color:#666666;border-right-color:#666666;width:100%;"></div>
	<?
	// Flatnuke-Fast-News link
	echo "<br />"._FASTNEWSSTR."<br /><a href=\"javascript:if(navigator.userAgent.indexOf('Safari') >= 0){Q=getSelection();}else{Q=document.selection?document.selection.createRange().text:document.getSelection();}location.href='http://".$_SERVER["HTTP_HOST"].$_SERVER["PHP_SELF"]."?mod=news&refbody='+encodeURIComponent(Q)+'&refurl='+encodeURIComponent(location.href)+'&reftitle='+encodeURIComponent(document.title);\">$sitename &raquo; Flatnuke Fast News</a>";
}

/*
 * Manage news proposed by users/visitors
 *
 * @author Marco Segato <segatom@users.sourceforge.net>
 * @version 20070721
 */
function fncc_managepropnews() {
	// security checks
	$mod  = getparam("mod",  PAR_GET, SAN_FLAT);
	$news = getparam("news", PAR_GET, SAN_FLAT);
	$rewrite     = "false";
	$edit_header = "";
	$edit_body   = "";
	$edit_cat    = "";
	// load contents of the news proposed
	if(isset($news) AND file_exists(get_fn_dir("var")."/$news.xml")) {
		$rewrite = $news;
		$fd = stripslashes(get_file(get_fn_dir("var")."/$news.xml"));
		$reftitle    = get_xml_element("fn:title", $fd);
		$edit_header = get_xml_element("fn:header",$fd);
		$edit_body   = get_xml_element("fn:body",  $fd);
		$edit_cat    = get_xml_element("fn:avatar",$fd);
	}
	// list news waiting for acceptance
	$news_array = array();
	$news_dir = opendir(get_fn_dir("var"));
	while($news_file=readdir($news_dir)) {
		if(eregi("^news_[0-9]+\.xml", $news_file)) {
			array_push($news_array, str_replace(".xml","",$news_file));
		}
	} //echo "<pre>";print_r($news_array);echo "</pre>";	//-> TEST
	closedir($news_dir);
	if(count($news_array)==0) {
		echo "<b>"._NOPUBNEWS." !</b>";
		return;
	} else {
		sort($news_array);
	}
	?><select style="max-width:100%" onchange="javascript:completeAHAH.ahah('<?=get_fn_dir("sections")?>/<?=$mod?>/section.php?mod=<?=$mod?>&amp;op=fnccpropnews&amp;news='+this.options[this.selectedIndex].value,'fn_adminpanel','0','get');"><?
		echo "\n<option value=\"\">---  "._SEGNNOTIZIE."  ---</option>\n";
		for($i=0;$i<count($news_array);$i++) {
			$old_news = stripslashes(get_file(get_fn_dir("var")."/$news_array[$i].xml"));
			$old_news_tit = get_xml_element("fn:title",$old_news);
			echo "<option value=\"$news_array[$i]\"";
			if($news_array[$i]==$news) echo "selected=\"selected\"";
			echo ">$old_news_tit ("._POSTATO.date(" d/m/Y, H:i", str_replace("news_","",$news_array[$i])).")</option>\n";
		}
	?></select><?
	// print html form (only if you chose a news)
	if(trim($news)=="") {
		return;
	}
	?><br /><br /><?
	echo "<form action=\"index.php?mod=$mod\" method=\"post\">";
	?><b><?= _TITNOTIZIA ?></b><br />
	<input type="text" id="news_title" name="title" style="width:100%" value="<?= $reftitle ?>" /><br /><br />
	<b><?= _ARGOMENTO ?></b><br />
	<? $print_cat = ($edit_cat=="") ? ("images/nonews.png") : ("images/news/$edit_cat"); ?>
	<img id="avatar" name="avatar" src="<?=$print_cat?>" border="0" alt="Topic" /><br />
	<select style="max-width:100%" name="icon" onchange="document.avatar.src='images/news/'+this.options[this.selectedIndex].value"><?
		// list topic arguments
		echo "\n<option value=\"../nonews.png\"> --- </option>\n";
		$icon_array = array();
		$icon_dir = opendir('images/news');
		while($icon_file=readdir($icon_dir)) {
			if(!( $icon_file=="." OR $icon_file==".." ) AND (!ereg("^\.",$icon_file) AND ($icon_file!="CVS")) ) {
				array_push($icon_array, $icon_file);
			}
		}
		closedir($icon_dir);
		if(count($icon_array)>0)
			sort($icon_array);
		for ($i=0;$i<count($icon_array);$i++) {
			echo "<option value=\"$icon_array[$i]\"";
			if($edit_cat == $icon_array[$i]) echo " selected=\"selected\"";
			echo ">".str_replace("_"," ", ereg_replace("\..*","",$icon_array[$i]))."</option>\n";
		}
	echo "</select><br /><br />";
	// bbcodes panel news HEADER
	bbcodes_panel("head", "home", "formatting"); echo "<br />";
	bbcodes_panel("head", "home", "emoticons"); echo "<br />";
	bbcodes_panel("head", "home", "images"); echo "<br />";
	echo "<b>"._INTMESSAGGIO."</b><br />";
	echo "<textarea id='news_head' rows='20' style='width:100%;' name='head'>";
	echo "$edit_header";
	echo "</textarea>\n<br /><br />";
	// bbcodes panel news BODY
	bbcodes_panel("body", "home", "formatting"); echo "<br />";
	bbcodes_panel("body", "home", "emoticons"); echo "<br />";
	bbcodes_panel("body", "home", "images"); echo "<br />";
	echo "<b>"._CORPOMESSAGGIO."</b><br />";
	echo "<textarea id='news_body' rows='20' style='width:100%;' name='body'>$edit_body</textarea><br /><br />";
	// submit buttons
	?><input type="hidden" name="conf_mod" value="savepropnews" />
	<input type="hidden" name="rewrite" value="<?=$rewrite?>" />
	<input type="submit" value="<?=_INSNOTIZIA?>" />
	<input type="button" value="<?=_ANTEPRIMA?>" onclick='ShowHideDiv("fnpreview");' />
	<? $delurl = get_fn_dir("sections")."/$mod/section.php?mod=$mod&amp;get_act=deletenews&amp;delnews=misc/$news.xml"; ?>
	<input type="button" value="<?=_ELIMINA?>" onclick="javascript:completeAHAH.ahah('<?=$delurl?>','fn_adminpanel','0','get');" />
	</form>
	<script language="javascript">
		getElement("news_title").onkeyup     = news_preview;
		getElement("news_title").onmousemove = news_preview;
		getElement("news_head").onkeyup      = news_preview;
		getElement("news_head").onmousemove  = news_preview;
		getElement("news_body").onkeyup      = news_preview;
		getElement("news_body").onmousemove  = news_preview;
		news_preview();
	</script>
	<br /><div id="fnpreview" name="fnpreview" style="overflow:auto;max-height:300px;visibility:visible;background-color:#F0F0F0;border:2px solid;padding:5px;border-top-color:#ffffff;border-left-color:#ffffff;border-bottom-color:#666666;border-right-color:#666666;width:100%;"></div><?
}

/*
 * Manage Flatnuke poll
 *
 * @author Marco Segato <segatom@users.sourceforge.net>
 * @version 20070716
 */
function fncc_editpoll() {
	// security conversions
	$mod     = getparam("mod",     PAR_GET,    SAN_FLAT);
	$myforum = getparam("myforum", PAR_COOKIE, SAN_FLAT);
	include (get_fn_dir("sections")."/none_Sondaggio/config.php");
	// files' declarations
	$file_xml = get_file($sondaggio_file_dati);
	$attivo   = get_xml_element("fp:attivo",$file_xml);
	$opzioni  = get_xml_element("fp:opzioni",$file_xml);
	$opzione  = get_xml_array("fp:opzione",$opzioni);
	// print html form
	echo "<form action=\"index.php?mod=$mod\" method=\"post\">";
	// poll status: open/closed
	echo "<div style='margin-bottom:1em;'>"._FP_STATOSONDAGGIO;
	if($attivo=="y") {
		echo "<input type='radio' name='fp_stato' value='y' checked='checked' />"._FP_APERTO;
		echo "<input type='radio' name='fp_stato' value='n' />"._FP_CHIUSO;
	} else { 
		echo "<input type='radio' name='fp_stato' value='y' />"._FP_APERTO;
		echo "<input type='radio' name='fp_stato' value='n' checked='checked' />"._FP_CHIUSO;
	}
	echo "</div>";
	// poll argument
	echo "<div style='margin-bottom:1em;'>"._FP_DOMANDASONDAGGIO.": ";
	echo "<input type='text' name='salva_domanda' value='".get_xml_element("fp:domanda",$file_xml)."' style='width:60%;' />";
	echo "</div>";
	// instructions
	echo "<div align='justify' style='margin-bottom:1em;'>"._FP_ISTRUZIONIMODIFICA."</div>";
	// poll options
	echo "<table width='100%'><tbody>";
	for($n=0; $n<count($opzione); $n++) {	// print possible answers and votes (max 20)
		echo "<tr width='100%'>";
		echo "<td align='right'>"; echo $n+1; echo "</td>";
		echo "<td><input type='text' name='salva_opzioni[]' value='".get_xml_element("fp:testo",$opzione[$n])."' /></td>";
		echo "<td>"._FP_VOTI."</td>";
		echo "<td><input type='text' name='salva_voti[]' value='".get_xml_element("fp:voto",$opzione[$n])."' /></td>";
		echo "</tr>";
	}
	for($n=count($opzione); $n<20; $n++) {	// print empty options
		echo "<tr width='100%'>";
		echo "<td align='right'>"; echo $n+1; echo "</td>";
		echo "<td><input type='text' name='salva_opzioni[]' value='' /></td>";
		echo "<td>"._FP_VOTI."</td>";
		echo "<td><input type='text' name='salva_voti[]' value='' /></td>";
		echo "</tr>";
	}
	echo "</tbody></table>";
	// save poll configuration
	?><br />
	<input type="hidden" name="conf_mod" value="savepoll" />
	<center><input type="submit" value="<?=_FP_MODIFICA?>" /></center>
	</form><?
	// archive poll
	echo "<form action=\"index.php?mod=$mod\" method=\"post\">";
	?><input type="hidden" name="conf_mod" value="archpoll" />
	<center><input type="submit" value="<?=_FP_CHIUDIARCHIVIA?>" /></center>
	</form>
	<?
}

/*
 * List all members of the site, with the possibility
 * to list them in order by name or by time
 *
 * @author Marco Segato <segatom@users.sourceforge.net>
 * @version 20070729
 */
function fncc_userslist() {
	// security conversions
	$mod   = getparam("mod", PAR_GET, SAN_FLAT);
	$order = getparam("order", PAR_GET, SAN_FLAT);
	// variables
	global $fuso_orario;
	$time_fresh = 192;	// number of hours in a week
	// load members in an array
	$users = list_users();
	$members = array();
	for($i=0;$i<count($users);$i++) {
		array_push($members, array("name" => $users[$i], "time" => filemtime(get_fn_dir("users")."/".$users[$i].".php")+(3600*$fuso_orario)));
	}	//echo "<pre>";print_r($members);echo "</pre>";	//-> TEST
	// sort the array as chosen
	if(count($members)>0) {
		switch($order) {
			case "name_a":
				sort ($members); // ascending by name
			break;
			case "name_d":
				rsort ($members); // descending name
			break;
			case "time_a":
				usort($members, create_function('$a, $b', "return strnatcasecmp(\$a['time'], \$b['time']);")); // ascending by time
			break;
			case "time_d":
				usort($members, create_function('$a, $b', "return strnatcasecmp(\$a['time'], \$b['time']);")); // descending by time
				$members = array_reverse($members, FALSE);
			break;
			default: sort ($members);
		}
	}
	// print links to order the list
	$ord_name_a = build_ahah_link($mod, "&amp;op=fnccmembers&amp;order=name_a", "fn_adminpanel", "get");
	$ord_name_d = build_ahah_link($mod, "&amp;op=fnccmembers&amp;order=name_d", "fn_adminpanel", "get");
	$ord_time_a = build_ahah_link($mod, "&amp;op=fnccmembers&amp;order=time_a", "fn_adminpanel", "get");
	$ord_time_d = build_ahah_link($mod, "&amp;op=fnccmembers&amp;order=time_d", "fn_adminpanel", "get");
	// print the list of the members
	$style_h = " style=\"border:1px solid;border-collapse:collapse;font-weight:bold;text-align:center;\"";
	$style_c = " style=\"border-bottom:1px solid;padding-left:1.5em;";
	echo "<table cellspacing='0' cellpadding='0' style='width:100%'><tbody>";
	echo "<tr>";
		echo "<td ".$style_h.">Id</td>";
		echo "<td ".$style_h.">$ord_name_a&#8595;</a> "._NOMEUTENTE." $ord_name_d&#8593;</a></td>";
		echo "<td ".$style_h.">$ord_time_a&#8595;</a> "._FNCC_CHANGEDATE." $ord_time_d&#8593;</a></td>";
	echo "</tr>";
	for($i=0; $i<count($members); $i++) {
		echo "<tr>";
		echo "<td ".$style_c."text-align:right;padding-right:0.5em;\">".($i+1)."</td>";
		$member = str_replace(".php", "", $members[$i]['name']);
		echo "<td $style_c\"><a href=\"index.php?mod=none_Login&amp;action=viewprofile&amp;user=$member\" title=\""._VIEW_USERPROFILE." $member\">$member</a></td>";
		// print image 'new.gif' if userprofile has been modified within 1 week
		if(time()-$members[$i]['time']<$time_fresh*3600) {
			$img_fresh = "<img src='images/mime/new.gif' alt='new' />";
		} else {
			$img_fresh = "";
		}
		echo "<td  ".$style_c."\">".date(" d.m.Y, H:i:s", $members[$i]['time'])." $img_fresh</td>";
		echo "</tr>";
	}
	?></tbody></table><?
}

/*
 * Add a new user profile
 *
 * @author Marco Segato <segatom@users.sourceforge.net>
 * @version 20070716
 */
function fncc_newuserprofile() {
	// security conversions
	$mod   = getparam("mod", PAR_GET, SAN_FLAT);
	// print fields to fill
	echo "<form action=\"index.php?mod=$mod\" method=\"post\">";
	$style1 = "font-style:bold; padding:0.2em;";
	$style2 = "padding:0.2em;";
	?><table width='70%' align='center' border='1' style="border-collapse:collapse">
	<tbody>
	<tr>
		<td style="<?=$style1?>"><label for="nome"><b><span>*</span> <?=_NOMEUTENTE?></b></label></td>
		<td style="<?=$style2?>"><input name="nome" type="text" id="nome"/></td>
	</tr>
	<tr>
		<td style="<?=$style1?>"><label for="regpass"><b><span>*</span> <?=_PASSWORD?></b></label></td>
		<td style="<?=$style2?>"><input name="regpass" type="password" id="regpass" /></td>
	</tr>
	<tr>
		<td style="<?=$style1?>"><label for="reregpass"><b><span>*</span> <?=_PASSWORD?></b></label></td>
		<td style="<?=$style2?>"><input name="reregpass" type="password" id="reregpass" /></td>
	</tr>
	<tr>
		<td style="<?=$style1?>"><label for="anag"><?=_FNOME?></label></td>
		<td style="<?=$style2?>"><input name="anag" type="text" id="anag" /></td>
	</tr>
	<tr>
		<td style="<?=$style1?>"><label for="email"><?
			if ($reguser=="2" AND $action=="reguser") echo "<span>*</span>&nbsp;<b>";
			echo _FEMAIL;
			if ($reguser=="2" AND $action=="reguser") echo "</b>";
		?></label></td>
		<td style="<?=$style2?>"><input name="email" type="text" id="email" /></td>
	</tr>
	<tr>
		<td style="<?=$style1?>"><label for="hiddenmail"><?=_HIDDENMAIL?></label></td>
		<td style="<?=$style2?>"><input name="hiddenmail" type="checkbox" id="hiddenmail" /></td>
	</tr>
	<tr>
		<td style="<?=$style1?>"><label for="homep"><?=_FHOME?></label></td>
		<td style="<?=$style2?>"><input name="homep" type="text" id="homep" /></td>
	</tr>
	<tr>
		<td style="<?=$style1?>"><label for="prof"><?=_FPROFES?></label></td>
		<td style="<?=$style2?>"><input name="prof" type="text" id="prof" /></td>
	</tr>
	<tr>
		<td style="<?=$style1?>"><label for="prov"><?=_FPROV?></label></td>
		<td style="<?=$style2?>"><input name="prov" type="text" id="prov" /></td>
	</tr>
	<tr>
		<td style="<?=$style1?>"><label for="ava"><?=_FAVAT?></label></td>
		<td style="<?=$style2?>">
			<img name="avatar" src="forum/images/blank.png" alt="avatar" border="0" style="max-width:120px;" id="avatar" />
			<br />
			<select name="ava" onchange='document.avatar.src="forum/images/"+this.options[this.selectedIndex].value'>
			<option value="blank.png">----</option><?
			$modlist = array();
			$handle = opendir('forum/images');
			while ($file = readdir($handle)) {
				if (!( $file=="." or $file==".." )) {
					array_push($modlist, $file);
				}
			}
			closedir($handle);
			if(count($modlist)>0)
				sort($modlist);
			for ($i=0; $i < sizeof($modlist); $i++) {
				echo "<option value=\"$modlist[$i]\">$modlist[$i]</option>\n";
			}
			?></select><br /><br />
			<?=_FAVATREM?>:<br /><?
			echo "<input type=\"text\" name=\"url_avatar\" />";
		?></td>
	</tr>
	<tr>
		<td style="<?=$style1?>"><label for="firma"><?=_FFIRMA?></label></td>
		<td style="<?=$style2?>"><textarea name="firma" id="firma" rows="5" cols="23"></textarea></td>
	</tr>
	<tr>
		<td style="<?=$style1?>"><label for="level"><?=_LEVEL?></label></td>
		<td style="<?=$style2?>">
			<select name="level" id="level"><?
				for($i=0; $i<11; $i++){
					echo "<option value=\"$i\">$i</option>";
				}
			?></select>
		</td>
	</tr>
	</tbody>
	</table>
	<div align="center" style="margin:1em;"><input type="submit" value="<?=_FINVIA?>" /></div>
	<input type="hidden" name="conf_mod" value="saveprofile" />
	</form><?	
}

/*
 * Manage profiles waiting for activation
 *
 * @author Marco Segato <segatom@users.sourceforge.net>
 * @version 20070730
 */
function fncc_listwaiting() {
	// security conversions
	$mod   = getparam("mod",   PAR_GET, SAN_FLAT);
	$order = getparam("order", PAR_GET, SAN_FLAT);
	$user  = getparam("user",  PAR_GET, SAN_FLAT);
	// variables
	global $fuso_orario;
	$time_fresh = 192;	// number of hours in a week
	// load members in an array
	$waitinglist = array();
	$handle = opendir(get_waiting_users_dir());
	while($file = readdir($handle)) {
		if(eregi("^[0-9a-zA-Z]+\.php$", $file)) {
			$file = str_replace(".php", "", $file);
			array_push($waitinglist, $file);
		}
	}	//echo "<pre>";print_r($waitinglist);echo "</pre>";	//-> TEST
	closedir($handle);
	// check the number of profiles to activate
	if(count($waitinglist)==0) {
		echo _FNCC_NOUSERSTOACTIVATE;
		return;
	}
	$members = array();
	for($i=0;$i<count($waitinglist);$i++) {
		array_push($members, array("name" => $waitinglist[$i], "time" => filemtime(get_waiting_users_dir()."/".$waitinglist[$i].".php")+(3600*$fuso_orario)));
	}	//echo "<pre>";print_r($members);echo "</pre>";	//-> TEST
	// sort the array as chosen
	if(count($members)>0) {
		switch($order) {
			case "name_a":
				sort ($members); // ascending by name
			break;
			case "name_d":
				rsort ($members); // descending name
			break;
			case "time_a":
				usort($members, create_function('$a, $b', "return strnatcasecmp(\$a['time'], \$b['time']);")); // ascending by time
			break;
			case "time_d":
				usort($members, create_function('$a, $b', "return strnatcasecmp(\$a['time'], \$b['time']);")); // descending by time
				$members = array_reverse($members, FALSE);
			break;
			default: sort ($members);
		}
	}
	// print links to order the list
	$ord_name_a = build_ahah_link($mod, "&amp;op=fnccwaitingusers&amp;order=name_a", "fn_adminpanel", "get");
	$ord_name_d = build_ahah_link($mod, "&amp;op=fnccwaitingusers&amp;order=name_d", "fn_adminpanel", "get");
	$ord_time_a = build_ahah_link($mod, "&amp;op=fnccwaitingusers&amp;order=time_a", "fn_adminpanel", "get");
	$ord_time_d = build_ahah_link($mod, "&amp;op=fnccwaitingusers&amp;order=time_d", "fn_adminpanel", "get");
	// print the list of the profiles
	$style_h = " style=\"border:1px solid;border-collapse:collapse;font-weight:bold;text-align:center;\"";
	$style_c = " style=\"border-bottom:1px solid;padding-left:1.5em;";
	echo "<table cellspacing='0' cellpadding='0' style='width:100%'><tbody>";
	echo "<tr>";
		echo "<td ".$style_h.">Id</td>";
		echo "<td ".$style_h.">$ord_name_a&#8595;</a> "._NOMEUTENTE." $ord_name_d&#8593;</a></td>";
		echo "<td ".$style_h.">$ord_time_a&#8595;</a> "._FNCC_CHANGEDATE." $ord_time_d&#8593;</a></td>";
	echo "</tr>";
	for($i=0; $i<count($members); $i++) {
		echo "<tr>";
		echo "<td ".$style_c."text-align:right;padding-right:0.5em;\">".($i+1)."</td>";
		$member = str_replace(".php", "", $members[$i]['name']);
		$link = build_ahah_link($mod, "&amp;op=fnccwaitingusers&amp;user=$member", "fn_adminpanel", "get");
		echo "<td $style_c\">".$link.$member."</a></td>";
		// print image 'new.gif' if userprofile has been registered within 1 week
		if(time()-$members[$i]['time']<$time_fresh*3600) {
			$img_fresh = "<img src='images/mime/new.gif' alt='new' />";
		} else {
			$img_fresh = "";
		}
		echo "<td  ".$style_c."\">".date(" d.m.Y, H:i:s", $members[$i]['time'])." $img_fresh</td>";
		echo "</tr>";
	}
	?></tbody></table><?
	// print all the details of the profile chosen
	switch("$user") {
		case "":
			continue;
		break;
		default:
			$user_xml = array();
			$user_xml = load_user_profile($user, 1);	//echo "<pre>";print_r($user_xml);echo "</pre>"; //-> TEST
			$detstyle1 = "float:left;height:2em;width:25%;";
			$detstyle2 = "float:left;height:2em;width:60%;";
			?><p><center><b><?=$user?></b></center></p>
			<div id='user_profile' style='width:85%;padding: 1em 0 0.5em 15%;border:1px dashed;'>
			<div id='password' style='float:left;width:100%;'>
				<div style='<?=$detstyle1?>'><?=_PASSWORD?></div>
				<div style='<?=$detstyle2?>'>&nbsp;<?=$user_xml['password']?></div>
			</div>
			<div id='name' style='float:left;width:100%;'>
				<div style='<?=$detstyle1?>'><?=_FNOME?></div>
				<div style='<?=$detstyle2?>'>&nbsp;<?=$user_xml['name']?></div>
			</div>
			<div id='mail' style='float:left;width:100%;'>
				<div style='<?=$detstyle1?>'><?=_FEMAIL?></div>
				<div style='<?=$detstyle2?>'>&nbsp;<?=$user_xml['mail']?></div>
			</div>
			<div id='mail' style='float:left;width:100%;'>
				<div style='<?=$detstyle1?>'><?=_HIDDENMAIL?></div>
				<div style='<?=$detstyle2?>'><input id="hiddenmail" type="checkbox" disabled='disabled' <? if ($user_xml['hiddenmail']=="1") echo "checked='checked'";?> /></div>
			</div>
			<div id='homepage' style='float:left;width:100%;'>
				<div style='<?=$detstyle1?>'><?=_FHOME?></div>
				<div style='<?=$detstyle2?>'>&nbsp;<?=$user_xml['homepage']?></div>
			</div>
			<div id='work' style='float:left;width:100%;'>
				<div style='<?=$detstyle1?>'><?=_FPROFES?></div>
				<div style='<?=$detstyle2?>'>&nbsp;<?=$user_xml['work']?></div>
			</div>
			<div id='from' style='float:left;width:100%;'>
				<div style='<?=$detstyle1?>'><?=_FPROV?></div>
				<div style='<?=$detstyle2?>'>&nbsp;<?=$user_xml['from']?></div>
			</div>
			<div id='avatar' style='float:left;width:100%;'>
				<div style='<?=$detstyle1?>'><?=_FAVAT?></div>
				<div style='<?=$detstyle2?>'>&nbsp;<?=$user_xml['avatar']?></div>
			</div>
			<div id='sign' style='float:left;width:100%;'>
				<div style='<?=$detstyle1?>'><?=_FFIRMA?></div>
				<div style='<?=$detstyle2?>'>&nbsp;<?=$user_xml['sign']?></div>
			</div>
			<div id='level' style='float:left;width:100%;margin-bottom:1.5em;'>
				<div style='<?=$detstyle1?>border-bottom:1px solid;'><?=_LEVEL?></div>
				<div style='<?=$detstyle2?>border-bottom:1px solid;'>&nbsp;<?=$user_xml['level']?></div>
			</div>
			<div id='regmail' style='float:left;width:100%;'><?
				echo build_ahah_link($mod, "", "fn_adminpanel", "post", "form_updatewaiting");
				?><input type="hidden" name="conf_mod" value="updatewaiting" />
				<input type="hidden" name="user" value="<?=$user?>" />
				<div style='<?=$detstyle1?>'><?=_FNCC_REGMAIL?></div>
				<div style='float:left;height:2em;width:55%;margin-right:2px;'><input name='regmail' type='text' style='width:100%' value='<?=$user_xml['regmail']?>' /></div><?
				$url_mod = "<button type='submit' title=\""._FNCC_REGMAILDES."\">";
				$url_mod .= "<img src='".get_fn_dir("sections")."/$mod/none_images/save.png' alt='save' border='0' />";
				$url_mod .= "</button>\n";
				?><div style='float:left'><?=$url_mod?></div>
				</form>
			</div>
			<div id='regcode' style='float:left;width:100%;'><?
				echo build_ahah_link($mod, "", "fn_adminpanel", "post", "form_sendactivation");
				?><input type="hidden" name="conf_mod" value="sendactivation" />
				<input type="hidden" name="mod" value="<?=$mod?>" />
				<input type="hidden" name="user" value="<?=$user?>" />
				<input type='hidden' name='regcode' value='<?=$user_xml['regcode']?>' />
				<input type="hidden" name="mail" value="<?=$user_xml['regmail']?>" />
				<div style='<?=$detstyle1?>'><?=_FNCC_REGCODE?></div>
				<div style='float:left;height:2em;width:55%;margin-right:2px;'><input type='text' style='width:100%' disabled='disabled' value='<?=$user_xml['regcode']?>' /></div><?
				$url_reg = "<button type='submit' title=\""._FNCC_REGCODEDES."\">";
				$url_reg .= "<img src='forum/icons/mail.png' alt='mail' border='0' />";
				$url_reg .= "</button>\n";
				?><div style='float:left'><?=$url_reg?></div>
				</form>
			</div>
			<p style='margin-left:30%;font-weight:bold'><?
			echo build_ahah_link($mod, "&amp;op=fnccwaitingusers&amp;get_act=deletewaiting&amp;deluser=$user", "fn_adminpanel", "get");
			echo _ELIMINA."</a> | ";
			echo "<a href='index.php?mod=none_Login&amp;action=activateuser&amp;user=$user&amp;regcode=".$user_xml['regcode']."'>"._FNCC_ACTIVATE."</a>";
			?></p>
			</div><?
		break;
	}
}

/*
 * Manage Flatnuke backups
 *
 * @author Marco Segato <segatom@users.sourceforge.net>
 * @version 20070730
 */
function fncc_managebackups() {
	// security checks
	$mod = getparam("mod", PAR_GET, SAN_FLAT);
	$log = getparam("log", PAR_GET, SAN_FLAT);
	// list all types of backup allowed
	$backup_array = array(
		"news"    =>array("value"=>get_fn_dir("news"),    			"desc"=>_FNCC_BACKUPNEWS),
		"users"   =>array("value"=>get_fn_dir("users"),   			"desc"=>_FNCC_BACKUPUSERS),
		"var"     =>array("value"=>get_fn_dir("var"),     			"desc"=>_FNCC_BACKUPMISC." /".get_fn_dir("var")),
		"sections"=>array("value"=>get_fn_dir("sections"),			"desc"=>_FNCC_BACKUPSECT),
		"forum"   =>array("value"=>get_fn_dir("var")."/flatforum",	"desc"=>_FNCC_BACKUPFORUM),
		"site"    =>array("value"=>"./",                  			"desc"=>_FNCC_BACKUPSITE),
    );	//echo "<pre>";print_r($backup_array);echo "</pre>"; //-> TEST
	// print html forms
	$icon = get_fn_dir("sections")."/$mod/none_images/floppy_unmount.png";
	foreach($backup_array as $tosave) {
		echo "<form action=\"index.php?mod=$mod\" method=\"post\">";
		?><div style="float:left;width:100%;border-bottom:solid 1px;">
			<div style="float:left;width:70%;padding:0.5em 0 0.5em 1em;">
			<img src="<?=$icon?>" alt="backup" style="vertical-align:middle;margin-right:1em;"><?=$tosave['desc']?>
			<input type="hidden" name="conf_mod" value="dobackup" />
			<input type="hidden" name="tosave" value="<?=$tosave['value']?>" />
			</div>
			<div style="float:left;padding:1em 0 1em 0;">
			<input type="submit" value="<?=_FNCC_SAVE?>" />
			</div>
		</div>
		</form><?	
	}
	// print cancel form
	echo build_ahah_link($mod, "", "fn_adminpanel", "post", "form_cleanbackup");
	?><div style="float:left;width:100%;padding-bottom:2em;">
		<div style="float:left;width:70%;padding:0.5em 0 0.5em 1em;">
		<img src="<?=get_fn_dir("sections")?>/<?=$mod?>/none_images/button_cancel.png" alt="canc" style="vertical-align:middle;padding-right:1em;">
		<?=_FNCC_DELBACKUP." (".count(fncc_listbackups()).")"?>
		</div>
		<div style="float:left;padding:1em 0 1em 0;">
		<input type="hidden" name="conf_mod" value="cleanbackup" />
		<input type="submit" value="<?=_ELIMINA?>" />
		</div>
	</div>
	</form><?
}

/*
 * Manage Flatnuke logs
 *
 * @author Marco Segato <segatom@users.sourceforge.net>
 * @version 20070720
 */
function fncc_managelogs() {
	// security checks
	$mod = getparam("mod", PAR_GET, SAN_FLAT);
	$log = getparam("log", PAR_GET, SAN_FLAT);
	$rewrite     = "false";
	// load content of the log you choosed
	if(isset($log) AND file_exists(get_fn_dir("var")."/log/$log.php")) {
		$content = stripslashes(get_file(get_fn_dir("var")."/log/$log.php"));
	}
	// list news waiting for acceptance
	$logs_array = array();
	$logs_dir = opendir(get_fn_dir("var")."/log");
	while($logs_file=readdir($logs_dir)) {
		if($logs_file!="." AND $logs_file!=".." ) {
			array_push($logs_array, str_replace(".php","",$logs_file));
		}
	} //echo "<pre>";print_r($logs_array);echo "</pre>";	//-> TEST
	closedir($logs_dir);
	if(count($logs_array)==0) {
		echo "<b>"._NORESULT." !</b>";
		return;
	} else {
		sort($logs_array);
	}
	?><select style="max-width:100%" onchange="javascript:completeAHAH.ahah('<?=get_fn_dir("sections")?>/<?=$mod?>/section.php?mod=<?=$mod?>&amp;op=fncclogs&amp;log='+this.options[this.selectedIndex].value,'fn_adminpanel','0','get');"><?
		echo "\n<option value=\"\">---  "._FNCC_LOGLIST."  ---</option>\n";
		for($i=0;$i<count($logs_array);$i++) {
			echo "<option value=\"$logs_array[$i]\"";
			if($logs_array[$i]==$log) echo "selected=\"selected\"";
			echo ">$logs_array[$i]</option>\n";
		}
	?></select><?
	// print html form (only if you chose a log)
	if(trim($log)=="") {
		return;
	}
	?><br /><br /><?
	echo "<textarea name='log_content' readonly='readonly' wrap='off' rows='20' style='width:100%;'>";
	echo $content;
	echo "</textarea>\n<br /><br />";
	// delete button
	echo build_ahah_link($mod, "", "fn_adminpanel", "post", "form_cleanlog");
	?><input type="hidden" name="conf_mod" value="cleanlog" />
	<input type="hidden" name="logfile" value="misc/log/<?=$log?>.php" />
	<input type="submit" value="<?=_FNCC_CLEANLOG?>" />
	</form><?
}

/*
 * Manage Flatnuke blacklists
 *
 * @author Marco Segato <segatom@users.sourceforge.net>
 * @version 20070721
 */
function fncc_manageblacklists() {
	// security checks
	$mod  = getparam("mod",  PAR_GET, SAN_FLAT);
	$list = getparam("list", PAR_GET, SAN_FLAT);
	$rewrite     = "false";
	// load content of the log you choosed
	if(isset($list) AND file_exists("include/blacklists/$list.php")) {
		$rewrite = $list;
		$content = get_file("include/blacklists/$list.php");
	}
	// list news waiting for acceptance
	$lists_array = array();
	$lists_dir = opendir("include/blacklists");
	while($lists_file=readdir($lists_dir)) {
		if($lists_file!="." AND $lists_file!="..") {
			array_push($lists_array, str_replace(".php","",$lists_file));
		}
	} //echo "<pre>";print_r($lists_array);echo "</pre>";	//-> TEST
	closedir($lists_dir);
	if(count($lists_array)==0) {
		echo "<b>"._NORESULT." !</b>";
		return;
	} else {
		sort($lists_array);
	}
	?><select style="max-width:100%" onchange="javascript:completeAHAH.ahah('<?=get_fn_dir("sections")?>/<?=$mod?>/section.php?mod=<?=$mod?>&amp;op=fnccblacklists&amp;list='+this.options[this.selectedIndex].value,'fn_adminpanel','0','get');"><?
		echo "\n<option value=\"\">---  "._FNCC_MANAGEBLACKLISTS."  ---</option>\n";
		for($i=0;$i<count($lists_array);$i++) {
			echo "<option value=\"$lists_array[$i]\"";
			if($lists_array[$i]==$list) echo "selected=\"selected\"";
			echo ">$lists_array[$i]</option>\n";
		}
	?></select><?
	// print html form (only if you chose a blacklist)
	if(trim($list)=="") {
		return;
	}
	?><br /><br /><?
	echo build_ahah_link($mod, "", "fn_adminpanel", "post", "form_modblacklist");
	echo "<textarea name='conf_body' rows='20' style='width:100%;' wrap='off'>";
	echo $content;
	echo "</textarea>\n<br /><br />";
	// check writing permissions
	if(is_writeable("include/blacklists/$list.php"))	{
		?><div align="center" style="font-weight:bold;">
			<?=_FNCC_WARNINGDOC?><br /><br />
			<input type="hidden" name="conf_mod" value="modblacklist" />
			<input type="hidden" name="conf_file" value="include/blacklists/<?=$list?>.php" />
			<input type="submit" value="<?=_MODIFICA?>" />
		</div><?
	} else { 
		?><div align="center" style="font-weight:bold;font-color:red;">
			<?=_FNCC_WARNINGRIGHTS?>
		</div><? 
	}
	?></form><?
}

?>