<?php
/************************************************************************/
/* FlatNuke - Flat Text Based Content Management System                 */
/* ============================================                         */
/*                                                                      */
/* Copyright (c) 2003-2004 by Simone Vellei                             */
/* http://flatnuke.sourceforge.net                                      */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

/* if there aren't a registered user go to setup */
/*if(file_exists("setup.php")) {
	
	$mod   = $_GET['mod'];

	if(strcmp($mod, "none_Login") == 0) 
		{}
	else 
		if(file_exists("misc/firstinstall")) 
			header("Location: setup.php");
}*/

// include Flatnuke APIs
include_once "functions.php";
include "header.php";

// check if IP address is blacklisted
$ip = strip_tags(getparam("REMOTE_ADDR", PAR_SERVER, SAN_NULL));
if (is_blocked_ip($ip)){
	fnlog("Security", "$ip||Access denied to IP address $ip.");
	// have fun ;)
	header("Location: http://www.spam.com/");
	exit;
}

// deny remote cross access to this file in case of comments or login/administration access
$mod    = getparam("mod",PAR_GET,SAN_FLAT);
$action = getparam("action",PAR_GET,SAN_FLAT);
if( $mod!="" AND ($mod=='comment' OR ($mod=='none_Login' AND $action!='activateuser') OR $mod=='none_Admin') ){
	if( !eregi( $_SERVER['HTTP_HOST'],$_SERVER['HTTP_REFERER'] ) ){
		if ($mod == 'comment') {
			$mod = 'read';
		} else {
			//fnlog("Security", "$ip||Blocked unauthorized remote access to index.php. URL=".$_SERVER['HTTP_REFERER']);	// uncomment if interested on lamers' access
			header("Location: index.php");
			exit;
		}
	}
}

// if no active session we start a new one
if (session_id() == "") session_start();
$_SESSION['fn_session'] = session_id();

// security option
$req = getparam("REQUEST_URI", PAR_SERVER, SAN_FLAT);
if(strstr($req,"myforum=")) {
	header("Location: index.php");
	exit;
}

// first microtime to calculate time generation page
$time1 = get_microtime();

//AUTOBUILD -->
// prevent annoying newbies still using that fuckin' Winzip(C) ...
$list_empty_dirs = array("news");
foreach($list_empty_dirs as $empty_dir) {
	if(!file_exists($empty_dir)) {
		if(mkdir($empty_dir, 0777)) {
			fnlog("Homepage", "$ip||".get_username()."||Directory $empty_dir created.");
		} else {
			fnlog("Homepage", "$ip||".get_username()."||Directory $empty_dir cannot be created, check write permissions.");
		}
	}
}
// create some system files on-the-fly
$list_new_files = array("misc/motd.php");
foreach($list_new_files as $new_file) {
	if(!file_exists($new_file)) {
		fnwrite($new_file, _MOTDMESS, "w+", array("nonull"));
	}
}
//<-- AUTOBUID

// STATISTICS -->
$from = getparam("HTTP_REFERER", PAR_SERVER, SAN_FLAT);
$host = getparam("HTTP_HOST", PAR_SERVER, SAN_FLAT);
$self = getparam("PHP_SELF", PAR_SERVER, SAN_FLAT);
$where= "http://".$host.$self;
$where = str_replace(basename($where),"",$where);
$url=str_replace("http://","",$where);
$url=str_replace("www.","",$url);
$from=str_replace("http://","",$from);
$from=str_replace("www.","",$from);
if (file_exists("sections/none_Statistiche/stat.php") AND !stristr($from,$url)) {
	include "sections/none_Statistiche/stat.php";
	stats();
}
// <-- STATISTICS

// MAINTENANCE --> _MAINT  _MAINT_MSG
if ($maintenance == "1") {
	if(!is_admin()) {
		?><div align="center" style="padding:2em;">
			<div style="background-color:#F0F0F0;max-width:250px;padding:10px;border:1px solid #999999;">
			<img alt="Flatnuke CMS login" src="images/maintenance.png" /><br />
			<br />
			<span style="color:#CC0000;">
				<b><?= _MAINT ?></b><br />
				<?= _MAINT_MSG ?>
			</span><br /><br />
			<form action="sections/none_Login/section.php" method="post">
			<input type="hidden" name="action" value="login" />
			<label for="username" style="font-size:20px;"><?= _NOMEUTENTE ?>:</label><br />
			<input alt="username" name="nome" size="15" id="username" style="border:0.5px solid #333333;font-size:20px;" /><br />
			<label for="password" style="font-size:20px;"><?= _PASSWORD ?></label>:<br />
			<input alt="password" name="logpassword" type="password" size="15" id="password" style="border:0.5px solid #333333;font-size:20px;" /><br />
			<br />
			<input type="submit" value="<?= _LOGIN ?>" style="border:0.5px solid #333333;font-size:16px;font-weight:bold;" />
			</form>
			</div>
		</div><?
		if(defined('_THEME_VER')) {
			if(_THEME_VER > 0) {
			} 
		}
		else {
			include_once "footer.php";
		}
		exit();
	} else {
		echo "<div style='padding:1em;color:red;background-color:yellow;border:3px solid red;text-align:center;font-weight:bold;font-size:larger;'>"._MAINT."</div>";
	}
}
// <-- MAINTENANCE

function getflopt(){
	global $home_section, $theme;

	$op   = get_mod();
	$file = stripslashes(getparam("file",PAR_GET,SAN_FLAT));
	$id   = getparam("id",PAR_GET,SAN_FLAT);
	$fnaction = getparam("fnaction",PAR_POST,SAN_FLAT);
	$sect     = getparam("sect",PAR_GET,SAN_FLAT);
	$fnfile   = getparam("fnfile",PAR_GET,SAN_FLAT);
	$fneditor = getparam("fneditor",PAR_GET,SAN_FLAT);
	
	// check option to execute
	switch($op){
		// no option given: homepage
		case "":
			if ($fnaction !="") continue;
			// print motd content if exists
			if(file_exists("misc/motd.php") AND trim(get_file("misc/motd.php"))!="") {
				OpenTable();
				echo "<div class=\"motd\">";
				// print motd image if exists
				if(file_exists("themes/$theme/images/motd.png")) {
					echo "<img src='themes/$theme/images/motd.png' align='left' hspace='10' vspace='10' alt='Motd' />";
				} else echo "<!-- MOTD image \"themes/$theme/images/motd.png\" not found -->";
				include ("misc/motd.php");
				echo "</div>";
				CloseTable();
			}
			if(($home_section == "") or !isset($home_section))
				create_news();		// display news as default
			else
				view_section($home_section);	// display section in homepage
		break;
		// read details of a news
		case "read":
			read_news($id);
		break;
		// publish a news
		case "news":
			if(is_admin())
				insert_news();
			else {
				OpenTable();
				print("<div align='center'><b>"._NOLEVELSECT."</b></div>");
				CloseTable();
				return;
			}
		break;
		// modify a file
		case "modcont":
			if(is_admin())
				edit_content($file,$fneditor);
			else {
				OpenTable();
				print("<div align='center'><b>"._NOLEVELSECT."</b></div>");
				CloseTable();
				return;
			}
		break;
		// insert a comment to a news
		case "comment":
			insert_comment($id);
		break;
		case "fnrenamesectinterface":
			rename_sect_interface($sect);
		break;
		case "fnnewsectinterface":
			create_sect_interface($sect);
		break;
		case "fnnewfileinterface":
			create_file_interface($sect);
		break;
		case "fndeletesectinterface":
			delete_sect_interface($sect);
		break;
		case "fnmovesectinterface":
			move_sect_interface($sect);
		break;
		case "fnmovefileinterface":
			fn_move_file_interface($fnfile);
		break;
		case "fndeletefileinterface":
			delete_file_interface($fnfile);
		break;
		case "fnrenamefileinterface":
			rename_file_interface($fnfile);
		break;
		case "usermodcont":
			user_edit_content($file,$fneditor);
		break;
		case "fnchoosesecttypeinterface":
			choose_sect_type_interface($sect);
		break;
		// view a section
		default:
			if (trim($fnaction=="")) view_section($op);
		break;
	}
	
	switch($fnaction){
		// manage sections
		case "fnrenamesect"    : rename_section();      break;
		case "fnmovesect"      : move_section();        break;
		case "fncreatesect"    : create_section();      break;
		case "fndeletesect"    : delete_section();      break;
		case "fnchangesecttype": change_section_type(); break;
		// manage files
		case "fncreatefile": create_file();    break;
		case "fndeletefile": delete_file();    break;
		case "fnrenamefile": fn_rename_file(); break;
		case "fnmovefile"  : fn_move_file();   break;
		// manage permissions
		case "fnaddusersectperm"           : fn_add_user_view_perm();    break;
		case "fnremoveusersectperm"        : fn_remove_user_view_perm(); break;
		case "fnaddusereditsectpermconfirm": fn_add_edit_perm_confirm(); break;
		case "fnaddusereditsectperm"       : fn_add_user_edit_perm();    break;
		case "fnremoveusereditsectperm"    : fn_remove_user_edit_perm(); break;
	}

}

include_once "themes/$theme/theme.php";
include "themes/$theme/structure.php";

if(defined('_THEME_VER')) {
	if(_THEME_VER > 0) {
	}
} else {
	include_once "footer.php";
}

?>
