/***************************************************************************
                          segmenttip.h  -  description
                             -------------------
    begin                : Sat Jul 12 2003
    copyright            : (C) 2003 by Max Howell
    email                : max.howell@methylblue.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SEGMENTTIP_H
#define SEGMENTTIP_H

#include <qwidget.h>
#include <qpixmap.h>

#include "define.h" //UnitPrefix



class File;
class Directory;
class QPoint;
class QTimer;
class QString;

class SegmentTip : public QWidget
{
  Q_OBJECT
  
  public: 
    SegmentTip( unsigned int );
    virtual ~SegmentTip();

    void updateTip( const File *, const Directory * );
    void moveto( QPoint, const QWidget&, bool );

  protected:
    virtual bool eventFilter( QObject *, QEvent * );
    virtual void showEvent( QShowEvent * );
    virtual void hideEvent( QHideEvent * );

  private:
    unsigned int m_cursorHeight;
    QPixmap m_pixmap;
    QString m_text;
    QTimer *m_timer;    
};

#endif
