# FIAIF is an Intelligent firewall, version: $Revision: 1.14 $
#
# description: Automates a packet filtering firewall with iptables.
#
# Script Author: Anders Fugmann <afu at fugmann dot net>
# 
# FIAIF is an Intelligent firewall
# Copyright (C) 2002-2004 Anders Peter Fugmann
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

###############################################################################
# Filter out illegal packets. 
# Parameters: <queue> <table>
###############################################################################
function add_sanity_check()
{
    local TABLE=$1
    local QUEUE=$2

    IPTABLES -t ${TABLE} -A ${QUEUE} -m state --state INVALID -j LOG_INVALID

    IPTABLES -t ${TABLE} -A ${QUEUE} -p tcp --tcp-flags ALL ACK -m state --state ESTABLISHED -j RETURN
    IPTABLES -t ${TABLE} -A ${QUEUE} -p tcp --tcp-flags ALL ACK -m state --state NEW,RELATED -j LOG_SCAN
    IPTABLES -t ${TABLE} -A ${QUEUE} -p tcp --tcp-flags ALL SYN -m state --state NEW -j RETURN
    IPTABLES -t ${TABLE} -A ${QUEUE} -p tcp --tcp-flags ALL SYN -m state --state RELATED -j RETURN
    IPTABLES -t ${TABLE} -A ${QUEUE} -p tcp --tcp-flags ALL PSH,ACK -m state --state ESTABLISHED -j RETURN
    IPTABLES -t ${TABLE} -A ${QUEUE} -p tcp --tcp-flags ALL PSH,ACK -m state --state NEW -j RETURN
    IPTABLES -t ${TABLE} -A ${QUEUE} -p tcp --tcp-flags ALL PSH,ACK -m state --state RELATED -j LOG_SCAN
    IPTABLES -t ${TABLE} -A ${QUEUE} -p tcp --tcp-flags ALL NONE -j LOG_SCAN
    IPTABLES -t ${TABLE} -A ${QUEUE} -p tcp --tcp-flags ALL ALL -j LOG_SCAN
    IPTABLES -t ${TABLE} -A ${QUEUE} -p tcp --tcp-flags SYN,FIN SYN,FIN -j LOG_SCAN
    IPTABLES -t ${TABLE} -A ${QUEUE} -p tcp --tcp-flags SYN,RST SYN,RST -j LOG_SCAN
    IPTABLES -t ${TABLE} -A ${QUEUE} -p tcp --tcp-flags RST,FIN RST,FIN -j LOG_SCAN
    IPTABLES -t ${TABLE} -A ${QUEUE} -p tcp --tcp-flags SYN,URG SYN,URG -j LOG_SCAN
    IPTABLES -t ${TABLE} -A ${QUEUE} -p tcp --tcp-flags ALL SYN,PSH -j LOG_SCAN
    IPTABLES -t ${TABLE} -A ${QUEUE} -p tcp --tcp-flags ALL SYN,ACK,PSH -j LOG_SCAN
    IPTABLES -t ${TABLE} -A ${QUEUE} -p tcp --tcp-flags ACK,FIN FIN -j LOG_SCAN
    IPTABLES -t ${TABLE} -A ${QUEUE} -p tcp --tcp-flags ACK,PSH PSH -j LOG_SCAN
    IPTABLES -t ${TABLE} -A ${QUEUE} -p tcp --tcp-flags ACK,URG URG -j LOG_SCAN
    IPTABLES -t ${TABLE} -A ${QUEUE} -p tcp --tcp-flags ALL RST -m state --state ESTABLISHED -j RETURN
    IPTABLES -t ${TABLE} -A ${QUEUE} -p tcp --tcp-flags ALL RST -m state --state NEW,RELATED -j LOG_SCAN
    IPTABLES -t ${TABLE} -A ${QUEUE} -p tcp --tcp-flags SYN,ACK NONE -j LOG_SCAN
    IPTABLES -t ${TABLE} -A ${QUEUE} -p tcp --tcp-flags ALL SYN -m state --state NEW -j RETURN
    IPTABLES -t ${TABLE} -A ${QUEUE} -p tcp --tcp-flags ALL SYN -m state --state RELATED -j RETURN
    ## This seems to conservative....
    # IPTABLES -t ${TABLE} -A ${QUEUE} -p tcp --tcp-flags ALL SYN -m state --state ESTABLISHED -j LOG_SCAN
    IPTABLES -t ${TABLE} -A ${QUEUE} -p tcp --tcp-flags ALL SYN,ACK -m state --state ESTABLISHED -j RETURN
    IPTABLES -t ${TABLE} -A ${QUEUE} -p tcp --tcp-flags ALL SYN,ACK -m state --state NEW,RELATED -j LOG_SCAN
    IPTABLES -t ${TABLE} -A ${QUEUE} -p tcp --tcp-flags ALL FIN,ACK -m state --state ESTABLISHED -j RETURN
    IPTABLES -t ${TABLE} -A ${QUEUE} -p tcp --tcp-flags ALL FIN,ACK -m state --state NEW,RELATED -j LOG_SCAN_NOLOG
    IPTABLES -t ${TABLE} -A ${QUEUE} -p tcp --tcp-flags ALL RST,ACK -m state --state ESTABLISHED -j RETURN
    IPTABLES -t ${TABLE} -A ${QUEUE} -p tcp --tcp-flags ALL RST,ACK -m state --state NEW -j RETURN
    IPTABLES -t ${TABLE} -A ${QUEUE} -p tcp --tcp-flags ALL RST,ACK -m state --state RELATED -j LOG_SCAN
    IPTABLES -t ${TABLE} -A ${QUEUE} -p tcp --tcp-flags ALL ACK,PSH,RST -m state --state ESTABLISHED -j RETURN
    IPTABLES -t ${TABLE} -A ${QUEUE} -p tcp --tcp-flags ALL ACK,PSH,RST -m state --state NEW,RELATED -j LOG_SCAN
    IPTABLES -t ${TABLE} -A ${QUEUE} -p tcp --tcp-flags ALL FIN,PSH,ACK -m state --state ESTABLISHED -j RETURN
    IPTABLES -t ${TABLE} -A ${QUEUE} -p tcp --tcp-flags ALL FIN,PSH,ACK -m state --state NEW,RELATED -j LOG_SCAN

    #IPTABLES -t ${TABLE} -A ${QUEUE} -p tcp --tcp-flags ALL RST,ACK,PSH -j LOG_SCAN 
    #IPTABLES -t ${TABLE} -A ${QUEUE} -p tcp --tcp-flags ALL RST,ACK,URG -j LOG_SCAN
    #IPTABLES -t ${TABLE} -A ${QUEUE} -p tcp --tcp-flags ALL RST,ACK,PSH,URG -j LOG_SCAN
    #IPTABLES -t ${TABLE} -A ${QUEUE} -p tcp --tcp-flags ALL FIN,PSH,ACK,URG -j LOG_SCAN
    #IPTABLES -t ${TABLE} -A ${QUEUE} -p tcp --tcp-flags ALL ACK,URG -j LOG_SCAN
    #IPTABLES -t ${TABLE} -A ${QUEUE} -p tcp --tcp-flags ALL ACK,URG,FIN -j LOG_SCAN 

    ### ICMP TESTS
    IPTABLES -t ${TABLE} -A ${QUEUE} -p icmp --fragment -j LOG_DROP
    IPTABLES -t ${TABLE} -A ${QUEUE} -p icmp --icmp-type address-mask-request -j LOG_DROP
    IPTABLES -t ${TABLE} -A ${QUEUE} -p icmp --icmp-type address-mask-reply -j LOG_DROP
    IPTABLES -t ${TABLE} -A ${QUEUE} -p icmp --icmp-type timestamp-request -j LOG_DROP
    IPTABLES -t ${TABLE} -A ${QUEUE} -p icmp --icmp-type timestamp-reply -j LOG_DROP
    IPTABLES -t ${TABLE} -A ${QUEUE} -p icmp --icmp-type redirect -j LOG_DROP
}
