// This code conforms with the UFC specification version 2.0.0
// and was automatically generated by FFC version 0.9.9.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: True
//   cpp_optimize:                   False
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'ufc'
//   log_level:                      10
//   log_prefix:                     ''
//   optimize:                       False
//   output_dir:                     '.'
//   precision:                      '8'
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   split:                          False

#ifndef __HYPERELASTICITY_H
#define __HYPERELASTICITY_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class hyperelasticity_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  hyperelasticity_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~hyperelasticity_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Discontinuous Lagrange', Cell('tetrahedron', 1, Space(3)), 0)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::tetrahedron;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 3;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 1;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    
    // Compute Jacobian of affine map from reference cell
    
    // Compute sub determinants
    
    // Compute determinant of Jacobian
    
    // Compute inverse of Jacobian
    
    // Compute constants
    
    // Get coordinates and map to the reference (FIAT) element
    
    
    // Reset values.
    *values = 0.00000000;
    
    // Array of basisvalues.
    double basisvalues[1] = {0.00000000};
    
    // Declare helper variables.
    
    // Compute basisvalues.
    basisvalues[0] = 1.00000000;
    
    // Table(s) of coefficients.
    static const double coefficients0[1] = \
    {1.00000000};
    
    // Compute value(s).
    for (unsigned int r = 0; r < 1; r++)
    {
      *values += coefficients0[r]*basisvalues[r];
    }// end loop over 'r'
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Element is constant, calling evaluate_basis.
    evaluate_basis(0, values, coordinates, c);
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    
    // Compute constants
    
    // Get coordinates and map to the reference (FIAT) element
    
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K_00, K_01, K_02}, {K_10, K_11, K_12}, {K_20, K_21, K_22}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.00000000;
    }// end loop over 'r'
    
    
    // Array of basisvalues.
    double basisvalues[1] = {0.00000000};
    
    // Declare helper variables.
    
    // Compute basisvalues.
    basisvalues[0] = 1.00000000;
    
    // Table(s) of coefficients.
    static const double coefficients0[1] = \
    {1.00000000};
    
    // Tables of derivatives of the polynomial base (transpose).
    static const double dmats0[1][1] = \
    {{0.00000000}};
    
    static const double dmats1[1][1] = \
    {{0.00000000}};
    
    static const double dmats2[1][1] = \
    {{0.00000000}};
    
    // Compute reference derivatives.
    // Declare pointer to array of derivatives on FIAT element.
    double *derivatives = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      derivatives[r] = 0.00000000;
    }// end loop over 'r'
    
    // Declare derivative matrix (of polynomial basis).
    double dmats[1][1] = \
    {{1.00000000}};
    
    // Declare (auxiliary) derivative matrix (of polynomial basis).
    double dmats_old[1][1] = \
    {{1.00000000}};
    
    // Loop possible derivatives.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      // Resetting dmats values to compute next derivative.
      for (unsigned int t = 0; t < 1; t++)
      {
        for (unsigned int u = 0; u < 1; u++)
        {
          dmats[t][u] = 0.00000000;
          if (t == u)
          {
          dmats[t][u] = 1.00000000;
          }
          
        }// end loop over 'u'
      }// end loop over 't'
      
      // Looping derivative order to generate dmats.
      for (unsigned int s = 0; s < n; s++)
      {
        // Updating dmats_old with new values and resetting dmats.
        for (unsigned int t = 0; t < 1; t++)
        {
          for (unsigned int u = 0; u < 1; u++)
          {
            dmats_old[t][u] = dmats[t][u];
            dmats[t][u] = 0.00000000;
          }// end loop over 'u'
        }// end loop over 't'
        
        // Update dmats using an inner product.
        if (combinations[r][s] == 0)
        {
        for (unsigned int t = 0; t < 1; t++)
        {
          for (unsigned int u = 0; u < 1; u++)
          {
            for (unsigned int tu = 0; tu < 1; tu++)
            {
              dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
        if (combinations[r][s] == 1)
        {
        for (unsigned int t = 0; t < 1; t++)
        {
          for (unsigned int u = 0; u < 1; u++)
          {
            for (unsigned int tu = 0; tu < 1; tu++)
            {
              dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
        if (combinations[r][s] == 2)
        {
        for (unsigned int t = 0; t < 1; t++)
        {
          for (unsigned int u = 0; u < 1; u++)
          {
            for (unsigned int tu = 0; tu < 1; tu++)
            {
              dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
      }// end loop over 's'
      for (unsigned int s = 0; s < 1; s++)
      {
        for (unsigned int t = 0; t < 1; t++)
        {
          derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
        }// end loop over 't'
      }// end loop over 's'
    }// end loop over 'r'
    
    // Transform derivatives back to physical element
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r] += transform[r][s]*derivatives[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer to array of derivatives on FIAT element
    delete [] derivatives;
    
    // Delete pointer to array of combinations of derivatives and transform
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      delete [] combinations[r];
    }// end loop over 'r'
    delete [] combinations;
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      delete [] transform[r];
    }// end loop over 'r'
    delete [] transform;
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Element is constant, calling evaluate_basis_derivatives.
    evaluate_basis_derivatives(0, n, values, coordinates, c);
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[3];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = 0.25000000*x[0][0] + 0.25000000*x[1][0] + 0.25000000*x[2][0] + 0.25000000*x[3][0];
      y[1] = 0.25000000*x[0][1] + 0.25000000*x[1][1] + 0.25000000*x[2][1] + 0.25000000*x[3][1];
      y[2] = 0.25000000*x[0][2] + 0.25000000*x[1][2] + 0.25000000*x[2][2] + 0.25000000*x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.00000000;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[3];
    const double * const * x = c.coordinates;
    y[0] = 0.25000000*x[0][0] + 0.25000000*x[1][0] + 0.25000000*x[2][0] + 0.25000000*x[3][0];
    y[1] = 0.25000000*x[0][1] + 0.25000000*x[1][1] + 0.25000000*x[2][1] + 0.25000000*x[3][1];
    y[2] = 0.25000000*x[0][2] + 0.25000000*x[1][2] + 0.25000000*x[2][2] + 0.25000000*x[3][2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[0];
    vertex_values[2] = dof_values[0];
    vertex_values[3] = dof_values[0];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c)
  {
    std::cerr << "*** FFC warning: " << "map_from_reference_cell not yet implemented (introduced in UFC 2.0)." << std::endl;
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c)
  {
    std::cerr << "*** FFC warning: " << "map_to_reference_cell not yet implemented (introduced in UFC 2.0)." << std::endl;
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new hyperelasticity_finite_element_0();
  }

};

/// This class defines the interface for a finite element.

class hyperelasticity_finite_element_1: public ufc::finite_element
{
public:

  /// Constructor
  hyperelasticity_finite_element_1() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~hyperelasticity_finite_element_1()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::tetrahedron;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 3;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 4;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Reset values.
    *values = 0.00000000;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.28867513, -0.18257419, -0.10540926, -0.07453560};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.28867513, 0.18257419, -0.10540926, -0.07453560};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.28867513, 0.00000000, 0.21081851, -0.07453560};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.28867513, 0.00000000, 0.00000000, 0.22360680};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.00000000;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 4; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K_00, K_01, K_02}, {K_10, K_11, K_12}, {K_20, K_21, K_22}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.00000000;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.28867513, -0.18257419, -0.10540926, -0.07453560};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.28867513, 0.18257419, -0.10540926, -0.07453560};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.28867513, 0.00000000, 0.21081851, -0.07453560};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.28867513, 0.00000000, 0.00000000, 0.22360680};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.00000000;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 4; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[3];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      y[2] = x[0][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      y[2] = x[1][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      y[2] = x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = x[3][0];
      y[1] = x[3][1];
      y[2] = x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.00000000;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[1];
    
    // Declare variable for physical coordinates.
    double y[3];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    y[2] = x[0][2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    y[2] = x[1][2];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    y[2] = x[2][2];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = x[3][0];
    y[1] = x[3][1];
    y[2] = x[3][2];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
    vertex_values[3] = dof_values[3];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c)
  {
    std::cerr << "*** FFC warning: " << "map_from_reference_cell not yet implemented (introduced in UFC 2.0)." << std::endl;
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c)
  {
    std::cerr << "*** FFC warning: " << "map_to_reference_cell not yet implemented (introduced in UFC 2.0)." << std::endl;
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new hyperelasticity_finite_element_1();
  }

};

/// This class defines the interface for a finite element.

class hyperelasticity_finite_element_2: public ufc::finite_element
{
public:

  /// Constructor
  hyperelasticity_finite_element_2() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~hyperelasticity_finite_element_2()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::tetrahedron;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 3;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 12;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 1;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return 3;
        break;
      }
    }
    
    return 0;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Reset values.
    values[0] = 0.00000000;
    values[1] = 0.00000000;
    values[2] = 0.00000000;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.28867513, -0.18257419, -0.10540926, -0.07453560};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.28867513, 0.18257419, -0.10540926, -0.07453560};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.28867513, 0.00000000, 0.21081851, -0.07453560};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.28867513, 0.00000000, 0.00000000, 0.22360680};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.28867513, -0.18257419, -0.10540926, -0.07453560};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.28867513, 0.18257419, -0.10540926, -0.07453560};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.28867513, 0.00000000, 0.21081851, -0.07453560};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.28867513, 0.00000000, 0.00000000, 0.22360680};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.28867513, -0.18257419, -0.10540926, -0.07453560};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.28867513, 0.18257419, -0.10540926, -0.07453560};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.28867513, 0.00000000, 0.21081851, -0.07453560};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.28867513, 0.00000000, 0.00000000, 0.22360680};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 4; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values[3] = {0.00000000, 0.00000000, 0.00000000};
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 12; r++)
    {
      evaluate_basis(r, dof_values, coordinates, c);
      for (unsigned int s = 0; s < 3; s++)
      {
        values[r*3 + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K_00, K_01, K_02}, {K_10, K_11, K_12}, {K_20, K_21, K_22}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < 3*num_derivatives; r++)
    {
      values[r] = 0.00000000;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.28867513, -0.18257419, -0.10540926, -0.07453560};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.28867513, 0.18257419, -0.10540926, -0.07453560};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.28867513, 0.00000000, 0.21081851, -0.07453560};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.28867513, 0.00000000, 0.00000000, 0.22360680};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.28867513, -0.18257419, -0.10540926, -0.07453560};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.28867513, 0.18257419, -0.10540926, -0.07453560};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.28867513, 0.00000000, 0.21081851, -0.07453560};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.28867513, 0.00000000, 0.00000000, 0.22360680};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.28867513, -0.18257419, -0.10540926, -0.07453560};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.28867513, 0.18257419, -0.10540926, -0.07453560};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.28867513, 0.00000000, 0.21081851, -0.07453560};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[4] = {0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 0; r < 1; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 1; r++)
      {
        for (unsigned int s = 0; s < 1 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 2; r++)
      {
        for (unsigned int s = 0; s < 2 - r; s++)
        {
          for (unsigned int t = 0; t < 2 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[4] = \
      {0.28867513, 0.00000000, 0.00000000, 0.22360680};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[4][4] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point in cell
  virtual void evaluate_basis_derivatives_all(unsigned int n,
                                              double* values,
                                              const double* coordinates,
                                              const ufc::cell& c) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[3*num_derivatives];
    for (unsigned int r = 0; r < 3*num_derivatives; r++)
    {
      dof_values[r] = 0.00000000;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 12; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, coordinates, c);
      for (unsigned int s = 0; s < 3*num_derivatives; s++)
      {
        values[r*3*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(unsigned int i,
                              const ufc::function& f,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[3];
    
    // Declare variable for physical coordinates.
    double y[3];
    const double * const * x = c.coordinates;
    switch (i)
    {
    case 0:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      y[2] = x[0][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      y[2] = x[1][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      y[2] = x[2][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = x[3][0];
      y[1] = x[3][1];
      y[2] = x[3][2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      y[2] = x[0][2];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 5:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      y[2] = x[1][2];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 6:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      y[2] = x[2][2];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 7:
      {
        y[0] = x[3][0];
      y[1] = x[3][1];
      y[2] = x[3][2];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 8:
      {
        y[0] = x[0][0];
      y[1] = x[0][1];
      y[2] = x[0][2];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 9:
      {
        y[0] = x[1][0];
      y[1] = x[1][1];
      y[2] = x[1][2];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 10:
      {
        y[0] = x[2][0];
      y[1] = x[2][1];
      y[2] = x[2][2];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 11:
      {
        y[0] = x[3][0];
      y[1] = x[3][1];
      y[2] = x[3][2];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    }
    
    return 0.00000000;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation.
    double vals[3];
    
    // Declare variable for physical coordinates.
    double y[3];
    const double * const * x = c.coordinates;
    y[0] = x[0][0];
    y[1] = x[0][1];
    y[2] = x[0][2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = x[1][0];
    y[1] = x[1][1];
    y[2] = x[1][2];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = x[2][0];
    y[1] = x[2][1];
    y[2] = x[2][2];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = x[3][0];
    y[1] = x[3][1];
    y[2] = x[3][2];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = x[0][0];
    y[1] = x[0][1];
    y[2] = x[0][2];
    f.evaluate(vals, y, c);
    values[4] = vals[1];
    y[0] = x[1][0];
    y[1] = x[1][1];
    y[2] = x[1][2];
    f.evaluate(vals, y, c);
    values[5] = vals[1];
    y[0] = x[2][0];
    y[1] = x[2][1];
    y[2] = x[2][2];
    f.evaluate(vals, y, c);
    values[6] = vals[1];
    y[0] = x[3][0];
    y[1] = x[3][1];
    y[2] = x[3][2];
    f.evaluate(vals, y, c);
    values[7] = vals[1];
    y[0] = x[0][0];
    y[1] = x[0][1];
    y[2] = x[0][2];
    f.evaluate(vals, y, c);
    values[8] = vals[2];
    y[0] = x[1][0];
    y[1] = x[1][1];
    y[2] = x[1][2];
    f.evaluate(vals, y, c);
    values[9] = vals[2];
    y[0] = x[2][0];
    y[1] = x[2][1];
    y[2] = x[2][2];
    f.evaluate(vals, y, c);
    values[10] = vals[2];
    y[0] = x[3][0];
    y[1] = x[3][1];
    y[2] = x[3][2];
    f.evaluate(vals, y, c);
    values[11] = vals[2];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[3] = dof_values[1];
    vertex_values[6] = dof_values[2];
    vertex_values[9] = dof_values[3];
    // Evaluate function and change variables
    vertex_values[1] = dof_values[4];
    vertex_values[4] = dof_values[5];
    vertex_values[7] = dof_values[6];
    vertex_values[10] = dof_values[7];
    // Evaluate function and change variables
    vertex_values[2] = dof_values[8];
    vertex_values[5] = dof_values[9];
    vertex_values[8] = dof_values[10];
    vertex_values[11] = dof_values[11];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c)
  {
    std::cerr << "*** FFC warning: " << "map_from_reference_cell not yet implemented (introduced in UFC 2.0)." << std::endl;
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c)
  {
    std::cerr << "*** FFC warning: " << "map_to_reference_cell not yet implemented (introduced in UFC 2.0)." << std::endl;
  }

  /// Return the number of sub elements (for a mixed element)
  virtual unsigned int num_sub_elements() const
  {
    return 3;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_finite_element_1();
        break;
      }
    case 1:
      {
        return new hyperelasticity_finite_element_1();
        break;
      }
    case 2:
      {
        return new hyperelasticity_finite_element_1();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new hyperelasticity_finite_element_2();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class hyperelasticity_dofmap_0: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  hyperelasticity_dofmap_0() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~hyperelasticity_dofmap_0()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Discontinuous Lagrange', Cell('tetrahedron', 1, Space(3)), 0)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return false;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return true;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[3];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 3;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 1;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 1;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 0;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 0;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 1;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    dofs[0] = c.entity_indices[3][0];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 3)
    {
    std::cerr << "*** FFC warning: " << "d is larger than dimension (3)" << std::endl;
    }
    
    switch (d)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        if (i > 0)
      {
      std::cerr << "*** FFC warning: " << "i is larger than number of entities (0)" << std::endl;
      }
      
      dofs[0] = 0;
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = 0.25000000*x[0][0] + 0.25000000*x[1][0] + 0.25000000*x[2][0] + 0.25000000*x[3][0];
    coordinates[0][1] = 0.25000000*x[0][1] + 0.25000000*x[1][1] + 0.25000000*x[2][1] + 0.25000000*x[3][1];
    coordinates[0][2] = 0.25000000*x[0][2] + 0.25000000*x[1][2] + 0.25000000*x[2][2] + 0.25000000*x[3][2];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new hyperelasticity_dofmap_0();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class hyperelasticity_dofmap_1: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  hyperelasticity_dofmap_1() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~hyperelasticity_dofmap_1()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = m.num_entities[0];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 3;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 4;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 4;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 3;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    dofs[0] = c.entity_indices[0][0];
    dofs[1] = c.entity_indices[0][1];
    dofs[2] = c.entity_indices[0][2];
    dofs[3] = c.entity_indices[0][3];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
        break;
      }
    case 3:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 3)
    {
    std::cerr << "*** FFC warning: " << "d is larger than dimension (3)" << std::endl;
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      std::cerr << "*** FFC warning: " << "i is larger than number of entities (3)" << std::endl;
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[0][2] = x[0][2];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[1][2] = x[1][2];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[2][2] = x[2][2];
    coordinates[3][0] = x[3][0];
    coordinates[3][1] = x[3][1];
    coordinates[3][2] = x[3][2];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new hyperelasticity_dofmap_1();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class hyperelasticity_dofmap_2: public ufc::dofmap
{
private:

  unsigned int _global_dimension;
public:

  /// Constructor
  hyperelasticity_dofmap_2() : ufc::dofmap()
  {
    _global_dimension = 0;
  }

  /// Destructor
  virtual ~hyperelasticity_dofmap_2()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Initialize dofmap for mesh (return true iff init_cell() is needed)
  virtual bool init_mesh(const ufc::mesh& m)
  {
    _global_dimension = 3.00000000*m.num_entities[0];
    return false;
  }

  /// Initialize dofmap for given cell
  virtual void init_cell(const ufc::mesh& m,
                         const ufc::cell& c)
  {
    // Do nothing
  }

  /// Finish initialization of dofmap for cells
  virtual void init_cell_finalize()
  {
    // Do nothing
  }

  /// Return the topological dimension of the associated cell shape
  virtual unsigned int topological_dimension() const
  {
    return 3;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the global finite element function space
  virtual unsigned int global_dimension() const
  {
    return _global_dimension;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual unsigned int local_dimension(const ufc::cell& c) const
  {
    return 12;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual unsigned int max_local_dimension() const
  {
    return 12;
  }

  /// Return the number of dofs on each cell facet
  virtual unsigned int num_facet_dofs() const
  {
    return 9;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual unsigned int num_entity_dofs(unsigned int d) const
  {
    switch (d)
    {
    case 0:
      {
        return 3;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(unsigned int* dofs,
                             const ufc::mesh& m,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    dofs[3] = offset + c.entity_indices[0][3];
    offset += m.num_entities[0];
    dofs[4] = offset + c.entity_indices[0][0];
    dofs[5] = offset + c.entity_indices[0][1];
    dofs[6] = offset + c.entity_indices[0][2];
    dofs[7] = offset + c.entity_indices[0][3];
    offset += m.num_entities[0];
    dofs[8] = offset + c.entity_indices[0][0];
    dofs[9] = offset + c.entity_indices[0][1];
    dofs[10] = offset + c.entity_indices[0][2];
    dofs[11] = offset + c.entity_indices[0][3];
    offset += m.num_entities[0];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(unsigned int* dofs,
                                   unsigned int facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 5;
      dofs[4] = 6;
      dofs[5] = 7;
      dofs[6] = 9;
      dofs[7] = 10;
      dofs[8] = 11;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 6;
      dofs[5] = 7;
      dofs[6] = 8;
      dofs[7] = 10;
      dofs[8] = 11;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 7;
      dofs[6] = 8;
      dofs[7] = 9;
      dofs[8] = 11;
        break;
      }
    case 3:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 6;
      dofs[6] = 8;
      dofs[7] = 9;
      dofs[8] = 10;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(unsigned int* dofs,
                                    unsigned int d, unsigned int i) const
  {
    if (d > 3)
    {
    std::cerr << "*** FFC warning: " << "d is larger than dimension (3)" << std::endl;
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      std::cerr << "*** FFC warning: " << "i is larger than number of entities (3)" << std::endl;
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
        dofs[1] = 4;
        dofs[2] = 8;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
        dofs[1] = 5;
        dofs[2] = 9;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
        dofs[1] = 6;
        dofs[2] = 10;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
        dofs[1] = 7;
        dofs[2] = 11;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** coordinates,
                                    const ufc::cell& c) const
  {
    const double * const * x = c.coordinates;
    
    coordinates[0][0] = x[0][0];
    coordinates[0][1] = x[0][1];
    coordinates[0][2] = x[0][2];
    coordinates[1][0] = x[1][0];
    coordinates[1][1] = x[1][1];
    coordinates[1][2] = x[1][2];
    coordinates[2][0] = x[2][0];
    coordinates[2][1] = x[2][1];
    coordinates[2][2] = x[2][2];
    coordinates[3][0] = x[3][0];
    coordinates[3][1] = x[3][1];
    coordinates[3][2] = x[3][2];
    coordinates[4][0] = x[0][0];
    coordinates[4][1] = x[0][1];
    coordinates[4][2] = x[0][2];
    coordinates[5][0] = x[1][0];
    coordinates[5][1] = x[1][1];
    coordinates[5][2] = x[1][2];
    coordinates[6][0] = x[2][0];
    coordinates[6][1] = x[2][1];
    coordinates[6][2] = x[2][2];
    coordinates[7][0] = x[3][0];
    coordinates[7][1] = x[3][1];
    coordinates[7][2] = x[3][2];
    coordinates[8][0] = x[0][0];
    coordinates[8][1] = x[0][1];
    coordinates[8][2] = x[0][2];
    coordinates[9][0] = x[1][0];
    coordinates[9][1] = x[1][1];
    coordinates[9][2] = x[1][2];
    coordinates[10][0] = x[2][0];
    coordinates[10][1] = x[2][1];
    coordinates[10][2] = x[2][2];
    coordinates[11][0] = x[3][0];
    coordinates[11][1] = x[3][1];
    coordinates[11][2] = x[3][2];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual unsigned int num_sub_dofmaps() const
  {
    return 3;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_dofmap_1();
        break;
      }
    case 1:
      {
        return new hyperelasticity_dofmap_1();
        break;
      }
    case 2:
      {
        return new hyperelasticity_dofmap_1();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new hyperelasticity_dofmap_2();
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class hyperelasticity_cell_integral_0_0: public ufc::cell_integral
{
public:

  /// Constructor
  hyperelasticity_cell_integral_0_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~hyperelasticity_cell_integral_0_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Cell Volume.
    
    // Compute circumradius.
    
    
    // Array of quadrature weights.
    static const double W1 = 0.16666667;
    // Quadrature points on the UFC reference element: (0.25000000, 0.25000000, 0.25000000)
    
    // Value of basis functions at quadrature points.
    static const double FE1_C0_D001[1][12] = \
    {{-1.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
    
    static const double FE1_C0_D010[1][12] = \
    {{-1.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
    
    static const double FE1_C0_D100[1][12] = \
    {{-1.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
    
    static const double FE1_C1_D001[1][12] = \
    {{0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
    
    static const double FE1_C1_D010[1][12] = \
    {{0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
    
    static const double FE1_C1_D100[1][12] = \
    {{0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
    
    static const double FE1_C2_D001[1][12] = \
    {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 0.00000000, 1.00000000}};
    
    static const double FE1_C2_D010[1][12] = \
    {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 1.00000000, 0.00000000}};
    
    static const double FE1_C2_D100[1][12] = \
    {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 1.00000000, 0.00000000, 0.00000000}};
    
    // Reset values in the element tensor.
    for (unsigned int r = 0; r < 144; r++)
    {
      A[r] = 0.00000000;
    }// end loop over 'r'
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('eliminate zeros', False), ('ignore ones', False), ('ignore zero tables', False), ('optimisation', False), ('remove zero terms', False)
    
    // Loop quadrature points for integral.
    // Number of operations to compute element tensor for following IP loop = 802728
    // Only 1 integration point, omitting IP loop.
    
    // Coefficient declarations.
    double F0 = 0.00000000;
    double F1 = 0.00000000;
    double F2 = 0.00000000;
    double F3 = 0.00000000;
    double F4 = 0.00000000;
    double F5 = 0.00000000;
    double F6 = 0.00000000;
    double F7 = 0.00000000;
    double F8 = 0.00000000;
    
    // Total number of operations to compute function values = 216
    for (unsigned int r = 0; r < 12; r++)
    {
      F0 += FE1_C0_D100[0][r]*w[0][r];
      F1 += FE1_C0_D010[0][r]*w[0][r];
      F2 += FE1_C0_D001[0][r]*w[0][r];
      F3 += FE1_C1_D100[0][r]*w[0][r];
      F4 += FE1_C1_D010[0][r]*w[0][r];
      F5 += FE1_C1_D001[0][r]*w[0][r];
      F6 += FE1_C2_D100[0][r]*w[0][r];
      F7 += FE1_C2_D010[0][r]*w[0][r];
      F8 += FE1_C2_D001[0][r]*w[0][r];
    }// end loop over 'r'
    
    // Number of operations for primary indices: 802512
    for (unsigned int j = 0; j < 12; j++)
    {
      for (unsigned int k = 0; k < 12; k++)
      {
        // Number of operations to compute entry: 5573
        A[j*12 + k] += (((((((K_01*FE1_C2_D100[0][k] + K_11*FE1_C2_D010[0][k] + K_21*FE1_C2_D001[0][k]))*((w[2][0]/(2.00000000)*(((((-1.00000000)*1.00000000 + ((((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)) + ((K_00*F3 + K_10*F4 + K_20*F5))*((K_00*F3 + K_10*F4 + K_20*F5)) + ((K_00*F6 + K_10*F7 + K_20*F8))*((K_00*F6 + K_10*F7 + K_20*F8))))/(2.00000000) + ((-1.00000000)*1.00000000 + (((K_02*F0 + K_12*F1 + K_22*F2))*((K_02*F0 + K_12*F1 + K_22*F2)) + (((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000)) + ((K_02*F3 + K_12*F4 + K_22*F5))*((K_02*F3 + K_12*F4 + K_22*F5))))/(2.00000000) + ((-1.00000000)*1.00000000 + (((K_01*F0 + K_11*F1 + K_21*F2))*((K_01*F0 + K_11*F1 + K_21*F2)) + ((K_01*F6 + K_11*F7 + K_21*F8))*((K_01*F6 + K_11*F7 + K_21*F8)) + (((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))))/(2.00000000)))*2.00000000*1.00000000*1.00000000) + w[1][0]*(2.00000000*(1.00000000*1.00000000*(((-1.00000000)*1.00000000 + (((K_01*F0 + K_11*F1 + K_21*F2))*((K_01*F0 + K_11*F1 + K_21*F2)) + ((K_01*F6 + K_11*F7 + K_21*F8))*((K_01*F6 + K_11*F7 + K_21*F8)) + (((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))))/(2.00000000)))))) + ((((((2.00000000*(((K_01*FE1_C1_D100[0][k] + K_11*FE1_C1_D010[0][k] + K_21*FE1_C1_D001[0][k]))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))) + 2.00000000*(((K_01*FE1_C0_D100[0][k] + K_11*FE1_C0_D010[0][k] + K_21*FE1_C0_D001[0][k]))*((K_01*F0 + K_11*F1 + K_21*F2))) + 2.00000000*(((K_01*FE1_C2_D100[0][k] + K_11*FE1_C2_D010[0][k] + K_21*FE1_C2_D001[0][k]))*((K_01*F6 + K_11*F7 + K_21*F8))))/(2.00000000) + (2.00000000*(((K_02*FE1_C0_D100[0][k] + K_12*FE1_C0_D010[0][k] + K_22*FE1_C0_D001[0][k]))*((K_02*F0 + K_12*F1 + K_22*F2))) + 2.00000000*(((K_02*FE1_C1_D100[0][k] + K_12*FE1_C1_D010[0][k] + K_22*FE1_C1_D001[0][k]))*((K_02*F3 + K_12*F4 + K_22*F5))) + 2.00000000*(((K_02*FE1_C2_D100[0][k] + K_12*FE1_C2_D010[0][k] + K_22*FE1_C2_D001[0][k]))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))))/(2.00000000) + (2.00000000*(((K_00*FE1_C0_D100[0][k] + K_10*FE1_C0_D010[0][k] + K_20*FE1_C0_D001[0][k]))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))) + 2.00000000*(((K_00*FE1_C2_D100[0][k] + K_10*FE1_C2_D010[0][k] + K_20*FE1_C2_D001[0][k]))*((K_00*F6 + K_10*F7 + K_20*F8))) + 2.00000000*(((K_00*FE1_C1_D100[0][k] + K_10*FE1_C1_D010[0][k] + K_20*FE1_C1_D001[0][k]))*((K_00*F3 + K_10*F4 + K_20*F5))))/(2.00000000)))*2.00000000*1.00000000*1.00000000)*w[2][0]/(2.00000000) + (2.00000000*(((2.00000000*(((K_01*FE1_C1_D100[0][k] + K_11*FE1_C1_D010[0][k] + K_21*FE1_C1_D001[0][k]))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))) + 2.00000000*(((K_01*FE1_C0_D100[0][k] + K_11*FE1_C0_D010[0][k] + K_21*FE1_C0_D001[0][k]))*((K_01*F0 + K_11*F1 + K_21*F2))) + 2.00000000*(((K_01*FE1_C2_D100[0][k] + K_11*FE1_C2_D010[0][k] + K_21*FE1_C2_D001[0][k]))*((K_01*F6 + K_11*F7 + K_21*F8))))/(2.00000000))*1.00000000*1.00000000))*w[1][0]))*((K_01*F6 + K_11*F7 + K_21*F8))) + (((K_00*FE1_C2_D100[0][k] + K_10*FE1_C2_D010[0][k] + K_20*FE1_C2_D001[0][k]))*(w[1][0]*(2.00000000*(1.00000000*1.00000000*(((((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))*((K_00*F3 + K_10*F4 + K_20*F5)) + ((K_01*F6 + K_11*F7 + K_21*F8))*((K_00*F6 + K_10*F7 + K_20*F8)) + ((K_01*F0 + K_11*F1 + K_21*F2))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)))/(2.00000000))))) + ((2.00000000*((((((K_00*FE1_C2_D100[0][k] + K_10*FE1_C2_D010[0][k] + K_20*FE1_C2_D001[0][k]))*((K_01*F6 + K_11*F7 + K_21*F8)) + ((K_01*FE1_C2_D100[0][k] + K_11*FE1_C2_D010[0][k] + K_21*FE1_C2_D001[0][k]))*((K_00*F6 + K_10*F7 + K_20*F8))) + (((K_01*FE1_C0_D100[0][k] + K_11*FE1_C0_D010[0][k] + K_21*FE1_C0_D001[0][k]))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)) + ((K_00*FE1_C0_D100[0][k] + K_10*FE1_C0_D010[0][k] + K_20*FE1_C0_D001[0][k]))*((K_01*F0 + K_11*F1 + K_21*F2))) + (((K_00*FE1_C1_D100[0][k] + K_10*FE1_C1_D010[0][k] + K_20*FE1_C1_D001[0][k]))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000)) + ((K_01*FE1_C1_D100[0][k] + K_11*FE1_C1_D010[0][k] + K_21*FE1_C1_D001[0][k]))*((K_00*F3 + K_10*F4 + K_20*F5))))/(2.00000000))*1.00000000*1.00000000))*w[1][0])*((K_00*F6 + K_10*F7 + K_20*F8))) + (((2.00000000*((((((K_02*FE1_C0_D100[0][k] + K_12*FE1_C0_D010[0][k] + K_22*FE1_C0_D001[0][k]))*((K_01*F0 + K_11*F1 + K_21*F2)) + ((K_01*FE1_C0_D100[0][k] + K_11*FE1_C0_D010[0][k] + K_21*FE1_C0_D001[0][k]))*((K_02*F0 + K_12*F1 + K_22*F2))) + (((K_01*FE1_C1_D100[0][k] + K_11*FE1_C1_D010[0][k] + K_21*FE1_C1_D001[0][k]))*((K_02*F3 + K_12*F4 + K_22*F5)) + ((K_02*FE1_C1_D100[0][k] + K_12*FE1_C1_D010[0][k] + K_22*FE1_C1_D001[0][k]))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))) + (((K_02*FE1_C2_D100[0][k] + K_12*FE1_C2_D010[0][k] + K_22*FE1_C2_D001[0][k]))*((K_01*F6 + K_11*F7 + K_21*F8)) + ((K_01*FE1_C2_D100[0][k] + K_11*FE1_C2_D010[0][k] + K_21*FE1_C2_D001[0][k]))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))))/(2.00000000))*1.00000000*1.00000000))*w[1][0])*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000)) + ((K_02*FE1_C2_D100[0][k] + K_12*FE1_C2_D010[0][k] + K_22*FE1_C2_D001[0][k]))*(w[1][0]*(2.00000000*(1.00000000*1.00000000*((((K_01*F0 + K_11*F1 + K_21*F2))*((K_02*F0 + K_12*F1 + K_22*F2)) + ((K_01*F6 + K_11*F7 + K_21*F8))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000)) + (((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))*((K_02*F3 + K_12*F4 + K_22*F5)))/(2.00000000))))))))*((K_01*FE1_C2_D100[0][j] + K_11*FE1_C2_D010[0][j] + K_21*FE1_C2_D001[0][j])) + (((((K_01*FE1_C1_D100[0][k] + K_11*FE1_C1_D010[0][k] + K_21*FE1_C1_D001[0][k]))*((w[2][0]/(2.00000000)*(((((-1.00000000)*1.00000000 + ((((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)) + ((K_00*F3 + K_10*F4 + K_20*F5))*((K_00*F3 + K_10*F4 + K_20*F5)) + ((K_00*F6 + K_10*F7 + K_20*F8))*((K_00*F6 + K_10*F7 + K_20*F8))))/(2.00000000) + ((-1.00000000)*1.00000000 + (((K_02*F0 + K_12*F1 + K_22*F2))*((K_02*F0 + K_12*F1 + K_22*F2)) + (((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000)) + ((K_02*F3 + K_12*F4 + K_22*F5))*((K_02*F3 + K_12*F4 + K_22*F5))))/(2.00000000) + ((-1.00000000)*1.00000000 + (((K_01*F0 + K_11*F1 + K_21*F2))*((K_01*F0 + K_11*F1 + K_21*F2)) + ((K_01*F6 + K_11*F7 + K_21*F8))*((K_01*F6 + K_11*F7 + K_21*F8)) + (((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))))/(2.00000000)))*2.00000000*1.00000000*1.00000000) + w[1][0]*(2.00000000*(1.00000000*1.00000000*(((-1.00000000)*1.00000000 + (((K_01*F0 + K_11*F1 + K_21*F2))*((K_01*F0 + K_11*F1 + K_21*F2)) + ((K_01*F6 + K_11*F7 + K_21*F8))*((K_01*F6 + K_11*F7 + K_21*F8)) + (((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))))/(2.00000000)))))) + ((((((2.00000000*(((K_01*FE1_C1_D100[0][k] + K_11*FE1_C1_D010[0][k] + K_21*FE1_C1_D001[0][k]))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))) + 2.00000000*(((K_01*FE1_C0_D100[0][k] + K_11*FE1_C0_D010[0][k] + K_21*FE1_C0_D001[0][k]))*((K_01*F0 + K_11*F1 + K_21*F2))) + 2.00000000*(((K_01*FE1_C2_D100[0][k] + K_11*FE1_C2_D010[0][k] + K_21*FE1_C2_D001[0][k]))*((K_01*F6 + K_11*F7 + K_21*F8))))/(2.00000000) + (2.00000000*(((K_02*FE1_C0_D100[0][k] + K_12*FE1_C0_D010[0][k] + K_22*FE1_C0_D001[0][k]))*((K_02*F0 + K_12*F1 + K_22*F2))) + 2.00000000*(((K_02*FE1_C1_D100[0][k] + K_12*FE1_C1_D010[0][k] + K_22*FE1_C1_D001[0][k]))*((K_02*F3 + K_12*F4 + K_22*F5))) + 2.00000000*(((K_02*FE1_C2_D100[0][k] + K_12*FE1_C2_D010[0][k] + K_22*FE1_C2_D001[0][k]))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))))/(2.00000000) + (2.00000000*(((K_00*FE1_C0_D100[0][k] + K_10*FE1_C0_D010[0][k] + K_20*FE1_C0_D001[0][k]))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))) + 2.00000000*(((K_00*FE1_C2_D100[0][k] + K_10*FE1_C2_D010[0][k] + K_20*FE1_C2_D001[0][k]))*((K_00*F6 + K_10*F7 + K_20*F8))) + 2.00000000*(((K_00*FE1_C1_D100[0][k] + K_10*FE1_C1_D010[0][k] + K_20*FE1_C1_D001[0][k]))*((K_00*F3 + K_10*F4 + K_20*F5))))/(2.00000000)))*2.00000000*1.00000000*1.00000000)*w[2][0]/(2.00000000) + (2.00000000*(((2.00000000*(((K_01*FE1_C1_D100[0][k] + K_11*FE1_C1_D010[0][k] + K_21*FE1_C1_D001[0][k]))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))) + 2.00000000*(((K_01*FE1_C0_D100[0][k] + K_11*FE1_C0_D010[0][k] + K_21*FE1_C0_D001[0][k]))*((K_01*F0 + K_11*F1 + K_21*F2))) + 2.00000000*(((K_01*FE1_C2_D100[0][k] + K_11*FE1_C2_D010[0][k] + K_21*FE1_C2_D001[0][k]))*((K_01*F6 + K_11*F7 + K_21*F8))))/(2.00000000))*1.00000000*1.00000000))*w[1][0]))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))) + (((2.00000000*((((((K_00*FE1_C2_D100[0][k] + K_10*FE1_C2_D010[0][k] + K_20*FE1_C2_D001[0][k]))*((K_01*F6 + K_11*F7 + K_21*F8)) + ((K_01*FE1_C2_D100[0][k] + K_11*FE1_C2_D010[0][k] + K_21*FE1_C2_D001[0][k]))*((K_00*F6 + K_10*F7 + K_20*F8))) + (((K_01*FE1_C0_D100[0][k] + K_11*FE1_C0_D010[0][k] + K_21*FE1_C0_D001[0][k]))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)) + ((K_00*FE1_C0_D100[0][k] + K_10*FE1_C0_D010[0][k] + K_20*FE1_C0_D001[0][k]))*((K_01*F0 + K_11*F1 + K_21*F2))) + (((K_00*FE1_C1_D100[0][k] + K_10*FE1_C1_D010[0][k] + K_20*FE1_C1_D001[0][k]))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000)) + ((K_01*FE1_C1_D100[0][k] + K_11*FE1_C1_D010[0][k] + K_21*FE1_C1_D001[0][k]))*((K_00*F3 + K_10*F4 + K_20*F5))))/(2.00000000))*1.00000000*1.00000000))*w[1][0])*((K_00*F3 + K_10*F4 + K_20*F5)) + ((K_00*FE1_C1_D100[0][k] + K_10*FE1_C1_D010[0][k] + K_20*FE1_C1_D001[0][k]))*(w[1][0]*(2.00000000*(1.00000000*1.00000000*(((((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))*((K_00*F3 + K_10*F4 + K_20*F5)) + ((K_01*F6 + K_11*F7 + K_21*F8))*((K_00*F6 + K_10*F7 + K_20*F8)) + ((K_01*F0 + K_11*F1 + K_21*F2))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)))/(2.00000000)))))) + (((2.00000000*((((((K_02*FE1_C0_D100[0][k] + K_12*FE1_C0_D010[0][k] + K_22*FE1_C0_D001[0][k]))*((K_01*F0 + K_11*F1 + K_21*F2)) + ((K_01*FE1_C0_D100[0][k] + K_11*FE1_C0_D010[0][k] + K_21*FE1_C0_D001[0][k]))*((K_02*F0 + K_12*F1 + K_22*F2))) + (((K_01*FE1_C1_D100[0][k] + K_11*FE1_C1_D010[0][k] + K_21*FE1_C1_D001[0][k]))*((K_02*F3 + K_12*F4 + K_22*F5)) + ((K_02*FE1_C1_D100[0][k] + K_12*FE1_C1_D010[0][k] + K_22*FE1_C1_D001[0][k]))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))) + (((K_02*FE1_C2_D100[0][k] + K_12*FE1_C2_D010[0][k] + K_22*FE1_C2_D001[0][k]))*((K_01*F6 + K_11*F7 + K_21*F8)) + ((K_01*FE1_C2_D100[0][k] + K_11*FE1_C2_D010[0][k] + K_21*FE1_C2_D001[0][k]))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))))/(2.00000000))*1.00000000*1.00000000))*w[1][0])*((K_02*F3 + K_12*F4 + K_22*F5)) + ((K_02*FE1_C1_D100[0][k] + K_12*FE1_C1_D010[0][k] + K_22*FE1_C1_D001[0][k]))*(w[1][0]*(2.00000000*(1.00000000*1.00000000*((((K_01*F0 + K_11*F1 + K_21*F2))*((K_02*F0 + K_12*F1 + K_22*F2)) + ((K_01*F6 + K_11*F7 + K_21*F8))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000)) + (((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))*((K_02*F3 + K_12*F4 + K_22*F5)))/(2.00000000))))))))*((K_01*FE1_C1_D100[0][j] + K_11*FE1_C1_D010[0][j] + K_21*FE1_C1_D001[0][j])) + (((((((((2.00000000*(((K_01*FE1_C1_D100[0][k] + K_11*FE1_C1_D010[0][k] + K_21*FE1_C1_D001[0][k]))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))) + 2.00000000*(((K_01*FE1_C0_D100[0][k] + K_11*FE1_C0_D010[0][k] + K_21*FE1_C0_D001[0][k]))*((K_01*F0 + K_11*F1 + K_21*F2))) + 2.00000000*(((K_01*FE1_C2_D100[0][k] + K_11*FE1_C2_D010[0][k] + K_21*FE1_C2_D001[0][k]))*((K_01*F6 + K_11*F7 + K_21*F8))))/(2.00000000) + (2.00000000*(((K_02*FE1_C0_D100[0][k] + K_12*FE1_C0_D010[0][k] + K_22*FE1_C0_D001[0][k]))*((K_02*F0 + K_12*F1 + K_22*F2))) + 2.00000000*(((K_02*FE1_C1_D100[0][k] + K_12*FE1_C1_D010[0][k] + K_22*FE1_C1_D001[0][k]))*((K_02*F3 + K_12*F4 + K_22*F5))) + 2.00000000*(((K_02*FE1_C2_D100[0][k] + K_12*FE1_C2_D010[0][k] + K_22*FE1_C2_D001[0][k]))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))))/(2.00000000) + (2.00000000*(((K_00*FE1_C0_D100[0][k] + K_10*FE1_C0_D010[0][k] + K_20*FE1_C0_D001[0][k]))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))) + 2.00000000*(((K_00*FE1_C2_D100[0][k] + K_10*FE1_C2_D010[0][k] + K_20*FE1_C2_D001[0][k]))*((K_00*F6 + K_10*F7 + K_20*F8))) + 2.00000000*(((K_00*FE1_C1_D100[0][k] + K_10*FE1_C1_D010[0][k] + K_20*FE1_C1_D001[0][k]))*((K_00*F3 + K_10*F4 + K_20*F5))))/(2.00000000)))*2.00000000*1.00000000*1.00000000)*w[2][0]/(2.00000000) + (2.00000000*(((2.00000000*(((K_01*FE1_C1_D100[0][k] + K_11*FE1_C1_D010[0][k] + K_21*FE1_C1_D001[0][k]))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))) + 2.00000000*(((K_01*FE1_C0_D100[0][k] + K_11*FE1_C0_D010[0][k] + K_21*FE1_C0_D001[0][k]))*((K_01*F0 + K_11*F1 + K_21*F2))) + 2.00000000*(((K_01*FE1_C2_D100[0][k] + K_11*FE1_C2_D010[0][k] + K_21*FE1_C2_D001[0][k]))*((K_01*F6 + K_11*F7 + K_21*F8))))/(2.00000000))*1.00000000*1.00000000))*w[1][0]))*((K_01*F0 + K_11*F1 + K_21*F2)) + ((K_01*FE1_C0_D100[0][k] + K_11*FE1_C0_D010[0][k] + K_21*FE1_C0_D001[0][k]))*((w[2][0]/(2.00000000)*(((((-1.00000000)*1.00000000 + ((((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)) + ((K_00*F3 + K_10*F4 + K_20*F5))*((K_00*F3 + K_10*F4 + K_20*F5)) + ((K_00*F6 + K_10*F7 + K_20*F8))*((K_00*F6 + K_10*F7 + K_20*F8))))/(2.00000000) + ((-1.00000000)*1.00000000 + (((K_02*F0 + K_12*F1 + K_22*F2))*((K_02*F0 + K_12*F1 + K_22*F2)) + (((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000)) + ((K_02*F3 + K_12*F4 + K_22*F5))*((K_02*F3 + K_12*F4 + K_22*F5))))/(2.00000000) + ((-1.00000000)*1.00000000 + (((K_01*F0 + K_11*F1 + K_21*F2))*((K_01*F0 + K_11*F1 + K_21*F2)) + ((K_01*F6 + K_11*F7 + K_21*F8))*((K_01*F6 + K_11*F7 + K_21*F8)) + (((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))))/(2.00000000)))*2.00000000*1.00000000*1.00000000) + w[1][0]*(2.00000000*(1.00000000*1.00000000*(((-1.00000000)*1.00000000 + (((K_01*F0 + K_11*F1 + K_21*F2))*((K_01*F0 + K_11*F1 + K_21*F2)) + ((K_01*F6 + K_11*F7 + K_21*F8))*((K_01*F6 + K_11*F7 + K_21*F8)) + (((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))))/(2.00000000))))))) + (((2.00000000*((((((K_00*FE1_C2_D100[0][k] + K_10*FE1_C2_D010[0][k] + K_20*FE1_C2_D001[0][k]))*((K_01*F6 + K_11*F7 + K_21*F8)) + ((K_01*FE1_C2_D100[0][k] + K_11*FE1_C2_D010[0][k] + K_21*FE1_C2_D001[0][k]))*((K_00*F6 + K_10*F7 + K_20*F8))) + (((K_01*FE1_C0_D100[0][k] + K_11*FE1_C0_D010[0][k] + K_21*FE1_C0_D001[0][k]))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)) + ((K_00*FE1_C0_D100[0][k] + K_10*FE1_C0_D010[0][k] + K_20*FE1_C0_D001[0][k]))*((K_01*F0 + K_11*F1 + K_21*F2))) + (((K_00*FE1_C1_D100[0][k] + K_10*FE1_C1_D010[0][k] + K_20*FE1_C1_D001[0][k]))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000)) + ((K_01*FE1_C1_D100[0][k] + K_11*FE1_C1_D010[0][k] + K_21*FE1_C1_D001[0][k]))*((K_00*F3 + K_10*F4 + K_20*F5))))/(2.00000000))*1.00000000*1.00000000))*w[1][0])*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)) + ((K_00*FE1_C0_D100[0][k] + K_10*FE1_C0_D010[0][k] + K_20*FE1_C0_D001[0][k]))*(w[1][0]*(2.00000000*(1.00000000*1.00000000*(((((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))*((K_00*F3 + K_10*F4 + K_20*F5)) + ((K_01*F6 + K_11*F7 + K_21*F8))*((K_00*F6 + K_10*F7 + K_20*F8)) + ((K_01*F0 + K_11*F1 + K_21*F2))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)))/(2.00000000)))))) + (((2.00000000*((((((K_02*FE1_C0_D100[0][k] + K_12*FE1_C0_D010[0][k] + K_22*FE1_C0_D001[0][k]))*((K_01*F0 + K_11*F1 + K_21*F2)) + ((K_01*FE1_C0_D100[0][k] + K_11*FE1_C0_D010[0][k] + K_21*FE1_C0_D001[0][k]))*((K_02*F0 + K_12*F1 + K_22*F2))) + (((K_01*FE1_C1_D100[0][k] + K_11*FE1_C1_D010[0][k] + K_21*FE1_C1_D001[0][k]))*((K_02*F3 + K_12*F4 + K_22*F5)) + ((K_02*FE1_C1_D100[0][k] + K_12*FE1_C1_D010[0][k] + K_22*FE1_C1_D001[0][k]))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))) + (((K_02*FE1_C2_D100[0][k] + K_12*FE1_C2_D010[0][k] + K_22*FE1_C2_D001[0][k]))*((K_01*F6 + K_11*F7 + K_21*F8)) + ((K_01*FE1_C2_D100[0][k] + K_11*FE1_C2_D010[0][k] + K_21*FE1_C2_D001[0][k]))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))))/(2.00000000))*1.00000000*1.00000000))*w[1][0])*((K_02*F0 + K_12*F1 + K_22*F2)) + ((K_02*FE1_C0_D100[0][k] + K_12*FE1_C0_D010[0][k] + K_22*FE1_C0_D001[0][k]))*(w[1][0]*(2.00000000*(1.00000000*1.00000000*((((K_01*F0 + K_11*F1 + K_21*F2))*((K_02*F0 + K_12*F1 + K_22*F2)) + ((K_01*F6 + K_11*F7 + K_21*F8))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000)) + (((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))*((K_02*F3 + K_12*F4 + K_22*F5)))/(2.00000000))))))))*((K_01*FE1_C0_D100[0][j] + K_11*FE1_C0_D010[0][j] + K_21*FE1_C0_D001[0][j]))) + (((((((2.00000000*(((2.00000000*(((K_00*FE1_C0_D100[0][k] + K_10*FE1_C0_D010[0][k] + K_20*FE1_C0_D001[0][k]))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))) + 2.00000000*(((K_00*FE1_C2_D100[0][k] + K_10*FE1_C2_D010[0][k] + K_20*FE1_C2_D001[0][k]))*((K_00*F6 + K_10*F7 + K_20*F8))) + 2.00000000*(((K_00*FE1_C1_D100[0][k] + K_10*FE1_C1_D010[0][k] + K_20*FE1_C1_D001[0][k]))*((K_00*F3 + K_10*F4 + K_20*F5))))/(2.00000000))*1.00000000*1.00000000))*w[1][0] + ((((2.00000000*(((K_01*FE1_C1_D100[0][k] + K_11*FE1_C1_D010[0][k] + K_21*FE1_C1_D001[0][k]))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))) + 2.00000000*(((K_01*FE1_C0_D100[0][k] + K_11*FE1_C0_D010[0][k] + K_21*FE1_C0_D001[0][k]))*((K_01*F0 + K_11*F1 + K_21*F2))) + 2.00000000*(((K_01*FE1_C2_D100[0][k] + K_11*FE1_C2_D010[0][k] + K_21*FE1_C2_D001[0][k]))*((K_01*F6 + K_11*F7 + K_21*F8))))/(2.00000000) + (2.00000000*(((K_02*FE1_C0_D100[0][k] + K_12*FE1_C0_D010[0][k] + K_22*FE1_C0_D001[0][k]))*((K_02*F0 + K_12*F1 + K_22*F2))) + 2.00000000*(((K_02*FE1_C1_D100[0][k] + K_12*FE1_C1_D010[0][k] + K_22*FE1_C1_D001[0][k]))*((K_02*F3 + K_12*F4 + K_22*F5))) + 2.00000000*(((K_02*FE1_C2_D100[0][k] + K_12*FE1_C2_D010[0][k] + K_22*FE1_C2_D001[0][k]))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))))/(2.00000000) + (2.00000000*(((K_00*FE1_C0_D100[0][k] + K_10*FE1_C0_D010[0][k] + K_20*FE1_C0_D001[0][k]))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))) + 2.00000000*(((K_00*FE1_C2_D100[0][k] + K_10*FE1_C2_D010[0][k] + K_20*FE1_C2_D001[0][k]))*((K_00*F6 + K_10*F7 + K_20*F8))) + 2.00000000*(((K_00*FE1_C1_D100[0][k] + K_10*FE1_C1_D010[0][k] + K_20*FE1_C1_D001[0][k]))*((K_00*F3 + K_10*F4 + K_20*F5))))/(2.00000000)))*2.00000000*1.00000000*1.00000000)*w[2][0]/(2.00000000)))*((K_00*F3 + K_10*F4 + K_20*F5)) + ((K_00*FE1_C1_D100[0][k] + K_10*FE1_C1_D010[0][k] + K_20*FE1_C1_D001[0][k]))*((w[2][0]/(2.00000000)*(((((-1.00000000)*1.00000000 + ((((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)) + ((K_00*F3 + K_10*F4 + K_20*F5))*((K_00*F3 + K_10*F4 + K_20*F5)) + ((K_00*F6 + K_10*F7 + K_20*F8))*((K_00*F6 + K_10*F7 + K_20*F8))))/(2.00000000) + ((-1.00000000)*1.00000000 + (((K_02*F0 + K_12*F1 + K_22*F2))*((K_02*F0 + K_12*F1 + K_22*F2)) + (((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000)) + ((K_02*F3 + K_12*F4 + K_22*F5))*((K_02*F3 + K_12*F4 + K_22*F5))))/(2.00000000) + ((-1.00000000)*1.00000000 + (((K_01*F0 + K_11*F1 + K_21*F2))*((K_01*F0 + K_11*F1 + K_21*F2)) + ((K_01*F6 + K_11*F7 + K_21*F8))*((K_01*F6 + K_11*F7 + K_21*F8)) + (((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))))/(2.00000000)))*2.00000000*1.00000000*1.00000000) + w[1][0]*(2.00000000*(1.00000000*1.00000000*(((-1.00000000)*1.00000000 + ((((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)) + ((K_00*F3 + K_10*F4 + K_20*F5))*((K_00*F3 + K_10*F4 + K_20*F5)) + ((K_00*F6 + K_10*F7 + K_20*F8))*((K_00*F6 + K_10*F7 + K_20*F8))))/(2.00000000))))))) + (((K_02*FE1_C1_D100[0][k] + K_12*FE1_C1_D010[0][k] + K_22*FE1_C1_D001[0][k]))*(w[1][0]*(2.00000000*(1.00000000*1.00000000*((((K_00*F3 + K_10*F4 + K_20*F5))*((K_02*F3 + K_12*F4 + K_22*F5)) + (((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))*((K_02*F0 + K_12*F1 + K_22*F2)) + ((K_00*F6 + K_10*F7 + K_20*F8))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000)))/(2.00000000))))) + ((2.00000000*((((((K_02*FE1_C2_D100[0][k] + K_12*FE1_C2_D010[0][k] + K_22*FE1_C2_D001[0][k]))*((K_00*F6 + K_10*F7 + K_20*F8)) + ((K_00*FE1_C2_D100[0][k] + K_10*FE1_C2_D010[0][k] + K_20*FE1_C2_D001[0][k]))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))) + (((K_00*FE1_C1_D100[0][k] + K_10*FE1_C1_D010[0][k] + K_20*FE1_C1_D001[0][k]))*((K_02*F3 + K_12*F4 + K_22*F5)) + ((K_02*FE1_C1_D100[0][k] + K_12*FE1_C1_D010[0][k] + K_22*FE1_C1_D001[0][k]))*((K_00*F3 + K_10*F4 + K_20*F5))) + (((K_02*FE1_C0_D100[0][k] + K_12*FE1_C0_D010[0][k] + K_22*FE1_C0_D001[0][k]))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)) + ((K_00*FE1_C0_D100[0][k] + K_10*FE1_C0_D010[0][k] + K_20*FE1_C0_D001[0][k]))*((K_02*F0 + K_12*F1 + K_22*F2))))/(2.00000000))*1.00000000*1.00000000))*w[1][0])*((K_02*F3 + K_12*F4 + K_22*F5))) + (((2.00000000*((((((K_00*FE1_C2_D100[0][k] + K_10*FE1_C2_D010[0][k] + K_20*FE1_C2_D001[0][k]))*((K_01*F6 + K_11*F7 + K_21*F8)) + ((K_01*FE1_C2_D100[0][k] + K_11*FE1_C2_D010[0][k] + K_21*FE1_C2_D001[0][k]))*((K_00*F6 + K_10*F7 + K_20*F8))) + (((K_01*FE1_C0_D100[0][k] + K_11*FE1_C0_D010[0][k] + K_21*FE1_C0_D001[0][k]))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)) + ((K_00*FE1_C0_D100[0][k] + K_10*FE1_C0_D010[0][k] + K_20*FE1_C0_D001[0][k]))*((K_01*F0 + K_11*F1 + K_21*F2))) + (((K_00*FE1_C1_D100[0][k] + K_10*FE1_C1_D010[0][k] + K_20*FE1_C1_D001[0][k]))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000)) + ((K_01*FE1_C1_D100[0][k] + K_11*FE1_C1_D010[0][k] + K_21*FE1_C1_D001[0][k]))*((K_00*F3 + K_10*F4 + K_20*F5))))/(2.00000000))*1.00000000*1.00000000))*w[1][0])*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000)) + ((K_01*FE1_C1_D100[0][k] + K_11*FE1_C1_D010[0][k] + K_21*FE1_C1_D001[0][k]))*(w[1][0]*(2.00000000*(1.00000000*1.00000000*((((K_00*F6 + K_10*F7 + K_20*F8))*((K_01*F6 + K_11*F7 + K_21*F8)) + (((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))*((K_01*F0 + K_11*F1 + K_21*F2)) + ((K_00*F3 + K_10*F4 + K_20*F5))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000)))/(2.00000000))))))))*((K_00*FE1_C1_D100[0][j] + K_10*FE1_C1_D010[0][j] + K_20*FE1_C1_D001[0][j])) + (((((K_02*FE1_C0_D100[0][k] + K_12*FE1_C0_D010[0][k] + K_22*FE1_C0_D001[0][k]))*(w[1][0]*(2.00000000*(1.00000000*1.00000000*((((K_00*F3 + K_10*F4 + K_20*F5))*((K_02*F3 + K_12*F4 + K_22*F5)) + (((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))*((K_02*F0 + K_12*F1 + K_22*F2)) + ((K_00*F6 + K_10*F7 + K_20*F8))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000)))/(2.00000000))))) + ((2.00000000*((((((K_02*FE1_C2_D100[0][k] + K_12*FE1_C2_D010[0][k] + K_22*FE1_C2_D001[0][k]))*((K_00*F6 + K_10*F7 + K_20*F8)) + ((K_00*FE1_C2_D100[0][k] + K_10*FE1_C2_D010[0][k] + K_20*FE1_C2_D001[0][k]))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))) + (((K_00*FE1_C1_D100[0][k] + K_10*FE1_C1_D010[0][k] + K_20*FE1_C1_D001[0][k]))*((K_02*F3 + K_12*F4 + K_22*F5)) + ((K_02*FE1_C1_D100[0][k] + K_12*FE1_C1_D010[0][k] + K_22*FE1_C1_D001[0][k]))*((K_00*F3 + K_10*F4 + K_20*F5))) + (((K_02*FE1_C0_D100[0][k] + K_12*FE1_C0_D010[0][k] + K_22*FE1_C0_D001[0][k]))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)) + ((K_00*FE1_C0_D100[0][k] + K_10*FE1_C0_D010[0][k] + K_20*FE1_C0_D001[0][k]))*((K_02*F0 + K_12*F1 + K_22*F2))))/(2.00000000))*1.00000000*1.00000000))*w[1][0])*((K_02*F0 + K_12*F1 + K_22*F2))) + (((K_00*FE1_C0_D100[0][k] + K_10*FE1_C0_D010[0][k] + K_20*FE1_C0_D001[0][k]))*((w[2][0]/(2.00000000)*(((((-1.00000000)*1.00000000 + ((((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)) + ((K_00*F3 + K_10*F4 + K_20*F5))*((K_00*F3 + K_10*F4 + K_20*F5)) + ((K_00*F6 + K_10*F7 + K_20*F8))*((K_00*F6 + K_10*F7 + K_20*F8))))/(2.00000000) + ((-1.00000000)*1.00000000 + (((K_02*F0 + K_12*F1 + K_22*F2))*((K_02*F0 + K_12*F1 + K_22*F2)) + (((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000)) + ((K_02*F3 + K_12*F4 + K_22*F5))*((K_02*F3 + K_12*F4 + K_22*F5))))/(2.00000000) + ((-1.00000000)*1.00000000 + (((K_01*F0 + K_11*F1 + K_21*F2))*((K_01*F0 + K_11*F1 + K_21*F2)) + ((K_01*F6 + K_11*F7 + K_21*F8))*((K_01*F6 + K_11*F7 + K_21*F8)) + (((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))))/(2.00000000)))*2.00000000*1.00000000*1.00000000) + w[1][0]*(2.00000000*(1.00000000*1.00000000*(((-1.00000000)*1.00000000 + ((((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)) + ((K_00*F3 + K_10*F4 + K_20*F5))*((K_00*F3 + K_10*F4 + K_20*F5)) + ((K_00*F6 + K_10*F7 + K_20*F8))*((K_00*F6 + K_10*F7 + K_20*F8))))/(2.00000000)))))) + (((2.00000000*(((2.00000000*(((K_00*FE1_C0_D100[0][k] + K_10*FE1_C0_D010[0][k] + K_20*FE1_C0_D001[0][k]))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))) + 2.00000000*(((K_00*FE1_C2_D100[0][k] + K_10*FE1_C2_D010[0][k] + K_20*FE1_C2_D001[0][k]))*((K_00*F6 + K_10*F7 + K_20*F8))) + 2.00000000*(((K_00*FE1_C1_D100[0][k] + K_10*FE1_C1_D010[0][k] + K_20*FE1_C1_D001[0][k]))*((K_00*F3 + K_10*F4 + K_20*F5))))/(2.00000000))*1.00000000*1.00000000))*w[1][0] + ((((2.00000000*(((K_01*FE1_C1_D100[0][k] + K_11*FE1_C1_D010[0][k] + K_21*FE1_C1_D001[0][k]))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))) + 2.00000000*(((K_01*FE1_C0_D100[0][k] + K_11*FE1_C0_D010[0][k] + K_21*FE1_C0_D001[0][k]))*((K_01*F0 + K_11*F1 + K_21*F2))) + 2.00000000*(((K_01*FE1_C2_D100[0][k] + K_11*FE1_C2_D010[0][k] + K_21*FE1_C2_D001[0][k]))*((K_01*F6 + K_11*F7 + K_21*F8))))/(2.00000000) + (2.00000000*(((K_02*FE1_C0_D100[0][k] + K_12*FE1_C0_D010[0][k] + K_22*FE1_C0_D001[0][k]))*((K_02*F0 + K_12*F1 + K_22*F2))) + 2.00000000*(((K_02*FE1_C1_D100[0][k] + K_12*FE1_C1_D010[0][k] + K_22*FE1_C1_D001[0][k]))*((K_02*F3 + K_12*F4 + K_22*F5))) + 2.00000000*(((K_02*FE1_C2_D100[0][k] + K_12*FE1_C2_D010[0][k] + K_22*FE1_C2_D001[0][k]))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))))/(2.00000000) + (2.00000000*(((K_00*FE1_C0_D100[0][k] + K_10*FE1_C0_D010[0][k] + K_20*FE1_C0_D001[0][k]))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))) + 2.00000000*(((K_00*FE1_C2_D100[0][k] + K_10*FE1_C2_D010[0][k] + K_20*FE1_C2_D001[0][k]))*((K_00*F6 + K_10*F7 + K_20*F8))) + 2.00000000*(((K_00*FE1_C1_D100[0][k] + K_10*FE1_C1_D010[0][k] + K_20*FE1_C1_D001[0][k]))*((K_00*F3 + K_10*F4 + K_20*F5))))/(2.00000000)))*2.00000000*1.00000000*1.00000000)*w[2][0]/(2.00000000)))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))) + (((K_01*FE1_C0_D100[0][k] + K_11*FE1_C0_D010[0][k] + K_21*FE1_C0_D001[0][k]))*(w[1][0]*(2.00000000*(1.00000000*1.00000000*((((K_00*F6 + K_10*F7 + K_20*F8))*((K_01*F6 + K_11*F7 + K_21*F8)) + (((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))*((K_01*F0 + K_11*F1 + K_21*F2)) + ((K_00*F3 + K_10*F4 + K_20*F5))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000)))/(2.00000000))))) + ((2.00000000*((((((K_00*FE1_C2_D100[0][k] + K_10*FE1_C2_D010[0][k] + K_20*FE1_C2_D001[0][k]))*((K_01*F6 + K_11*F7 + K_21*F8)) + ((K_01*FE1_C2_D100[0][k] + K_11*FE1_C2_D010[0][k] + K_21*FE1_C2_D001[0][k]))*((K_00*F6 + K_10*F7 + K_20*F8))) + (((K_01*FE1_C0_D100[0][k] + K_11*FE1_C0_D010[0][k] + K_21*FE1_C0_D001[0][k]))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)) + ((K_00*FE1_C0_D100[0][k] + K_10*FE1_C0_D010[0][k] + K_20*FE1_C0_D001[0][k]))*((K_01*F0 + K_11*F1 + K_21*F2))) + (((K_00*FE1_C1_D100[0][k] + K_10*FE1_C1_D010[0][k] + K_20*FE1_C1_D001[0][k]))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000)) + ((K_01*FE1_C1_D100[0][k] + K_11*FE1_C1_D010[0][k] + K_21*FE1_C1_D001[0][k]))*((K_00*F3 + K_10*F4 + K_20*F5))))/(2.00000000))*1.00000000*1.00000000))*w[1][0])*((K_01*F0 + K_11*F1 + K_21*F2)))))*((K_00*FE1_C0_D100[0][j] + K_10*FE1_C0_D010[0][j] + K_20*FE1_C0_D001[0][j])) + (((((2.00000000*((((((K_00*FE1_C2_D100[0][k] + K_10*FE1_C2_D010[0][k] + K_20*FE1_C2_D001[0][k]))*((K_01*F6 + K_11*F7 + K_21*F8)) + ((K_01*FE1_C2_D100[0][k] + K_11*FE1_C2_D010[0][k] + K_21*FE1_C2_D001[0][k]))*((K_00*F6 + K_10*F7 + K_20*F8))) + (((K_01*FE1_C0_D100[0][k] + K_11*FE1_C0_D010[0][k] + K_21*FE1_C0_D001[0][k]))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)) + ((K_00*FE1_C0_D100[0][k] + K_10*FE1_C0_D010[0][k] + K_20*FE1_C0_D001[0][k]))*((K_01*F0 + K_11*F1 + K_21*F2))) + (((K_00*FE1_C1_D100[0][k] + K_10*FE1_C1_D010[0][k] + K_20*FE1_C1_D001[0][k]))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000)) + ((K_01*FE1_C1_D100[0][k] + K_11*FE1_C1_D010[0][k] + K_21*FE1_C1_D001[0][k]))*((K_00*F3 + K_10*F4 + K_20*F5))))/(2.00000000))*1.00000000*1.00000000))*w[1][0])*((K_01*F6 + K_11*F7 + K_21*F8)) + ((K_01*FE1_C2_D100[0][k] + K_11*FE1_C2_D010[0][k] + K_21*FE1_C2_D001[0][k]))*(w[1][0]*(2.00000000*(1.00000000*1.00000000*((((K_00*F6 + K_10*F7 + K_20*F8))*((K_01*F6 + K_11*F7 + K_21*F8)) + (((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))*((K_01*F0 + K_11*F1 + K_21*F2)) + ((K_00*F3 + K_10*F4 + K_20*F5))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000)))/(2.00000000)))))) + ((((2.00000000*(((2.00000000*(((K_00*FE1_C0_D100[0][k] + K_10*FE1_C0_D010[0][k] + K_20*FE1_C0_D001[0][k]))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))) + 2.00000000*(((K_00*FE1_C2_D100[0][k] + K_10*FE1_C2_D010[0][k] + K_20*FE1_C2_D001[0][k]))*((K_00*F6 + K_10*F7 + K_20*F8))) + 2.00000000*(((K_00*FE1_C1_D100[0][k] + K_10*FE1_C1_D010[0][k] + K_20*FE1_C1_D001[0][k]))*((K_00*F3 + K_10*F4 + K_20*F5))))/(2.00000000))*1.00000000*1.00000000))*w[1][0] + ((((2.00000000*(((K_01*FE1_C1_D100[0][k] + K_11*FE1_C1_D010[0][k] + K_21*FE1_C1_D001[0][k]))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))) + 2.00000000*(((K_01*FE1_C0_D100[0][k] + K_11*FE1_C0_D010[0][k] + K_21*FE1_C0_D001[0][k]))*((K_01*F0 + K_11*F1 + K_21*F2))) + 2.00000000*(((K_01*FE1_C2_D100[0][k] + K_11*FE1_C2_D010[0][k] + K_21*FE1_C2_D001[0][k]))*((K_01*F6 + K_11*F7 + K_21*F8))))/(2.00000000) + (2.00000000*(((K_02*FE1_C0_D100[0][k] + K_12*FE1_C0_D010[0][k] + K_22*FE1_C0_D001[0][k]))*((K_02*F0 + K_12*F1 + K_22*F2))) + 2.00000000*(((K_02*FE1_C1_D100[0][k] + K_12*FE1_C1_D010[0][k] + K_22*FE1_C1_D001[0][k]))*((K_02*F3 + K_12*F4 + K_22*F5))) + 2.00000000*(((K_02*FE1_C2_D100[0][k] + K_12*FE1_C2_D010[0][k] + K_22*FE1_C2_D001[0][k]))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))))/(2.00000000) + (2.00000000*(((K_00*FE1_C0_D100[0][k] + K_10*FE1_C0_D010[0][k] + K_20*FE1_C0_D001[0][k]))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))) + 2.00000000*(((K_00*FE1_C2_D100[0][k] + K_10*FE1_C2_D010[0][k] + K_20*FE1_C2_D001[0][k]))*((K_00*F6 + K_10*F7 + K_20*F8))) + 2.00000000*(((K_00*FE1_C1_D100[0][k] + K_10*FE1_C1_D010[0][k] + K_20*FE1_C1_D001[0][k]))*((K_00*F3 + K_10*F4 + K_20*F5))))/(2.00000000)))*2.00000000*1.00000000*1.00000000)*w[2][0]/(2.00000000)))*((K_00*F6 + K_10*F7 + K_20*F8)) + ((K_00*FE1_C2_D100[0][k] + K_10*FE1_C2_D010[0][k] + K_20*FE1_C2_D001[0][k]))*((w[2][0]/(2.00000000)*(((((-1.00000000)*1.00000000 + ((((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)) + ((K_00*F3 + K_10*F4 + K_20*F5))*((K_00*F3 + K_10*F4 + K_20*F5)) + ((K_00*F6 + K_10*F7 + K_20*F8))*((K_00*F6 + K_10*F7 + K_20*F8))))/(2.00000000) + ((-1.00000000)*1.00000000 + (((K_02*F0 + K_12*F1 + K_22*F2))*((K_02*F0 + K_12*F1 + K_22*F2)) + (((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000)) + ((K_02*F3 + K_12*F4 + K_22*F5))*((K_02*F3 + K_12*F4 + K_22*F5))))/(2.00000000) + ((-1.00000000)*1.00000000 + (((K_01*F0 + K_11*F1 + K_21*F2))*((K_01*F0 + K_11*F1 + K_21*F2)) + ((K_01*F6 + K_11*F7 + K_21*F8))*((K_01*F6 + K_11*F7 + K_21*F8)) + (((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))))/(2.00000000)))*2.00000000*1.00000000*1.00000000) + w[1][0]*(2.00000000*(1.00000000*1.00000000*(((-1.00000000)*1.00000000 + ((((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)) + ((K_00*F3 + K_10*F4 + K_20*F5))*((K_00*F3 + K_10*F4 + K_20*F5)) + ((K_00*F6 + K_10*F7 + K_20*F8))*((K_00*F6 + K_10*F7 + K_20*F8))))/(2.00000000))))))) + (((K_02*FE1_C2_D100[0][k] + K_12*FE1_C2_D010[0][k] + K_22*FE1_C2_D001[0][k]))*(w[1][0]*(2.00000000*(1.00000000*1.00000000*((((K_00*F3 + K_10*F4 + K_20*F5))*((K_02*F3 + K_12*F4 + K_22*F5)) + (((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))*((K_02*F0 + K_12*F1 + K_22*F2)) + ((K_00*F6 + K_10*F7 + K_20*F8))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000)))/(2.00000000))))) + ((2.00000000*((((((K_02*FE1_C2_D100[0][k] + K_12*FE1_C2_D010[0][k] + K_22*FE1_C2_D001[0][k]))*((K_00*F6 + K_10*F7 + K_20*F8)) + ((K_00*FE1_C2_D100[0][k] + K_10*FE1_C2_D010[0][k] + K_20*FE1_C2_D001[0][k]))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))) + (((K_00*FE1_C1_D100[0][k] + K_10*FE1_C1_D010[0][k] + K_20*FE1_C1_D001[0][k]))*((K_02*F3 + K_12*F4 + K_22*F5)) + ((K_02*FE1_C1_D100[0][k] + K_12*FE1_C1_D010[0][k] + K_22*FE1_C1_D001[0][k]))*((K_00*F3 + K_10*F4 + K_20*F5))) + (((K_02*FE1_C0_D100[0][k] + K_12*FE1_C0_D010[0][k] + K_22*FE1_C0_D001[0][k]))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)) + ((K_00*FE1_C0_D100[0][k] + K_10*FE1_C0_D010[0][k] + K_20*FE1_C0_D001[0][k]))*((K_02*F0 + K_12*F1 + K_22*F2))))/(2.00000000))*1.00000000*1.00000000))*w[1][0])*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000)))))*((K_00*FE1_C2_D100[0][j] + K_10*FE1_C2_D010[0][j] + K_20*FE1_C2_D001[0][j]))) + ((((((K_00*FE1_C2_D100[0][k] + K_10*FE1_C2_D010[0][k] + K_20*FE1_C2_D001[0][k]))*(w[1][0]*(2.00000000*(1.00000000*1.00000000*(((((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))*((K_00*F6 + K_10*F7 + K_20*F8)) + ((K_02*F0 + K_12*F1 + K_22*F2))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)) + ((K_02*F3 + K_12*F4 + K_22*F5))*((K_00*F3 + K_10*F4 + K_20*F5)))/(2.00000000))))) + ((2.00000000*((((((K_00*FE1_C0_D100[0][k] + K_10*FE1_C0_D010[0][k] + K_20*FE1_C0_D001[0][k]))*((K_02*F0 + K_12*F1 + K_22*F2)) + ((K_02*FE1_C0_D100[0][k] + K_12*FE1_C0_D010[0][k] + K_22*FE1_C0_D001[0][k]))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))) + (((K_02*FE1_C1_D100[0][k] + K_12*FE1_C1_D010[0][k] + K_22*FE1_C1_D001[0][k]))*((K_00*F3 + K_10*F4 + K_20*F5)) + ((K_00*FE1_C1_D100[0][k] + K_10*FE1_C1_D010[0][k] + K_20*FE1_C1_D001[0][k]))*((K_02*F3 + K_12*F4 + K_22*F5))) + (((K_00*FE1_C2_D100[0][k] + K_10*FE1_C2_D010[0][k] + K_20*FE1_C2_D001[0][k]))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000)) + ((K_02*FE1_C2_D100[0][k] + K_12*FE1_C2_D010[0][k] + K_22*FE1_C2_D001[0][k]))*((K_00*F6 + K_10*F7 + K_20*F8))))/(2.00000000))*1.00000000*1.00000000))*w[1][0])*((K_00*F6 + K_10*F7 + K_20*F8))) + (((2.00000000*((((((K_02*FE1_C0_D100[0][k] + K_12*FE1_C0_D010[0][k] + K_22*FE1_C0_D001[0][k]))*((K_01*F0 + K_11*F1 + K_21*F2)) + ((K_01*FE1_C0_D100[0][k] + K_11*FE1_C0_D010[0][k] + K_21*FE1_C0_D001[0][k]))*((K_02*F0 + K_12*F1 + K_22*F2))) + (((K_01*FE1_C1_D100[0][k] + K_11*FE1_C1_D010[0][k] + K_21*FE1_C1_D001[0][k]))*((K_02*F3 + K_12*F4 + K_22*F5)) + ((K_02*FE1_C1_D100[0][k] + K_12*FE1_C1_D010[0][k] + K_22*FE1_C1_D001[0][k]))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))) + (((K_02*FE1_C2_D100[0][k] + K_12*FE1_C2_D010[0][k] + K_22*FE1_C2_D001[0][k]))*((K_01*F6 + K_11*F7 + K_21*F8)) + ((K_01*FE1_C2_D100[0][k] + K_11*FE1_C2_D010[0][k] + K_21*FE1_C2_D001[0][k]))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))))/(2.00000000))*1.00000000*1.00000000))*w[1][0])*((K_01*F6 + K_11*F7 + K_21*F8)) + ((K_01*FE1_C2_D100[0][k] + K_11*FE1_C2_D010[0][k] + K_21*FE1_C2_D001[0][k]))*(w[1][0]*(2.00000000*(1.00000000*1.00000000*((((K_02*F0 + K_12*F1 + K_22*F2))*((K_01*F0 + K_11*F1 + K_21*F2)) + ((K_02*F3 + K_12*F4 + K_22*F5))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000)) + (((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))*((K_01*F6 + K_11*F7 + K_21*F8)))/(2.00000000)))))) + ((((2.00000000*(((2.00000000*(((K_02*FE1_C0_D100[0][k] + K_12*FE1_C0_D010[0][k] + K_22*FE1_C0_D001[0][k]))*((K_02*F0 + K_12*F1 + K_22*F2))) + 2.00000000*(((K_02*FE1_C1_D100[0][k] + K_12*FE1_C1_D010[0][k] + K_22*FE1_C1_D001[0][k]))*((K_02*F3 + K_12*F4 + K_22*F5))) + 2.00000000*(((K_02*FE1_C2_D100[0][k] + K_12*FE1_C2_D010[0][k] + K_22*FE1_C2_D001[0][k]))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))))/(2.00000000))*1.00000000*1.00000000))*w[1][0] + ((((2.00000000*(((K_01*FE1_C1_D100[0][k] + K_11*FE1_C1_D010[0][k] + K_21*FE1_C1_D001[0][k]))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))) + 2.00000000*(((K_01*FE1_C0_D100[0][k] + K_11*FE1_C0_D010[0][k] + K_21*FE1_C0_D001[0][k]))*((K_01*F0 + K_11*F1 + K_21*F2))) + 2.00000000*(((K_01*FE1_C2_D100[0][k] + K_11*FE1_C2_D010[0][k] + K_21*FE1_C2_D001[0][k]))*((K_01*F6 + K_11*F7 + K_21*F8))))/(2.00000000) + (2.00000000*(((K_02*FE1_C0_D100[0][k] + K_12*FE1_C0_D010[0][k] + K_22*FE1_C0_D001[0][k]))*((K_02*F0 + K_12*F1 + K_22*F2))) + 2.00000000*(((K_02*FE1_C1_D100[0][k] + K_12*FE1_C1_D010[0][k] + K_22*FE1_C1_D001[0][k]))*((K_02*F3 + K_12*F4 + K_22*F5))) + 2.00000000*(((K_02*FE1_C2_D100[0][k] + K_12*FE1_C2_D010[0][k] + K_22*FE1_C2_D001[0][k]))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))))/(2.00000000) + (2.00000000*(((K_00*FE1_C0_D100[0][k] + K_10*FE1_C0_D010[0][k] + K_20*FE1_C0_D001[0][k]))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))) + 2.00000000*(((K_00*FE1_C2_D100[0][k] + K_10*FE1_C2_D010[0][k] + K_20*FE1_C2_D001[0][k]))*((K_00*F6 + K_10*F7 + K_20*F8))) + 2.00000000*(((K_00*FE1_C1_D100[0][k] + K_10*FE1_C1_D010[0][k] + K_20*FE1_C1_D001[0][k]))*((K_00*F3 + K_10*F4 + K_20*F5))))/(2.00000000)))*2.00000000*1.00000000*1.00000000)*w[2][0]/(2.00000000)))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000)) + ((K_02*FE1_C2_D100[0][k] + K_12*FE1_C2_D010[0][k] + K_22*FE1_C2_D001[0][k]))*((w[2][0]/(2.00000000)*(((((-1.00000000)*1.00000000 + ((((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)) + ((K_00*F3 + K_10*F4 + K_20*F5))*((K_00*F3 + K_10*F4 + K_20*F5)) + ((K_00*F6 + K_10*F7 + K_20*F8))*((K_00*F6 + K_10*F7 + K_20*F8))))/(2.00000000) + ((-1.00000000)*1.00000000 + (((K_02*F0 + K_12*F1 + K_22*F2))*((K_02*F0 + K_12*F1 + K_22*F2)) + (((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000)) + ((K_02*F3 + K_12*F4 + K_22*F5))*((K_02*F3 + K_12*F4 + K_22*F5))))/(2.00000000) + ((-1.00000000)*1.00000000 + (((K_01*F0 + K_11*F1 + K_21*F2))*((K_01*F0 + K_11*F1 + K_21*F2)) + ((K_01*F6 + K_11*F7 + K_21*F8))*((K_01*F6 + K_11*F7 + K_21*F8)) + (((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))))/(2.00000000)))*2.00000000*1.00000000*1.00000000) + w[1][0]*(2.00000000*(1.00000000*1.00000000*(((-1.00000000)*1.00000000 + (((K_02*F0 + K_12*F1 + K_22*F2))*((K_02*F0 + K_12*F1 + K_22*F2)) + (((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000)) + ((K_02*F3 + K_12*F4 + K_22*F5))*((K_02*F3 + K_12*F4 + K_22*F5))))/(2.00000000)))))))))*((K_02*FE1_C2_D100[0][j] + K_12*FE1_C2_D010[0][j] + K_22*FE1_C2_D001[0][j])) + ((((((2.00000000*(((2.00000000*(((K_02*FE1_C0_D100[0][k] + K_12*FE1_C0_D010[0][k] + K_22*FE1_C0_D001[0][k]))*((K_02*F0 + K_12*F1 + K_22*F2))) + 2.00000000*(((K_02*FE1_C1_D100[0][k] + K_12*FE1_C1_D010[0][k] + K_22*FE1_C1_D001[0][k]))*((K_02*F3 + K_12*F4 + K_22*F5))) + 2.00000000*(((K_02*FE1_C2_D100[0][k] + K_12*FE1_C2_D010[0][k] + K_22*FE1_C2_D001[0][k]))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))))/(2.00000000))*1.00000000*1.00000000))*w[1][0] + ((((2.00000000*(((K_01*FE1_C1_D100[0][k] + K_11*FE1_C1_D010[0][k] + K_21*FE1_C1_D001[0][k]))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))) + 2.00000000*(((K_01*FE1_C0_D100[0][k] + K_11*FE1_C0_D010[0][k] + K_21*FE1_C0_D001[0][k]))*((K_01*F0 + K_11*F1 + K_21*F2))) + 2.00000000*(((K_01*FE1_C2_D100[0][k] + K_11*FE1_C2_D010[0][k] + K_21*FE1_C2_D001[0][k]))*((K_01*F6 + K_11*F7 + K_21*F8))))/(2.00000000) + (2.00000000*(((K_02*FE1_C0_D100[0][k] + K_12*FE1_C0_D010[0][k] + K_22*FE1_C0_D001[0][k]))*((K_02*F0 + K_12*F1 + K_22*F2))) + 2.00000000*(((K_02*FE1_C1_D100[0][k] + K_12*FE1_C1_D010[0][k] + K_22*FE1_C1_D001[0][k]))*((K_02*F3 + K_12*F4 + K_22*F5))) + 2.00000000*(((K_02*FE1_C2_D100[0][k] + K_12*FE1_C2_D010[0][k] + K_22*FE1_C2_D001[0][k]))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))))/(2.00000000) + (2.00000000*(((K_00*FE1_C0_D100[0][k] + K_10*FE1_C0_D010[0][k] + K_20*FE1_C0_D001[0][k]))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))) + 2.00000000*(((K_00*FE1_C2_D100[0][k] + K_10*FE1_C2_D010[0][k] + K_20*FE1_C2_D001[0][k]))*((K_00*F6 + K_10*F7 + K_20*F8))) + 2.00000000*(((K_00*FE1_C1_D100[0][k] + K_10*FE1_C1_D010[0][k] + K_20*FE1_C1_D001[0][k]))*((K_00*F3 + K_10*F4 + K_20*F5))))/(2.00000000)))*2.00000000*1.00000000*1.00000000)*w[2][0]/(2.00000000)))*((K_02*F3 + K_12*F4 + K_22*F5)) + ((K_02*FE1_C1_D100[0][k] + K_12*FE1_C1_D010[0][k] + K_22*FE1_C1_D001[0][k]))*((w[2][0]/(2.00000000)*(((((-1.00000000)*1.00000000 + ((((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)) + ((K_00*F3 + K_10*F4 + K_20*F5))*((K_00*F3 + K_10*F4 + K_20*F5)) + ((K_00*F6 + K_10*F7 + K_20*F8))*((K_00*F6 + K_10*F7 + K_20*F8))))/(2.00000000) + ((-1.00000000)*1.00000000 + (((K_02*F0 + K_12*F1 + K_22*F2))*((K_02*F0 + K_12*F1 + K_22*F2)) + (((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000)) + ((K_02*F3 + K_12*F4 + K_22*F5))*((K_02*F3 + K_12*F4 + K_22*F5))))/(2.00000000) + ((-1.00000000)*1.00000000 + (((K_01*F0 + K_11*F1 + K_21*F2))*((K_01*F0 + K_11*F1 + K_21*F2)) + ((K_01*F6 + K_11*F7 + K_21*F8))*((K_01*F6 + K_11*F7 + K_21*F8)) + (((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))))/(2.00000000)))*2.00000000*1.00000000*1.00000000) + w[1][0]*(2.00000000*(1.00000000*1.00000000*(((-1.00000000)*1.00000000 + (((K_02*F0 + K_12*F1 + K_22*F2))*((K_02*F0 + K_12*F1 + K_22*F2)) + (((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000)) + ((K_02*F3 + K_12*F4 + K_22*F5))*((K_02*F3 + K_12*F4 + K_22*F5))))/(2.00000000))))))) + (((K_00*FE1_C1_D100[0][k] + K_10*FE1_C1_D010[0][k] + K_20*FE1_C1_D001[0][k]))*(w[1][0]*(2.00000000*(1.00000000*1.00000000*(((((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))*((K_00*F6 + K_10*F7 + K_20*F8)) + ((K_02*F0 + K_12*F1 + K_22*F2))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)) + ((K_02*F3 + K_12*F4 + K_22*F5))*((K_00*F3 + K_10*F4 + K_20*F5)))/(2.00000000))))) + ((2.00000000*((((((K_00*FE1_C0_D100[0][k] + K_10*FE1_C0_D010[0][k] + K_20*FE1_C0_D001[0][k]))*((K_02*F0 + K_12*F1 + K_22*F2)) + ((K_02*FE1_C0_D100[0][k] + K_12*FE1_C0_D010[0][k] + K_22*FE1_C0_D001[0][k]))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))) + (((K_02*FE1_C1_D100[0][k] + K_12*FE1_C1_D010[0][k] + K_22*FE1_C1_D001[0][k]))*((K_00*F3 + K_10*F4 + K_20*F5)) + ((K_00*FE1_C1_D100[0][k] + K_10*FE1_C1_D010[0][k] + K_20*FE1_C1_D001[0][k]))*((K_02*F3 + K_12*F4 + K_22*F5))) + (((K_00*FE1_C2_D100[0][k] + K_10*FE1_C2_D010[0][k] + K_20*FE1_C2_D001[0][k]))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000)) + ((K_02*FE1_C2_D100[0][k] + K_12*FE1_C2_D010[0][k] + K_22*FE1_C2_D001[0][k]))*((K_00*F6 + K_10*F7 + K_20*F8))))/(2.00000000))*1.00000000*1.00000000))*w[1][0])*((K_00*F3 + K_10*F4 + K_20*F5))) + (((K_01*FE1_C1_D100[0][k] + K_11*FE1_C1_D010[0][k] + K_21*FE1_C1_D001[0][k]))*(w[1][0]*(2.00000000*(1.00000000*1.00000000*((((K_02*F0 + K_12*F1 + K_22*F2))*((K_01*F0 + K_11*F1 + K_21*F2)) + ((K_02*F3 + K_12*F4 + K_22*F5))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000)) + (((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))*((K_01*F6 + K_11*F7 + K_21*F8)))/(2.00000000))))) + ((2.00000000*((((((K_02*FE1_C0_D100[0][k] + K_12*FE1_C0_D010[0][k] + K_22*FE1_C0_D001[0][k]))*((K_01*F0 + K_11*F1 + K_21*F2)) + ((K_01*FE1_C0_D100[0][k] + K_11*FE1_C0_D010[0][k] + K_21*FE1_C0_D001[0][k]))*((K_02*F0 + K_12*F1 + K_22*F2))) + (((K_01*FE1_C1_D100[0][k] + K_11*FE1_C1_D010[0][k] + K_21*FE1_C1_D001[0][k]))*((K_02*F3 + K_12*F4 + K_22*F5)) + ((K_02*FE1_C1_D100[0][k] + K_12*FE1_C1_D010[0][k] + K_22*FE1_C1_D001[0][k]))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))) + (((K_02*FE1_C2_D100[0][k] + K_12*FE1_C2_D010[0][k] + K_22*FE1_C2_D001[0][k]))*((K_01*F6 + K_11*F7 + K_21*F8)) + ((K_01*FE1_C2_D100[0][k] + K_11*FE1_C2_D010[0][k] + K_21*FE1_C2_D001[0][k]))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))))/(2.00000000))*1.00000000*1.00000000))*w[1][0])*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000)))))*((K_02*FE1_C1_D100[0][j] + K_12*FE1_C1_D010[0][j] + K_22*FE1_C1_D001[0][j])) + (((((K_01*FE1_C0_D100[0][k] + K_11*FE1_C0_D010[0][k] + K_21*FE1_C0_D001[0][k]))*(w[1][0]*(2.00000000*(1.00000000*1.00000000*((((K_02*F0 + K_12*F1 + K_22*F2))*((K_01*F0 + K_11*F1 + K_21*F2)) + ((K_02*F3 + K_12*F4 + K_22*F5))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000)) + (((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))*((K_01*F6 + K_11*F7 + K_21*F8)))/(2.00000000))))) + ((2.00000000*((((((K_02*FE1_C0_D100[0][k] + K_12*FE1_C0_D010[0][k] + K_22*FE1_C0_D001[0][k]))*((K_01*F0 + K_11*F1 + K_21*F2)) + ((K_01*FE1_C0_D100[0][k] + K_11*FE1_C0_D010[0][k] + K_21*FE1_C0_D001[0][k]))*((K_02*F0 + K_12*F1 + K_22*F2))) + (((K_01*FE1_C1_D100[0][k] + K_11*FE1_C1_D010[0][k] + K_21*FE1_C1_D001[0][k]))*((K_02*F3 + K_12*F4 + K_22*F5)) + ((K_02*FE1_C1_D100[0][k] + K_12*FE1_C1_D010[0][k] + K_22*FE1_C1_D001[0][k]))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))) + (((K_02*FE1_C2_D100[0][k] + K_12*FE1_C2_D010[0][k] + K_22*FE1_C2_D001[0][k]))*((K_01*F6 + K_11*F7 + K_21*F8)) + ((K_01*FE1_C2_D100[0][k] + K_11*FE1_C2_D010[0][k] + K_21*FE1_C2_D001[0][k]))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))))/(2.00000000))*1.00000000*1.00000000))*w[1][0])*((K_01*F0 + K_11*F1 + K_21*F2))) + (((K_00*FE1_C0_D100[0][k] + K_10*FE1_C0_D010[0][k] + K_20*FE1_C0_D001[0][k]))*(w[1][0]*(2.00000000*(1.00000000*1.00000000*(((((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))*((K_00*F6 + K_10*F7 + K_20*F8)) + ((K_02*F0 + K_12*F1 + K_22*F2))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)) + ((K_02*F3 + K_12*F4 + K_22*F5))*((K_00*F3 + K_10*F4 + K_20*F5)))/(2.00000000))))) + ((2.00000000*((((((K_00*FE1_C0_D100[0][k] + K_10*FE1_C0_D010[0][k] + K_20*FE1_C0_D001[0][k]))*((K_02*F0 + K_12*F1 + K_22*F2)) + ((K_02*FE1_C0_D100[0][k] + K_12*FE1_C0_D010[0][k] + K_22*FE1_C0_D001[0][k]))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))) + (((K_02*FE1_C1_D100[0][k] + K_12*FE1_C1_D010[0][k] + K_22*FE1_C1_D001[0][k]))*((K_00*F3 + K_10*F4 + K_20*F5)) + ((K_00*FE1_C1_D100[0][k] + K_10*FE1_C1_D010[0][k] + K_20*FE1_C1_D001[0][k]))*((K_02*F3 + K_12*F4 + K_22*F5))) + (((K_00*FE1_C2_D100[0][k] + K_10*FE1_C2_D010[0][k] + K_20*FE1_C2_D001[0][k]))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000)) + ((K_02*FE1_C2_D100[0][k] + K_12*FE1_C2_D010[0][k] + K_22*FE1_C2_D001[0][k]))*((K_00*F6 + K_10*F7 + K_20*F8))))/(2.00000000))*1.00000000*1.00000000))*w[1][0])*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))) + ((((2.00000000*(((2.00000000*(((K_02*FE1_C0_D100[0][k] + K_12*FE1_C0_D010[0][k] + K_22*FE1_C0_D001[0][k]))*((K_02*F0 + K_12*F1 + K_22*F2))) + 2.00000000*(((K_02*FE1_C1_D100[0][k] + K_12*FE1_C1_D010[0][k] + K_22*FE1_C1_D001[0][k]))*((K_02*F3 + K_12*F4 + K_22*F5))) + 2.00000000*(((K_02*FE1_C2_D100[0][k] + K_12*FE1_C2_D010[0][k] + K_22*FE1_C2_D001[0][k]))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))))/(2.00000000))*1.00000000*1.00000000))*w[1][0] + ((((2.00000000*(((K_01*FE1_C1_D100[0][k] + K_11*FE1_C1_D010[0][k] + K_21*FE1_C1_D001[0][k]))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))) + 2.00000000*(((K_01*FE1_C0_D100[0][k] + K_11*FE1_C0_D010[0][k] + K_21*FE1_C0_D001[0][k]))*((K_01*F0 + K_11*F1 + K_21*F2))) + 2.00000000*(((K_01*FE1_C2_D100[0][k] + K_11*FE1_C2_D010[0][k] + K_21*FE1_C2_D001[0][k]))*((K_01*F6 + K_11*F7 + K_21*F8))))/(2.00000000) + (2.00000000*(((K_02*FE1_C0_D100[0][k] + K_12*FE1_C0_D010[0][k] + K_22*FE1_C0_D001[0][k]))*((K_02*F0 + K_12*F1 + K_22*F2))) + 2.00000000*(((K_02*FE1_C1_D100[0][k] + K_12*FE1_C1_D010[0][k] + K_22*FE1_C1_D001[0][k]))*((K_02*F3 + K_12*F4 + K_22*F5))) + 2.00000000*(((K_02*FE1_C2_D100[0][k] + K_12*FE1_C2_D010[0][k] + K_22*FE1_C2_D001[0][k]))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))))/(2.00000000) + (2.00000000*(((K_00*FE1_C0_D100[0][k] + K_10*FE1_C0_D010[0][k] + K_20*FE1_C0_D001[0][k]))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))) + 2.00000000*(((K_00*FE1_C2_D100[0][k] + K_10*FE1_C2_D010[0][k] + K_20*FE1_C2_D001[0][k]))*((K_00*F6 + K_10*F7 + K_20*F8))) + 2.00000000*(((K_00*FE1_C1_D100[0][k] + K_10*FE1_C1_D010[0][k] + K_20*FE1_C1_D001[0][k]))*((K_00*F3 + K_10*F4 + K_20*F5))))/(2.00000000)))*2.00000000*1.00000000*1.00000000)*w[2][0]/(2.00000000)))*((K_02*F0 + K_12*F1 + K_22*F2)) + ((K_02*FE1_C0_D100[0][k] + K_12*FE1_C0_D010[0][k] + K_22*FE1_C0_D001[0][k]))*((w[2][0]/(2.00000000)*(((((-1.00000000)*1.00000000 + ((((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)) + ((K_00*F3 + K_10*F4 + K_20*F5))*((K_00*F3 + K_10*F4 + K_20*F5)) + ((K_00*F6 + K_10*F7 + K_20*F8))*((K_00*F6 + K_10*F7 + K_20*F8))))/(2.00000000) + ((-1.00000000)*1.00000000 + (((K_02*F0 + K_12*F1 + K_22*F2))*((K_02*F0 + K_12*F1 + K_22*F2)) + (((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000)) + ((K_02*F3 + K_12*F4 + K_22*F5))*((K_02*F3 + K_12*F4 + K_22*F5))))/(2.00000000) + ((-1.00000000)*1.00000000 + (((K_01*F0 + K_11*F1 + K_21*F2))*((K_01*F0 + K_11*F1 + K_21*F2)) + ((K_01*F6 + K_11*F7 + K_21*F8))*((K_01*F6 + K_11*F7 + K_21*F8)) + (((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))))/(2.00000000)))*2.00000000*1.00000000*1.00000000) + w[1][0]*(2.00000000*(1.00000000*1.00000000*(((-1.00000000)*1.00000000 + (((K_02*F0 + K_12*F1 + K_22*F2))*((K_02*F0 + K_12*F1 + K_22*F2)) + (((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000)) + ((K_02*F3 + K_12*F4 + K_22*F5))*((K_02*F3 + K_12*F4 + K_22*F5))))/(2.00000000)))))))))*((K_02*FE1_C0_D100[0][j] + K_12*FE1_C0_D010[0][j] + K_22*FE1_C0_D001[0][j]))))*W1*det;
      }// end loop over 'k'
    }// end loop over 'j'
  }

  /// Tabulate the tensor for the contribution from a local cell
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    std::cerr << "*** FFC warning: " << "Quadrature version of tabulate_tensor not yet implemented (introduced in UFC 2.0)." << std::endl;
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class hyperelasticity_cell_integral_1_0: public ufc::cell_integral
{
public:

  /// Constructor
  hyperelasticity_cell_integral_1_0() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~hyperelasticity_cell_integral_1_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Cell Volume.
    
    // Compute circumradius.
    
    
    // Array of quadrature weights.
    static const double W8[8] = {0.03697986, 0.01602704, 0.02115701, 0.00916943, 0.03697986, 0.01602704, 0.02115701, 0.00916943};
    // Quadrature points on the UFC reference element: (0.15668264, 0.13605498, 0.12251482), (0.08139567, 0.07067972, 0.54415184), (0.06583869, 0.56593317, 0.12251482), (0.03420279, 0.29399880, 0.54415184), (0.58474756, 0.13605498, 0.12251482), (0.30377276, 0.07067972, 0.54415184), (0.24571333, 0.56593317, 0.12251482), (0.12764656, 0.29399880, 0.54415184)
    
    // Value of basis functions at quadrature points.
    static const double FE1_C0[8][12] = \
    {{0.58474756, 0.15668264, 0.13605498, 0.12251482, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.30377276, 0.08139567, 0.07067972, 0.54415184, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.24571333, 0.06583869, 0.56593317, 0.12251482, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.12764656, 0.03420279, 0.29399880, 0.54415184, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.15668264, 0.58474756, 0.13605498, 0.12251482, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.08139567, 0.30377276, 0.07067972, 0.54415184, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.06583869, 0.24571333, 0.56593317, 0.12251482, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.03420279, 0.12764656, 0.29399880, 0.54415184, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
    
    static const double FE1_C0_D001[8][12] = \
    {{-1.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-1.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-1.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-1.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-1.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-1.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-1.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-1.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
    
    static const double FE1_C0_D010[8][12] = \
    {{-1.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-1.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-1.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-1.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-1.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-1.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-1.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-1.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
    
    static const double FE1_C0_D100[8][12] = \
    {{-1.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-1.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-1.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-1.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-1.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-1.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-1.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {-1.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
    
    static const double FE1_C1[8][12] = \
    {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.58474756, 0.15668264, 0.13605498, 0.12251482, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.30377276, 0.08139567, 0.07067972, 0.54415184, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.24571333, 0.06583869, 0.56593317, 0.12251482, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.12764656, 0.03420279, 0.29399880, 0.54415184, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.15668264, 0.58474756, 0.13605498, 0.12251482, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.08139567, 0.30377276, 0.07067972, 0.54415184, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.06583869, 0.24571333, 0.56593317, 0.12251482, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.03420279, 0.12764656, 0.29399880, 0.54415184, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
    
    static const double FE1_C1_D001[8][12] = \
    {{0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
    
    static const double FE1_C1_D010[8][12] = \
    {{0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
    
    static const double FE1_C1_D100[8][12] = \
    {{0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
    
    static const double FE1_C2[8][12] = \
    {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.58474756, 0.15668264, 0.13605498, 0.12251482},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.30377276, 0.08139567, 0.07067972, 0.54415184},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.24571333, 0.06583869, 0.56593317, 0.12251482},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.12764656, 0.03420279, 0.29399880, 0.54415184},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.15668264, 0.58474756, 0.13605498, 0.12251482},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.08139567, 0.30377276, 0.07067972, 0.54415184},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.06583869, 0.24571333, 0.56593317, 0.12251482},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.03420279, 0.12764656, 0.29399880, 0.54415184}};
    
    static const double FE1_C2_D001[8][12] = \
    {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 0.00000000, 1.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 0.00000000, 1.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 0.00000000, 1.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 0.00000000, 1.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 0.00000000, 1.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 0.00000000, 1.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 0.00000000, 1.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 0.00000000, 1.00000000}};
    
    static const double FE1_C2_D010[8][12] = \
    {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 1.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 1.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 1.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 1.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 1.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 1.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 1.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 0.00000000, 1.00000000, 0.00000000}};
    
    static const double FE1_C2_D100[8][12] = \
    {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 1.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 1.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 1.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 1.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 1.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 1.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 1.00000000, 0.00000000, 0.00000000},
    {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -1.00000000, 1.00000000, 0.00000000, 0.00000000}};
    
    // Reset values in the element tensor.
    for (unsigned int r = 0; r < 12; r++)
    {
      A[r] = 0.00000000;
    }// end loop over 'r'
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('eliminate zeros', False), ('ignore ones', False), ('ignore zero tables', False), ('optimisation', False), ('remove zero terms', False)
    
    // Loop quadrature points for integral.
    // Number of operations to compute element tensor for following IP loop = 242496
    for (unsigned int ip = 0; ip < 8; ip++)
    {
      
      // Coefficient declarations.
      double F0 = 0.00000000;
      double F1 = 0.00000000;
      double F2 = 0.00000000;
      double F3 = 0.00000000;
      double F4 = 0.00000000;
      double F5 = 0.00000000;
      double F6 = 0.00000000;
      double F7 = 0.00000000;
      double F8 = 0.00000000;
      double F9 = 0.00000000;
      double F10 = 0.00000000;
      double F11 = 0.00000000;
      
      // Total number of operations to compute function values = 288
      for (unsigned int r = 0; r < 12; r++)
      {
        F0 += FE1_C0_D100[ip][r]*w[0][r];
        F1 += FE1_C0_D010[ip][r]*w[0][r];
        F2 += FE1_C0_D001[ip][r]*w[0][r];
        F3 += FE1_C1_D100[ip][r]*w[0][r];
        F4 += FE1_C1_D010[ip][r]*w[0][r];
        F5 += FE1_C1_D001[ip][r]*w[0][r];
        F6 += FE1_C2_D100[ip][r]*w[0][r];
        F7 += FE1_C2_D010[ip][r]*w[0][r];
        F8 += FE1_C2_D001[ip][r]*w[0][r];
        F9 += FE1_C0[ip][r]*w[1][r];
        F10 += FE1_C1[ip][r]*w[1][r];
        F11 += FE1_C2[ip][r]*w[1][r];
      }// end loop over 'r'
      
      // Number of operations for primary indices: 30024
      for (unsigned int j = 0; j < 12; j++)
      {
        // Number of operations to compute entry: 2502
        A[j] += (((((K_01*FE1_C1_D100[ip][j] + K_11*FE1_C1_D010[ip][j] + K_21*FE1_C1_D001[ip][j]))*((((K_00*F3 + K_10*F4 + K_20*F5))*(w[3][0]*(2.00000000*(1.00000000*1.00000000*(((((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))*((K_00*F3 + K_10*F4 + K_20*F5)) + ((K_01*F6 + K_11*F7 + K_21*F8))*((K_00*F6 + K_10*F7 + K_20*F8)) + ((K_01*F0 + K_11*F1 + K_21*F2))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)))/(2.00000000))))) + (((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))*((w[3][0]*(2.00000000*(1.00000000*1.00000000*(((-1.00000000)*1.00000000 + (((K_01*F0 + K_11*F1 + K_21*F2))*((K_01*F0 + K_11*F1 + K_21*F2)) + ((K_01*F6 + K_11*F7 + K_21*F8))*((K_01*F6 + K_11*F7 + K_21*F8)) + (((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))))/(2.00000000)))) + w[4][0]/(2.00000000)*(((((-1.00000000)*1.00000000 + ((((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)) + ((K_00*F3 + K_10*F4 + K_20*F5))*((K_00*F3 + K_10*F4 + K_20*F5)) + ((K_00*F6 + K_10*F7 + K_20*F8))*((K_00*F6 + K_10*F7 + K_20*F8))))/(2.00000000) + ((-1.00000000)*1.00000000 + (((K_02*F0 + K_12*F1 + K_22*F2))*((K_02*F0 + K_12*F1 + K_22*F2)) + (((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000)) + ((K_02*F3 + K_12*F4 + K_22*F5))*((K_02*F3 + K_12*F4 + K_22*F5))))/(2.00000000) + ((-1.00000000)*1.00000000 + (((K_01*F0 + K_11*F1 + K_21*F2))*((K_01*F0 + K_11*F1 + K_21*F2)) + ((K_01*F6 + K_11*F7 + K_21*F8))*((K_01*F6 + K_11*F7 + K_21*F8)) + (((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))))/(2.00000000)))*2.00000000*1.00000000*1.00000000))) + ((K_02*F3 + K_12*F4 + K_22*F5))*(w[3][0]*(2.00000000*(1.00000000*1.00000000*((((K_01*F0 + K_11*F1 + K_21*F2))*((K_02*F0 + K_12*F1 + K_22*F2)) + ((K_01*F6 + K_11*F7 + K_21*F8))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000)) + (((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))*((K_02*F3 + K_12*F4 + K_22*F5)))/(2.00000000))))))) + ((K_01*FE1_C2_D100[ip][j] + K_11*FE1_C2_D010[ip][j] + K_21*FE1_C2_D001[ip][j]))*((((K_00*F6 + K_10*F7 + K_20*F8))*(w[3][0]*(2.00000000*(1.00000000*1.00000000*(((((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))*((K_00*F3 + K_10*F4 + K_20*F5)) + ((K_01*F6 + K_11*F7 + K_21*F8))*((K_00*F6 + K_10*F7 + K_20*F8)) + ((K_01*F0 + K_11*F1 + K_21*F2))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)))/(2.00000000))))) + ((K_01*F6 + K_11*F7 + K_21*F8))*((w[3][0]*(2.00000000*(1.00000000*1.00000000*(((-1.00000000)*1.00000000 + (((K_01*F0 + K_11*F1 + K_21*F2))*((K_01*F0 + K_11*F1 + K_21*F2)) + ((K_01*F6 + K_11*F7 + K_21*F8))*((K_01*F6 + K_11*F7 + K_21*F8)) + (((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))))/(2.00000000)))) + w[4][0]/(2.00000000)*(((((-1.00000000)*1.00000000 + ((((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)) + ((K_00*F3 + K_10*F4 + K_20*F5))*((K_00*F3 + K_10*F4 + K_20*F5)) + ((K_00*F6 + K_10*F7 + K_20*F8))*((K_00*F6 + K_10*F7 + K_20*F8))))/(2.00000000) + ((-1.00000000)*1.00000000 + (((K_02*F0 + K_12*F1 + K_22*F2))*((K_02*F0 + K_12*F1 + K_22*F2)) + (((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000)) + ((K_02*F3 + K_12*F4 + K_22*F5))*((K_02*F3 + K_12*F4 + K_22*F5))))/(2.00000000) + ((-1.00000000)*1.00000000 + (((K_01*F0 + K_11*F1 + K_21*F2))*((K_01*F0 + K_11*F1 + K_21*F2)) + ((K_01*F6 + K_11*F7 + K_21*F8))*((K_01*F6 + K_11*F7 + K_21*F8)) + (((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))))/(2.00000000)))*2.00000000*1.00000000*1.00000000))) + (((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))*(w[3][0]*(2.00000000*(1.00000000*1.00000000*((((K_01*F0 + K_11*F1 + K_21*F2))*((K_02*F0 + K_12*F1 + K_22*F2)) + ((K_01*F6 + K_11*F7 + K_21*F8))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000)) + (((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))*((K_02*F3 + K_12*F4 + K_22*F5)))/(2.00000000))))))) + ((K_01*FE1_C0_D100[ip][j] + K_11*FE1_C0_D010[ip][j] + K_21*FE1_C0_D001[ip][j]))*((((K_02*F0 + K_12*F1 + K_22*F2))*(w[3][0]*(2.00000000*(1.00000000*1.00000000*((((K_01*F0 + K_11*F1 + K_21*F2))*((K_02*F0 + K_12*F1 + K_22*F2)) + ((K_01*F6 + K_11*F7 + K_21*F8))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000)) + (((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))*((K_02*F3 + K_12*F4 + K_22*F5)))/(2.00000000))))) + ((K_01*F0 + K_11*F1 + K_21*F2))*((w[3][0]*(2.00000000*(1.00000000*1.00000000*(((-1.00000000)*1.00000000 + (((K_01*F0 + K_11*F1 + K_21*F2))*((K_01*F0 + K_11*F1 + K_21*F2)) + ((K_01*F6 + K_11*F7 + K_21*F8))*((K_01*F6 + K_11*F7 + K_21*F8)) + (((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))))/(2.00000000)))) + w[4][0]/(2.00000000)*(((((-1.00000000)*1.00000000 + ((((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)) + ((K_00*F3 + K_10*F4 + K_20*F5))*((K_00*F3 + K_10*F4 + K_20*F5)) + ((K_00*F6 + K_10*F7 + K_20*F8))*((K_00*F6 + K_10*F7 + K_20*F8))))/(2.00000000) + ((-1.00000000)*1.00000000 + (((K_02*F0 + K_12*F1 + K_22*F2))*((K_02*F0 + K_12*F1 + K_22*F2)) + (((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000)) + ((K_02*F3 + K_12*F4 + K_22*F5))*((K_02*F3 + K_12*F4 + K_22*F5))))/(2.00000000) + ((-1.00000000)*1.00000000 + (((K_01*F0 + K_11*F1 + K_21*F2))*((K_01*F0 + K_11*F1 + K_21*F2)) + ((K_01*F6 + K_11*F7 + K_21*F8))*((K_01*F6 + K_11*F7 + K_21*F8)) + (((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))))/(2.00000000)))*2.00000000*1.00000000*1.00000000))) + (((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))*(w[3][0]*(2.00000000*(1.00000000*1.00000000*(((((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))*((K_00*F3 + K_10*F4 + K_20*F5)) + ((K_01*F6 + K_11*F7 + K_21*F8))*((K_00*F6 + K_10*F7 + K_20*F8)) + ((K_01*F0 + K_11*F1 + K_21*F2))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)))/(2.00000000)))))))) + (((K_02*FE1_C0_D100[ip][j] + K_12*FE1_C0_D010[ip][j] + K_22*FE1_C0_D001[ip][j]))*(((((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))*(w[3][0]*(2.00000000*(1.00000000*1.00000000*(((((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))*((K_00*F6 + K_10*F7 + K_20*F8)) + ((K_02*F0 + K_12*F1 + K_22*F2))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)) + ((K_02*F3 + K_12*F4 + K_22*F5))*((K_00*F3 + K_10*F4 + K_20*F5)))/(2.00000000))))) + ((K_01*F0 + K_11*F1 + K_21*F2))*(w[3][0]*(2.00000000*(1.00000000*1.00000000*((((K_02*F0 + K_12*F1 + K_22*F2))*((K_01*F0 + K_11*F1 + K_21*F2)) + ((K_02*F3 + K_12*F4 + K_22*F5))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000)) + (((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))*((K_01*F6 + K_11*F7 + K_21*F8)))/(2.00000000))))) + ((K_02*F0 + K_12*F1 + K_22*F2))*((w[3][0]*(2.00000000*(1.00000000*1.00000000*(((-1.00000000)*1.00000000 + (((K_02*F0 + K_12*F1 + K_22*F2))*((K_02*F0 + K_12*F1 + K_22*F2)) + (((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000)) + ((K_02*F3 + K_12*F4 + K_22*F5))*((K_02*F3 + K_12*F4 + K_22*F5))))/(2.00000000)))) + w[4][0]/(2.00000000)*(((((-1.00000000)*1.00000000 + ((((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)) + ((K_00*F3 + K_10*F4 + K_20*F5))*((K_00*F3 + K_10*F4 + K_20*F5)) + ((K_00*F6 + K_10*F7 + K_20*F8))*((K_00*F6 + K_10*F7 + K_20*F8))))/(2.00000000) + ((-1.00000000)*1.00000000 + (((K_02*F0 + K_12*F1 + K_22*F2))*((K_02*F0 + K_12*F1 + K_22*F2)) + (((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000)) + ((K_02*F3 + K_12*F4 + K_22*F5))*((K_02*F3 + K_12*F4 + K_22*F5))))/(2.00000000) + ((-1.00000000)*1.00000000 + (((K_01*F0 + K_11*F1 + K_21*F2))*((K_01*F0 + K_11*F1 + K_21*F2)) + ((K_01*F6 + K_11*F7 + K_21*F8))*((K_01*F6 + K_11*F7 + K_21*F8)) + (((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))))/(2.00000000)))*2.00000000*1.00000000*1.00000000))))) + ((K_02*FE1_C1_D100[ip][j] + K_12*FE1_C1_D010[ip][j] + K_22*FE1_C1_D001[ip][j]))*((((K_00*F3 + K_10*F4 + K_20*F5))*(w[3][0]*(2.00000000*(1.00000000*1.00000000*(((((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))*((K_00*F6 + K_10*F7 + K_20*F8)) + ((K_02*F0 + K_12*F1 + K_22*F2))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)) + ((K_02*F3 + K_12*F4 + K_22*F5))*((K_00*F3 + K_10*F4 + K_20*F5)))/(2.00000000))))) + (((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))*(w[3][0]*(2.00000000*(1.00000000*1.00000000*((((K_02*F0 + K_12*F1 + K_22*F2))*((K_01*F0 + K_11*F1 + K_21*F2)) + ((K_02*F3 + K_12*F4 + K_22*F5))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000)) + (((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))*((K_01*F6 + K_11*F7 + K_21*F8)))/(2.00000000))))) + ((K_02*F3 + K_12*F4 + K_22*F5))*((w[3][0]*(2.00000000*(1.00000000*1.00000000*(((-1.00000000)*1.00000000 + (((K_02*F0 + K_12*F1 + K_22*F2))*((K_02*F0 + K_12*F1 + K_22*F2)) + (((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000)) + ((K_02*F3 + K_12*F4 + K_22*F5))*((K_02*F3 + K_12*F4 + K_22*F5))))/(2.00000000)))) + w[4][0]/(2.00000000)*(((((-1.00000000)*1.00000000 + ((((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)) + ((K_00*F3 + K_10*F4 + K_20*F5))*((K_00*F3 + K_10*F4 + K_20*F5)) + ((K_00*F6 + K_10*F7 + K_20*F8))*((K_00*F6 + K_10*F7 + K_20*F8))))/(2.00000000) + ((-1.00000000)*1.00000000 + (((K_02*F0 + K_12*F1 + K_22*F2))*((K_02*F0 + K_12*F1 + K_22*F2)) + (((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000)) + ((K_02*F3 + K_12*F4 + K_22*F5))*((K_02*F3 + K_12*F4 + K_22*F5))))/(2.00000000) + ((-1.00000000)*1.00000000 + (((K_01*F0 + K_11*F1 + K_21*F2))*((K_01*F0 + K_11*F1 + K_21*F2)) + ((K_01*F6 + K_11*F7 + K_21*F8))*((K_01*F6 + K_11*F7 + K_21*F8)) + (((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))))/(2.00000000)))*2.00000000*1.00000000*1.00000000))))) + ((K_02*FE1_C2_D100[ip][j] + K_12*FE1_C2_D010[ip][j] + K_22*FE1_C2_D001[ip][j]))*(((((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))*((w[3][0]*(2.00000000*(1.00000000*1.00000000*(((-1.00000000)*1.00000000 + (((K_02*F0 + K_12*F1 + K_22*F2))*((K_02*F0 + K_12*F1 + K_22*F2)) + (((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000)) + ((K_02*F3 + K_12*F4 + K_22*F5))*((K_02*F3 + K_12*F4 + K_22*F5))))/(2.00000000)))) + w[4][0]/(2.00000000)*(((((-1.00000000)*1.00000000 + ((((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)) + ((K_00*F3 + K_10*F4 + K_20*F5))*((K_00*F3 + K_10*F4 + K_20*F5)) + ((K_00*F6 + K_10*F7 + K_20*F8))*((K_00*F6 + K_10*F7 + K_20*F8))))/(2.00000000) + ((-1.00000000)*1.00000000 + (((K_02*F0 + K_12*F1 + K_22*F2))*((K_02*F0 + K_12*F1 + K_22*F2)) + (((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000)) + ((K_02*F3 + K_12*F4 + K_22*F5))*((K_02*F3 + K_12*F4 + K_22*F5))))/(2.00000000) + ((-1.00000000)*1.00000000 + (((K_01*F0 + K_11*F1 + K_21*F2))*((K_01*F0 + K_11*F1 + K_21*F2)) + ((K_01*F6 + K_11*F7 + K_21*F8))*((K_01*F6 + K_11*F7 + K_21*F8)) + (((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))))/(2.00000000)))*2.00000000*1.00000000*1.00000000))) + ((K_01*F6 + K_11*F7 + K_21*F8))*(w[3][0]*(2.00000000*(1.00000000*1.00000000*((((K_02*F0 + K_12*F1 + K_22*F2))*((K_01*F0 + K_11*F1 + K_21*F2)) + ((K_02*F3 + K_12*F4 + K_22*F5))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000)) + (((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))*((K_01*F6 + K_11*F7 + K_21*F8)))/(2.00000000))))) + ((K_00*F6 + K_10*F7 + K_20*F8))*(w[3][0]*(2.00000000*(1.00000000*1.00000000*(((((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))*((K_00*F6 + K_10*F7 + K_20*F8)) + ((K_02*F0 + K_12*F1 + K_22*F2))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)) + ((K_02*F3 + K_12*F4 + K_22*F5))*((K_00*F3 + K_10*F4 + K_20*F5)))/(2.00000000)))))))) + (((K_00*FE1_C1_D100[ip][j] + K_10*FE1_C1_D010[ip][j] + K_20*FE1_C1_D001[ip][j]))*(((((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))*(w[3][0]*(2.00000000*(1.00000000*1.00000000*((((K_00*F6 + K_10*F7 + K_20*F8))*((K_01*F6 + K_11*F7 + K_21*F8)) + (((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))*((K_01*F0 + K_11*F1 + K_21*F2)) + ((K_00*F3 + K_10*F4 + K_20*F5))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000)))/(2.00000000))))) + ((K_00*F3 + K_10*F4 + K_20*F5))*((w[3][0]*(2.00000000*(1.00000000*1.00000000*(((-1.00000000)*1.00000000 + ((((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)) + ((K_00*F3 + K_10*F4 + K_20*F5))*((K_00*F3 + K_10*F4 + K_20*F5)) + ((K_00*F6 + K_10*F7 + K_20*F8))*((K_00*F6 + K_10*F7 + K_20*F8))))/(2.00000000)))) + w[4][0]/(2.00000000)*(((((-1.00000000)*1.00000000 + ((((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)) + ((K_00*F3 + K_10*F4 + K_20*F5))*((K_00*F3 + K_10*F4 + K_20*F5)) + ((K_00*F6 + K_10*F7 + K_20*F8))*((K_00*F6 + K_10*F7 + K_20*F8))))/(2.00000000) + ((-1.00000000)*1.00000000 + (((K_02*F0 + K_12*F1 + K_22*F2))*((K_02*F0 + K_12*F1 + K_22*F2)) + (((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000)) + ((K_02*F3 + K_12*F4 + K_22*F5))*((K_02*F3 + K_12*F4 + K_22*F5))))/(2.00000000) + ((-1.00000000)*1.00000000 + (((K_01*F0 + K_11*F1 + K_21*F2))*((K_01*F0 + K_11*F1 + K_21*F2)) + ((K_01*F6 + K_11*F7 + K_21*F8))*((K_01*F6 + K_11*F7 + K_21*F8)) + (((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))))/(2.00000000)))*2.00000000*1.00000000*1.00000000))) + ((K_02*F3 + K_12*F4 + K_22*F5))*(w[3][0]*(2.00000000*(1.00000000*1.00000000*((((K_00*F3 + K_10*F4 + K_20*F5))*((K_02*F3 + K_12*F4 + K_22*F5)) + (((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))*((K_02*F0 + K_12*F1 + K_22*F2)) + ((K_00*F6 + K_10*F7 + K_20*F8))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000)))/(2.00000000))))))) + ((K_00*FE1_C2_D100[ip][j] + K_10*FE1_C2_D010[ip][j] + K_20*FE1_C2_D001[ip][j]))*((((K_00*F6 + K_10*F7 + K_20*F8))*((w[3][0]*(2.00000000*(1.00000000*1.00000000*(((-1.00000000)*1.00000000 + ((((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)) + ((K_00*F3 + K_10*F4 + K_20*F5))*((K_00*F3 + K_10*F4 + K_20*F5)) + ((K_00*F6 + K_10*F7 + K_20*F8))*((K_00*F6 + K_10*F7 + K_20*F8))))/(2.00000000)))) + w[4][0]/(2.00000000)*(((((-1.00000000)*1.00000000 + ((((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)) + ((K_00*F3 + K_10*F4 + K_20*F5))*((K_00*F3 + K_10*F4 + K_20*F5)) + ((K_00*F6 + K_10*F7 + K_20*F8))*((K_00*F6 + K_10*F7 + K_20*F8))))/(2.00000000) + ((-1.00000000)*1.00000000 + (((K_02*F0 + K_12*F1 + K_22*F2))*((K_02*F0 + K_12*F1 + K_22*F2)) + (((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000)) + ((K_02*F3 + K_12*F4 + K_22*F5))*((K_02*F3 + K_12*F4 + K_22*F5))))/(2.00000000) + ((-1.00000000)*1.00000000 + (((K_01*F0 + K_11*F1 + K_21*F2))*((K_01*F0 + K_11*F1 + K_21*F2)) + ((K_01*F6 + K_11*F7 + K_21*F8))*((K_01*F6 + K_11*F7 + K_21*F8)) + (((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))))/(2.00000000)))*2.00000000*1.00000000*1.00000000))) + ((K_01*F6 + K_11*F7 + K_21*F8))*(w[3][0]*(2.00000000*(1.00000000*1.00000000*((((K_00*F6 + K_10*F7 + K_20*F8))*((K_01*F6 + K_11*F7 + K_21*F8)) + (((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))*((K_01*F0 + K_11*F1 + K_21*F2)) + ((K_00*F3 + K_10*F4 + K_20*F5))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000)))/(2.00000000))))) + (((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))*(w[3][0]*(2.00000000*(1.00000000*1.00000000*((((K_00*F3 + K_10*F4 + K_20*F5))*((K_02*F3 + K_12*F4 + K_22*F5)) + (((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))*((K_02*F0 + K_12*F1 + K_22*F2)) + ((K_00*F6 + K_10*F7 + K_20*F8))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000)))/(2.00000000))))))) + ((K_00*FE1_C0_D100[ip][j] + K_10*FE1_C0_D010[ip][j] + K_20*FE1_C0_D001[ip][j]))*((((K_02*F0 + K_12*F1 + K_22*F2))*(w[3][0]*(2.00000000*(1.00000000*1.00000000*((((K_00*F3 + K_10*F4 + K_20*F5))*((K_02*F3 + K_12*F4 + K_22*F5)) + (((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))*((K_02*F0 + K_12*F1 + K_22*F2)) + ((K_00*F6 + K_10*F7 + K_20*F8))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000)))/(2.00000000))))) + ((K_01*F0 + K_11*F1 + K_21*F2))*(w[3][0]*(2.00000000*(1.00000000*1.00000000*((((K_00*F6 + K_10*F7 + K_20*F8))*((K_01*F6 + K_11*F7 + K_21*F8)) + (((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))*((K_01*F0 + K_11*F1 + K_21*F2)) + ((K_00*F3 + K_10*F4 + K_20*F5))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000)))/(2.00000000))))) + (((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))*((w[3][0]*(2.00000000*(1.00000000*1.00000000*(((-1.00000000)*1.00000000 + ((((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)) + ((K_00*F3 + K_10*F4 + K_20*F5))*((K_00*F3 + K_10*F4 + K_20*F5)) + ((K_00*F6 + K_10*F7 + K_20*F8))*((K_00*F6 + K_10*F7 + K_20*F8))))/(2.00000000)))) + w[4][0]/(2.00000000)*(((((-1.00000000)*1.00000000 + ((((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000))*(((K_00*F0 + K_10*F1 + K_20*F2) + 1.00000000)) + ((K_00*F3 + K_10*F4 + K_20*F5))*((K_00*F3 + K_10*F4 + K_20*F5)) + ((K_00*F6 + K_10*F7 + K_20*F8))*((K_00*F6 + K_10*F7 + K_20*F8))))/(2.00000000) + ((-1.00000000)*1.00000000 + (((K_02*F0 + K_12*F1 + K_22*F2))*((K_02*F0 + K_12*F1 + K_22*F2)) + (((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000))*(((K_02*F6 + K_12*F7 + K_22*F8) + 1.00000000)) + ((K_02*F3 + K_12*F4 + K_22*F5))*((K_02*F3 + K_12*F4 + K_22*F5))))/(2.00000000) + ((-1.00000000)*1.00000000 + (((K_01*F0 + K_11*F1 + K_21*F2))*((K_01*F0 + K_11*F1 + K_21*F2)) + ((K_01*F6 + K_11*F7 + K_21*F8))*((K_01*F6 + K_11*F7 + K_21*F8)) + (((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))*(((K_01*F3 + K_11*F4 + K_21*F5) + 1.00000000))))/(2.00000000)))*2.00000000*1.00000000*1.00000000))))))) + ((FE1_C1[ip][j]*F10 + FE1_C0[ip][j]*F9 + FE1_C2[ip][j]*F11))*(-1.00000000))*W8[ip]*det;
      }// end loop over 'j'
    }// end loop over 'ip'
  }

  /// Tabulate the tensor for the contribution from a local cell
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    std::cerr << "*** FFC warning: " << "Quadrature version of tabulate_tensor not yet implemented (introduced in UFC 2.0)." << std::endl;
  }

};

/// This class defines the interface for the tabulation of the
/// exterior facet tensor corresponding to the local contribution to
/// a form from the integral over an exterior facet.

class hyperelasticity_exterior_facet_integral_1_0: public ufc::exterior_facet_integral
{
public:

  /// Constructor
  hyperelasticity_exterior_facet_integral_1_0() : ufc::exterior_facet_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~hyperelasticity_exterior_facet_integral_1_0()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local exterior facet
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int facet) const
  {
    // Number of operations (multiply-add pairs) for Jacobian data:      27
    // Number of operations (multiply-add pairs) for geometry tensor:    12
    // Number of operations (multiply-add pairs) for tensor contraction: 90
    // Total number of operations (multiply-add pairs):                  129
    
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    
    // Compute sub determinants
    
    // Compute determinant of Jacobian
    
    // Compute inverse of Jacobian
    
    // Get vertices on face
    static unsigned int face_vertices[4][3] = {{1, 2, 3}, {0, 2, 3}, {0, 1, 3}, {0, 1, 2}};
    const unsigned int v0 = face_vertices[facet][0];
    const unsigned int v1 = face_vertices[facet][1];
    const unsigned int v2 = face_vertices[facet][2];
    
    // Compute scale factor (area of face scaled by area of reference triangle)
    const double a0 = (x[v0][1]*x[v1][2] + x[v0][2]*x[v2][1] + x[v1][1]*x[v2][2]) - (x[v2][1]*x[v1][2] + x[v2][2]*x[v0][1] + x[v1][1]*x[v0][2]);
    
    const double a1 = (x[v0][2]*x[v1][0] + x[v0][0]*x[v2][2] + x[v1][2]*x[v2][0]) - (x[v2][2]*x[v1][0] + x[v2][0]*x[v0][2] + x[v1][2]*x[v0][0]);
    
    const double a2 = (x[v0][0]*x[v1][1] + x[v0][1]*x[v2][0] + x[v1][0]*x[v2][1]) - (x[v2][0]*x[v1][1] + x[v2][1]*x[v0][0] + x[v1][0]*x[v0][1]);
    
    const double det = std::sqrt(a0*a0 + a1*a1 + a2*a2);
    
    // Compute geometry tensor
    const double G0_0 = det*w[2][0]*(1.0);
    const double G0_1 = det*w[2][1]*(1.0);
    const double G0_2 = det*w[2][2]*(1.0);
    const double G0_3 = det*w[2][3]*(1.0);
    const double G0_4 = det*w[2][4]*(1.0);
    const double G0_5 = det*w[2][5]*(1.0);
    const double G0_6 = det*w[2][6]*(1.0);
    const double G0_7 = det*w[2][7]*(1.0);
    const double G0_8 = det*w[2][8]*(1.0);
    const double G0_9 = det*w[2][9]*(1.0);
    const double G0_10 = det*w[2][10]*(1.0);
    const double G0_11 = det*w[2][11]*(1.0);
    
    // Compute element tensor
    switch (facet)
    {
    case 0:
      {
        A[0] = 0.00000000;
      A[1] = -0.08333333*G0_1 - 0.04166667*G0_2 - 0.04166667*G0_3;
      A[2] = -0.04166667*G0_1 - 0.08333333*G0_2 - 0.04166667*G0_3;
      A[3] = -0.04166667*G0_1 - 0.04166667*G0_2 - 0.08333333*G0_3;
      A[4] = 0.00000000;
      A[5] = -0.08333333*G0_5 - 0.04166667*G0_6 - 0.04166667*G0_7;
      A[6] = -0.04166667*G0_5 - 0.08333333*G0_6 - 0.04166667*G0_7;
      A[7] = -0.04166667*G0_5 - 0.04166667*G0_6 - 0.08333333*G0_7;
      A[8] = 0.00000000;
      A[9] = -0.08333333*G0_9 - 0.04166667*G0_10 - 0.04166667*G0_11;
      A[10] = -0.04166667*G0_9 - 0.08333333*G0_10 - 0.04166667*G0_11;
      A[11] = -0.04166667*G0_9 - 0.04166667*G0_10 - 0.08333333*G0_11;
        break;
      }
    case 1:
      {
        A[0] = -0.08333333*G0_0 - 0.04166667*G0_2 - 0.04166667*G0_3;
      A[1] = 0.00000000;
      A[2] = -0.04166667*G0_0 - 0.08333333*G0_2 - 0.04166667*G0_3;
      A[3] = -0.04166667*G0_0 - 0.04166667*G0_2 - 0.08333333*G0_3;
      A[4] = -0.08333333*G0_4 - 0.04166667*G0_6 - 0.04166667*G0_7;
      A[5] = 0.00000000;
      A[6] = -0.04166667*G0_4 - 0.08333333*G0_6 - 0.04166667*G0_7;
      A[7] = -0.04166667*G0_4 - 0.04166667*G0_6 - 0.08333333*G0_7;
      A[8] = -0.08333333*G0_8 - 0.04166667*G0_10 - 0.04166667*G0_11;
      A[9] = 0.00000000;
      A[10] = -0.04166667*G0_8 - 0.08333333*G0_10 - 0.04166667*G0_11;
      A[11] = -0.04166667*G0_8 - 0.04166667*G0_10 - 0.08333333*G0_11;
        break;
      }
    case 2:
      {
        A[0] = -0.08333333*G0_0 - 0.04166667*G0_1 - 0.04166667*G0_3;
      A[1] = -0.04166667*G0_0 - 0.08333333*G0_1 - 0.04166667*G0_3;
      A[2] = 0.00000000;
      A[3] = -0.04166667*G0_0 - 0.04166667*G0_1 - 0.08333333*G0_3;
      A[4] = -0.08333333*G0_4 - 0.04166667*G0_5 - 0.04166667*G0_7;
      A[5] = -0.04166667*G0_4 - 0.08333333*G0_5 - 0.04166667*G0_7;
      A[6] = 0.00000000;
      A[7] = -0.04166667*G0_4 - 0.04166667*G0_5 - 0.08333333*G0_7;
      A[8] = -0.08333333*G0_8 - 0.04166667*G0_9 - 0.04166667*G0_11;
      A[9] = -0.04166667*G0_8 - 0.08333333*G0_9 - 0.04166667*G0_11;
      A[10] = 0.00000000;
      A[11] = -0.04166667*G0_8 - 0.04166667*G0_9 - 0.08333333*G0_11;
        break;
      }
    case 3:
      {
        A[0] = -0.08333333*G0_0 - 0.04166667*G0_1 - 0.04166667*G0_2;
      A[1] = -0.04166667*G0_0 - 0.08333333*G0_1 - 0.04166667*G0_2;
      A[2] = -0.04166667*G0_0 - 0.04166667*G0_1 - 0.08333333*G0_2;
      A[3] = 0.00000000;
      A[4] = -0.08333333*G0_4 - 0.04166667*G0_5 - 0.04166667*G0_6;
      A[5] = -0.04166667*G0_4 - 0.08333333*G0_5 - 0.04166667*G0_6;
      A[6] = -0.04166667*G0_4 - 0.04166667*G0_5 - 0.08333333*G0_6;
      A[7] = 0.00000000;
      A[8] = -0.08333333*G0_8 - 0.04166667*G0_9 - 0.04166667*G0_10;
      A[9] = -0.04166667*G0_8 - 0.08333333*G0_9 - 0.04166667*G0_10;
      A[10] = -0.04166667*G0_8 - 0.04166667*G0_9 - 0.08333333*G0_10;
      A[11] = 0.00000000;
        break;
      }
    }
    
  }

  /// Tabulate the tensor for the contribution from a local exterior facet
  /// using the specified reference cell quadrature points/weights
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const ufc::cell& c,
                               unsigned int num_quadrature_points,
                               const double * const * quadrature_points,
                               const double* quadrature_weights) const
  {
    std::cerr << "*** FFC warning: " << "Quadrature version of tabulate_tensor not available when using the FFC tensor representation." << std::endl;
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class hyperelasticity_form_0: public ufc::form
{
public:

  /// Constructor
  hyperelasticity_form_0() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~hyperelasticity_form_0()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(IndexSum(IndexSum(Product(Indexed(ComponentTensor(IndexSum(Sum(Product(Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 1), MultiIndex((Index(0),), {Index(0): 3})), MultiIndex((Index(1),), {Index(1): 3})), MultiIndex((Index(1), Index(0)), {Index(0): 3, Index(1): 3})), MultiIndex((Index(2), Index(3)), {Index(2): 3, Index(3): 3})), Indexed(Sum(ComponentTensor(Product(Constant(Cell('tetrahedron', 1, Space(3)), 1), Indexed(IndexSum(ComponentTensor(Indexed(ComponentTensor(Indexed(IndexSum(Sum(ComponentTensor(Product(Indexed(ComponentTensor(Indexed(ComponentTensor(Product(Indexed(Identity(3), MultiIndex((Index(4), Index(5)), {Index(4): 3, Index(5): 3})), Indexed(Identity(3), MultiIndex((Index(6), Index(7)), {Index(7): 3, Index(6): 3}))), MultiIndex((Index(4), Index(6), Index(5), Index(7)), {Index(7): 3, Index(4): 3, Index(5): 3, Index(6): 3})), MultiIndex((Index(8), Index(9), Index(10), Index(11)), {Index(11): 3, Index(8): 3, Index(9): 3, Index(10): 3})), MultiIndex((Index(10), Index(11)), {Index(11): 3, Index(10): 3})), MultiIndex((Index(12), Index(13)), {Index(13): 3, Index(12): 3})), Indexed(Variable(ComponentTensor(Division(Indexed(Sum(ComponentTensor(IndexSum(Product(Indexed(ComponentTensor(Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(14),), {Index(14): 3})), MultiIndex((Index(15),), {Index(15): 3})), MultiIndex((Index(15), Index(14)), {Index(14): 3, Index(15): 3})), Identity(3)), MultiIndex((Index(16), Index(17)), {Index(17): 3, Index(16): 3})), MultiIndex((Index(17), Index(16)), {Index(17): 3, Index(16): 3})), MultiIndex((Index(18), Index(19)), {Index(19): 3, Index(18): 3})), Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(20),), {Index(20): 3})), MultiIndex((Index(21),), {Index(21): 3})), MultiIndex((Index(21), Index(20)), {Index(21): 3, Index(20): 3})), Identity(3)), MultiIndex((Index(19), Index(22)), {Index(22): 3, Index(19): 3}))), MultiIndex((Index(19),), {Index(19): 3})), MultiIndex((Index(18), Index(22)), {Index(22): 3, Index(18): 3})), ComponentTensor(Product(IntValue(-1, (), (), {}), Indexed(Identity(3), MultiIndex((Index(23), Index(24)), {Index(24): 3, Index(23): 3}))), MultiIndex((Index(23), Index(24)), {Index(24): 3, Index(23): 3}))), MultiIndex((Index(25), Index(26)), {Index(26): 3, Index(25): 3})), IntValue(2, (), (), {})), MultiIndex((Index(25), Index(26)), {Index(26): 3, Index(25): 3})), Label(0)), MultiIndex((Index(9), Index(27)), {Index(9): 3, Index(27): 3}))), MultiIndex((Index(12), Index(13)), {Index(13): 3, Index(12): 3})), ComponentTensor(Product(Indexed(ComponentTensor(Indexed(ComponentTensor(Product(Indexed(Identity(3), MultiIndex((Index(4), Index(5)), {Index(4): 3, Index(5): 3})), Indexed(Identity(3), MultiIndex((Index(6), Index(7)), {Index(7): 3, Index(6): 3}))), MultiIndex((Index(4), Index(6), Index(5), Index(7)), {Index(7): 3, Index(4): 3, Index(5): 3, Index(6): 3})), MultiIndex((Index(9), Index(27), Index(28), Index(29)), {Index(29): 3, Index(9): 3, Index(28): 3, Index(27): 3})), MultiIndex((Index(28), Index(29)), {Index(29): 3, Index(28): 3})), MultiIndex((Index(30), Index(31)), {Index(31): 3, Index(30): 3})), Indexed(Variable(ComponentTensor(Division(Indexed(Sum(ComponentTensor(IndexSum(Product(Indexed(ComponentTensor(Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(14),), {Index(14): 3})), MultiIndex((Index(15),), {Index(15): 3})), MultiIndex((Index(15), Index(14)), {Index(14): 3, Index(15): 3})), Identity(3)), MultiIndex((Index(16), Index(17)), {Index(17): 3, Index(16): 3})), MultiIndex((Index(17), Index(16)), {Index(17): 3, Index(16): 3})), MultiIndex((Index(18), Index(19)), {Index(19): 3, Index(18): 3})), Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(20),), {Index(20): 3})), MultiIndex((Index(21),), {Index(21): 3})), MultiIndex((Index(21), Index(20)), {Index(21): 3, Index(20): 3})), Identity(3)), MultiIndex((Index(19), Index(22)), {Index(22): 3, Index(19): 3}))), MultiIndex((Index(19),), {Index(19): 3})), MultiIndex((Index(18), Index(22)), {Index(22): 3, Index(18): 3})), ComponentTensor(Product(IntValue(-1, (), (), {}), Indexed(Identity(3), MultiIndex((Index(23), Index(24)), {Index(24): 3, Index(23): 3}))), MultiIndex((Index(23), Index(24)), {Index(24): 3, Index(23): 3}))), MultiIndex((Index(25), Index(26)), {Index(26): 3, Index(25): 3})), IntValue(2, (), (), {})), MultiIndex((Index(25), Index(26)), {Index(26): 3, Index(25): 3})), Label(0)), MultiIndex((Index(8), Index(9)), {Index(8): 3, Index(9): 3}))), MultiIndex((Index(30), Index(31)), {Index(31): 3, Index(30): 3}))), MultiIndex((Index(9),), {Index(9): 3})), MultiIndex((Index(32), Index(33)), {Index(33): 3, Index(32): 3})), MultiIndex((Index(8), Index(27), Index(32), Index(33)), {Index(33): 3, Index(27): 3, Index(32): 3, Index(8): 3})), MultiIndex((Index(34), Index(34), Index(35), Index(36)), {Index(35): 3, Index(36): 3, Index(34): 3})), MultiIndex((Index(35), Index(36)), {Index(35): 3, Index(36): 3})), MultiIndex((Index(34),), {Index(34): 3})), MultiIndex((Index(37), Index(38)), {Index(37): 3, Index(38): 3}))), MultiIndex((Index(37), Index(38)), {Index(37): 3, Index(38): 3})), ComponentTensor(Product(Division(Constant(Cell('tetrahedron', 1, Space(3)), 2), IntValue(2, (), (), {})), Indexed(ComponentTensor(Product(IndexSum(Indexed(Variable(ComponentTensor(Division(Indexed(Sum(ComponentTensor(IndexSum(Product(Indexed(ComponentTensor(Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(14),), {Index(14): 3})), MultiIndex((Index(15),), {Index(15): 3})), MultiIndex((Index(15), Index(14)), {Index(14): 3, Index(15): 3})), Identity(3)), MultiIndex((Index(16), Index(17)), {Index(17): 3, Index(16): 3})), MultiIndex((Index(17), Index(16)), {Index(17): 3, Index(16): 3})), MultiIndex((Index(18), Index(19)), {Index(19): 3, Index(18): 3})), Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(20),), {Index(20): 3})), MultiIndex((Index(21),), {Index(21): 3})), MultiIndex((Index(21), Index(20)), {Index(21): 3, Index(20): 3})), Identity(3)), MultiIndex((Index(19), Index(22)), {Index(22): 3, Index(19): 3}))), MultiIndex((Index(19),), {Index(19): 3})), MultiIndex((Index(18), Index(22)), {Index(22): 3, Index(18): 3})), ComponentTensor(Product(IntValue(-1, (), (), {}), Indexed(Identity(3), MultiIndex((Index(23), Index(24)), {Index(24): 3, Index(23): 3}))), MultiIndex((Index(23), Index(24)), {Index(24): 3, Index(23): 3}))), MultiIndex((Index(25), Index(26)), {Index(26): 3, Index(25): 3})), IntValue(2, (), (), {})), MultiIndex((Index(25), Index(26)), {Index(26): 3, Index(25): 3})), Label(0)), MultiIndex((Index(39), Index(39)), {Index(39): 3})), MultiIndex((Index(39),), {Index(39): 3})), Indexed(ComponentTensor(Product(IntValue(2, (), (), {}), Indexed(IndexSum(ComponentTensor(Indexed(ComponentTensor(Product(Indexed(Identity(3), MultiIndex((Index(4), Index(5)), {Index(4): 3, Index(5): 3})), Indexed(Identity(3), MultiIndex((Index(6), Index(7)), {Index(7): 3, Index(6): 3}))), MultiIndex((Index(4), Index(6), Index(5), Index(7)), {Index(7): 3, Index(4): 3, Index(5): 3, Index(6): 3})), MultiIndex((Index(39), Index(39), Index(40), Index(41)), {Index(40): 3, Index(41): 3, Index(39): 3})), MultiIndex((Index(40), Index(41)), {Index(40): 3, Index(41): 3})), MultiIndex((Index(39),), {Index(39): 3})), MultiIndex((Index(42), Index(43)), {Index(43): 3, Index(42): 3}))), MultiIndex((Index(42), Index(43)), {Index(43): 3, Index(42): 3})), MultiIndex((Index(44), Index(45)), {Index(44): 3, Index(45): 3}))), MultiIndex((Index(44), Index(45)), {Index(44): 3, Index(45): 3})), MultiIndex((Index(46), Index(47)), {Index(46): 3, Index(47): 3}))), MultiIndex((Index(46), Index(47)), {Index(46): 3, Index(47): 3}))), MultiIndex((Index(3), Index(48)), {Index(48): 3, Index(3): 3}))), Product(Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(0),), {Index(0): 3})), MultiIndex((Index(1),), {Index(1): 3})), MultiIndex((Index(1), Index(0)), {Index(0): 3, Index(1): 3})), Identity(3)), MultiIndex((Index(2), Index(3)), {Index(2): 3, Index(3): 3})), Indexed(Sum(ComponentTensor(Product(Constant(Cell('tetrahedron', 1, Space(3)), 1), Indexed(IndexSum(ComponentTensor(Indexed(ComponentTensor(Indexed(IndexSum(Sum(ComponentTensor(Product(Indexed(ComponentTensor(Division(Indexed(ComponentTensor(IndexSum(Sum(Product(Indexed(ComponentTensor(Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 1), MultiIndex((Index(14),), {Index(14): 3})), MultiIndex((Index(15),), {Index(15): 3})), MultiIndex((Index(15), Index(14)), {Index(14): 3, Index(15): 3})), MultiIndex((Index(16), Index(17)), {Index(17): 3, Index(16): 3})), MultiIndex((Index(17), Index(16)), {Index(17): 3, Index(16): 3})), MultiIndex((Index(18), Index(19)), {Index(19): 3, Index(18): 3})), Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(20),), {Index(20): 3})), MultiIndex((Index(21),), {Index(21): 3})), MultiIndex((Index(21), Index(20)), {Index(21): 3, Index(20): 3})), Identity(3)), MultiIndex((Index(19), Index(22)), {Index(22): 3, Index(19): 3}))), Product(Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 1), MultiIndex((Index(20),), {Index(20): 3})), MultiIndex((Index(21),), {Index(21): 3})), MultiIndex((Index(21), Index(20)), {Index(21): 3, Index(20): 3})), MultiIndex((Index(19), Index(22)), {Index(22): 3, Index(19): 3})), Indexed(ComponentTensor(Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(14),), {Index(14): 3})), MultiIndex((Index(15),), {Index(15): 3})), MultiIndex((Index(15), Index(14)), {Index(14): 3, Index(15): 3})), Identity(3)), MultiIndex((Index(16), Index(17)), {Index(17): 3, Index(16): 3})), MultiIndex((Index(17), Index(16)), {Index(17): 3, Index(16): 3})), MultiIndex((Index(18), Index(19)), {Index(19): 3, Index(18): 3})))), MultiIndex((Index(19),), {Index(19): 3})), MultiIndex((Index(18), Index(22)), {Index(22): 3, Index(18): 3})), MultiIndex((Index(25), Index(26)), {Index(26): 3, Index(25): 3})), IntValue(2, (), (), {})), MultiIndex((Index(25), Index(26)), {Index(26): 3, Index(25): 3})), MultiIndex((Index(9), Index(27)), {Index(9): 3, Index(27): 3})), Indexed(ComponentTensor(Indexed(ComponentTensor(Product(Indexed(Identity(3), MultiIndex((Index(4), Index(5)), {Index(4): 3, Index(5): 3})), Indexed(Identity(3), MultiIndex((Index(6), Index(7)), {Index(7): 3, Index(6): 3}))), MultiIndex((Index(4), Index(6), Index(5), Index(7)), {Index(7): 3, Index(4): 3, Index(5): 3, Index(6): 3})), MultiIndex((Index(8), Index(9), Index(10), Index(11)), {Index(11): 3, Index(8): 3, Index(9): 3, Index(10): 3})), MultiIndex((Index(10), Index(11)), {Index(11): 3, Index(10): 3})), MultiIndex((Index(12), Index(13)), {Index(13): 3, Index(12): 3}))), MultiIndex((Index(12), Index(13)), {Index(13): 3, Index(12): 3})), ComponentTensor(Product(Indexed(ComponentTensor(Division(Indexed(ComponentTensor(IndexSum(Sum(Product(Indexed(ComponentTensor(Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 1), MultiIndex((Index(14),), {Index(14): 3})), MultiIndex((Index(15),), {Index(15): 3})), MultiIndex((Index(15), Index(14)), {Index(14): 3, Index(15): 3})), MultiIndex((Index(16), Index(17)), {Index(17): 3, Index(16): 3})), MultiIndex((Index(17), Index(16)), {Index(17): 3, Index(16): 3})), MultiIndex((Index(18), Index(19)), {Index(19): 3, Index(18): 3})), Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(20),), {Index(20): 3})), MultiIndex((Index(21),), {Index(21): 3})), MultiIndex((Index(21), Index(20)), {Index(21): 3, Index(20): 3})), Identity(3)), MultiIndex((Index(19), Index(22)), {Index(22): 3, Index(19): 3}))), Product(Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 1), MultiIndex((Index(20),), {Index(20): 3})), MultiIndex((Index(21),), {Index(21): 3})), MultiIndex((Index(21), Index(20)), {Index(21): 3, Index(20): 3})), MultiIndex((Index(19), Index(22)), {Index(22): 3, Index(19): 3})), Indexed(ComponentTensor(Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(14),), {Index(14): 3})), MultiIndex((Index(15),), {Index(15): 3})), MultiIndex((Index(15), Index(14)), {Index(14): 3, Index(15): 3})), Identity(3)), MultiIndex((Index(16), Index(17)), {Index(17): 3, Index(16): 3})), MultiIndex((Index(17), Index(16)), {Index(17): 3, Index(16): 3})), MultiIndex((Index(18), Index(19)), {Index(19): 3, Index(18): 3})))), MultiIndex((Index(19),), {Index(19): 3})), MultiIndex((Index(18), Index(22)), {Index(22): 3, Index(18): 3})), MultiIndex((Index(25), Index(26)), {Index(26): 3, Index(25): 3})), IntValue(2, (), (), {})), MultiIndex((Index(25), Index(26)), {Index(26): 3, Index(25): 3})), MultiIndex((Index(8), Index(9)), {Index(8): 3, Index(9): 3})), Indexed(ComponentTensor(Indexed(ComponentTensor(Product(Indexed(Identity(3), MultiIndex((Index(4), Index(5)), {Index(4): 3, Index(5): 3})), Indexed(Identity(3), MultiIndex((Index(6), Index(7)), {Index(7): 3, Index(6): 3}))), MultiIndex((Index(4), Index(6), Index(5), Index(7)), {Index(7): 3, Index(4): 3, Index(5): 3, Index(6): 3})), MultiIndex((Index(9), Index(27), Index(28), Index(29)), {Index(29): 3, Index(9): 3, Index(28): 3, Index(27): 3})), MultiIndex((Index(28), Index(29)), {Index(29): 3, Index(28): 3})), MultiIndex((Index(30), Index(31)), {Index(31): 3, Index(30): 3}))), MultiIndex((Index(30), Index(31)), {Index(31): 3, Index(30): 3}))), MultiIndex((Index(9),), {Index(9): 3})), MultiIndex((Index(32), Index(33)), {Index(33): 3, Index(32): 3})), MultiIndex((Index(8), Index(27), Index(32), Index(33)), {Index(33): 3, Index(27): 3, Index(32): 3, Index(8): 3})), MultiIndex((Index(34), Index(34), Index(35), Index(36)), {Index(35): 3, Index(36): 3, Index(34): 3})), MultiIndex((Index(35), Index(36)), {Index(35): 3, Index(36): 3})), MultiIndex((Index(34),), {Index(34): 3})), MultiIndex((Index(37), Index(38)), {Index(37): 3, Index(38): 3}))), MultiIndex((Index(37), Index(38)), {Index(37): 3, Index(38): 3})), ComponentTensor(Product(Division(Constant(Cell('tetrahedron', 1, Space(3)), 2), IntValue(2, (), (), {})), Indexed(ComponentTensor(Product(IndexSum(Indexed(ComponentTensor(Division(Indexed(ComponentTensor(IndexSum(Sum(Product(Indexed(ComponentTensor(Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 1), MultiIndex((Index(14),), {Index(14): 3})), MultiIndex((Index(15),), {Index(15): 3})), MultiIndex((Index(15), Index(14)), {Index(14): 3, Index(15): 3})), MultiIndex((Index(16), Index(17)), {Index(17): 3, Index(16): 3})), MultiIndex((Index(17), Index(16)), {Index(17): 3, Index(16): 3})), MultiIndex((Index(18), Index(19)), {Index(19): 3, Index(18): 3})), Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(20),), {Index(20): 3})), MultiIndex((Index(21),), {Index(21): 3})), MultiIndex((Index(21), Index(20)), {Index(21): 3, Index(20): 3})), Identity(3)), MultiIndex((Index(19), Index(22)), {Index(22): 3, Index(19): 3}))), Product(Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 1), MultiIndex((Index(20),), {Index(20): 3})), MultiIndex((Index(21),), {Index(21): 3})), MultiIndex((Index(21), Index(20)), {Index(21): 3, Index(20): 3})), MultiIndex((Index(19), Index(22)), {Index(22): 3, Index(19): 3})), Indexed(ComponentTensor(Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(14),), {Index(14): 3})), MultiIndex((Index(15),), {Index(15): 3})), MultiIndex((Index(15), Index(14)), {Index(14): 3, Index(15): 3})), Identity(3)), MultiIndex((Index(16), Index(17)), {Index(17): 3, Index(16): 3})), MultiIndex((Index(17), Index(16)), {Index(17): 3, Index(16): 3})), MultiIndex((Index(18), Index(19)), {Index(19): 3, Index(18): 3})))), MultiIndex((Index(19),), {Index(19): 3})), MultiIndex((Index(18), Index(22)), {Index(22): 3, Index(18): 3})), MultiIndex((Index(25), Index(26)), {Index(26): 3, Index(25): 3})), IntValue(2, (), (), {})), MultiIndex((Index(25), Index(26)), {Index(26): 3, Index(25): 3})), MultiIndex((Index(39), Index(39)), {Index(39): 3})), MultiIndex((Index(39),), {Index(39): 3})), Indexed(ComponentTensor(Product(IntValue(2, (), (), {}), Indexed(IndexSum(ComponentTensor(Indexed(ComponentTensor(Product(Indexed(Identity(3), MultiIndex((Index(4), Index(5)), {Index(4): 3, Index(5): 3})), Indexed(Identity(3), MultiIndex((Index(6), Index(7)), {Index(7): 3, Index(6): 3}))), MultiIndex((Index(4), Index(6), Index(5), Index(7)), {Index(7): 3, Index(4): 3, Index(5): 3, Index(6): 3})), MultiIndex((Index(39), Index(39), Index(40), Index(41)), {Index(40): 3, Index(41): 3, Index(39): 3})), MultiIndex((Index(40), Index(41)), {Index(40): 3, Index(41): 3})), MultiIndex((Index(39),), {Index(39): 3})), MultiIndex((Index(42), Index(43)), {Index(43): 3, Index(42): 3}))), MultiIndex((Index(42), Index(43)), {Index(43): 3, Index(42): 3})), MultiIndex((Index(44), Index(45)), {Index(44): 3, Index(45): 3}))), MultiIndex((Index(44), Index(45)), {Index(44): 3, Index(45): 3})), MultiIndex((Index(46), Index(47)), {Index(46): 3, Index(47): 3}))), MultiIndex((Index(46), Index(47)), {Index(46): 3, Index(47): 3}))), MultiIndex((Index(3), Index(48)), {Index(48): 3, Index(3): 3})))), MultiIndex((Index(3),), {Index(3): 3})), MultiIndex((Index(2), Index(48)), {Index(48): 3, Index(2): 3})), MultiIndex((Index(49), Index(50)), {Index(50): 3, Index(49): 3})), Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(51),), {Index(51): 3})), MultiIndex((Index(52),), {Index(52): 3})), MultiIndex((Index(52), Index(51)), {Index(52): 3, Index(51): 3})), MultiIndex((Index(49), Index(50)), {Index(50): 3, Index(49): 3}))), MultiIndex((Index(49),), {Index(49): 3})), MultiIndex((Index(50),), {Index(50): 3})), Measure('cell', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 3;
  }

  /// Return the number of cell domains
  virtual unsigned int num_cell_domains() const
  {
    return 1;
  }

  /// Return the number of exterior facet domains
  virtual unsigned int num_exterior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of interior facet domains
  virtual unsigned int num_interior_facet_domains() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_finite_element_2();
        break;
      }
    case 1:
      {
        return new hyperelasticity_finite_element_2();
        break;
      }
    case 2:
      {
        return new hyperelasticity_finite_element_2();
        break;
      }
    case 3:
      {
        return new hyperelasticity_finite_element_0();
        break;
      }
    case 4:
      {
        return new hyperelasticity_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_dofmap_2();
        break;
      }
    case 1:
      {
        return new hyperelasticity_dofmap_2();
        break;
      }
    case 2:
      {
        return new hyperelasticity_dofmap_2();
        break;
      }
    case 3:
      {
        return new hyperelasticity_dofmap_0();
        break;
      }
    case 4:
      {
        return new hyperelasticity_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_cell_integral_0_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class hyperelasticity_form_1: public ufc::form
{
public:

  /// Constructor
  hyperelasticity_form_1() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~hyperelasticity_form_1()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "Form([Integral(Sum(IndexSum(IndexSum(Product(Indexed(ComponentTensor(IndexSum(Product(Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(0),), {Index(0): 3})), MultiIndex((Index(1),), {Index(1): 3})), MultiIndex((Index(1), Index(0)), {Index(0): 3, Index(1): 3})), Identity(3)), MultiIndex((Index(2), Index(3)), {Index(2): 3, Index(3): 3})), Indexed(Sum(ComponentTensor(Product(Constant(Cell('tetrahedron', 1, Space(3)), 3), Indexed(IndexSum(ComponentTensor(Indexed(ComponentTensor(Indexed(IndexSum(Sum(ComponentTensor(Product(Indexed(ComponentTensor(Indexed(ComponentTensor(Product(Indexed(Identity(3), MultiIndex((Index(4), Index(5)), {Index(4): 3, Index(5): 3})), Indexed(Identity(3), MultiIndex((Index(6), Index(7)), {Index(7): 3, Index(6): 3}))), MultiIndex((Index(4), Index(6), Index(5), Index(7)), {Index(7): 3, Index(4): 3, Index(5): 3, Index(6): 3})), MultiIndex((Index(8), Index(9), Index(10), Index(11)), {Index(11): 3, Index(8): 3, Index(9): 3, Index(10): 3})), MultiIndex((Index(10), Index(11)), {Index(11): 3, Index(10): 3})), MultiIndex((Index(12), Index(13)), {Index(13): 3, Index(12): 3})), Indexed(Variable(ComponentTensor(Division(Indexed(Sum(ComponentTensor(IndexSum(Product(Indexed(ComponentTensor(Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(14),), {Index(14): 3})), MultiIndex((Index(15),), {Index(15): 3})), MultiIndex((Index(15), Index(14)), {Index(14): 3, Index(15): 3})), Identity(3)), MultiIndex((Index(16), Index(17)), {Index(17): 3, Index(16): 3})), MultiIndex((Index(17), Index(16)), {Index(17): 3, Index(16): 3})), MultiIndex((Index(18), Index(19)), {Index(19): 3, Index(18): 3})), Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(20),), {Index(20): 3})), MultiIndex((Index(21),), {Index(21): 3})), MultiIndex((Index(21), Index(20)), {Index(21): 3, Index(20): 3})), Identity(3)), MultiIndex((Index(19), Index(22)), {Index(22): 3, Index(19): 3}))), MultiIndex((Index(19),), {Index(19): 3})), MultiIndex((Index(18), Index(22)), {Index(22): 3, Index(18): 3})), ComponentTensor(Product(IntValue(-1, (), (), {}), Indexed(Identity(3), MultiIndex((Index(23), Index(24)), {Index(24): 3, Index(23): 3}))), MultiIndex((Index(23), Index(24)), {Index(24): 3, Index(23): 3}))), MultiIndex((Index(25), Index(26)), {Index(26): 3, Index(25): 3})), IntValue(2, (), (), {})), MultiIndex((Index(25), Index(26)), {Index(26): 3, Index(25): 3})), Label(0)), MultiIndex((Index(9), Index(27)), {Index(9): 3, Index(27): 3}))), MultiIndex((Index(12), Index(13)), {Index(13): 3, Index(12): 3})), ComponentTensor(Product(Indexed(ComponentTensor(Indexed(ComponentTensor(Product(Indexed(Identity(3), MultiIndex((Index(4), Index(5)), {Index(4): 3, Index(5): 3})), Indexed(Identity(3), MultiIndex((Index(6), Index(7)), {Index(7): 3, Index(6): 3}))), MultiIndex((Index(4), Index(6), Index(5), Index(7)), {Index(7): 3, Index(4): 3, Index(5): 3, Index(6): 3})), MultiIndex((Index(9), Index(27), Index(28), Index(29)), {Index(29): 3, Index(9): 3, Index(28): 3, Index(27): 3})), MultiIndex((Index(28), Index(29)), {Index(29): 3, Index(28): 3})), MultiIndex((Index(30), Index(31)), {Index(31): 3, Index(30): 3})), Indexed(Variable(ComponentTensor(Division(Indexed(Sum(ComponentTensor(IndexSum(Product(Indexed(ComponentTensor(Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(14),), {Index(14): 3})), MultiIndex((Index(15),), {Index(15): 3})), MultiIndex((Index(15), Index(14)), {Index(14): 3, Index(15): 3})), Identity(3)), MultiIndex((Index(16), Index(17)), {Index(17): 3, Index(16): 3})), MultiIndex((Index(17), Index(16)), {Index(17): 3, Index(16): 3})), MultiIndex((Index(18), Index(19)), {Index(19): 3, Index(18): 3})), Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(20),), {Index(20): 3})), MultiIndex((Index(21),), {Index(21): 3})), MultiIndex((Index(21), Index(20)), {Index(21): 3, Index(20): 3})), Identity(3)), MultiIndex((Index(19), Index(22)), {Index(22): 3, Index(19): 3}))), MultiIndex((Index(19),), {Index(19): 3})), MultiIndex((Index(18), Index(22)), {Index(22): 3, Index(18): 3})), ComponentTensor(Product(IntValue(-1, (), (), {}), Indexed(Identity(3), MultiIndex((Index(23), Index(24)), {Index(24): 3, Index(23): 3}))), MultiIndex((Index(23), Index(24)), {Index(24): 3, Index(23): 3}))), MultiIndex((Index(25), Index(26)), {Index(26): 3, Index(25): 3})), IntValue(2, (), (), {})), MultiIndex((Index(25), Index(26)), {Index(26): 3, Index(25): 3})), Label(0)), MultiIndex((Index(8), Index(9)), {Index(8): 3, Index(9): 3}))), MultiIndex((Index(30), Index(31)), {Index(31): 3, Index(30): 3}))), MultiIndex((Index(9),), {Index(9): 3})), MultiIndex((Index(32), Index(33)), {Index(33): 3, Index(32): 3})), MultiIndex((Index(8), Index(27), Index(32), Index(33)), {Index(33): 3, Index(27): 3, Index(32): 3, Index(8): 3})), MultiIndex((Index(34), Index(34), Index(35), Index(36)), {Index(35): 3, Index(36): 3, Index(34): 3})), MultiIndex((Index(35), Index(36)), {Index(35): 3, Index(36): 3})), MultiIndex((Index(34),), {Index(34): 3})), MultiIndex((Index(37), Index(38)), {Index(37): 3, Index(38): 3}))), MultiIndex((Index(37), Index(38)), {Index(37): 3, Index(38): 3})), ComponentTensor(Product(Division(Constant(Cell('tetrahedron', 1, Space(3)), 4), IntValue(2, (), (), {})), Indexed(ComponentTensor(Product(IndexSum(Indexed(Variable(ComponentTensor(Division(Indexed(Sum(ComponentTensor(IndexSum(Product(Indexed(ComponentTensor(Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(14),), {Index(14): 3})), MultiIndex((Index(15),), {Index(15): 3})), MultiIndex((Index(15), Index(14)), {Index(14): 3, Index(15): 3})), Identity(3)), MultiIndex((Index(16), Index(17)), {Index(17): 3, Index(16): 3})), MultiIndex((Index(17), Index(16)), {Index(17): 3, Index(16): 3})), MultiIndex((Index(18), Index(19)), {Index(19): 3, Index(18): 3})), Indexed(Sum(ComponentTensor(Indexed(SpatialDerivative(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(20),), {Index(20): 3})), MultiIndex((Index(21),), {Index(21): 3})), MultiIndex((Index(21), Index(20)), {Index(21): 3, Index(20): 3})), Identity(3)), MultiIndex((Index(19), Index(22)), {Index(22): 3, Index(19): 3}))), MultiIndex((Index(19),), {Index(19): 3})), MultiIndex((Index(18), Index(22)), {Index(22): 3, Index(18): 3})), ComponentTensor(Product(IntValue(-1, (), (), {}), Indexed(Identity(3), MultiIndex((Index(23), Index(24)), {Index(24): 3, Index(23): 3}))), MultiIndex((Index(23), Index(24)), {Index(24): 3, Index(23): 3}))), MultiIndex((Index(25), Index(26)), {Index(26): 3, Index(25): 3})), IntValue(2, (), (), {})), MultiIndex((Index(25), Index(26)), {Index(26): 3, Index(25): 3})), Label(0)), MultiIndex((Index(39), Index(39)), {Index(39): 3})), MultiIndex((Index(39),), {Index(39): 3})), Indexed(ComponentTensor(Product(IntValue(2, (), (), {}), Indexed(IndexSum(ComponentTensor(Indexed(ComponentTensor(Product(Indexed(Identity(3), MultiIndex((Index(4), Index(5)), {Index(4): 3, Index(5): 3})), Indexed(Identity(3), MultiIndex((Index(6), Index(7)), {Index(7): 3, Index(6): 3}))), MultiIndex((Index(4), Index(6), Index(5), Index(7)), {Index(7): 3, Index(4): 3, Index(5): 3, Index(6): 3})), MultiIndex((Index(39), Index(39), Index(40), Index(41)), {Index(40): 3, Index(41): 3, Index(39): 3})), MultiIndex((Index(40), Index(41)), {Index(40): 3, Index(41): 3})), MultiIndex((Index(39),), {Index(39): 3})), MultiIndex((Index(42), Index(43)), {Index(43): 3, Index(42): 3}))), MultiIndex((Index(42), Index(43)), {Index(43): 3, Index(42): 3})), MultiIndex((Index(44), Index(45)), {Index(44): 3, Index(45): 3}))), MultiIndex((Index(44), Index(45)), {Index(44): 3, Index(45): 3})), MultiIndex((Index(46), Index(47)), {Index(46): 3, Index(47): 3}))), MultiIndex((Index(46), Index(47)), {Index(46): 3, Index(47): 3}))), MultiIndex((Index(3), Index(48)), {Index(48): 3, Index(3): 3}))), MultiIndex((Index(3),), {Index(3): 3})), MultiIndex((Index(2), Index(48)), {Index(48): 3, Index(2): 3})), MultiIndex((Index(49), Index(50)), {Index(50): 3, Index(49): 3})), Indexed(ComponentTensor(Indexed(SpatialDerivative(Argument(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(51),), {Index(51): 3})), MultiIndex((Index(52),), {Index(52): 3})), MultiIndex((Index(52), Index(51)), {Index(52): 3, Index(51): 3})), MultiIndex((Index(49), Index(50)), {Index(50): 3, Index(49): 3}))), MultiIndex((Index(49),), {Index(49): 3})), MultiIndex((Index(50),), {Index(50): 3})), Product(IntValue(-1, (), (), {}), IndexSum(Product(Indexed(Argument(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(53),), {Index(53): 3})), Indexed(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 1), MultiIndex((Index(53),), {Index(53): 3}))), MultiIndex((Index(53),), {Index(53): 3})))), Measure('cell', 0, None)), Integral(Product(IntValue(-1, (), (), {}), IndexSum(Product(Indexed(Argument(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 0), MultiIndex((Index(54),), {Index(54): 3})), Indexed(Coefficient(VectorElement('Lagrange', Cell('tetrahedron', 1, Space(3)), 1, 3), 2), MultiIndex((Index(54),), {Index(54): 3}))), MultiIndex((Index(54),), {Index(54): 3}))), Measure('exterior_facet', 0, None))])";
  }

  /// Return the rank of the global tensor (r)
  virtual unsigned int rank() const
  {
    return 1;
  }

  /// Return the number of coefficients (n)
  virtual unsigned int num_coefficients() const
  {
    return 5;
  }

  /// Return the number of cell domains
  virtual unsigned int num_cell_domains() const
  {
    return 1;
  }

  /// Return the number of exterior facet domains
  virtual unsigned int num_exterior_facet_domains() const
  {
    return 1;
  }

  /// Return the number of interior facet domains
  virtual unsigned int num_interior_facet_domains() const
  {
    return 0;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_finite_element_2();
        break;
      }
    case 1:
      {
        return new hyperelasticity_finite_element_2();
        break;
      }
    case 2:
      {
        return new hyperelasticity_finite_element_2();
        break;
      }
    case 3:
      {
        return new hyperelasticity_finite_element_2();
        break;
      }
    case 4:
      {
        return new hyperelasticity_finite_element_0();
        break;
      }
    case 5:
      {
        return new hyperelasticity_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_dofmap_2();
        break;
      }
    case 1:
      {
        return new hyperelasticity_dofmap_2();
        break;
      }
    case 2:
      {
        return new hyperelasticity_dofmap_2();
        break;
      }
    case 3:
      {
        return new hyperelasticity_dofmap_2();
        break;
      }
    case 4:
      {
        return new hyperelasticity_dofmap_0();
        break;
      }
    case 5:
      {
        return new hyperelasticity_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_cell_integral_1_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(unsigned int i) const
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_exterior_facet_integral_1_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(unsigned int i) const
  {
    return 0;
  }

};

#endif
