/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableEnhanced;

public class CompareNetcdf {
    boolean showCompare = false;
    boolean showEach = false;
    boolean compareData = false;
    private static final double TOL = 1.0E-5;
    private static final float TOLF = 1.0E-5f;

    public static void compareFiles(NetcdfFile org, NetcdfFile copy) {
        CompareNetcdf.compareFiles(org, copy, false, false, false);
    }

    public static void compareFiles(NetcdfFile org, NetcdfFile copy, boolean _compareData, boolean _showCompare, boolean _showEach) {
        CompareNetcdf tc = new CompareNetcdf(_showCompare, _showEach, _compareData);
        tc.compare(org, copy, new Formatter(System.out));
    }

    public CompareNetcdf(boolean showCompare, boolean showEach, boolean compareData) {
        this.compareData = compareData;
        this.showCompare = showCompare;
        this.showEach = showEach;
    }

    public boolean compare(NetcdfFile org, NetcdfFile copy, Formatter f) {
        f.format("Original = %s%n", org.getLocation());
        f.format("CompareTo= %s%n", copy.getLocation());
        long start = System.currentTimeMillis();
        boolean ok = this.compareGroups(org.getRootGroup(), copy.getRootGroup(), f);
        f.format("Files are the same = %s%n", ok);
        long took = System.currentTimeMillis() - start;
        f.format("Time to compare = %d msecs%n", took);
        return ok;
    }

    public boolean compareVariables(NetcdfFile org, NetcdfFile copy, Formatter f) {
        Variable copyVar;
        f.format("Original = %s%n", org.getLocation());
        f.format("CompareTo= %s%n", copy.getLocation());
        boolean ok = true;
        for (Variable orgV : org.getVariables()) {
            copyVar = copy.findVariable(orgV.getShortName());
            if (copyVar != null) continue;
            f.format(" cant find variable %s in 2nd file%n", orgV.getName());
            ok = false;
        }
        for (Variable orgV : copy.getVariables()) {
            copyVar = org.findVariable(orgV.getShortName());
            if (copyVar != null) continue;
            f.format(" cant find variable %s in 1st file%n", orgV.getName());
            ok = false;
        }
        return ok;
    }

    private boolean compareGroups(Group org, Group copy, Formatter f) {
        if (this.showCompare) {
            f.format(" compareGroup %s to %s %n", org.getName(), copy.getName());
        }
        boolean ok = true;
        if (!org.getName().equals(copy.getName())) {
            f.format(" names are different %s != %s %n", org.getName(), copy.getName());
            ok = false;
        }
        ok &= this.checkAll(org.getDimensions(), copy.getDimensions(), null, f);
        ok &= this.checkAll(org.getAttributes(), copy.getAttributes(), null, f);
        for (Variable orgV : org.getVariables()) {
            Variable copyVar = copy.findVariable(orgV.getShortName());
            if (copyVar == null) {
                f.format(" cant find variable %s in 2nd file%n", orgV.getName());
                ok = false;
                continue;
            }
            ok &= this.compareVariables(orgV, copyVar, this.compareData, f);
        }
        for (Variable copyV : copy.getVariables()) {
            Variable orgV = org.findVariable(copyV.getShortName());
            if (orgV != null) continue;
            f.format(" cant find variable %s in 1st file%n", copyV.getName());
            ok = false;
        }
        ArrayList groups = new ArrayList();
        ok &= this.checkAll(org.getGroups(), copy.getGroups(), groups, f);
        for (int i = 0; i < groups.size(); i += 2) {
            Group orgGroup = (Group)groups.get(i);
            Group ncmlGroup = (Group)groups.get(i + 1);
            ok &= this.compareGroups(orgGroup, ncmlGroup, f);
        }
        return ok;
    }

    private boolean compareVariables(Variable org, Variable copy, boolean compareData, Formatter f) {
        boolean ok = true;
        if (this.showCompare) {
            f.format("  compareVariables %s to %s %n", org.getName(), copy.getName());
        }
        if (!org.getName().equals(copy.getName())) {
            f.format("  names are different %s != %s %n", org.getName(), copy.getName());
            ok = false;
        }
        ok &= this.checkAll(org.getDimensions(), copy.getDimensions(), null, f);
        ok &= this.checkAll(org.getAttributes(), copy.getAttributes(), null, f);
        if (org instanceof VariableEnhanced && copy instanceof VariableEnhanced) {
            VariableEnhanced orge = (VariableEnhanced)((Object)org);
            VariableEnhanced copye = (VariableEnhanced)((Object)copy);
            ok &= this.checkAll(orge.getCoordinateSystems(), copye.getCoordinateSystems(), null, f);
        }
        if (compareData) {
            try {
                CompareNetcdf.compareVariableData(org, copy, this.showCompare, f);
            }
            catch (IOException e) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
                e.printStackTrace(new PrintStream(bos));
                f.format("%s", bos.toString());
            }
        }
        if (org instanceof Structure) {
            assert (copy instanceof Structure);
            Structure orgS = (Structure)org;
            Structure ncmlS = (Structure)copy;
            ArrayList vars = new ArrayList();
            ok &= this.checkAll(orgS.getVariables(), ncmlS.getVariables(), vars, f);
            for (int i = 0; i < vars.size(); i += 2) {
                Variable orgV = (Variable)vars.get(i);
                Variable ncmlV = (Variable)vars.get(i + 1);
                ok &= this.compareVariables(orgV, ncmlV, false, f);
            }
        }
        return ok;
    }

    private boolean checkAll(List list1, List list2, List result, Formatter f) {
        boolean ok = true;
        for (Object aList1 : list1) {
            ok &= this.checkEach(aList1, list1, list2, result, f);
        }
        for (Object aList2 : list2) {
            ok &= this.checkEach(aList2, list2, list1, result, f);
        }
        return ok;
    }

    private boolean checkEach(Object want1, List list1, List list2, List result, Formatter f) {
        boolean ok = true;
        try {
            Object want;
            Object want2;
            int index1;
            int index2 = list2.indexOf(want1);
            if (index2 < 0) {
                f.format("   %s %s not in list 2", want1.getClass().getName(), want1);
                ok = false;
            }
            if ((index1 = list1.indexOf(want2 = list2.get(index2))) < 0) {
                f.format("   %s %s not in list 1", want2.getClass().getName(), want2);
                ok = false;
            }
            if ((want = list1.get(index1)) != want1) {
                f.format("   %s not ==", want1);
                ok = false;
            }
            if (this.showEach) {
                f.format("  OK <%s>.equals<%s>%n", want1, want2);
            }
            if (result != null) {
                result.add(want1);
                result.add(want2);
            }
        }
        catch (Throwable t) {
            f.format(" Error= %s %n", t.getMessage());
        }
        return ok;
    }

    public static void compareVariableData(Variable var1, Variable var2, boolean showCompare, Formatter f) throws IOException {
        Array data1 = var1.read();
        Array data2 = var2.read();
        if (showCompare) {
            f.format("   compareArrays %s %s size=%d%n", var1.getNameAndDimensions(), var1.isUnlimited(), data1.getSize());
        }
        CompareNetcdf.compareData(data1, data2);
        if (showCompare) {
            f.format("   ok%n", new Object[0]);
        }
    }

    public static void compareData(Array data1, Array data2) {
        CompareNetcdf.compareData(data1, data2, 1.0E-5);
    }

    public static void compareData(Array data1, Array data2, double tol) {
        block16: {
            IndexIterator iter2;
            IndexIterator iter1;
            DataType dt;
            block20: {
                block19: {
                    block18: {
                        block17: {
                            block15: {
                                if (data1.getSize() != data2.getSize()) {
                                    System.out.println("HEY");
                                }
                                assert (data1.getSize() == data2.getSize());
                                assert (data1.getElementType() == data2.getElementType()) : data1.getElementType() + "!=" + data2.getElementType();
                                dt = DataType.getType(data1.getElementType());
                                iter1 = data1.getIndexIterator();
                                iter2 = data2.getIndexIterator();
                                if (dt != DataType.DOUBLE) break block15;
                                while (iter1.hasNext() && iter2.hasNext()) {
                                    double v1 = iter1.getDoubleNext();
                                    double v2 = iter2.getDoubleNext();
                                    if (!Double.isNaN(v1) || !Double.isNaN(v2)) assert (CompareNetcdf.closeEnough(v1, v2, tol)) : v1 + " != " + v2 + " count=" + iter1 + " diff = " + CompareNetcdf.diff(v1, v2) + " pdiff=" + CompareNetcdf.pdiff(v1, v2);
                                }
                                break block16;
                            }
                            if (dt != DataType.FLOAT) break block17;
                            while (iter1.hasNext() && iter2.hasNext()) {
                                float v1 = iter1.getFloatNext();
                                float v2 = iter2.getFloatNext();
                                if (!Float.isNaN(v1) || !Float.isNaN(v2)) assert (CompareNetcdf.closeEnough(v1, v2, (float)tol)) : v1 + " != " + v2 + " count=" + iter1;
                            }
                            break block16;
                        }
                        if (dt != DataType.INT) break block18;
                        while (iter1.hasNext() && iter2.hasNext()) {
                            int v1 = iter1.getIntNext();
                            int v2 = iter2.getIntNext();
                            assert (v1 == v2) : v1 + " != " + v2 + " count=" + iter1;
                        }
                        break block16;
                    }
                    if (dt != DataType.SHORT) break block19;
                    while (iter1.hasNext() && iter2.hasNext()) {
                        short v2;
                        short v1 = iter1.getShortNext();
                        if (v1 != (v2 = iter2.getShortNext())) {
                            System.out.println("HEY");
                        }
                        assert (v1 == v2) : v1 + " != " + v2 + " count=" + iter1;
                    }
                    break block16;
                }
                if (dt != DataType.BYTE) break block20;
                while (iter1.hasNext() && iter2.hasNext()) {
                    byte v1 = iter1.getByteNext();
                    byte v2 = iter2.getByteNext();
                    assert (v1 == v2) : v1 + " != " + v2 + " count=" + iter1;
                }
                break block16;
            }
            if (dt != DataType.STRUCTURE) break block16;
            while (iter1.hasNext() && iter2.hasNext()) {
                CompareNetcdf.compareStructureData((StructureData)iter1.next(), (StructureData)iter2.next(), tol);
            }
        }
    }

    public static void compareStructureData(StructureData sdata1, StructureData sdata2, double tol) {
        StructureMembers sm1 = sdata1.getStructureMembers();
        StructureMembers sm2 = sdata2.getStructureMembers();
        assert (sm1.getMembers().size() == sm2.getMembers().size());
        for (StructureMembers.Member m1 : sm1.getMembers()) {
            if (m1.getName().equals("time")) continue;
            StructureMembers.Member m2 = sm2.findMember(m1.getName());
            if (m1.getName().startsWith("Radiosonde ascension number (see Note 12)")) {
                System.out.println("HEY");
            }
            Array data1 = sdata1.getArray(m1);
            Array data2 = sdata2.getArray(m2);
            CompareNetcdf.compareData(data1, data2, tol);
        }
    }

    public static boolean closeEnoughP(double d1, double d2) {
        if (Math.abs(d1) < 1.0E-5) {
            return Math.abs(d1 - d2) < 1.0E-5;
        }
        return Math.abs((d1 - d2) / d1) < 1.0E-5;
    }

    public static boolean closeEnough(double d1, double d2) {
        return Math.abs(d1 - d2) < 1.0E-5;
    }

    public static boolean closeEnough(double d1, double d2, double tol) {
        return Math.abs(d1 - d2) < tol;
    }

    public static boolean closeEnoughP(double d1, double d2, double tol) {
        if (Math.abs(d1) < tol) {
            return Math.abs(d1 - d2) < tol;
        }
        return Math.abs((d1 - d2) / d1) < tol;
    }

    public static double diff(double d1, double d2) {
        return Math.abs(d1 - d2);
    }

    public static double pdiff(double d1, double d2) {
        return Math.abs((d1 - d2) / d1);
    }

    public static boolean closeEnough(float d1, float d2) {
        return Math.abs(d1 - d2) < 1.0E-5f;
    }

    public static boolean closeEnoughP(float d1, float d2) {
        if (Math.abs(d1) < 1.0E-5f) {
            return Math.abs(d1 - d2) < 1.0E-5f;
        }
        return Math.abs((d1 - d2) / d1) < 1.0E-5f;
    }

    public static void main(String[] arg) throws IOException {
        NetcdfFile ncfile1 = NetcdfDataset.openFile("dods://thredds.cise-nsf.gov:8080/thredds/dodsC/satellite/SFC-T/SUPER-NATIONAL_1km/20090516/SUPER-NATIONAL_1km_SFC-T_20090516_2200.gini", null);
        NetcdfFile ncfile2 = NetcdfDataset.openFile("dods://motherlode.ucar.edu:8080/thredds/dodsC/satellite/SFC-T/SUPER-NATIONAL_1km/20090516/SUPER-NATIONAL_1km_SFC-T_20090516_2200.gini", null);
        CompareNetcdf.compareFiles(ncfile1, ncfile2, false, true, false);
    }
}

