/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.stream;

import java.io.IOException;
import java.nio.ByteBuffer;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.stream.NcStream;
import ucar.nc2.stream.NcStreamProto;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public class NcStreamIosp
extends AbstractIOServiceProvider {
    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        raf.seek(0L);
        if (!this.readAndTest(raf, NcStream.MAGIC_START)) {
            return false;
        }
        byte[] b = new byte[4];
        raf.read(b);
        return this.test(b, NcStream.MAGIC_HEADER) || this.test(b, NcStream.MAGIC_DATA);
    }

    public String getFileTypeId() {
        return "ncstream";
    }

    public String getFileTypeDescription() {
        return "netCDF streaming protocol";
    }

    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        this.raf = raf;
        raf.seek(0L);
        assert (this.readAndTest(raf, NcStream.MAGIC_START));
        assert (this.readAndTest(raf, NcStream.MAGIC_HEADER));
        int msize = this.readVInt(raf);
        System.out.println("READ header len= " + msize);
        byte[] m = new byte[msize];
        raf.read(m);
        NcStreamProto.Header proto = NcStreamProto.Header.parseFrom(m);
        NcStreamProto.Group root = proto.getRoot();
        for (NcStreamProto.Dimension dim : root.getDimsList()) {
            ncfile.addDimension(null, NcStream.decodeDim(dim));
        }
        for (NcStreamProto.Attribute att : root.getAttsList()) {
            ncfile.addAttribute(null, NcStream.decodeAtt(att));
        }
        for (NcStreamProto.Variable var : root.getVarsList()) {
            ncfile.addVariable(null, NcStream.decodeVar(ncfile, null, null, var));
        }
        while (!raf.isAtEndOfFile()) {
            assert (this.readAndTest(raf, NcStream.MAGIC_DATA));
            int psize = this.readVInt(raf);
            System.out.println(" dproto len= " + psize);
            byte[] dp = new byte[psize];
            raf.read(dp);
            NcStreamProto.Data dproto = NcStreamProto.Data.parseFrom(dp);
            System.out.println(" dproto = " + dproto);
            int dsize = this.readVInt(raf);
            System.out.println(" data len= " + dsize);
            DataSection dataSection = new DataSection();
            dataSection.size = dsize;
            dataSection.filePos = raf.getFilePointer();
            dataSection.section = NcStream.decodeSection(dproto.getSection());
            Variable v = ncfile.getRootGroup().findVariable(dproto.getVarName());
            v.setSPobject(dataSection);
            raf.skipBytes(dsize);
        }
    }

    public Array readData(Variable v, Section section) throws IOException, InvalidRangeException {
        DataSection dataSection = (DataSection)v.getSPobject();
        this.raf.seek(dataSection.filePos);
        byte[] data = new byte[dataSection.size];
        this.raf.read(data);
        Array dataArray = Array.factory(v.getDataType(), v.getShape(), ByteBuffer.wrap(data));
        return dataArray.section(section.getRanges());
    }

    private int readVInt(RandomAccessFile raf) throws IOException {
        byte b = (byte)raf.read();
        int i = b & 0x7F;
        int shift = 7;
        while ((b & 0x80) != 0) {
            b = (byte)raf.read();
            i |= (b & 0x7F) << shift;
            shift += 7;
        }
        return i;
    }

    private boolean readAndTest(RandomAccessFile raf, byte[] test) throws IOException {
        byte[] b = new byte[test.length];
        raf.read(b);
        return this.test(b, test);
    }

    private boolean test(byte[] bread, byte[] test) throws IOException {
        if (bread.length != test.length) {
            return false;
        }
        for (int i = 0; i < bread.length; ++i) {
            if (bread[i] == test[i]) continue;
            return false;
        }
        return true;
    }

    private class DataSection {
        int size;
        long filePos;
        Section section;

        private DataSection() {
        }
    }
}

