#! /bin/sh
#
# -------------------------------------------------------------------------
# Convert other getty issue to fbgetty syntax
# This is part of fbgetty package
#
# -------------------------------------------------------------------------
# @(#) $Id: convertissue.sh,v 1.1.2.2 2001/12/27 18:31:58 ydroneaud Exp $
# -------------------------------------------------------------------------
#
# Copyright (C) 2001 Yann Droneaud <ydroneaud@meuh.eu.org>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
#

VERSION='$Version$'
PROGRAM_NAME=`basename $0`

files=
arg=
syntax=

for arg in $* ; do
 case $arg in
   --help|-h|-\?) 
    cat <<EOF
Usage: $PROGRAM_NAME --syntax=[GETTY] files...
convert issue file form GETTY syntax to fbgetty
Options:
  --help         show this help
  --version      show version
  --syntax=GETTY select syntax to convert from
   GETTY could be:
    agetty
    fgetty
    getty_ps
    mgetty
    mingetty
    telnetd
    rungetty

send comment to Yann Droneaud <ydroneaud@meuh.eu.org>

EOF
    exit 0 ;;

   --version) 
    cat <<EOF
$PROGRAM_NAME version $VERSION
Copyright (C) 2001 Yann Droneaud <ydroneaud@meuh.eu.org>"
This is part of fbgetty
This is free software, and you are welcome to redistribute it under
the GNU General Public License. It comes with ABSOLUTELY NO WARRANTY.

EOF
    exit 0 ;;

   --syntax*) 
    syntax=`echo $arg | sed 's/--syntax=\(.*\)/\1/g'` ;;

   -*) 
    echo "Unrecognize option $arg" 1>&2
    echo "Try \`$PROGRAM_NAME --help' for more informations" 1>&2
    exit 1 ;;

   *) 
    if test "x$files" = "x" ; then files="$arg" ; else files="$files $arg" ; fi ;;

 esac
done

if test "x$files" = "x" ; then
  echo "No files specified..."  1>&2
  echo "Try \`$PROGRAM_NAME --help' for more informations" 1>&2
  exit 2 
fi

case $syntax in
  # getty_ps use @? with uppercase character
  #
  # @B current (evaluated at the time the @B is seen) baud rate.
  # @D current date, in MM/DD/YY .
  # @L line to which getty is attached.
  # @S system node name.
  # @T current time, in HH:MM:SS (24-hour) .
  # @U number of currently signed-on users.  This is a count of the number of entries  in  the  /etc/utmp
  #    file that have a non-null ut_name field.
  # @V value of VERSION, as given in the defaults file.
  getty_ps) cmd='s/@\(.\)/%\1/g' ;;

  # agetty/mingetty and rungetty use \? ,and does not handle control char
  #
  # \b baudrate of the current line.
  # \d current date.
  # \s system name, the name of the operating system.
  # \l name of the current tty line.
  # \m architecture identifier of the machine, eg. i486
  # \n nodename of the machine, also known as the hostname.
  # \o domainname of the machine.
  # \r release number of the OS, eg. 1.1.9.
  # \t current time.
  # \u number of current users logged in.
  # \U string "1 user" or "<n> users" where <n> is the number of current users logged in.
  # \v version of the OS, eg. the build-date etc.
  agetty|mingetty|rungetty|fgetty) cmd='s/\([^\\]\)\\\([^\\]\)/\1%\2/g' ;;

  # mgetty use a mix of \? control char (lower case) and special character (upper character)
  #
  # @ system name
  # \n newline
  # \r carriage return
  # \g bell
  # \b backspace (ascii 010)
  # \f form feed (ascii 013)
  # \t TAB
  # \P (and \L) port name (e.g. ttyS0)
  # \C date and time, in "ctime()" format
  # \I Connection string (e.g. 2400/REL)
  # \N (and \U) number of users currently logged in
  # \S Port speed (e.g. 38400)
  # \D current date in dd/mm/yy format
  # \T current time in hh:mm:ss format
  # \DIGIT character with the specified octal code
  mgetty) cmd= "";;

  # telnetd syntax is like fbgetty
  #
  # %t current tty
  # %h system node name (FQDN)
  # %D name of the NIS domain
  # %d current time and date
  # %s name of the operating system
  # %m machine (hardware) type
  # %r operating system release
  # %v operating system version
  # %% a single '%' character
  telnetd) cmd= "";;

  *) 
   echo "Unknown syntax '$syntax'" 1>&2
   echo "Try \`$PROGRAM_NAME --help' for more informations" 1>&2 
   exit 3 ;;
esac

for file in $files ; do
 sed $cmd $file
done
