/*
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "compiler.h"

#include "ptrace.h"
#include "segment.h"

#include "config.h"

/* ==================== RUNTIME_RM ==================== */
#ifdef RUNTIME_RM

CODE16;

void
bios_15_c0xx(struct regs *regs)
{
	static CONST struct config {
		unsigned short len;
		unsigned char sys_submodel_id;
		unsigned char sys_submodel_revision;
		unsigned char bios_revision;
		unsigned char feature_byte_1;
		unsigned char feature_byte_2;
		unsigned char feature_byte_3;
		unsigned char feature_byte_4;
		unsigned char feature_byte_5;
	} config = {
		/* (unsigned short) (sizeof(config) - sizeof(config.len)), */
		8, /* FIXME */

		0xfc,			/* sys model id (AT) */
		0x00,			/* sys submodel id */
		1,			/* bios revision */

		/*
		 * feature byte 1
		 */
		(0 << 7)		/* 1=DMA channel 3 used by hard disk */
		| (1 << 6)		/* 1=2 interrupt controllers present */
		| (1 << 5)		/* 1=RTC present */
		| (1 << 4)		/* 1=BIOS calls int 15h/4Fh every key */
		| (0 << 3)		/* 1=wait for extern event supported */
					/*   (Int 15h/41h) */
		| (1 << 2)		/* 1=extended BIOS data area used */
		| (0 << 1)		/* 0=AT or ESDI bus, 1=MicroChannel */
		| (0 << 0),		/* 1=Dual bus (MicroChannel + ISA) */

		/*
		 * feature byte 2
		 */
		(0 << 7)		/* 1=32-bit DMA supported */
		| (1 << 6)		/* 1=int16h, function 9 supported */
		| (0 << 5)		/* 1=int15h/C6h (get POS data) supported */
		| (0 << 4)		/* 1=int15h/C7h (get mem map info) supported */
		| (0 << 3)		/* 1=int15h/C8h (en/dis CPU) supported */
		| (0 << 2)		/* 1=non-8042 kb controller */
		| (0 << 1)		/* 1=data streaming supported */
		| (0 << 0),		/* reserved */

		/*
		 * feature byte 3
		 */
		(0 << 7)		/* not used */
		| (0 << 6)		/* reserved */
		| (0 << 5)		/* reserved */
		| (0 << 4)		/* POST supports ROM-to-RAM enable/disable */
		| (0 << 3)		/* SCSI on system board */
		| (0 << 2)		/* info panel installed */
		| (0 << 1)		/* Initial Machine Load (IML) system - BIOS on disk */
		| (0 << 0),		/* SCSI supported in IML */

		/*
		 * feature byte 4
		 */
		(0 << 7)		/* IBM private */
		| (0 << 6)		/* EEPROM present */
		| (0 << 3)		/* (3 bit) ABIOS presence (011 = not supported) */
		| (0 << 2)		/* private */
		| (0 << 1)		/* memory split above 16Mb supported */
		| (0 << 0),		/* POSTEXT directly supported by POST */

		/*
		 * feature byte 5
		 */
		(0 << 7)		/* reserved */
		| (0 << 6)		/* reserved */
		| (0 << 5)		/* reserved */
		| (0 << 4)		/* reserved */
		| (0 << 3)		/* reserved */
		| (0 << 2)		/* reserved */
		| (0 << 1)		/* enhanced mouse */
		| (0 << 0),		/* flash EPROM */
	};

	AH = 0;
	BX = PTR_OFF(&config);
	ES = PTR_SEG(&config); 

	F &= ~(1 << 0);	/* Clear CF. */
}

#endif /* RUNTIME_RM */
