/*
 * Copyright (C) 2015 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <gtk/gtk.h>

#include "glue.h"
#include "glue-gui-gtk.h"

#include "wattmeter_gui_gtk.h"

#define COMP		"wattmeter"
#define COMP_(x)	wattmeter_ ## x

struct cpssp {
	GtkWidget *gui_power;
};

/*
 * Simulator Callbacks
 */
static void
COMP_(gui_gtk_watt_set)(void *_cpssp, int val)
{
	struct cpssp *cpssp = _cpssp;
	char s[10];

	sprintf(s, "%5d mW", val);
	gtk_label_set_text((GtkLabel *) cpssp->gui_power, s);
	gui_gtk_flush();
}

void *
COMP_(gui_gtk_create)(
	unsigned int page,
	const char *name,
	struct sig_manage *port_manage,
	struct sig_std_logic *port_gnd,
	struct sig_std_logic *port_input,
	struct sig_std_logic *port_output,
	struct sig_integer *port_watt
)
{
	static const struct sig_integer_funcs watt_funcs = {
		.set = COMP_(gui_gtk_watt_set),
	};
	struct cpssp *cpssp;
	GtkWidget *hbox;
	GtkWidget *label;

	cpssp = shm_alloc(sizeof(*cpssp));
	assert(cpssp);

	hbox = gtk_hbox_new(FALSE, 1);

	label = gtk_label_new("  Power: ");
	gtk_widget_show(label);
	gtk_box_pack_start(GTK_BOX(hbox), label, TRUE, FALSE, 0);

	cpssp->gui_power = gtk_label_new("0 mW");
	gtk_widget_show(cpssp->gui_power);
	gtk_box_pack_start(GTK_BOX(hbox), cpssp->gui_power, TRUE, FALSE, 0);

	gtk_widget_show(hbox);

	gui_gtk_comp_add(page, COMP, name, hbox, FALSE, FALSE, NULL);

	/* Out */

	/* In */
	sig_integer_connect_in(port_watt, cpssp, &watt_funcs);

	return cpssp;
}

void
COMP_(gui_gtk_destroy)(void *_cpssp)
{
	struct cpssp *cpssp = _cpssp;

	shm_free(cpssp);
}

void
COMP_(gui_gtk_suspend)(void *_cpssp, FILE *fp)
{
	/* FIXME */
}

void
COMP_(gui_gtk_resume)(void *_cpssp, FILE *fp)
{
	/* FIXME */
}
