/*
 * Copyright (C) 2016 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>

#include "glue-gui.h"

#include "oscilloscope_gui.h"
#ifdef HAVE_GTK
#include "oscilloscope_gui_gtk.h"
#endif

void *
oscilloscope_gui_create(
	unsigned int page,
	const char *name,
	struct sig_manage *port_manage,
	struct sig_std_logic *port_a,
	struct sig_std_logic *port_b,
	struct sig_opt_rgb *port_monitor,
	struct sig_std_logic *port_gnd,
	struct sig_std_logic *port_vcc,
	struct sig_integer *port_adj_c,
	struct sig_integer *port_adj_d,
	struct sig_integer *port_adj_e,
	struct sig_integer *port_adj_f
)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		return oscilloscope_gui_gtk_create(page, name,
				port_manage,
				port_a,
				port_b,
				port_monitor,
				port_gnd,
				port_vcc,
				port_adj_c,
				port_adj_d,
				port_adj_e,
				port_adj_f
			);
	break;
#endif
	case GUI_NULL:
		return (void *)1;
	default:
		assert(0);
	}
}

void
oscilloscope_gui_destroy(void *_cpssp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		oscilloscope_gui_gtk_destroy(_cpssp);
		break;
#endif
	case GUI_NULL:
		/* Nothing to do... */
	default:
		assert(0);
	}
}

void
oscilloscope_gui_suspend(void *_cpssp, FILE *fp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		oscilloscope_gui_gtk_suspend(_cpssp, fp);
		break;
#endif
	case GUI_NULL:
		/* Nothing to do... */
		break;
	default:
		assert(0); /* Mustn't happen. */
	}
}

void
oscilloscope_gui_resume(void *_cpssp, FILE *fp)
{
	switch (selected_gui) {
#ifdef HAVE_GTK
	case GUI_GTK:
		oscilloscope_gui_gtk_resume(_cpssp, fp);
		break;
#endif
	case GUI_NULL:
		/* Nothing to do... */
		break;
	default:
		assert(0); /* Mustn't happen. */
	}
}
