/*
 * Copyright (C) 2016 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

/* 64-Bit Timer Plus (Timer) */

/*
 * For most of the comments, infos, ... see:
 * TI AM1808/AM1810 ARM Microprocessor - Technical Reference Manual
 * (SPRUH82A - December 2011), Chapter 30, pages 1429...
 */

#define DEBUG_CONTROL_FLOW	1

#ifdef INCLUDE
#endif /* INCLUDE */
#ifdef STATE

struct {
	uint32_t tim12;
	uint32_t tim34;
	uint32_t period12;
	uint32_t period34;

	uint8_t enamode12;
	uint8_t enamode34;

	uint32_t reg[0x1000 >> 2];
} NAME;

#endif /* STATE */
#ifdef BEHAVIOR

static void
NAME_(st)(struct cpssp *cpssp, uint32_t addr, unsigned int bs, uint32_t val)
{
	addr &= 0xfff;

	if (DEBUG_CONTROL_FLOW) {
		fprintf(stderr, "%s: addr=0x%08x, bs=0x%x, val=0x%08x\n",
				__FUNCTION__, addr, bs, val);
	}

	switch (addr) {
	/* ... */
	case 0x010:
		/* Timer Counter Register 12 */
		cpssp->NAME.tim12 = val;
		break;
	case 0x014:
		/* Timer Counter Register 34 */
		cpssp->NAME.tim34 = val;
		break;
	case 0x018:
		/* Timer Period Register 12 */
		cpssp->NAME.period12 = val;
		break;
	case 0x01c:
		/* Timer Period Register 34 */
		cpssp->NAME.period34 = val;
		break;
	case 0x020:
		/* Timer Control Register */
		/* ... - FIXME */
		cpssp->NAME.enamode34 = (val >> 22) & 3;
		/* ... - FIXME */
		cpssp->NAME.enamode12 = (val >> 6) & 3;
		/* ... - FIXME */
		break;
	case 0x024:
		/* Timer Global Control Register */
		goto todo;
		break;
	/* ... */
	default:
	todo:	;
		fprintf(stderr, "WARNING: %s: addr=0x%08x\n",
				__FUNCTION__, addr);

		cpssp->NAME.reg[addr >> 2] = val;
		break;
	}
}

static void
NAME_(ld)(struct cpssp *cpssp, uint32_t addr, unsigned int bs, uint32_t *valp)
{
	addr &= 0xfff;

	switch (addr) {
	/* ... */
	case 0x010:
		/* Timer Counter Register 12 */
		*valp = cpssp->NAME.tim12;
		break;
	case 0x014:
		/* Timer Counter Register 34 */
		*valp = cpssp->NAME.tim34;
		break;
	case 0x018:
		/* Timer Period Register 12 */
		*valp = cpssp->NAME.period12;
		break;
	case 0x01c:
		/* Timer Period Register 34 */
		*valp = cpssp->NAME.period34;
		break;
	case 0x020:
		/* Timer Control Register */
		*valp = 0;
		/* ... - FIXME */
		*valp |= cpssp->NAME.enamode34 << 22;
		/* ... - FIXME */
		*valp |= cpssp->NAME.enamode12 << 6;
		/* ... - FIXME */
		goto warn;
		break;
	case 0x024:
		/* Timer Global Control Register */
		goto todo;
		break;
	/* ... */
	default:
	todo:	;
		*valp = cpssp->NAME.reg[addr >> 2];
	warn:	;
		fprintf(stderr, "WARNING: %s: addr=0x%08x\n",
				__FUNCTION__, addr);
		break;
	}

	if (DEBUG_CONTROL_FLOW) {
		fprintf(stderr, "%s: addr=0x%08x, bs=0x%x, *valp=0x%08x\n",
				__FUNCTION__, addr, bs, *valp);
	}
}

static void
NAME_(clk)(struct cpssp *cpssp)
{
	if (cpssp->NAME.enamode12 != 0) {
		if (cpssp->NAME.tim12 == cpssp->NAME.period12) {
			cpssp->NAME.tim12 = 0;
		} else {
			cpssp->NAME.tim12++;
		}
	}
	if (cpssp->NAME.enamode34 != 0) {
		if (cpssp->NAME.tim34 == cpssp->NAME.period34) {
			cpssp->NAME.tim34 = 0;
		} else {
			cpssp->NAME.tim34++;
		}
	}
}

static void
NAME_(reset)(struct cpssp *cpssp)
{
	cpssp->NAME.tim12 = 0;
	cpssp->NAME.tim34 = 0;
	cpssp->NAME.period12 = 0;
	cpssp->NAME.period34 = 0;
	cpssp->NAME.enamode12 = 0;
	cpssp->NAME.enamode34 = 0;
}

static void
NAME_(create)(struct cpssp *cpssp)
{
}

static void
NAME_(destroy)(struct cpssp *cpssp)
{
}

#endif /* BEHAVIOR */

#undef DEBUG_CONTROL_FLOW
