/*
 *  $Id: video_fau_camera_gui.c,v 1.5 2010-11-26 14:45:01 vrsieh Exp $
 *
 * Copyright (C) 2010 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>

#include "config.h"

#include "glue-gui.h"

#include "video_fau_camera_gui.h"

#ifdef HAVE_GTK
#include "video_fau_camera_gui_gtk.h"
#endif

#include "video_fau_camera_gui_null.h"

void *
video_fau_camera_gui_create(
        unsigned int page,
        const char *name,
        struct sig_manage *port_manage,
	struct sig_boolean *port_power,
        struct sig_opt_rgb *port_in,
        struct sig_video *port_out,
	struct sig_string *port_image,
	struct sig_string *port_movie
)
{
        switch (selected_gui) {
#ifdef HAVE_GTK
        case GUI_GTK:
                return video_fau_camera_gui_gtk_create(page, name,
                                port_manage,
				port_power,
                                port_in,
                                port_out,
				port_image,
				port_movie);
                break;
#endif
        case GUI_NULL:
                return video_fau_camera_gui_null_create(page, name,
                                port_manage,
				port_power,
                                port_in,
                                port_out,
				port_image,
				port_movie);
                break;
        default:
                assert(0);
        }
}

void
video_fau_camera_gui_destroy(void *_cpssp)
{
        switch (selected_gui) {
#ifdef HAVE_GTK
        case GUI_GTK:
                video_fau_camera_gui_gtk_destroy(_cpssp);
                break;
#endif
        case GUI_NULL:
                video_fau_camera_gui_null_destroy(_cpssp);
                break;
        default:
                assert(0);
        }
}
