/* $Id: AssertStat.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __ASSERT_STAT_HPP_INCLUDED
#define __ASSERT_STAT_HPP_INCLUDED

#include "frontend/ast/ConditionedStat.hpp"

namespace ast {

/** a sequential ASSERT stat */
class AssertStat : public ConditionedStat {
public:
	//! c'tor
	/** @param cond condition when the assert statement should be
	 *         evaluated.
	 *  @param optReport expression to report
	 *  @param optSeverity severity of report
	 *  @param loc location of the assert statement.
	 */
	AssertStat(
		Expression *cond,
		Expression *optReport,
		Expression *optSeverity,
		Location loc
		  ) : ConditionedStat(cond, loc),
		      report(optReport),
		      severity(optSeverity) {}

	//! Accept a Visitor.
 	/** All leaf AST nodes need to implement this method.
         *
         *  @param visitor the Visitor that can visit this node.
         */
	virtual void accept(Visitor& visitor) {
		visitor.visit(*this);
	}

	/** Put a textual representation of the AstNode on the stream.
	 *  @param stream stream to put the textual representation to.
	 */
	virtual void put(std::ostream &stream) const {
		stream << "Assert";
	}


	/** what to report (optional) */
	Expression *report;

	/** severity expression (optional) */
	Expression *severity;

protected:
	/** destructor */
	virtual ~AssertStat() {
		util::MiscUtil::terminate(this->report);
		util::MiscUtil::terminate(this->severity);
	}
};

}; /* namespace ast */

#endif /* __ASSERT_STAT_HPP_INCLUDED */
