/* $Id: Types.cpp 4323 2009-01-27 13:48:12Z potyra $
 *
 * Types: base types of VHDL.
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "frontend/ast/Types.hpp"
#include <cassert>

namespace ast {

enum BaseType
operator &&(enum BaseType left, enum BaseType right)
{
	if (left == right) {
		return left;
	}

	switch(left) {
	case BASE_TYPE_INTEGER:
		switch (right) {
		case BASE_TYPE_REAL:
			return right;

		default:
			return BASE_TYPE_UNSET;
		}

	case BASE_TYPE_REAL:
		switch (right) {
		case BASE_TYPE_INTEGER:
			return left;

		default:
			return BASE_TYPE_UNSET;
		}

	case BASE_TYPE_RANGE_INT:
		switch (right) {
		case BASE_TYPE_RANGE_REAL:
			return right;

		default:
			return BASE_TYPE_UNSET;
		}

	case BASE_TYPE_RANGE_REAL:
		switch (right) {
		case BASE_TYPE_RANGE_INT:
			return left;

		default:
			return BASE_TYPE_UNSET;
		}

	case BASE_TYPE_ENUM:
		switch (right) {
		case BASE_TYPE_ENUM:
			return left;

		default:
			return BASE_TYPE_UNSET;
		};
	default:
		break;
	}

	return BASE_TYPE_UNSET;
}


enum intermediate::OpType
toOpType(enum BaseType src)
{
	switch (src) {
	case BASE_TYPE_ARRAY:
	case BASE_TYPE_RECORD:
		return intermediate::OP_TYPE_POINTER;
		
	case BASE_TYPE_REAL:
		return intermediate::OP_TYPE_REAL;
	
	case BASE_TYPE_ENUM:
	case BASE_TYPE_INTEGER:
		return intermediate::OP_TYPE_INTEGER;

	case BASE_TYPE_UNSET:
	case BASE_TYPE_RANGE_REAL:
	case BASE_TYPE_RANGE_INT:
		/* must not happend */
		assert(false);
		break;
	}

	/* not reached */
	return intermediate::OP_TYPE_POINTER;
}

}; /* namespace ast */
