/* $Id: glue-main.h 4321 2009-01-27 13:02:52Z potyra $ 
 * FAUmachine main simulation functionality (stripped to necessary parts)
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __GLUE_MAIN_H_INCLUDED
#define __GLUE_MAIN_H_INCLUDED

#include <stdint.h>

/** used to determine if a failure is present. 0=no failure, other values
 *  mean an error occured.
 */
extern int failure;

/** Get virtual time.
 *  @return virtual time in TIME_HZ ticks.
 */
extern int64_t
time_virt(void);

/** Register a timer to call func with parameter data as soon as the
 *  simulation time tsc is reached.
 *  @param tsc virtual timestamp counter, 1 second == 1 * TIME_HZ.
 *  @param func callback that will be called.
 *  @param data parameter to the callback.
 */
extern void
time_call_at(int64_t tsc, void (*func)(void *data), void *data);

/** Stop simulation node.
 */
extern void
frontend_quit(void);

#endif /* __GLUE_MAIN_H_INCLUDED */
