/* $Id: EnumerationType.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __ENUMERATION_TYPE_HPP_INCLUDED
#define __ENUMERATION_TYPE_HPP_INCLUDED

#include "frontend/ast/TypeDeclaration.hpp"
#include "frontend/ast/EnumerationElement.hpp"

namespace ast {


//! one VHDL enumeration type.
/** This class represents one VHDL enumeration type.
 */
class EnumerationType : public TypeDeclaration {
public:
	//! c'tor
	/** @param declName name of the declared type.
          * @param elems declared enumeration elements (either ConstChar or
          *              ConstString).
          * @param loc location of the declaration.
          */
	EnumerationType(
		std::string* declName,
		std::list<EnumerationElement*>* elems,
		Location loc
		) : 	TypeDeclaration(declName, loc, BASE_TYPE_ENUM),
			elements(elems) {

			// enumerate all elements... and set link back to me.
			int j = 0;
			for (std::list<EnumerationElement*>::iterator i = 
				this->elements->begin(); 
				i != this->elements->end(); i++) {

				(*i)->value = j;
				(*i)->type = this;
				j++;
			}
	}

	//! Accept a Visitor.
 	/** All leaf AST nodes need to implement this method.
         *
         *  @param visitor the Visitor that can visit this node.
         */
	virtual void accept(Visitor& visitor) {
		visitor.visit(*this);
	}

	/** Put a textual representation of the AstNode on the stream.
	 *  @param stream stream to put the textual representation to.
	 */
	virtual void put(std::ostream &stream) const {
		assert(this->name);
		stream << "EnumerationType " << *this->name;
	}

	/** declared enumeration elements (either ConstChar or ConstString */
	std::list<EnumerationElement*>* elements;
};

}; /* namespace ast */

#endif /* __ENUMERATION_TYPE_HPP_INCLUDED */
