/* $Id: EnumerationElement.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * EnumerationElement: AST node of an enumeration element of an enumeration
 * type.
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */


#ifndef __ENUMERATION_ELEMENT_HPP_INCLUDED
#define __ENUMERATION_ELEMENT_HPP_INCLUDED

#include <string>
#include "frontend/ast/SymbolDeclaration.hpp"
#include "frontend/ast/Types.hpp"

namespace ast {

//! One element of an EnumerationType.
/** This class represents one element of an EnumerationType.
 */
class EnumerationElement : public SymbolDeclaration {
public:
	/** c'tor for string enumeration elements (identifier).
	 *  @param sym declared symbol
	 *  @param loc location of the declaration.
	 */
	EnumerationElement(
		std::string *sym, 
		Location loc
		) : 	SymbolDeclaration(sym, loc),
			value(-1),
			type(NULL) {}

	//! Accept a Visitor.
 	/** All leaf AST nodes need to implement this method.
         *
         *  @param visitor the Visitor that can visit this node.
         */
	virtual void accept(Visitor& visitor) {
		visitor.visit(*this);
	}

	/** Put a textual representation of the AstNode on the stream.
	 *  @param stream stream to put the textual representation to.
	 */
	virtual void put(std::ostream &stream) const {
		assert(this->name);
		stream << '\'' << *this->name << '\'';
	}

	/** (numerical) value, the element refers to */
	universal_integer value;
	/** link back to parent type 
	 *  (attention, not reference counted, due to cyclic nature) */
	const EnumerationType *type;
};

}; /* namespace ast */

#endif /* __ENUMERATION_ELEMENT_HPP_INCLUDED */
