/* $Id: glue-vhdl.c 4321 2009-01-27 13:02:52Z potyra $
 *
 *  Glue layer between fauhdli and FAUmachine to access FAUmachine signals 
 *  from VHDL.
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "glue-vhdl.h"
#include "glue-log.h"
#include <assert.h>
#include <stdlib.h>

struct glue_vhdl {
	unsigned int max_sig_id;
	unsigned int max_comp_id;
};


void
glue_vhdl_proc_set(
	struct glue_vhdl *s,
	const char *proc,
	const char *param,
	union fauhdli_value value
)
{
	faum_log(FAUM_LOG_WARNING, "fauhdli", "glue-vhdl",
		"Set foreign paramter %s of procedure %s. Skipping.\n",
		param, proc);
}

void
glue_vhdl_proc_call(struct glue_vhdl *s, const char *proc)
{
	faum_log(FAUM_LOG_WARNING, "fauhdli", "glue-vhdl",
		"Foreign procedure call of %s requested. Skipping.\n",
		proc);
}

void
glue_vhdl_set(
	struct glue_vhdl *s, 
	unsigned int sig_id, 
	union fauhdli_value data,
	void *drv
)
{
	assert(sig_id <= s->max_sig_id);
	faum_log(FAUM_LOG_WARNING, "fauhdli", "glue-vhdl",
		"Setting foreign signal %d requested. Skipping.\n", sig_id);
}

void
glue_vhdl_connect_out(
	struct glue_vhdl *s, 
	unsigned int sig_id,
	union fauhdli_value init,
	void *drv
)
{
	assert(sig_id <= s->max_sig_id);
	faum_log(FAUM_LOG_WARNING, "fauhdli", "glue-vhdl",
		"Connecting a driver to a foreign signal %d requested. "
		"Skipping.\n", sig_id);
}

void
glue_vhdl_connect_in(
	struct glue_vhdl *s,
	unsigned int sig_id,
	void (*drv_update)(void *_drv, union fauhdli_value value),
	void *drv
)
{
	assert(sig_id <= s->max_sig_id);
	faum_log(FAUM_LOG_WARNING, "fauhdli", "glue-vhdl",
		"Connecting a signal to a foreign signal %d requested. "
		"Skipping.\n", sig_id);
}

unsigned int
glue_vhdl_create_signal(
	struct glue_vhdl *s, 
	const char *type,
	const char *name
)
{
	faum_log(FAUM_LOG_WARNING, "fauhdli", "glue-vhdl", 
		"Foreign signal %s of type %s requested. Skipping.\n",
		name, type);
	s->max_sig_id++;
	return s->max_sig_id;
}

void
glue_vhdl_enable_event_wakeups(
	struct glue_vhdl *s, 
	void *_instance, 
	void (*cb)(void *_inst)
)
{
	/* nothing to do/check */
}

unsigned int
glue_vhdl_comp_create(
	struct glue_vhdl *s, 
	const char *type, 
	const char *name,
	unsigned int stack_depth
)
{
	faum_log(FAUM_LOG_WARNING, "fauhdli", "glue-vhdl",
		"Foreign component %s of type %s requested. Skipping\n",
		name, type);
	s->max_comp_id++;
	return s->max_comp_id;
}

void
glue_vhdl_comp_init(struct glue_vhdl *s, unsigned int comp)
{
	assert(comp <= s->max_comp_id);

	faum_log(FAUM_LOG_WARNING, "fauhdli", "glue-vhdl",
		"Initialization of foreign component %d requested."
		"Skipping.\n", comp);
}

void
glue_vhdl_comp_port_connect(
	struct glue_vhdl *s,
	unsigned int comp,
	const char *port,
	unsigned int sig
)
{
	assert(s != NULL);
	assert(comp <= s->max_comp_id);
	assert(sig <= s->max_sig_id);

	faum_log(FAUM_LOG_WARNING, "fauhdli", "glue-vhdl",
		"Foreign port %s of component %d request to connect to "
		"signal %d. Skipping\n", port, comp, sig);
}

void
glue_vhdl_comp_generic_set(
	struct glue_vhdl *s,
	unsigned int comp,
	const char *generic,
	union fauhdli_value val
)
{
	assert(s != NULL);
	assert(comp <= s->max_comp_id);
	
	faum_log(FAUM_LOG_WARNING, "fauhdli", "glue-vhdl",
		"Setting foreign generic %s of component %d requested. "
		"Skipping.\n", generic, comp);
}

struct glue_vhdl *
glue_vhdl_create(void)
{
	struct glue_vhdl *ret = malloc(sizeof(struct glue_vhdl));
	ret->max_sig_id = 0;
	ret->max_comp_id = 0;
	return ret;
}

void
glue_vhdl_destroy(struct glue_vhdl *s)
{
	assert(s != NULL);
	free(s);
}
