/* $Id: RegisterFactory.cpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * RegisterFactory: create and keep track of virtual registers.
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "intermediate/operands/RegisterFactory.hpp"
#include "intermediate/operands/Register.hpp"

namespace intermediate {

/* numbers <= 10 are reserved for special purposes:
 *   0 : integer return register
 *   1 : float return register
 *   2 : pointer return register
 *   3 : integer simulation time ("now()")
 *   4-9 : n.n.
 */
int RegisterFactory::counter = 10;

Register*
RegisterFactory::getRegister(enum OpType type)
{
	Register *ret = 
		new Register(type, RegisterFactory::counter);
	
	RegisterFactory::counter++;
	return ret;
}

Register*
RegisterFactory::getReturnRegister(enum OpType type)
{
	switch(type) {
	case OP_TYPE_INTEGER: {
		static Register *intReturn = NULL;
		if (intReturn == NULL) {
			intReturn = new Register(OP_TYPE_INTEGER, 0);
		}
		return intReturn;
	    }
	case OP_TYPE_REAL: {
		static Register *realReturn = NULL;
		if (realReturn == NULL) {
			realReturn = new Register(OP_TYPE_REAL, 1);
		}
		return realReturn;
	    }
	case OP_TYPE_POINTER: {
		static Register *ptrReturn = NULL;
		if (ptrReturn == NULL) {
			ptrReturn = new Register(OP_TYPE_POINTER, 2);
		}
		return ptrReturn;
	    }
	}
	// not reached
	return NULL;
}

Register *
RegisterFactory::getSimTime(void)
{
	Register *ret = new Register(OP_TYPE_INTEGER, 3);
	return ret;
}

}; /* namespace intermediate */
