/* $Id: TypeFactory.cpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "intermediate/container/TypeFactory.hpp"
#include <cassert>

namespace intermediate {

TypeFactory::typesNameT TypeFactory::typesByName = TypeFactory::initialize();

TypeFactory::typesNameT
TypeFactory::initialize(void)
{
	TypeFactory::typesNameT ret = typesNameT();
	Type *t = new Type("universal_integer", std::list<TypeElement*>());
	ret["universal_integer"] = t;

	t = new Type("universal_real", std::list<TypeElement*>());
	ret["universal_real"] = t;

	return ret;
}

std::string 
TypeFactory::getTypeName(enum ast::BaseType bt) {
	switch(bt) {
	case ast::BASE_TYPE_INTEGER:
		return std::string("universal_integer");
	case ast::BASE_TYPE_REAL:
		return std::string("universal_real");
	default:
		assert(false);
	}

	// not reached.
	// make g++ happy
	return std::string("error: not reached");
}

Type *
TypeFactory::getType(std::string typeName, std::list<TypeElement*> relements)
{
	Type *t = new Type(typeName, relements);
	TypeFactory::typesByName[typeName] = t;
	return t;
}

Type *
TypeFactory::lookupType(std::string typeName)
{
	typesNameT::const_iterator i = 
		TypeFactory::typesByName.find(typeName);

	if (i != TypeFactory::typesByName.end()) {
		return i->second;
	}

	return NULL;
}

}; /* namespace intermediate */
