// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file constantsCdrAux.ipp
 * This source file contains some declarations of CDR related functions.
 *
 * This file was generated by the tool fastddsgen.
 */

#ifndef FAST_DDS_GENERATED__CONSTANTSCDRAUX_IPP
#define FAST_DDS_GENERATED__CONSTANTSCDRAUX_IPP

#include "constantsCdrAux.hpp"

#include <fastcdr/Cdr.h>
#include <fastcdr/CdrSizeCalculator.hpp>


#include <fastcdr/exceptions/BadParamException.h>
using namespace eprosima::fastcdr::exception;

namespace eprosima {
namespace fastcdr {

template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const const_module1::ModuleConstsLiteralsStruct& data,
        size_t& current_alignment)
{
    using namespace const_module1;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.module1_array_literal_const_moduled(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.module1_array_literal_const_alias_const_moduled(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.var1(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(3),
                data.var2(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const const_module1::ModuleConstsLiteralsStruct& data)
{
    using namespace const_module1;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.module1_array_literal_const_moduled()
        << eprosima::fastcdr::MemberId(1) << data.module1_array_literal_const_alias_const_moduled()
        << eprosima::fastcdr::MemberId(2) << data.var1()
        << eprosima::fastcdr::MemberId(3) << data.var2()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        const_module1::ModuleConstsLiteralsStruct& data)
{
    using namespace const_module1;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.module1_array_literal_const_moduled();
                                            break;

                                        case 1:
                                                dcdr >> data.module1_array_literal_const_alias_const_moduled();
                                            break;

                                        case 2:
                                                dcdr >> data.var1();
                                            break;

                                        case 3:
                                                dcdr >> data.var2();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const const_module1::ModuleConstsLiteralsStruct& data)
{
    using namespace const_module1;

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.module1_array_literal_const_moduled();

                        scdr << data.module1_array_literal_const_alias_const_moduled();

                        scdr << data.var1();

                        scdr << data.var2();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const const_module2::Module2ConstsLiteralsStruct& data,
        size_t& current_alignment)
{
    using namespace const_module2;

    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.module2_array_literal_const_moduled(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.module2_array_literal_const_alias_const_moduled(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.module2_array_literal_const_scoped_moduled(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(3),
                data.module2_array_literal_module1_const_moduled(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const const_module2::Module2ConstsLiteralsStruct& data)
{
    using namespace const_module2;

    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.module2_array_literal_const_moduled()
        << eprosima::fastcdr::MemberId(1) << data.module2_array_literal_const_alias_const_moduled()
        << eprosima::fastcdr::MemberId(2) << data.module2_array_literal_const_scoped_moduled()
        << eprosima::fastcdr::MemberId(3) << data.module2_array_literal_module1_const_moduled()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        const_module2::Module2ConstsLiteralsStruct& data)
{
    using namespace const_module2;

    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.module2_array_literal_const_moduled();
                                            break;

                                        case 1:
                                                dcdr >> data.module2_array_literal_const_alias_const_moduled();
                                            break;

                                        case 2:
                                                dcdr >> data.module2_array_literal_const_scoped_moduled();
                                            break;

                                        case 3:
                                                dcdr >> data.module2_array_literal_module1_const_moduled();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const const_module2::Module2ConstsLiteralsStruct& data)
{
    using namespace const_module2;

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.module2_array_literal_const_moduled();

                        scdr << data.module2_array_literal_const_alias_const_moduled();

                        scdr << data.module2_array_literal_const_scoped_moduled();

                        scdr << data.module2_array_literal_module1_const_moduled();

}


template<>
eProsima_user_DllExport size_t calculate_serialized_size(
        eprosima::fastcdr::CdrSizeCalculator& calculator,
        const ConstsLiteralsStruct& data,
        size_t& current_alignment)
{
    static_cast<void>(data);

    eprosima::fastcdr::EncodingAlgorithmFlag previous_encoding = calculator.get_encoding();
    size_t calculated_size {calculator.begin_calculate_type_serialized_size(
                                eprosima::fastcdr::CdrVersion::XCDRv2 == calculator.get_cdr_version() ?
                                eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
                                eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
                                current_alignment)};


        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(0),
                data.array_literal_const_short(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(1),
                data.array_literal_const_ushort(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(2),
                data.array_literal_const_long(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(3),
                data.array_literal_const_ulong(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(4),
                data.array_literal_const_longlong(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(5),
                data.array_literal_const_ulonglong(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(6),
                data.array_literal_const_int8(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(7),
                data.array_literal_const_uint8(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(8),
                data.array_literal_const_int16(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(9),
                data.array_literal_const_uint16(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(10),
                data.array_literal_const_int32(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(11),
                data.array_literal_const_uint32(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(12),
                data.array_literal_const_int64(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(13),
                data.array_literal_const_uint64(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(14),
                data.array_literals_operations1_const(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(15),
                data.array_literals_operations2_const(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(16),
                data.array_literals_operations3_const(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(17),
                data.array_literals_operations4_const(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(18),
                data.array_literals_operations5_const(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(19),
                data.array_literals_operations6_const(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(20),
                data.array_literals_operations7_const(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(21),
                data.array_literals_operations8_const(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(22),
                data.array_literal_const_inner_const_helper(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(23),
                data.array_moduled1_literal_const(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(24),
                data.array_moduled2_literal_const(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(25),
                data.array_literal_const_alias_const(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(26),
                data.array_moduled1_literal_alias_const_moduled(), current_alignment);

        calculated_size += calculator.calculate_member_serialized_size(eprosima::fastcdr::MemberId(27),
                data.array_moduled2_literal_alias_const_moduled(), current_alignment);


    calculated_size += calculator.end_calculate_type_serialized_size(previous_encoding, current_alignment);

    return calculated_size;
}

template<>
eProsima_user_DllExport void serialize(
        eprosima::fastcdr::Cdr& scdr,
        const ConstsLiteralsStruct& data)
{
    eprosima::fastcdr::Cdr::state current_state(scdr);
    scdr.begin_serialize_type(current_state,
            eprosima::fastcdr::CdrVersion::XCDRv2 == scdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR);

    scdr
        << eprosima::fastcdr::MemberId(0) << data.array_literal_const_short()
        << eprosima::fastcdr::MemberId(1) << data.array_literal_const_ushort()
        << eprosima::fastcdr::MemberId(2) << data.array_literal_const_long()
        << eprosima::fastcdr::MemberId(3) << data.array_literal_const_ulong()
        << eprosima::fastcdr::MemberId(4) << data.array_literal_const_longlong()
        << eprosima::fastcdr::MemberId(5) << data.array_literal_const_ulonglong()
        << eprosima::fastcdr::MemberId(6) << data.array_literal_const_int8()
        << eprosima::fastcdr::MemberId(7) << data.array_literal_const_uint8()
        << eprosima::fastcdr::MemberId(8) << data.array_literal_const_int16()
        << eprosima::fastcdr::MemberId(9) << data.array_literal_const_uint16()
        << eprosima::fastcdr::MemberId(10) << data.array_literal_const_int32()
        << eprosima::fastcdr::MemberId(11) << data.array_literal_const_uint32()
        << eprosima::fastcdr::MemberId(12) << data.array_literal_const_int64()
        << eprosima::fastcdr::MemberId(13) << data.array_literal_const_uint64()
        << eprosima::fastcdr::MemberId(14) << data.array_literals_operations1_const()
        << eprosima::fastcdr::MemberId(15) << data.array_literals_operations2_const()
        << eprosima::fastcdr::MemberId(16) << data.array_literals_operations3_const()
        << eprosima::fastcdr::MemberId(17) << data.array_literals_operations4_const()
        << eprosima::fastcdr::MemberId(18) << data.array_literals_operations5_const()
        << eprosima::fastcdr::MemberId(19) << data.array_literals_operations6_const()
        << eprosima::fastcdr::MemberId(20) << data.array_literals_operations7_const()
        << eprosima::fastcdr::MemberId(21) << data.array_literals_operations8_const()
        << eprosima::fastcdr::MemberId(22) << data.array_literal_const_inner_const_helper()
        << eprosima::fastcdr::MemberId(23) << data.array_moduled1_literal_const()
        << eprosima::fastcdr::MemberId(24) << data.array_moduled2_literal_const()
        << eprosima::fastcdr::MemberId(25) << data.array_literal_const_alias_const()
        << eprosima::fastcdr::MemberId(26) << data.array_moduled1_literal_alias_const_moduled()
        << eprosima::fastcdr::MemberId(27) << data.array_moduled2_literal_alias_const_moduled()
;
    scdr.end_serialize_type(current_state);
}

template<>
eProsima_user_DllExport void deserialize(
        eprosima::fastcdr::Cdr& cdr,
        ConstsLiteralsStruct& data)
{
    cdr.deserialize_type(eprosima::fastcdr::CdrVersion::XCDRv2 == cdr.get_cdr_version() ?
            eprosima::fastcdr::EncodingAlgorithmFlag::DELIMIT_CDR2 :
            eprosima::fastcdr::EncodingAlgorithmFlag::PLAIN_CDR,
            [&data](eprosima::fastcdr::Cdr& dcdr, const eprosima::fastcdr::MemberId& mid) -> bool
            {
                bool ret_value = true;
                switch (mid.id)
                {
                                        case 0:
                                                dcdr >> data.array_literal_const_short();
                                            break;

                                        case 1:
                                                dcdr >> data.array_literal_const_ushort();
                                            break;

                                        case 2:
                                                dcdr >> data.array_literal_const_long();
                                            break;

                                        case 3:
                                                dcdr >> data.array_literal_const_ulong();
                                            break;

                                        case 4:
                                                dcdr >> data.array_literal_const_longlong();
                                            break;

                                        case 5:
                                                dcdr >> data.array_literal_const_ulonglong();
                                            break;

                                        case 6:
                                                dcdr >> data.array_literal_const_int8();
                                            break;

                                        case 7:
                                                dcdr >> data.array_literal_const_uint8();
                                            break;

                                        case 8:
                                                dcdr >> data.array_literal_const_int16();
                                            break;

                                        case 9:
                                                dcdr >> data.array_literal_const_uint16();
                                            break;

                                        case 10:
                                                dcdr >> data.array_literal_const_int32();
                                            break;

                                        case 11:
                                                dcdr >> data.array_literal_const_uint32();
                                            break;

                                        case 12:
                                                dcdr >> data.array_literal_const_int64();
                                            break;

                                        case 13:
                                                dcdr >> data.array_literal_const_uint64();
                                            break;

                                        case 14:
                                                dcdr >> data.array_literals_operations1_const();
                                            break;

                                        case 15:
                                                dcdr >> data.array_literals_operations2_const();
                                            break;

                                        case 16:
                                                dcdr >> data.array_literals_operations3_const();
                                            break;

                                        case 17:
                                                dcdr >> data.array_literals_operations4_const();
                                            break;

                                        case 18:
                                                dcdr >> data.array_literals_operations5_const();
                                            break;

                                        case 19:
                                                dcdr >> data.array_literals_operations6_const();
                                            break;

                                        case 20:
                                                dcdr >> data.array_literals_operations7_const();
                                            break;

                                        case 21:
                                                dcdr >> data.array_literals_operations8_const();
                                            break;

                                        case 22:
                                                dcdr >> data.array_literal_const_inner_const_helper();
                                            break;

                                        case 23:
                                                dcdr >> data.array_moduled1_literal_const();
                                            break;

                                        case 24:
                                                dcdr >> data.array_moduled2_literal_const();
                                            break;

                                        case 25:
                                                dcdr >> data.array_literal_const_alias_const();
                                            break;

                                        case 26:
                                                dcdr >> data.array_moduled1_literal_alias_const_moduled();
                                            break;

                                        case 27:
                                                dcdr >> data.array_moduled2_literal_alias_const_moduled();
                                            break;

                    default:
                        ret_value = false;
                        break;
                }
                return ret_value;
            });
}

void serialize_key(
        eprosima::fastcdr::Cdr& scdr,
        const ConstsLiteralsStruct& data)
{

    static_cast<void>(scdr);
    static_cast<void>(data);
                        scdr << data.array_literal_const_short();

                        scdr << data.array_literal_const_ushort();

                        scdr << data.array_literal_const_long();

                        scdr << data.array_literal_const_ulong();

                        scdr << data.array_literal_const_longlong();

                        scdr << data.array_literal_const_ulonglong();

                        scdr << data.array_literal_const_int8();

                        scdr << data.array_literal_const_uint8();

                        scdr << data.array_literal_const_int16();

                        scdr << data.array_literal_const_uint16();

                        scdr << data.array_literal_const_int32();

                        scdr << data.array_literal_const_uint32();

                        scdr << data.array_literal_const_int64();

                        scdr << data.array_literal_const_uint64();

                        scdr << data.array_literals_operations1_const();

                        scdr << data.array_literals_operations2_const();

                        scdr << data.array_literals_operations3_const();

                        scdr << data.array_literals_operations4_const();

                        scdr << data.array_literals_operations5_const();

                        scdr << data.array_literals_operations6_const();

                        scdr << data.array_literals_operations7_const();

                        scdr << data.array_literals_operations8_const();

                        scdr << data.array_literal_const_inner_const_helper();

                        scdr << data.array_moduled1_literal_const();

                        scdr << data.array_moduled2_literal_const();

                        scdr << data.array_literal_const_alias_const();

                        scdr << data.array_moduled1_literal_alias_const_moduled();

                        scdr << data.array_moduled2_literal_alias_const_moduled();

}



} // namespace fastcdr
} // namespace eprosima

#endif // FAST_DDS_GENERATED__CONSTANTSCDRAUX_IPP

