/*
 Falselogin by Tibor Koleszar <oldw@debian.org> GNU/GPL
*/
#include <stdio.h>
#include <publib.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/utsname.h>

#define CONFIG_FILE "/etc/falselogin.conf"
#define MESSAGE_ID "Message-ID"

int
main (int argc, char *argv[])
{
  FILE *f;
  struct passwd *pwd;
  char *temp, s_mail[50], host_n[512], deb_ver[50] = "";
  struct utsname u_name;
  int ok = 0;
  int total = 0;

  temp = (char *) malloc (1024);
  gethostname(host_n, 512);


  if (uname ((struct utsname *) &u_name) == -1)
    {
      perror ("Error at calling uname()");
      exit (255);
    }

  while (!ok)
    {
      pwd = getpwent ();
      if (pwd->pw_uid == getuid ())
	ok = 1;
    }
  sprintf (temp, "/var/spool/mail/%s", pwd->pw_name);
  if ((f = fopen (temp, "rt")) == NULL)
    strcpy (s_mail, "No mail.");
  else
    {
      while (!feof (f))
	{
	  fgets (temp, 1024, f);
	  if (!strncasecmp (temp, MESSAGE_ID, strlen (MESSAGE_ID)))
	    total++;
	}
      fclose (f);
    }

  if (!total)
    strcpy (s_mail, "No mail.");
  else
    sprintf (s_mail, "You have total %d new mail.", total);


  if ((f = fopen ("/etc/debian_version", "rt")) != NULL)
    {
      fgets(deb_ver, sizeof(deb_ver), f);
      if (*deb_ver && deb_ver[strlen(deb_ver)-1] == '\n')
	deb_ver[strlen(deb_ver)-1] = 0;
      fclose(f);
    };

  if ((f = fopen (CONFIG_FILE, "rt")) == NULL)
    {
      perror ("Can't parse config file");
      exit (255);
    };

  while (!feof (f))
    {
      fgets (temp, 1024, f);
      if (!feof (f) && strncmp(temp, "#", 1))
	{
	  if (strstr (temp, "%mail%") != NULL)
	    strsub (temp, "%mail%", s_mail);
	  if (strstr (temp, "%user%") != NULL)
	    strsub (temp, "%user%", pwd->pw_name);
	  if (strstr (temp, "%sysname%") != NULL)
	    strsub (temp, "%sysname%", u_name.sysname);
	  if (strstr (temp, "%nodename%") != NULL)
	    strsub (temp, "%nodename%", u_name.nodename);
	  if (strstr (temp, "%release%") != NULL)
	    strsub (temp, "%release%", u_name.release);
	  if (strstr (temp, "%version%") != NULL)
	    strsub (temp, "%version%", u_name.version);
	  if (strstr (temp, "%machine%") != NULL)
	    strsub (temp, "%machine%", u_name.machine);
	  if (strstr (temp, "%host%") != NULL)
	    strsub (temp, "%host%", host_n);
	  if (strstr (temp, "%debian_version%") != NULL)
	    strsub (temp, "%debian_version%", deb_ver);
	  printf ("%s", temp);
	}
    }
  fclose (f);


  if (argc >= 2) {
   if ( (!strncmp(argv[1], "--wait", 6) || !strncmp(argv[1], "-w", 2)) && atol(argv[2]) > 0 )
    sleep(atol(argv[2]));
   if ( (!strncmp(argv[1], "--wait", 6) || !strncmp(argv[1], "-w", 2)) && !strncmp(argv[2], "enter", 5) )
    while (getchar() != 10);
  }    
  

  free (temp);
  return 1;
}
