# This file is part of the Falcon repository manager
# Copyright (C) 2005-2008 Dennis Kaarsemaker
# See the file named COPYING in the root of the source tree for license details
#
# shell.py - Utilities for a falcon shell 

import falcon
from falcon.models import *
import cPickle as pickle
import django
from django.db import connection

def source(**kwargs):
    return falcon.package.SourcePackage.objects.get(**kwargs)
def sources(**kwargs):
    if kwargs: return falcon.package.SourcePackage.objects.get(**kwargs)
    return falcon.package.SourcePackage.objects.all()
def binary(**kwargs):
    return falcon.package.BinaryPackage.objects.get(**kwargs)
def binaries(**kwargs):
    if kwargs: return falcon.package.BinaryPackage.objects.filter(**kwargs)
    return falcon.package.BinaryPackage.objects.all()

conf = falcon.conf
plugins = falcon.plugin.enabled_plugins
mirrors = list(falcon.mirror.Mirror.objects.all())
