// ext3grep -- An ext3 file system investigation and undelete tool
//
//! @file dir_inode_to_block.h Declarations for dir_inode_to_block.cc
//
// Copyright (C) 2008, by
// 
// Carlo Wood, Run on IRC <carlo@alinoe.com>
// RSA-1024 0x624ACAD5 1997-01-26                    Sign & Encrypt
// Fingerprint16 = 32 EC A7 B6 AC DB 65 A6  F6 F6 55 DD 1C DC FF 61
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

#ifndef DIR_INIDE_TO_BLOCK_H
#define DIR_INIDE_TO_BLOCK_H

#ifndef USE_PCH
#include <string>
#include <vector>
#endif

#include "blocknr_vector_type.h"

bool does_not_end_on_END(std::string const& cachename);
void init_dir_inode_to_block_cache(void);
int dir_inode_to_block(uint32_t inode);
extern blocknr_vector_type* dir_inode_to_block_cache;
extern std::vector<int> extended_blocks;

#endif // DIR_INIDE_TO_BLOCK_H
