;;; ewb-triger.el --- Functions to insert triger of EWB.
;;
;; Copyright (C) 1999 ASCII Corporation
;;
;; This file is part of EWB.
;;
;;; Code:

(defvar ewb-triger-def-file-name "triger.def"
  "EWB triger.def ե")

(defvar ewb-triger-diff-file-name "triger.diff"
  "EWB triger.diff ե")

(defvar ewb-style-dir-name "Styles"
  "EWB ǥ쥯ȥ")

(defvar ewb-triger-list-buffer-name " *Triger List Buffer*"
  "EWB Υȥꥬեɤ߹Хåե")

(defvar ewb-triger-history nil
  "EWB ¾Υȥꥬ")

(defvar ewb-figure-history nil
  "EWB ɽϢΥȥꥬ")

(defun ewb-triger-def-file ()
  "triger.def Υե֤̾ĤʤСnil"
  (if (file-exists-p ewb-triger-def-file-name)
      ewb-triger-def-file-name
    (if (file-exists-p (concat
			ewb-style-dir-name "/" ewb-triger-def-file-name))
	(concat
	 ewb-style-dir-name "/" ewb-triger-def-file-name)
      nil)))

(defun ewb-triger-diff-file ()
  "triger.diff Υե֤̾ĤʤСnil"
  (if (file-exists-p ewb-triger-diff-file-name)
      ewb-triger-diff-file-name
    (if (file-exists-p (concat
			ewb-style-dir-name "/" ewb-triger-diff-file-name))
	(concat
	 ewb-style-dir-name "/" ewb-triger-diff-file-name)
      nil)))

(defun ewb-insert-figure ()
  "ɽϢΥȥꥬ롣"
  (interactive)
  (let* ((clist (ewb-get-figure-from-triger-def))
	 (type 
	  (completing-read
	   (concat
	    "Figure Type ["
	    (make-figure-list-text clist)
	    "] : ")
	   clist nil t))
	 (init-num-str (ewb-get-last-figure type))
	 (init-num (+ (string-to-number init-num-str) 1))
	 (init-format
	  (concat
	   "%s%"
	   (if (string= (substring init-num-str 0 1) "0")
	       "0")
	   (number-to-string (length init-num-str))
	   "d"
	   ))
	 (entry
	  (read-from-minibuffer
	   "Figure Triger : "
	   (format init-format type init-num)
	   nil nil
	   'ewb-figure-history))
	 )
    (if (= (current-column) 0)
	(insert (format "//%s " entry))
      (insert (format "//%s" entry)))))

(defun make-figure-list-text (clist)
  "ɽϢΥȥꥬΥꥹȤ | ǶڤäƥȤˤ֤"
  (let* ((num (- (length clist) 1))
	 (result ""))
    (progn
      (while (<= 0 num)
	(if (string= result "")
	    (setq result (nth 0 (nth num clist)))
	  (setq result 
		(concat
		 (nth 0 (nth num clist))
		 "|"
		 result)))
	(setq num (- num 1)))
       result)))

(defun ewb-get-last-figure (type)
  "ƱפοɽϢľΥȥꥬοʬõ֤
Ĥʤ \"ֹ2+00\" ֹ
ֹ⸫Ĥʤ \"0000\" ֤"
  (save-excursion
    (if (re-search-backward
	 (concat
	  "^//"
	  type
	  "\\([0-9]+\\) "
	  )
	 nil t)
	(match-string 1)
      (progn
	(goto-char (point-min))
	(if (re-search-forward
	     "^chapter +\\([0-9]+\\)"
	     nil t)
	    (format "%02d00" (string-to-number (match-string 1)))
	  "0000")))))

(defun ewb-get-figure-from-triger-def ()
  "triger.def 򳫤ɽϢΥȥꥬõơΥꥹȤ֤
ꥹȤΤϡewb-search-figure-in-triger-def"
  (if (ewb-triger-def-file)
      (let ((return)
	    (obuf (current-buffer))
	    )
	(progn
	  (set-buffer (get-buffer-create ewb-triger-list-buffer-name))
	  (erase-buffer)
	  (insert-file-contents (ewb-triger-def-file))
	  (if (ewb-triger-diff-file)
	      (insert-file-contents (ewb-triger-diff-file)))
	  (setq return (ewb-search-figure-in-triger-def))
	  (set-buffer obuf)
	  return))))

(defun ewb-search-figure-in-triger-def ()
  "triger.defǿɽϢΥȥꥬõΥꥹȤ֤"
  (let ((clist nil) (num))
    (progn
      (setq num 0)
      (goto-char (point-min))
      (while (re-search-forward
	      "^deffigure\\W+\\(\\w+\\)\\W+"
	      nil t)
	(setq clist
	      (cons
	       (list (match-string 1) num)
	       clist))
	(setq num (+ num 1)))
      clist)))

(defun ewb-insert-section ()
  "Фȥꥬ롣"
  (interactive)
  (insert (format "//%s " (ewb-get-last-section (ewb-get-section-from-triger-def)))))

(defun ewb-get-last-section (clist)
  "ľθФȥꥬõơ // ʬ֤
ĤʤС\"i\" ֤"
  (save-excursion
    (if (re-search-backward (make-section-triger-regexp clist) nil t)
	(match-string 1)
      "i")))

(defun make-section-triger-regexp (clist)
  "Фȥꥬɽꥹʸ롣"
  (let* ((num (- (length clist) 1))
	 (result ""))
    (progn
      (while (<= 0 num)
	(if (string= result "")
	    (setq result (nth 0 (nth num clist)))
	  (setq result
		(concat
		 (nth 0 (nth num clist))
		 "\\|"
		 result)))
	(setq num (- num 1)))
      (concat
       "^//\\("
       result
       "\\) "
      ))))

(defun ewb-get-section-from-triger-def ()
  "triger.def 򳫤ФȥꥬõơΥꥹȤ֤
ꥹȤΤϡewb-search-section-in-triger-def"
  (if (ewb-triger-def-file)
      (let ((return)
	    (obuf (current-buffer))
	    )
	(progn
	  (set-buffer (get-buffer-create ewb-triger-list-buffer-name))
	  (erase-buffer)
	  (insert-file-contents (ewb-triger-def-file))
	  (if (ewb-triger-diff-file)
	      (insert-file-contents (ewb-triger-diff-file)))
	  (setq return (ewb-search-section-in-triger-def))
	  (set-buffer obuf)
	  return))))

(defun ewb-search-section-in-triger-def ()
  "triger.def ǸФȥꥬõơΥꥹȤ֤"
  (let ((clist nil) (num))
    (progn
      (setq num 0)
      (goto-char (point-min))
      (while (re-search-forward
	      "^defcaption\\W+\\(\\w+\\)\\W+"
	      nil t)
	(setq clist
	      (cons
	       (list (match-string 1) num)
	       clist))
	(setq num (+ num 1)))
      clist)))

(defun ewb-insert-triger ()
  "̾ΥȥꥬϤ롣"
  (interactive)
  (let* ((clist (ewb-get-triger-from-triger-def (region-exists-p)))
	 (entry
	  (completing-read
	   "Triger: "
	   clist
	   nil nil nil 'ewb-triger-history))
	 )
    (if (> 0 (nth 1 (assoc entry clist))) ; if defsimple type triger
	(progn
	  (insert (format "//%s" entry))
	  (if (or
	       (and (>= (following-char) 48) ; if digits
		    (<= (following-char) 59))
	       (and (>= (logior (following-char) 32) ?a) ; if [a-z][A-Z]
		    (<= (logior (following-char) 32) ?z)))
	      (insert " ")))
      (if (and (< 1000 (nth 1 (assoc entry clist))) ; if defgroup type triger
	       (> 2000 (nth 1 (assoc entry clist))))
	  (save-excursion
	    (save-restriction
	      (narrow-to-region (region-beginning) (region-end))
	      (goto-char (point-min))
	      (if (/= (following-char) 10)
		  (insert (format "//%s{\n" entry))
		(insert (format "//%s{" entry)))
	      (goto-char (point-max))
	      (insert (format "//%s}" entry))
	      (widen)
	      (if (/= (following-char) 10)
		  (insert "\n"))))
	(if (< 2000 (nth 1 (assoc entry clist))) ; if defref, deflabel type triger
	    (progn
	      (insert (format "//%s{//}" entry))
	      (backward-char 3))
	  ;; if defgothic type triger
	  (save-excursion
	    (save-restriction
	      (narrow-to-region (region-beginning) (region-end))
	      (goto-char (point-min))
	      (insert (format "//%s{" entry))
	      (goto-char (point-max))
	      (insert (format "//%s}" entry))
	      (widen))))))))

(defun ewb-get-triger-from-triger-def (regionp)
  "triger.def 򳫤̾ΥȥꥬõơΥꥹȤ֤
ꥹȤΤϡewb-search-triger-in-triger-def"
  (if (ewb-triger-def-file)
      (let ((return)
	    (obuf (current-buffer))
	    )
	(progn
	  (set-buffer (get-buffer-create ewb-triger-list-buffer-name))
	  (erase-buffer)
	  (insert-file-contents (ewb-triger-def-file))
	  (if (ewb-triger-diff-file)
	      (insert-file-contents (ewb-triger-diff-file)))
	  (setq return (ewb-search-triger-in-triger-def regionp))
	  (set-buffer obuf)
	  return))))

(defun ewb-search-triger-in-triger-def (regionp)
  "triger.def ̾ΥȥꥬõơΥꥹȤ֤ꥹȤϤ줾졢

	(ȥꥬ̾ )

Υڥʤꡢ

    n < 0		defsimple type
    0 < n < 1000	defgothic type
    1000 < n < 2000	defgroup type
    2000 < n		defref, deflabel type

̣롣
regionptrueʤ顢defgothic typedefgroup typeΥȥꥬΥꥹȤ
regionpfalseʤ顢defsimple typedefref, deflabel typeΥꥹȤޤ"
  (let ((clist nil) (num))
    (progn
      (if regionp
	  (progn
	    ;; defgothic type triger's num is greater than 0.
	    (setq num 0)
	    (goto-char (point-min))
	    (while (re-search-forward
		    (concat
		     "^def"
		     "\\("
		     "gothic\\|"
		     "url\\|"
		     "noexpand"
		     "\\)"
		     "\\W+\\(\\w+\\)\\W+"
		     )
		    nil t)
	      (setq clist
		    (cons
		     (list (match-string 2) num)
		     clist))
	      (setq num (+ num 1)))
	    (setq clist
		  (cons
		   (list "LaTeX" num)
		   clist))
	    ;; defgroup type triger's num is greater than 1000.
	    (setq num 1001)
	    (goto-char (point-min))
	    (while (re-search-forward
		    (concat
		     "^def"
		     "\\("
		     "group\\|"
		     "list\\|"
		     "table\\|"
		     "item"
		     "\\)"
		     "\\W+\\(\\w+\\)\\W+"
		     )
		    nil t)
	      (setq clist
		    (cons
		     (list (match-string 2) num)
		     clist))
	      (setq num (+ num 1)))
	    )
	(progn
	  ;; defsimple type triger's num is less than 0.
	  (setq num -1)
	  (goto-char (point-min))
	  (while (re-search-forward
		  "^defsimple\\W+\\(\\w+\\)\\W+"
		  nil t)
	    (setq clist
		  (cons
		   (list (match-string 1) num)
		   clist))
	    (setq num (- num 1)))
	  ;; defref, deflabel type triger's num is greater than 2000.
	  (setq num 2001)
	  (goto-char (point-min))
	  (while (re-search-forward
		  (concat
		   "^def"
		   "\\("
		   "ref\\|"
		   "label"
		   "\\)"
		   "\\W+\\(\\w+\\)\\W+"
		   )
		  nil t)
	    (setq clist
		  (cons
		   (list (match-string 2) num)
		   clist))
	    (setq num (+ num 1)))
	  ))
      clist)))

(provide 'ewb-triger)

;;; Local Variables:
;;; mode: outline-minor
;;; End:

;;; ewb-triger.el ends here
