;;; ewb-forall.el --- Mode for ForAll.index of EWB.
;;
;; Copyright (C) 1999 ASCII Corporation
;;
;; This file is part of EWB.
;;
;;; Code:

(require 'ewb-index)
;(require 'ewb-mode)

(defun ewb-index-jump-from-forall-mouse (event)
  "ޥewb-index-jump-from-forall

Go to the occurrence highlighted by mouse.
This function is only reasonable when bound to a mouse key in the ForAll.index buffer"
  (interactive "e")
  (let ((window-save (selected-window))
	(frame-save (selected-frame)))
    ;; preserve the window/frame setup
    (unwind-protect
	(progn
	  (mouse-set-point event)
	  (ewb-index-jump-from-forall))
      (select-frame frame-save)
      (select-window window-save))))

(defvar ewb-forall-index-mode-map ())
(if ewb-forall-index-mode-map
    ()
  (setq ewb-forall-index-mode-map (make-sparse-keymap))
  (set-keymap-name ewb-forall-index-mode-map 'ewb-forall-index-mode-map) ; XEmacs
  (define-key ewb-forall-index-mode-map 'button2 'ewb-index-jump-from-forall-mouse) ; XEmacs
  (define-key ewb-forall-index-mode-map "\C-c\C-c" 'ewb-index-jump-from-forall))

(defun ewb-forall-index-mode ()
  "Major mode for output from \\[ewb-check-not-in-forall].
\\<ewb-forall-index-mode-map>Move point to one of the items in this buffer, then use
\\[ewb-index-jump-from-forall] to go to the ewb-forall-indexrence that the item refers to.
Alternatively, click \\[ewb-forall-mode-mouse-goto] on an item to go to it.

\\{ewb-forall-index-mode-map}"
  (interactive)
  (kill-all-local-variables)
  (use-local-map ewb-forall-index-mode-map)
  (setq major-mode 'ewb-forall-index-mode)
  (setq mode-name (gettext "EWB ForAll.index")) ; XEmacs
  (require 'mode-motion) ; XEmacs
  (setq mode-motion-hook 'mode-motion-highlight-line) ; XEmacs
  (if (and (featurep 'toolbar)
	   (console-on-window-system-p))
      (set-specifier default-toolbar (cons (current-buffer) ewb::forall-index-toolbar)))
  (if (featurep 'menubar)
      (progn
	;; make a local copy of the menubar, so our modes don't
	;; change the global menubar
	(set-buffer-menubar current-menubar)
	(add-submenu nil ewb-forall-index-menu)
	;; In an effort to avoid massive menu clutter, this mostly worthless menu is
	;; superceded by any local popup menu...
	(setq mode-popup-menu ewb-forall-index-mode-popup-menu)
	))
  (if ewb-font-lock-mode-p
      (font-lock-mode t))
  (run-hooks 'ewb-forall-index-mode-hook))


;;; font-lock support

(put 'ewb-forall-index-mode 'font-lock-defaults
     '(ewb-forall-index-font-lock-keywords nil nil nil))

(defconst ewb-forall-index-font-lock-keywords (purecopy
  (list
;   '("^\\(\.\./[^:]+\\):" 1 font-lock-function-name-face)
   '("^[^:]+:\\([0-9]+\\):" 1 font-lock-comment-face) ; ֹ : 뤤
   '("^[^:]+:[0-9]+:\\([0-9]+\\):" 1 font-lock-keyword-face) ; ֹ : 
   '("^[^:]+:[0-9]+:[0-9]+:\\(\\(\\(\\\\:\\)\\|[^:]\\)+\\):"
     1 font-lock-variable-name-face)	; ̾ : 
   '("^[^:]+:[0-9]+:[0-9]+:\\(\\(\\\\:\\)\\|[^:]\\)+:\\(\\(\\(\\\\:\\)\\|[^:]\\)+\\):"
     3 font-lock-reference-face)		; ɤ : Ť
   '("^[^:]+:[0-9]+:[0-9]+:\\(\\(\\\\:\\)\\|[^:]\\)+:\\(\\(\\\\:\\)\\|[^:]\\)+:\\(\\(\\(\\\\:\\)\\|[^:]\\)+\\):"
     5 font-lock-variable-name-face)	; ̾ : 
   '("^[^:]+:[0-9]+:[0-9]+:\\(\\(\\\\:\\)\\|[^:]\\)+:\\(\\(\\\\:\\)\\|[^:]\\)+:\\(\\(\\\\:\\)\\|[^:]\\)+:\\(\\(\\(\\\\:\\)\\|[^:]\\)+\\):"
     7 font-lock-reference-face)		; ɤ : Ť
   '("^[^:]+:[0-9]+:[0-9]+:\\(\\(\\\\:\\)\\|[^:]\\)+:\\(\\(\\\\:\\)\\|[^:]\\)+:\\(\\(\\\\:\\)\\|[^:]\\)+:\\(\\(\\\\:\\)\\|[^:]\\)+:\\(\\(\\(\\\\:\\)\\|[^:]\\)+\\):"
     9 font-lock-variable-name-face)	; ̾ : 
   '("^[^:]+:[0-9]+:[0-9]+:\\(\\(\\\\:\\)\\|[^:]\\)+:\\(\\(\\\\:\\)\\|[^:]\\)+:\\(\\(\\\\:\\)\\|[^:]\\)+:\\(\\(\\\\:\\)\\|[^:]\\)+:\\(\\(\\\\:\\)\\|[^:]\\)+:\\(\\(\\(\\\\:\\)\\|[^:]\\)+\\):"
     11 font-lock-reference-face)		; ɤ : Ť
   '(":\\([^:]+\\):$" 1 font-lock-doc-string-face) ;  : 
   ))
  "Additional expressions to highlight in ewb-forall-index-mode.")


;;; Toolbar

(defvar ewb::forall-index-toolbar
  (if (featurep 'toolbar)
; disabled until we get the next/prev-win icons working again.
;      (cons (first initial-toolbar-spec)
;       (cons (second initial-toolbar-spec)
	     '(
	       [toolbar-file-icon
		toolbar-open	t	"Open a file"]
	       [toolbar-disk-icon
		toolbar-save	t	"Save buffer"]
	       [toolbar-cut-icon
		toolbar-cut	t	"Kill region"]
	       [toolbar-copy-icon
		toolbar-copy	t	"Copy region"]
	       [toolbar-paste-icon
		toolbar-paste	t	"Paste from clipboard"]
	       [toolbar-undo-icon
		toolbar-undo	t	"Undo edit"]
	       [toolbar-replace-icon
		toolbar-replace	t	"Replace text"]
	       [ewb::toolbar-novice-search-icon
		toolbar-novice-search	t	"Novice search"]
	       [ewb::toolbar-novice-search-repeat-forward-icon
		toolbar-novice-search-repeat-forward	t	"Novice search forward"]
	       [ewb::toolbar-novice-search-repeat-backward-icon
		toolbar-novice-search-repeat-backward	t	"Novice search backward"]
	       [ewb::toolbar-jump-icon
		toolbar-ewbindex-jump	t	"EWB jump"]
		)))



;;; EWB menu support

(defvar ewb-forall-index-menu
  '("ForAll.index"
    ["Jumpt to //in"  	ewb-index-jump-from-forall		t]
    ))


;;; Popup menus.

(defconst ewb-forall-index-mode-popup-menu
  '("ForAll.index edit Commands"
    :filter edit-menu-filter
    ["Jumpt to //in"  	ewb-index-jump-from-forall		t]
    "-"
    ["Undo"		advertised-undo		t]
    ["Cut"		x-kill-primary-selection   t]
    ["Copy"		x-copy-primary-selection   t]
    ["Paste"		x-yank-clipboard-selection t]
    ["Clear"            x-delete-primary-selection t]
    ))



(run-hooks 'ewb-forall-index-mode-load-hook)

(provide 'ewb-forall)

;;; Local Variables:
;;; mode: outline-minor
;;; End:

;;; ewb-forall.el ends here.
